/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.run.deployment;

import com.android.tools.idea.flags.StudioFlags;
import com.android.tools.idea.run.deployment.AsyncDevicesGetter;
import com.android.tools.idea.run.deployment.Device;
import com.android.tools.idea.run.deployment.DeviceAndSnapshotComboBoxExecutionTarget;
import com.android.tools.idea.run.deployment.DeviceComparator;
import com.android.tools.idea.run.deployment.DevicesSelectedService;
import com.android.tools.idea.run.deployment.ExecutionTargetService;
import com.android.tools.idea.run.deployment.Popup;
import com.android.tools.idea.run.deployment.PopupActionGroup;
import com.android.tools.idea.run.deployment.SelectMultipleDevicesDialog;
import com.android.tools.idea.run.deployment.Target;
import com.android.tools.idea.run.deployment.UpdatableDeviceHelpTooltip;
import com.android.tools.idea.run.deployment.Updater;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.execution.RunManager;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.ex.ComboBoxAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.util.Key;
import com.intellij.serviceContainer.NonInjectable;
import com.intellij.util.ui.JBUI;
import java.awt.Component;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.BooleanSupplier;
import java.util.function.Function;
import java.util.function.IntUnaryOperator;
import javax.swing.GroupLayout;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class DeviceAndSnapshotComboBoxAction
extends ComboBoxAction {
    public static final Key<Boolean> DEPLOYS_TO_LOCAL_DEVICE = Key.create((String)"DeviceAndSnapshotComboBoxAction.deploysToLocalDevice");
    @NotNull
    private final BooleanSupplier mySelectDeviceSnapshotComboBoxSnapshotsEnabledGet;
    @NotNull
    private final Function<Project, AsyncDevicesGetter> myDevicesGetterGetter;
    @NotNull
    private final Function<Project, DevicesSelectedService> myDevicesSelectedServiceGetInstance;
    @NotNull
    private final Function<Project, ExecutionTargetService> myExecutionTargetServiceGetInstance;
    @NotNull
    private final BiFunction<Project, List<Device>, DialogWrapper> myNewSelectMultipleDevicesDialog;
    @NotNull
    private final Function<Project, RunManager> myGetRunManager;
    @NotNull
    private final UpdatableDeviceHelpTooltip myUpdatableDeviceHelpTooltip;

    private DeviceAndSnapshotComboBoxAction() {
        this(new Builder().setSelectDeviceSnapshotComboBoxSnapshotsEnabledGet(StudioFlags.SELECT_DEVICE_SNAPSHOT_COMBO_BOX_SNAPSHOTS_ENABLED::get).setDevicesGetterGetter(AsyncDevicesGetter::getInstance).setDevicesSelectedServiceGetInstance(DevicesSelectedService::getInstance).setExecutionTargetServiceGetInstance(ExecutionTargetService::getInstance).setNewSelectMultipleDevicesDialog(SelectMultipleDevicesDialog::new).setGetRunManager(RunManager::getInstance));
    }

    @NonInjectable
    private DeviceAndSnapshotComboBoxAction(@NotNull Builder builder2) {
        assert (builder2.mySelectDeviceSnapshotComboBoxSnapshotsEnabledGet != null);
        this.mySelectDeviceSnapshotComboBoxSnapshotsEnabledGet = builder2.mySelectDeviceSnapshotComboBoxSnapshotsEnabledGet;
        assert (builder2.myDevicesGetterGetter != null);
        this.myDevicesGetterGetter = builder2.myDevicesGetterGetter;
        assert (builder2.myDevicesSelectedServiceGetInstance != null);
        this.myDevicesSelectedServiceGetInstance = builder2.myDevicesSelectedServiceGetInstance;
        assert (builder2.myExecutionTargetServiceGetInstance != null);
        this.myExecutionTargetServiceGetInstance = builder2.myExecutionTargetServiceGetInstance;
        assert (builder2.myNewSelectMultipleDevicesDialog != null);
        this.myNewSelectMultipleDevicesDialog = builder2.myNewSelectMultipleDevicesDialog;
        assert (builder2.myGetRunManager != null);
        this.myGetRunManager = builder2.myGetRunManager;
        this.myUpdatableDeviceHelpTooltip = new UpdatableDeviceHelpTooltip();
    }

    @NotNull
    static DeviceAndSnapshotComboBoxAction getInstance() {
        return (DeviceAndSnapshotComboBoxAction)ActionManager.getInstance().getAction("DeviceAndSnapshotComboBox");
    }

    boolean areSnapshotsEnabled() {
        return this.mySelectDeviceSnapshotComboBoxSnapshotsEnabledGet.getAsBoolean();
    }

    @NotNull
    Optional<List<Device>> getDevices(@NotNull Project project) {
        Optional<List<Device>> optionalDevices = this.myDevicesGetterGetter.apply(project).get();
        if (optionalDevices.isPresent()) {
            List<Device> devices2 = optionalDevices.get();
            devices2.sort(new DeviceComparator());
            return Optional.of(devices2);
        }
        return optionalDevices;
    }

    void setTargetSelectedWithComboBox(@NotNull Project project, @NotNull Target target2) {
        this.myDevicesSelectedServiceGetInstance.apply(project).setTargetSelectedWithComboBox(target2);
        this.setActiveExecutionTarget(project, Collections.singleton(target2));
    }

    public boolean isMultipleTargetsSelectedInComboBox(@NotNull Project project) {
        return this.myDevicesSelectedServiceGetInstance.apply(project).isMultipleDevicesSelectedInComboBox();
    }

    public int getNumberOfSelectedDevices(@NotNull Project project) {
        return this.getSelectedDevices(project).size();
    }

    @NotNull
    @NotNull List<@NotNull Device> getSelectedDevices(@NotNull Project project) {
        List<Device> devices2 = this.getDevices(project).orElse(Collections.emptyList());
        return Target.filterDevices(this.getSelectedTargets(project, devices2), devices2);
    }

    @NotNull
    @NotNull Set<@NotNull Target> getSelectedTargets(@NotNull Project project) {
        return this.getSelectedTargets(project, this.getDevices(project).orElse(Collections.emptyList()));
    }

    @NotNull
    @NotNull Set<@NotNull Target> getSelectedTargets(@NotNull Project project, @NotNull @NotNull List<@NotNull Device> devices2) {
        DevicesSelectedService service = this.myDevicesSelectedServiceGetInstance.apply(project);
        if (service.isMultipleDevicesSelectedInComboBox()) {
            return service.getTargetsSelectedWithDialog(devices2);
        }
        return service.getTargetSelectedWithComboBox(devices2).map(Collections::singleton).orElseGet(Collections::emptySet);
    }

    void selectMultipleDevices(@NotNull Project project) {
        DevicesSelectedService service;
        List<Device> devices2 = this.myDevicesGetterGetter.apply(project).get().orElseThrow(AssertionError::new);
        if (!this.myNewSelectMultipleDevicesDialog.apply(project, devices2).showAndGet()) {
            return;
        }
        service.setMultipleDevicesSelectedInComboBox(!(service = this.myDevicesSelectedServiceGetInstance.apply(project)).getTargetsSelectedWithDialog(devices2).isEmpty());
        this.setActiveExecutionTarget(project, this.getSelectedTargets(project, devices2));
    }

    @NotNull
    public JComponent createCustomComponent(@NotNull Presentation presentation, @NotNull String place) {
        return this.createCustomComponent(presentation, JBUI::scale);
    }

    @NotNull
    @VisibleForTesting
    JComponent createCustomComponent(@NotNull Presentation presentation, @NotNull IntUnaryOperator scale) {
        JPanel panel2 = new JPanel(null);
        GroupLayout layout = new GroupLayout(panel2);
        ComboBoxAction.ComboBoxButton button = this.createComboBoxButton(presentation);
        GroupLayout.SequentialGroup horizontalGroup = layout.createSequentialGroup().addComponent((Component)button, 0, -1, scale.applyAsInt(250)).addGap(scale.applyAsInt(3));
        GroupLayout.ParallelGroup verticalGroup = layout.createParallelGroup().addComponent((Component)button);
        layout.setHorizontalGroup(horizontalGroup);
        layout.setVerticalGroup(verticalGroup);
        panel2.setLayout(layout);
        return panel2;
    }

    @NotNull
    protected ComboBoxAction.ComboBoxButton createComboBoxButton(@NotNull Presentation presentation) {
        ComboBoxAction.ComboBoxButton button = new ComboBoxAction.ComboBoxButton(presentation){

            @NotNull
            protected JBPopup createPopup(@NotNull Runnable runnable2) {
                DataContext context2 = this.getDataContext();
                return new Popup((ActionGroup)DeviceAndSnapshotComboBoxAction.this.createPopupActionGroup((JComponent)((Object)this), context2), context2, runnable2);
            }
        };
        this.myUpdatableDeviceHelpTooltip.installOn((JComponent)button);
        button.setName("deviceAndSnapshotComboBoxButton");
        return button;
    }

    protected boolean shouldShowDisabledActions() {
        return true;
    }

    @NotNull
    protected DefaultActionGroup createPopupActionGroup(@NotNull JComponent button) {
        throw new UnsupportedOperationException();
    }

    @NotNull
    protected DefaultActionGroup createPopupActionGroup(@NotNull JComponent button, @NotNull DataContext context2) {
        Project project = (Project)context2.getData(CommonDataKeys.PROJECT);
        assert (project != null);
        return new PopupActionGroup((Collection<Device>)this.getDevices(project).orElseThrow(AssertionError::new), this);
    }

    public void update(@NotNull AnActionEvent event) {
        Presentation presentation = event.getPresentation();
        Project project = event.getProject();
        if (project == null) {
            presentation.setVisible(false);
            return;
        }
        Optional<List<Device>> optionalDevices = this.getDevices(project);
        if (!optionalDevices.isPresent()) {
            presentation.setEnabled(false);
            presentation.setText("Loading Devices...");
            return;
        }
        List<Device> devices2 = optionalDevices.get();
        Updater updater = new Updater.Builder().setProject(project).setPresentation(presentation).setPlace(event.getPlace()).setDevicesSelectedService(this.myDevicesSelectedServiceGetInstance.apply(project)).setDevices(devices2).setConfigurationAndSettings(this.myGetRunManager.apply(project).getSelectedConfiguration()).setSelectDeviceSnapshotComboBoxSnapshotsEnabledGet(this.mySelectDeviceSnapshotComboBoxSnapshotsEnabledGet).build();
        updater.update();
        this.updateTooltip(project);
        this.setActiveExecutionTarget(project, this.getSelectedTargets(project, devices2));
    }

    private void updateTooltip(@NotNull Project project) {
        List<Device> selectedDevices = this.getSelectedDevices(project);
        if (selectedDevices.size() == 1) {
            this.myUpdatableDeviceHelpTooltip.updateTooltip(selectedDevices.get(0));
        } else {
            this.myUpdatableDeviceHelpTooltip.cancel();
        }
    }

    private void setActiveExecutionTarget(@NotNull Project project, @NotNull @NotNull Set<@NotNull Target> targets) {
        AsyncDevicesGetter getter = this.myDevicesGetterGetter.apply(project);
        this.myExecutionTargetServiceGetInstance.apply(project).setActiveTarget(new DeviceAndSnapshotComboBoxExecutionTarget(targets, getter));
    }

    @VisibleForTesting
    static final class Builder {
        @Nullable
        private BooleanSupplier mySelectDeviceSnapshotComboBoxSnapshotsEnabledGet = () -> false;
        @Nullable
        private Function<Project, AsyncDevicesGetter> myDevicesGetterGetter = project -> null;
        @Nullable
        private Function<Project, DevicesSelectedService> myDevicesSelectedServiceGetInstance = project -> null;
        @Nullable
        private Function<Project, ExecutionTargetService> myExecutionTargetServiceGetInstance = project -> null;
        @Nullable
        private BiFunction<Project, List<Device>, DialogWrapper> myNewSelectMultipleDevicesDialog = (project, devices2) -> null;
        @Nullable
        private Function<Project, RunManager> myGetRunManager = project -> null;

        Builder() {
        }

        @NotNull
        Builder setSelectDeviceSnapshotComboBoxSnapshotsEnabledGet(@NotNull BooleanSupplier selectDeviceSnapshotComboBoxSnapshotsEnabledGet) {
            this.mySelectDeviceSnapshotComboBoxSnapshotsEnabledGet = selectDeviceSnapshotComboBoxSnapshotsEnabledGet;
            return this;
        }

        @NotNull
        Builder setDevicesGetterGetter(@NotNull Function<Project, AsyncDevicesGetter> devicesGetterGetter) {
            this.myDevicesGetterGetter = devicesGetterGetter;
            return this;
        }

        @NotNull
        Builder setDevicesSelectedServiceGetInstance(@NotNull Function<Project, DevicesSelectedService> devicesSelectedServiceGetInstance) {
            this.myDevicesSelectedServiceGetInstance = devicesSelectedServiceGetInstance;
            return this;
        }

        @NotNull
        Builder setExecutionTargetServiceGetInstance(@NotNull Function<Project, ExecutionTargetService> executionTargetServiceGetInstance) {
            this.myExecutionTargetServiceGetInstance = executionTargetServiceGetInstance;
            return this;
        }

        @NotNull
        Builder setNewSelectMultipleDevicesDialog(@NotNull BiFunction<Project, List<Device>, DialogWrapper> newSelectMultipleDevicesDialog) {
            this.myNewSelectMultipleDevicesDialog = newSelectMultipleDevicesDialog;
            return this;
        }

        @NotNull
        Builder setGetRunManager(@NotNull Function<Project, RunManager> getRunManager) {
            this.myGetRunManager = getRunManager;
            return this;
        }

        @NotNull
        DeviceAndSnapshotComboBoxAction build() {
            return new DeviceAndSnapshotComboBoxAction(this);
        }
    }
}

