/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.run.deployment;

import com.android.ddmlib.IDevice;
import com.android.tools.idea.run.AndroidDevice;
import com.android.tools.idea.run.ConnectedAndroidDevice;
import com.android.tools.idea.run.LaunchCompatibilityChecker;
import com.android.tools.idea.run.deployment.AndroidDebugBridge;
import com.android.tools.idea.run.deployment.AsyncSupplier;
import com.android.tools.idea.run.deployment.ConnectedDevice;
import com.android.tools.idea.run.deployment.Key;
import com.android.tools.idea.run.deployment.SerialNumber;
import com.android.tools.idea.run.deployment.Tasks;
import com.android.tools.idea.run.deployment.VirtualDeviceName;
import com.android.tools.idea.run.deployment.VirtualDevicePath;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.intellij.util.concurrency.AppExecutorUtil;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class ConnectedDevicesTask
implements AsyncSupplier<List<ConnectedDevice>> {
    @NotNull
    private final AndroidDebugBridge myAndroidDebugBridge;
    @Nullable
    private final LaunchCompatibilityChecker myChecker;
    @NotNull
    private final Executor myExecutor;
    @NotNull
    private final Function<IDevice, AndroidDevice> myAndroidDeviceFactory;

    ConnectedDevicesTask(@NotNull AndroidDebugBridge androidDebugBridge, @Nullable LaunchCompatibilityChecker checker) {
        this(androidDebugBridge, checker, AppExecutorUtil.getAppExecutorService(), device2 -> new ConnectedAndroidDevice((IDevice)device2));
    }

    @VisibleForTesting
    ConnectedDevicesTask(@NotNull AndroidDebugBridge androidDebugBridge, @Nullable LaunchCompatibilityChecker checker, @NotNull Executor executor2, @NotNull Function<IDevice, AndroidDevice> androidDeviceFactory) {
        this.myAndroidDebugBridge = androidDebugBridge;
        this.myChecker = checker;
        this.myExecutor = executor2;
        this.myAndroidDeviceFactory = androidDeviceFactory;
    }

    @Override
    @NotNull
    public ListenableFuture<List<ConnectedDevice>> get() {
        return Futures.transform(this.myAndroidDebugBridge.getConnectedDevices(), this::newConnectedDevices, (Executor)this.myExecutor);
    }

    @NotNull
    private @NotNull List<@NotNull ConnectedDevice> newConnectedDevices(@NotNull @NotNull Collection<@NotNull IDevice> devices2) {
        return devices2.stream().filter(IDevice::isOnline).map(this::newConnectedDevice).collect(Collectors.toList());
    }

    @NotNull
    private ConnectedDevice newConnectedDevice(@NotNull IDevice ddmlibDevice) {
        AndroidDevice androidDevice = this.myAndroidDeviceFactory.apply(ddmlibDevice);
        ConnectedDevice.Builder builder2 = new ConnectedDevice.Builder().setName(ConnectedDevicesTask.composeDeviceName(ddmlibDevice)).setKey(ConnectedDevicesTask.newKey(ddmlibDevice)).setAndroidDevice(androidDevice).setType(Tasks.getTypeFromAndroidDevice(androidDevice));
        if (this.myChecker == null) {
            return builder2.build();
        }
        return builder2.setLaunchCompatibility(this.myChecker.validate(androidDevice)).build();
    }

    @NotNull
    private static String composeDeviceName(@NotNull IDevice ddmlibDevice) {
        String avdName;
        if (ddmlibDevice.isEmulator() && (avdName = ddmlibDevice.getAvdName()) != null && !avdName.equals("<build>")) {
            return avdName;
        }
        return ddmlibDevice.getSerialNumber();
    }

    @NotNull
    private static Key newKey(@NotNull IDevice device2) {
        if (!device2.isEmulator()) {
            return new SerialNumber(device2.getSerialNumber());
        }
        String path2 = device2.getAvdPath();
        if (path2 != null) {
            return new VirtualDevicePath(path2);
        }
        String name = device2.getAvdName();
        if (name != null && !name.equals("<build>")) {
            return new VirtualDeviceName(name);
        }
        return new SerialNumber(device2.getSerialNumber());
    }
}

