/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.run.deployment;

import com.android.sdklib.AndroidVersion;
import com.android.tools.idea.run.AndroidDevice;
import com.android.tools.idea.run.LaunchCompatibility;
import com.android.tools.idea.run.deployment.Device;
import com.android.tools.idea.run.deployment.Key;
import com.android.tools.idea.run.deployment.Snapshot;
import com.android.tools.idea.run.deployment.Target;
import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import java.util.concurrent.Future;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class ConnectedDevice
extends Device {
    private ConnectedDevice(@NotNull Builder builder2) {
        super(builder2);
    }

    boolean isVirtualDevice() {
        return this.getAndroidDevice().isVirtual();
    }

    boolean isPhysicalDevice() {
        return !this.getAndroidDevice().isVirtual();
    }

    @Override
    @NotNull
    Icon getIcon() {
        throw new UnsupportedOperationException();
    }

    @Override
    boolean isConnected() {
        throw new UnsupportedOperationException();
    }

    @Override
    @NotNull
    @NotNull Collection<@NotNull Snapshot> getSnapshots() {
        return Collections.emptyList();
    }

    @Override
    @NotNull
    Target getDefaultTarget() {
        throw new UnsupportedOperationException();
    }

    @Override
    @NotNull
    @NotNull Collection<@NotNull Target> getTargets() {
        throw new UnsupportedOperationException();
    }

    @Override
    @NotNull
    Future<AndroidVersion> getAndroidVersion() {
        throw new UnsupportedOperationException();
    }

    public boolean equals(@Nullable Object object) {
        if (!(object instanceof ConnectedDevice)) {
            return false;
        }
        Device device2 = (Device)object;
        return this.getName().equals(device2.getName()) && this.getType().equals((Object)device2.getType()) && this.getLaunchCompatibility().equals(device2.getLaunchCompatibility()) && this.getKey().equals(device2.getKey()) && Objects.equals(this.getConnectionTime(), device2.getConnectionTime()) && this.getAndroidDevice().equals(device2.getAndroidDevice());
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.getName(), this.getType(), this.getLaunchCompatibility(), this.getKey(), this.getConnectionTime(), this.getAndroidDevice()});
    }

    static final class Builder
    extends Device.Builder {
        Builder() {
        }

        @NotNull
        Builder setName(@NotNull String name) {
            this.myName = name;
            return this;
        }

        @NotNull
        Builder setLaunchCompatibility(@NotNull LaunchCompatibility launchCompatibility) {
            this.myLaunchCompatibility = launchCompatibility;
            return this;
        }

        @NotNull
        Builder setKey(@NotNull Key key) {
            this.myKey = key;
            return this;
        }

        @NotNull
        Builder setAndroidDevice(@NotNull AndroidDevice androidDevice) {
            this.myAndroidDevice = androidDevice;
            return this;
        }

        @NotNull
        Builder setType(@NotNull Device.Type type) {
            this.myType = type;
            return this;
        }

        @Override
        @NotNull
        ConnectedDevice build() {
            return new ConnectedDevice(this);
        }
    }
}

