/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.run.deployable;

import com.android.ddmlib.AndroidDebugBridge;
import com.android.ddmlib.IDevice;
import com.android.sdklib.AndroidVersion;
import com.intellij.openapi.application.ApplicationManager;
import java.util.Arrays;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Future;
import org.jetbrains.annotations.NotNull;

public class DeviceVersion
implements AndroidDebugBridge.IDebugBridgeChangeListener,
AndroidDebugBridge.IDeviceChangeListener {
    @NotNull
    private final Map<IDevice, Future<AndroidVersion>> myVersions = new ConcurrentHashMap<IDevice, Future<AndroidVersion>>();

    public DeviceVersion() {
        AndroidDebugBridge.addDeviceChangeListener((AndroidDebugBridge.IDeviceChangeListener)this);
        AndroidDebugBridge.addDebugBridgeChangeListener((AndroidDebugBridge.IDebugBridgeChangeListener)this);
    }

    public void dispose() {
        AndroidDebugBridge.removeDebugBridgeChangeListener((AndroidDebugBridge.IDebugBridgeChangeListener)this);
        AndroidDebugBridge.removeDeviceChangeListener((AndroidDebugBridge.IDeviceChangeListener)this);
    }

    @NotNull
    public Future<AndroidVersion> get(@NotNull IDevice iDevice) {
        return this.myVersions.compute(iDevice, (d, f) -> {
            if (f != null && f.isDone()) {
                try {
                    AndroidVersion version2 = (AndroidVersion)f.get();
                    if (version2 != AndroidVersion.DEFAULT) {
                        return f;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return ApplicationManager.getApplication().executeOnPooledThread(() -> {
                try {
                    String buildApi = d.getProperty("ro.build.version.sdk");
                    if (buildApi == null) {
                        return AndroidVersion.DEFAULT;
                    }
                    int api = Integer.parseInt(buildApi);
                    String codeName = d.getProperty("ro.build.version.codename");
                    return new AndroidVersion(api, codeName);
                }
                catch (Exception e) {
                    return AndroidVersion.DEFAULT;
                }
            });
        });
    }

    public void bridgeChanged(AndroidDebugBridge bridge) {
        if (bridge != null && bridge.isConnected() && bridge.hasInitialDeviceList()) {
            this.myVersions.keySet().retainAll(Arrays.asList(bridge.getDevices()));
        } else {
            this.myVersions.clear();
        }
    }

    public void deviceConnected(IDevice device2) {
    }

    public void deviceDisconnected(IDevice device2) {
        this.myVersions.remove(device2);
    }

    public void deviceChanged(IDevice device2, int changeMask) {
    }
}

