/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.run.debug;

import com.android.ddmlib.Client;
import com.android.ddmlib.logcat.LogCatMessage;
import com.android.tools.idea.logcat.AndroidLogcatFormatter;
import com.android.tools.idea.logcat.AndroidLogcatPreferences;
import com.android.tools.idea.run.ApplicationLogListener;
import com.android.tools.idea.run.debug.CaptureLogcatOutputToProcessHandlerKt;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.openapi.util.Key;
import java.time.ZoneId;
import java.util.concurrent.atomic.AtomicBoolean;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0014J\u001c\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\f2\n\u0010\u0012\u001a\u0006\u0012\u0002\b\u00030\u0013H\u0014R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/android/tools/idea/run/debug/MyLogcatListener;", "Lcom/android/tools/idea/run/ApplicationLogListener;", "client", "Lcom/android/ddmlib/Client;", "debugProcessHandler", "Lcom/intellij/execution/process/ProcessHandler;", "(Lcom/android/ddmlib/Client;Lcom/intellij/execution/process/ProcessHandler;)V", "formatter", "Lcom/android/tools/idea/logcat/AndroidLogcatFormatter;", "isFirstMessage", "Ljava/util/concurrent/atomic/AtomicBoolean;", "formatLogLine", "", "line", "Lcom/android/ddmlib/logcat/LogCatMessage;", "notifyTextAvailable", "", "message", "key", "Lcom/intellij/openapi/util/Key;", "intellij.android.core"})
final class MyLogcatListener
extends ApplicationLogListener {
    @NotNull
    private final ProcessHandler debugProcessHandler;
    @NotNull
    private final AndroidLogcatFormatter formatter;
    @NotNull
    private final AtomicBoolean isFirstMessage;

    public MyLogcatListener(@NotNull Client client2, @NotNull ProcessHandler debugProcessHandler) {
        Intrinsics.checkNotNullParameter((Object)client2, (String)"client");
        Intrinsics.checkNotNullParameter((Object)debugProcessHandler, (String)"debugProcessHandler");
        String string = client2.getClientData().getClientDescription();
        Intrinsics.checkNotNull((Object)string);
        super(string, client2.getClientData().getPid());
        this.debugProcessHandler = debugProcessHandler;
        this.formatter = new AndroidLogcatFormatter(ZoneId.systemDefault(), new AndroidLogcatPreferences());
        this.isFirstMessage = new AtomicBoolean(true);
    }

    @Override
    @NotNull
    protected String formatLogLine(@NotNull LogCatMessage line2) {
        Intrinsics.checkNotNullParameter((Object)line2, (String)"line");
        String string = this.formatter.formatMessage(CaptureLogcatOutputToProcessHandlerKt.access$getSIMPLE_FORMAT$p(), line2.getHeader(), line2.getMessage());
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"formatter.formatMessage(\u2026ine.header, line.message)");
        return string;
    }

    protected void notifyTextAvailable(@NotNull String message2, @NotNull Key<?> key) {
        Intrinsics.checkNotNullParameter((Object)message2, (String)"message");
        Intrinsics.checkNotNullParameter(key, (String)"key");
        if (this.isFirstMessage.compareAndSet(true, false)) {
            this.debugProcessHandler.notifyTextAvailable("Capturing and displaying logcat messages from application. This behavior can be disabled in the \"Logcat output\" section of the \"Debugger\" settings page.", ProcessOutputTypes.STDOUT);
        }
        this.debugProcessHandler.notifyTextAvailable(message2, key);
    }
}

