/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.run.configuration.execution;

import com.android.annotations.concurrency.WorkerThread;
import com.android.ddmlib.IDevice;
import com.android.ddmlib.IShellOutputReceiver;
import com.android.tools.deployer.DeployerException;
import com.android.tools.deployer.model.App;
import com.android.tools.deployer.model.component.AppComponent;
import com.android.tools.deployer.model.component.ComponentType;
import com.android.tools.idea.execution.common.AppRunSettings;
import com.android.tools.idea.execution.common.ComponentLaunchOptions;
import com.android.tools.idea.run.ApkProvider;
import com.android.tools.idea.run.ApplicationIdProvider;
import com.android.tools.idea.run.configuration.execution.AndroidWatchFaceConfigurationExecutorKt;
import com.android.tools.idea.run.configuration.execution.AndroidWearConfigurationExecutor;
import com.android.tools.idea.run.configuration.execution.RecordOutputReceiver;
import com.android.tools.idea.run.configuration.execution.SurfaceVersionException;
import com.android.tools.idea.run.configuration.execution.UtilsKt;
import com.android.tools.idea.run.configuration.execution.WatchFaceLaunchOptions;
import com.android.tools.idea.run.editor.DeployTarget;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicatorProvider;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0016\u0018\u00002\u00020\u0001B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ$\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00120\u00102\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0014J(\u0010\u0017\u001a\u00020\u00122\u0006\u0010\u0018\u001a\u00020\u00112\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0017J\u0018\u0010\u001b\u001a\u00020\u00122\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001c\u001a\u00020\u001dH\u0002R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lcom/android/tools/idea/run/configuration/execution/AndroidWatchFaceConfigurationExecutor;", "Lcom/android/tools/idea/run/configuration/execution/AndroidWearConfigurationExecutor;", "environment", "Lcom/intellij/execution/runners/ExecutionEnvironment;", "deployTarget", "Lcom/android/tools/idea/run/editor/DeployTarget;", "appRunSettings", "Lcom/android/tools/idea/execution/common/AppRunSettings;", "applicationIdProvider", "Lcom/android/tools/idea/run/ApplicationIdProvider;", "apkProvider", "Lcom/android/tools/idea/run/ApkProvider;", "(Lcom/intellij/execution/runners/ExecutionEnvironment;Lcom/android/tools/idea/run/editor/DeployTarget;Lcom/android/tools/idea/execution/common/AppRunSettings;Lcom/android/tools/idea/run/ApplicationIdProvider;Lcom/android/tools/idea/run/ApkProvider;)V", "watchFaceLaunchOptions", "Lcom/android/tools/idea/run/configuration/execution/WatchFaceLaunchOptions;", "getStopCallback", "Lkotlin/Function1;", "Lcom/android/ddmlib/IDevice;", "", "console", "Lcom/intellij/execution/ui/ConsoleView;", "isDebug", "", "launch", "device", "app", "Lcom/android/tools/deployer/model/App;", "setWatchFace", "mode", "Lcom/android/tools/deployer/model/component/AppComponent$Mode;", "intellij.android.core"})
public class AndroidWatchFaceConfigurationExecutor
extends AndroidWearConfigurationExecutor {
    @NotNull
    private final WatchFaceLaunchOptions watchFaceLaunchOptions;

    public AndroidWatchFaceConfigurationExecutor(@NotNull ExecutionEnvironment environment, @NotNull DeployTarget deployTarget2, @NotNull AppRunSettings appRunSettings2, @NotNull ApplicationIdProvider applicationIdProvider, @NotNull ApkProvider apkProvider) {
        Intrinsics.checkNotNullParameter((Object)environment, (String)"environment");
        Intrinsics.checkNotNullParameter((Object)deployTarget2, (String)"deployTarget");
        Intrinsics.checkNotNullParameter((Object)appRunSettings2, (String)"appRunSettings");
        Intrinsics.checkNotNullParameter((Object)applicationIdProvider, (String)"applicationIdProvider");
        Intrinsics.checkNotNullParameter((Object)apkProvider, (String)"apkProvider");
        super(environment, deployTarget2, appRunSettings2, applicationIdProvider, apkProvider);
        ComponentLaunchOptions componentLaunchOptions = appRunSettings2.getComponentLaunchOptions();
        Intrinsics.checkNotNull((Object)componentLaunchOptions, (String)"null cannot be cast to non-null type com.android.tools.idea.run.configuration.execution.WatchFaceLaunchOptions");
        this.watchFaceLaunchOptions = (WatchFaceLaunchOptions)componentLaunchOptions;
    }

    @Override
    @NotNull
    protected Function1<IDevice, Unit> getStopCallback(@NotNull ConsoleView console, boolean isDebug) {
        Intrinsics.checkNotNullParameter((Object)console, (String)"console");
        return AndroidWatchFaceConfigurationExecutorKt.access$getStopWatchFaceCallback(console, isDebug);
    }

    @Override
    @WorkerThread
    public void launch(@NotNull IDevice device2, @NotNull App app, @NotNull ConsoleView console, boolean isDebug) {
        Intrinsics.checkNotNullParameter((Object)device2, (String)"device");
        Intrinsics.checkNotNullParameter((Object)app, (String)"app");
        Intrinsics.checkNotNullParameter((Object)console, (String)"console");
        AppComponent.Mode mode = isDebug ? AppComponent.Mode.DEBUG : AppComponent.Mode.RUN;
        int version2 = UtilsKt.getWearDebugSurfaceVersion(device2);
        if (version2 < 2) {
            throw new SurfaceVersionException(2, version2, device2.isEmulator());
        }
        this.setWatchFace(app, mode);
        this.showWatchFace(device2, console);
    }

    private final void setWatchFace(App app, AppComponent.Mode mode) {
        ProgressIndicator progressIndicator;
        ProgressIndicator progressIndicator2 = ProgressIndicatorProvider.getGlobalProgressIndicator();
        if (progressIndicator2 != null) {
            ProgressIndicator progressIndicator3;
            ProgressIndicator $this$setWatchFace_u24lambda_u2d0 = progressIndicator3 = progressIndicator2;
            boolean bl = false;
            $this$setWatchFace_u24lambda_u2d0.checkCanceled();
            $this$setWatchFace_u24lambda_u2d0.setText("Launching the watch face");
            progressIndicator = progressIndicator3;
        } else {
            progressIndicator = null;
        }
        ProgressIndicator indicator = progressIndicator;
        RecordOutputReceiver outputReceiver2 = new RecordOutputReceiver((Function0<Boolean>)((Function0)new Function0<Boolean>(indicator){
            final /* synthetic */ ProgressIndicator $indicator;
            {
                this.$indicator = $indicator;
                super(0);
            }

            @NotNull
            public final Boolean invoke() {
                ProgressIndicator progressIndicator = this.$indicator;
                return progressIndicator != null ? progressIndicator.isCanceled() : false;
            }
        }));
        try {
            ComponentType componentType = this.watchFaceLaunchOptions.getComponentType();
            String string = this.watchFaceLaunchOptions.getComponentName();
            Intrinsics.checkNotNull((Object)string);
            app.activateComponent(componentType, string, mode, (IShellOutputReceiver)outputReceiver2);
        }
        catch (DeployerException ex) {
            CharSequence charSequence;
            CharSequence charSequence2 = outputReceiver2.getOutput();
            if (charSequence2.length() == 0) {
                boolean bl = false;
                charSequence = ex.getDetails();
            } else {
                charSequence = charSequence2;
            }
            Throwable throwable = ex;
            String string = "Error while launching watch face, message: " + charSequence;
            throw new ExecutionException(string, throwable);
        }
    }
}

