/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.run.configuration.execution;

import com.android.annotations.concurrency.WorkerThread;
import com.android.ddmlib.IDevice;
import com.android.tools.deployer.Deployer;
import com.android.tools.deployer.DeployerException;
import com.android.tools.deployer.model.App;
import com.android.tools.idea.concurrency.FutureUtils;
import com.android.tools.idea.execution.common.AppRunSettings;
import com.android.tools.idea.execution.common.ApplicationDeployer;
import com.android.tools.idea.execution.common.ApplicationTerminator;
import com.android.tools.idea.execution.common.processhandler.AndroidProcessHandler;
import com.android.tools.idea.run.ApkInfo;
import com.android.tools.idea.run.ApkProvider;
import com.android.tools.idea.run.ApplicationIdProvider;
import com.android.tools.idea.run.DeviceFutures;
import com.android.tools.idea.run.configuration.execution.AndroidConfigurationExecutor;
import com.android.tools.idea.run.configuration.execution.AndroidConfigurationExecutorBase;
import com.android.tools.idea.run.configuration.execution.ApplicationDeployerImpl;
import com.android.tools.idea.run.configuration.execution.UtilsKt;
import com.android.tools.idea.run.editor.DeployTarget;
import com.android.tools.idea.run.util.LaunchUtils;
import com.android.tools.idea.stats.RunStats;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.util.concurrent.ListenableFuture;
import com.intellij.execution.Executor;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.execution.filters.TextConsoleBuilderFactory;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicatorProvider;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.Function;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.xdebugger.impl.XDebugSessionImpl;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Supplier;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.AsyncPromise;
import org.jetbrains.concurrency.Promise;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0098\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\b&\u0018\u00002\u00020\u0001B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\b\u0010'\u001a\u00020(H\u0002J\u000e\u0010)\u001a\b\u0012\u0004\u0012\u00020+0*H\u0017J\u0010\u0010,\u001a\u00020-2\u0006\u0010.\u001a\u00020(H\u0016J\u0016\u0010/\u001a\b\u0012\u0004\u0012\u000201002\u0006\u00102\u001a\u000203H\u0002J$\u00104\u001a\u000e\u0012\u0004\u0012\u000201\u0012\u0004\u0012\u000206052\u0006\u0010.\u001a\u00020(2\u0006\u0010 \u001a\u00020!H$J(\u00107\u001a\u0002062\u0006\u00108\u001a\u0002012\u0006\u00109\u001a\u00020:2\u0006\u0010.\u001a\u00020(2\u0006\u0010 \u001a\u00020!H'J\u000e\u0010;\u001a\b\u0012\u0004\u0012\u00020+0*H\u0017J\u001e\u0010<\u001a\b\u0012\u0004\u0012\u00020=0*2\u0006\u00108\u001a\u0002012\u0006\u0010.\u001a\u00020(H$J\u0015\u0010>\u001a\u0002062\u0006\u00108\u001a\u000201H\u0000\u00a2\u0006\u0002\b?J\u0016\u0010@\u001a\u0002012\f\u0010A\u001a\b\u0012\u0004\u0012\u0002010BH\u0002R\u0014\u0010\n\u001a\u00020\u000bX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0019\u0010\u000f\u001a\u00070\u0010\u00a2\u0006\u0002\b\u00118DX\u0084\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R\u0014\u0010\u0006\u001a\u00020\u0007X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0014\u0010\b\u001a\u00020\tX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0014\u0010\u0018\u001a\u00020\u0019X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR\u0014\u0010\u0002\u001a\u00020\u0003X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001fR\u0014\u0010 \u001a\u00020!X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010\"R\u0019\u0010#\u001a\u00070$\u00a2\u0006\u0002\b\u0011X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b%\u0010&\u00a8\u0006C"}, d2={"Lcom/android/tools/idea/run/configuration/execution/AndroidConfigurationExecutorBase;", "Lcom/android/tools/idea/run/configuration/execution/AndroidConfigurationExecutor;", "environment", "Lcom/intellij/execution/runners/ExecutionEnvironment;", "deployTarget", "Lcom/android/tools/idea/run/editor/DeployTarget;", "appRunSettings", "Lcom/android/tools/idea/execution/common/AppRunSettings;", "applicationIdProvider", "Lcom/android/tools/idea/run/ApplicationIdProvider;", "apkProvider", "Lcom/android/tools/idea/run/ApkProvider;", "(Lcom/intellij/execution/runners/ExecutionEnvironment;Lcom/android/tools/idea/run/editor/DeployTarget;Lcom/android/tools/idea/execution/common/AppRunSettings;Lcom/android/tools/idea/run/ApplicationIdProvider;Lcom/android/tools/idea/run/ApkProvider;)V", "getApkProvider", "()Lcom/android/tools/idea/run/ApkProvider;", "appId", "", "Lorg/jetbrains/annotations/NotNull;", "getAppId", "()Ljava/lang/String;", "getAppRunSettings", "()Lcom/android/tools/idea/execution/common/AppRunSettings;", "getApplicationIdProvider", "()Lcom/android/tools/idea/run/ApplicationIdProvider;", "configuration", "Lcom/intellij/execution/configurations/RunConfiguration;", "getConfiguration", "()Lcom/intellij/execution/configurations/RunConfiguration;", "getDeployTarget", "()Lcom/android/tools/idea/run/editor/DeployTarget;", "getEnvironment", "()Lcom/intellij/execution/runners/ExecutionEnvironment;", "isDebug", "", "()Z", "project", "Lcom/intellij/openapi/project/Project;", "getProject", "()Lcom/intellij/openapi/project/Project;", "createConsole", "Lcom/intellij/execution/ui/ConsoleView;", "debug", "Lorg/jetbrains/concurrency/Promise;", "Lcom/intellij/execution/ui/RunContentDescriptor;", "getApplicationDeployer", "Lcom/android/tools/idea/execution/common/ApplicationDeployer;", "console", "getDevices", "", "Lcom/android/ddmlib/IDevice;", "stats", "Lcom/android/tools/idea/stats/RunStats;", "getStopCallback", "Lkotlin/Function1;", "", "launch", "device", "app", "Lcom/android/tools/deployer/model/App;", "run", "startDebugSession", "Lcom/intellij/xdebugger/impl/XDebugSessionImpl;", "terminatePreviousAppInstance", "terminatePreviousAppInstance$intellij_android_core", "waitForDevice", "deviceFuture", "Lcom/google/common/util/concurrent/ListenableFuture;", "intellij.android.core"})
public abstract class AndroidConfigurationExecutorBase
implements AndroidConfigurationExecutor {
    @NotNull
    private final ExecutionEnvironment environment;
    @NotNull
    private final DeployTarget deployTarget;
    @NotNull
    private final AppRunSettings appRunSettings;
    @NotNull
    private final ApplicationIdProvider applicationIdProvider;
    @NotNull
    private final ApkProvider apkProvider;
    @NotNull
    private final RunConfiguration configuration;
    @NotNull
    private final Project project;
    private final boolean isDebug;

    public AndroidConfigurationExecutorBase(@NotNull ExecutionEnvironment environment, @NotNull DeployTarget deployTarget2, @NotNull AppRunSettings appRunSettings2, @NotNull ApplicationIdProvider applicationIdProvider, @NotNull ApkProvider apkProvider) {
        Intrinsics.checkNotNullParameter((Object)environment, (String)"environment");
        Intrinsics.checkNotNullParameter((Object)deployTarget2, (String)"deployTarget");
        Intrinsics.checkNotNullParameter((Object)appRunSettings2, (String)"appRunSettings");
        Intrinsics.checkNotNullParameter((Object)applicationIdProvider, (String)"applicationIdProvider");
        Intrinsics.checkNotNullParameter((Object)apkProvider, (String)"apkProvider");
        this.environment = environment;
        this.deployTarget = deployTarget2;
        this.appRunSettings = appRunSettings2;
        this.applicationIdProvider = applicationIdProvider;
        this.apkProvider = apkProvider;
        RunProfile runProfile = this.environment.getRunProfile();
        Intrinsics.checkNotNull((Object)runProfile, (String)"null cannot be cast to non-null type com.intellij.execution.configurations.RunConfiguration");
        this.configuration = (RunConfiguration)runProfile;
        Project project = this.environment.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"environment.project");
        this.project = project;
        Executor executor2 = this.environment.getExecutor();
        Intrinsics.checkNotNullExpressionValue((Object)executor2, (String)"environment.executor");
        this.isDebug = com.android.tools.idea.run.configuration.UtilsKt.isDebug(executor2);
    }

    @NotNull
    protected final ExecutionEnvironment getEnvironment() {
        return this.environment;
    }

    @Override
    @NotNull
    public DeployTarget getDeployTarget() {
        return this.deployTarget;
    }

    @NotNull
    protected final AppRunSettings getAppRunSettings() {
        return this.appRunSettings;
    }

    @NotNull
    protected final ApplicationIdProvider getApplicationIdProvider() {
        return this.applicationIdProvider;
    }

    @NotNull
    protected final ApkProvider getApkProvider() {
        return this.apkProvider;
    }

    @Override
    @NotNull
    public RunConfiguration getConfiguration() {
        return this.configuration;
    }

    @NotNull
    protected final Project getProject() {
        return this.project;
    }

    @NotNull
    protected final String getAppId() {
        String string = this.applicationIdProvider.getPackageName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"applicationIdProvider.packageName");
        return string;
    }

    protected final boolean isDebug() {
        return this.isDebug;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @WorkerThread
    @NotNull
    public Promise<RunContentDescriptor> run() {
        void $this$toTypedArray$iv;
        void $this$mapTo$iv$iv;
        RunStats.from(this.environment).beginLaunchTasks();
        AsyncPromise promise = new AsyncPromise();
        RunStats runStats = RunStats.from(this.environment);
        Intrinsics.checkNotNullExpressionValue((Object)runStats, (String)"from(environment)");
        List<IDevice> devices2 = this.getDevices(runStats);
        ConsoleView console = this.createConsole();
        AndroidProcessHandler processHandler2 = new AndroidProcessHandler(this.project, this.getAppId(), this.getStopCallback(console, false), false, null, null, null, 120, null);
        ApplicationDeployer applicationInstaller = this.getApplicationDeployer(console);
        Function1 onDevice2 = (Function1)new Function1<IDevice, Unit>(this, applicationInstaller, console, processHandler2){
            final /* synthetic */ AndroidConfigurationExecutorBase this$0;
            final /* synthetic */ ApplicationDeployer $applicationInstaller;
            final /* synthetic */ ConsoleView $console;
            final /* synthetic */ AndroidProcessHandler $processHandler;
            {
                this.this$0 = $receiver;
                this.$applicationInstaller = $applicationInstaller;
                this.$console = $console;
                this.$processHandler = $processHandler;
                super(1);
            }

            public final void invoke(@NotNull IDevice device2) {
                Deployer.Result result2;
                Intrinsics.checkNotNullParameter((Object)device2, (String)"device");
                this.this$0.terminatePreviousAppInstance$intellij_android_core(device2);
                try {
                    Collection<ApkInfo> collection2 = this.this$0.getApkProvider().getApks(device2);
                    Intrinsics.checkNotNullExpressionValue(collection2, (String)"apkProvider.getApks(device)");
                    ApkInfo app = (ApkInfo)CollectionsKt.single((Iterable)collection2);
                    Intrinsics.checkNotNullExpressionValue((Object)app, (String)"app");
                    result2 = this.$applicationInstaller.fullDeploy(device2, app, this.this$0.getAppRunSettings().getDeployOptions());
                }
                catch (DeployerException e) {
                    String string = this.this$0.getAppId();
                    String string2 = e.getDetails();
                    if (string2 == null) {
                        string2 = "";
                    }
                    throw new com.intellij.execution.ExecutionException("Failed to install app '" + string + "'. " + string2, (Throwable)e);
                }
                Deployer.Result result3 = result2;
                App app = result3.app;
                Intrinsics.checkNotNullExpressionValue((Object)app, (String)"result.app");
                this.this$0.launch(device2, app, this.$console, false);
                this.$processHandler.addTargetDevice(device2);
            }
        };
        ExecutorService executorService = AppExecutorUtil.createBoundedApplicationPoolExecutor((String)"AndroidConfigurationExecutorBase", (int)5);
        Intrinsics.checkNotNullExpressionValue((Object)executorService, (String)"createBoundedApplication\u2026gurationExecutorBase\", 5)");
        ExecutorService executor2 = executorService;
        Iterable $this$map$iv = devices2;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            IDevice iDevice = (IDevice)item$iv$iv;
            Collection collection2 = destination$iv$iv;
            boolean bl = false;
            collection2.add(CompletableFuture.supplyAsync(new Supplier((Function1<? super IDevice, Unit>)onDevice2, (IDevice)it){
                final /* synthetic */ Function1<IDevice, Unit> $onDevice;
                final /* synthetic */ IDevice $it;
                {
                    this.$onDevice = $onDevice;
                    this.$it = $it;
                }

                public final void get() {
                    this.$onDevice.invoke((Object)this.$it);
                }
            }, executor2));
        }
        $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$toTypedArray = false;
        void thisCollection$iv = $this$toTypedArray$iv;
        CompletableFuture[] completableFutureArray = thisCollection$iv.toArray(new CompletableFuture[0]);
        if (completableFutureArray == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T of kotlin.collections.ArraysKt__ArraysJVMKt.toTypedArray>");
        }
        CompletableFuture[] futures2 = completableFutureArray;
        CompletableFuture.allOf(Arrays.copyOf(futures2, futures2.length)).handle(new BiFunction((AsyncPromise<RunContentDescriptor>)promise, processHandler2, console, this){
            final /* synthetic */ AsyncPromise<RunContentDescriptor> $promise;
            final /* synthetic */ AndroidProcessHandler $processHandler;
            final /* synthetic */ ConsoleView $console;
            final /* synthetic */ AndroidConfigurationExecutorBase this$0;
            {
                this.$promise = $promise;
                this.$processHandler = $processHandler;
                this.$console = $console;
                this.this$0 = $receiver;
            }

            public final void apply(Void void_, Throwable exception) {
                if (exception != null) {
                    if (exception instanceof CompletionException && exception.getCause() != null) {
                        Throwable throwable = exception.getCause();
                        Intrinsics.checkNotNull((Object)throwable);
                        this.$promise.setError(throwable);
                    } else {
                        this.$promise.setError(exception);
                    }
                    return;
                }
                UtilsKt.createRunContentDescriptor(this.$processHandler, this.$console, this.this$0.getEnvironment()).processed((Promise)this.$promise);
                RunStats.from(this.this$0.getEnvironment()).endLaunchTasks();
            }
        });
        return (Promise)promise;
    }

    @Override
    @WorkerThread
    @NotNull
    public Promise<RunContentDescriptor> debug() {
        RunStats.from(this.environment).beginLaunchTasks();
        AsyncPromise promise = new AsyncPromise();
        RunStats runStats = RunStats.from(this.environment);
        Intrinsics.checkNotNullExpressionValue((Object)runStats, (String)"from(environment)");
        List<IDevice> devices2 = this.getDevices(runStats);
        if (devices2.size() > 1) {
            throw new com.intellij.execution.ExecutionException("Debugging is allowed only for single device");
        }
        ConsoleView console = this.createConsole();
        IDevice device2 = (IDevice)CollectionsKt.single(devices2);
        this.terminatePreviousAppInstance$intellij_android_core(device2);
        Collection<ApkInfo> collection2 = this.apkProvider.getApks(device2);
        Intrinsics.checkNotNullExpressionValue(collection2, (String)"apkProvider.getApks(device)");
        ApkInfo app = (ApkInfo)CollectionsKt.single((Iterable)collection2);
        ApplicationDeployer applicationDeployer = this.getApplicationDeployer(console);
        Intrinsics.checkNotNullExpressionValue((Object)app, (String)"app");
        Deployer.Result deployResult = applicationDeployer.fullDeploy(device2, app, this.appRunSettings.getDeployOptions());
        FutureUtils.executeOnPooledThread((Function0)((Function0)new Function0<Promise<RunContentDescriptor>>((AsyncPromise<RunContentDescriptor>)promise, this, device2, console){
            final /* synthetic */ AsyncPromise<RunContentDescriptor> $promise;
            final /* synthetic */ AndroidConfigurationExecutorBase this$0;
            final /* synthetic */ IDevice $device;
            final /* synthetic */ ConsoleView $console;
            {
                this.$promise = $promise;
                this.this$0 = $receiver;
                this.$device = $device;
                this.$console = $console;
                super(0);
            }

            /*
             * WARNING - void declaration
             */
            @Nullable
            public final Promise<RunContentDescriptor> invoke() {
                Promise promise;
                AsyncPromise<RunContentDescriptor> asyncPromise = this.$promise;
                AndroidConfigurationExecutorBase androidConfigurationExecutorBase = this.this$0;
                IDevice iDevice = this.$device;
                ConsoleView consoleView = this.$console;
                AsyncPromise<RunContentDescriptor> asyncPromise2 = this.$promise;
                boolean $i$f$catchError = false;
                try {
                    boolean bl = false;
                    promise = androidConfigurationExecutorBase.startDebugSession(iDevice, consoleView).onError(new Consumer(asyncPromise2){
                        final /* synthetic */ AsyncPromise<RunContentDescriptor> $tmp0;
                        {
                            this.$tmp0 = $tmp0;
                        }

                        public final void accept(@NotNull Throwable p0) {
                            Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                            this.$tmp0.setError(p0);
                        }
                    }).then((Function)debug.1.2.INSTANCE).processed((Promise)asyncPromise2);
                }
                catch (Throwable e$iv) {
                    void $this$catchError$iv;
                    $this$catchError$iv.setError(e$iv);
                    promise = null;
                }
                return promise;
            }
        }));
        App app2 = deployResult.app;
        Intrinsics.checkNotNullExpressionValue((Object)app2, (String)"deployResult.app");
        this.launch(device2, app2, console, true);
        promise.onSuccess(new Consumer(this){
            final /* synthetic */ AndroidConfigurationExecutorBase this$0;
            {
                this.this$0 = $receiver;
            }

            public final void accept(@NotNull RunContentDescriptor it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                RunStats.from(this.this$0.getEnvironment()).endLaunchTasks();
            }
        });
        return (Promise)promise;
    }

    @NotNull
    protected abstract Function1<IDevice, Unit> getStopCallback(@NotNull ConsoleView var1, boolean var2) throws com.intellij.execution.ExecutionException;

    @VisibleForTesting
    public abstract void launch(@NotNull IDevice var1, @NotNull App var2, @NotNull ConsoleView var3, boolean var4) throws com.intellij.execution.ExecutionException;

    @NotNull
    protected abstract Promise<XDebugSessionImpl> startDebugSession(@NotNull IDevice var1, @NotNull ConsoleView var2);

    /*
     * WARNING - void declaration
     */
    private final List<IDevice> getDevices(RunStats stats) throws com.intellij.execution.ExecutionException {
        IDevice it;
        void $this$mapTo$iv$iv;
        ProgressManager.checkCanceled();
        ProgressIndicator progressIndicator = ProgressIndicatorProvider.getGlobalProgressIndicator();
        if (progressIndicator != null) {
            progressIndicator.setText("Waiting for all target devices to come online");
        }
        DeviceFutures deviceFutures = this.getDeployTarget().getDevices(this.project);
        if (deviceFutures == null) {
            throw new com.intellij.execution.ExecutionException(AndroidBundle.message("deployment.target.not.found", new Object[0]));
        }
        DeviceFutures deviceFutureList = deviceFutures;
        List<ListenableFuture<IDevice>> list2 = deviceFutureList.get();
        Intrinsics.checkNotNullExpressionValue(list2, (String)"deviceFutureList.get()");
        Iterable $this$map$iv = list2;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            ListenableFuture listenableFuture = (ListenableFuture)item$iv$iv;
            Collection collection2 = destination$iv$iv;
            boolean bl = false;
            ProgressManager.checkCanceled();
            stats.beginWaitForDevice();
            Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
            IDevice device2 = this.waitForDevice((ListenableFuture<IDevice>)it);
            stats.endWaitForDevice(device2);
            collection2.add(device2);
        }
        List devices2 = (List)destination$iv$iv;
        if (devices2.isEmpty()) {
            throw new com.intellij.execution.ExecutionException(AndroidBundle.message("deployment.target.not.found", new Object[0]));
        }
        Iterable $this$onEach$iv = devices2;
        boolean $i$f$onEach = false;
        Iterable $this$onEach_u24lambda_u2d16$iv = iterable = $this$onEach$iv;
        boolean bl = false;
        for (Object element$iv : $this$onEach_u24lambda_u2d16$iv) {
            it = (IDevice)element$iv;
            boolean bl2 = false;
            LaunchUtils.initiateDismissKeyguard(it);
        }
        return (List)iterable;
    }

    public final void terminatePreviousAppInstance$intellij_android_core(@NotNull IDevice device2) {
        Intrinsics.checkNotNullParameter((Object)device2, (String)"device");
        ApplicationTerminator terminator = new ApplicationTerminator(device2, this.getAppId());
        if (!terminator.killApp()) {
            throw new com.intellij.execution.ExecutionException("Could not terminate running app " + this.getAppId());
        }
    }

    private final IDevice waitForDevice(ListenableFuture<IDevice> deviceFuture) {
        long start2 = System.currentTimeMillis();
        long timeoutMs = TimeUnit.MINUTES.toMillis(1L);
        while (System.currentTimeMillis() - start2 < timeoutMs) {
            try {
                Object object = deviceFuture.get(1L, TimeUnit.SECONDS);
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"deviceFuture.get(1, TimeUnit.SECONDS)");
                return (IDevice)object;
            }
            catch (TimeoutException ignored) {
                ProgressManager.checkCanceled();
            }
            catch (InterruptedException e) {
                throw new com.intellij.execution.ExecutionException("Interrupted while waiting for device", (Throwable)e);
            }
            catch (ExecutionException e) {
                Throwable throwable = e.getCause();
                Intrinsics.checkNotNull((Object)throwable);
                throw new com.intellij.execution.ExecutionException("Error while waiting for device: " + throwable.getMessage(), (Throwable)e);
            }
        }
        throw new com.intellij.execution.ExecutionException("Device didn't come online");
    }

    @NotNull
    public ApplicationDeployer getApplicationDeployer(@NotNull ConsoleView console) throws com.intellij.execution.ExecutionException {
        Intrinsics.checkNotNullParameter((Object)console, (String)"console");
        return new ApplicationDeployerImpl(this.project, console);
    }

    private final ConsoleView createConsole() {
        ConsoleView consoleView = TextConsoleBuilderFactory.getInstance().createBuilder(this.project).getConsole();
        Intrinsics.checkNotNullExpressionValue((Object)consoleView, (String)"getInstance().createBuilder(project).console");
        ConsoleView console = consoleView;
        Disposer.register((Disposable)((Disposable)this.project), (Disposable)((Disposable)console));
        return console;
    }
}

