/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.run.configuration.execution;

import com.android.annotations.concurrency.WorkerThread;
import com.android.ddmlib.IDevice;
import com.android.ddmlib.IShellOutputReceiver;
import com.android.tools.deployer.DeployerException;
import com.android.tools.deployer.model.App;
import com.android.tools.deployer.model.component.AppComponent;
import com.android.tools.deployer.model.component.ComponentType;
import com.android.tools.idea.execution.common.AppRunSettings;
import com.android.tools.idea.execution.common.ComponentLaunchOptions;
import com.android.tools.idea.execution.common.DeployOptions;
import com.android.tools.idea.run.ApkInfo;
import com.android.tools.idea.run.ApkProvider;
import com.android.tools.idea.run.ApplicationIdProvider;
import com.android.tools.idea.run.configuration.AndroidComplicationConfiguration;
import com.android.tools.idea.run.configuration.ComplicationTypeUtilsKt;
import com.android.tools.idea.run.configuration.ComplicationWatchFaceInfo;
import com.android.tools.idea.run.configuration.execution.AndroidComplicationConfigurationExecutorKt;
import com.android.tools.idea.run.configuration.execution.AndroidWearConfigurationExecutor;
import com.android.tools.idea.run.configuration.execution.ComplicationLaunchOptions;
import com.android.tools.idea.run.configuration.execution.RecordOutputReceiver;
import com.android.tools.idea.run.configuration.execution.SurfaceVersionException;
import com.android.tools.idea.run.configuration.execution.UtilsKt;
import com.android.tools.idea.run.editor.DeployTarget;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicatorProvider;
import com.intellij.openapi.progress.ProgressManager;
import java.io.File;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0016\u0018\u00002\u00020\u0001B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ!\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u00102\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u0013H\u0000\u00a2\u0006\u0002\b\u0015J$\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u00020\u00190\u00172\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0014J\u0018\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u00182\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J(\u0010!\u001a\u00020\u00192\u0006\u0010 \u001a\u00020\u00182\u0006\u0010\"\u001a\u00020\u001f2\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0017J*\u0010#\u001a\u00020\u00192\u0006\u0010\"\u001a\u00020\u001f2\u0006\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020'2\b\u0010(\u001a\u0004\u0018\u00010)H\u0002R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006*"}, d2={"Lcom/android/tools/idea/run/configuration/execution/AndroidComplicationConfigurationExecutor;", "Lcom/android/tools/idea/run/configuration/execution/AndroidWearConfigurationExecutor;", "environment", "Lcom/intellij/execution/runners/ExecutionEnvironment;", "deployTarget", "Lcom/android/tools/idea/run/editor/DeployTarget;", "appRunSettings", "Lcom/android/tools/idea/execution/common/AppRunSettings;", "applicationIdProvider", "Lcom/android/tools/idea/run/ApplicationIdProvider;", "apkProvider", "Lcom/android/tools/idea/run/ApkProvider;", "(Lcom/intellij/execution/runners/ExecutionEnvironment;Lcom/android/tools/idea/run/editor/DeployTarget;Lcom/android/tools/idea/execution/common/AppRunSettings;Lcom/android/tools/idea/run/ApplicationIdProvider;Lcom/android/tools/idea/run/ApkProvider;)V", "complicationLaunchOptions", "Lcom/android/tools/idea/run/configuration/execution/ComplicationLaunchOptions;", "getComplicationSourceTypes", "", "", "apks", "", "Lcom/android/tools/idea/run/ApkInfo;", "getComplicationSourceTypes$intellij_android_core", "getStopCallback", "Lkotlin/Function1;", "Lcom/android/ddmlib/IDevice;", "", "console", "Lcom/intellij/execution/ui/ConsoleView;", "isDebug", "", "installWatchApp", "Lcom/android/tools/deployer/model/App;", "device", "launch", "app", "setComplicationOnWatchFace", "slot", "Lcom/android/tools/idea/run/configuration/AndroidComplicationConfiguration$ChosenSlot;", "mode", "Lcom/android/tools/deployer/model/component/AppComponent$Mode;", "indicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "intellij.android.core"})
public class AndroidComplicationConfigurationExecutor
extends AndroidWearConfigurationExecutor {
    @NotNull
    private final ComplicationLaunchOptions complicationLaunchOptions;

    public AndroidComplicationConfigurationExecutor(@NotNull ExecutionEnvironment environment, @NotNull DeployTarget deployTarget2, @NotNull AppRunSettings appRunSettings2, @NotNull ApplicationIdProvider applicationIdProvider, @NotNull ApkProvider apkProvider) {
        Intrinsics.checkNotNullParameter((Object)environment, (String)"environment");
        Intrinsics.checkNotNullParameter((Object)deployTarget2, (String)"deployTarget");
        Intrinsics.checkNotNullParameter((Object)appRunSettings2, (String)"appRunSettings");
        Intrinsics.checkNotNullParameter((Object)applicationIdProvider, (String)"applicationIdProvider");
        Intrinsics.checkNotNullParameter((Object)apkProvider, (String)"apkProvider");
        super(environment, deployTarget2, appRunSettings2, applicationIdProvider, apkProvider);
        ComponentLaunchOptions componentLaunchOptions = appRunSettings2.getComponentLaunchOptions();
        Intrinsics.checkNotNull((Object)componentLaunchOptions, (String)"null cannot be cast to non-null type com.android.tools.idea.run.configuration.execution.ComplicationLaunchOptions");
        this.complicationLaunchOptions = (ComplicationLaunchOptions)componentLaunchOptions;
    }

    @Override
    @WorkerThread
    public void launch(@NotNull IDevice device2, @NotNull App app, @NotNull ConsoleView console, boolean isDebug) {
        Intrinsics.checkNotNullParameter((Object)device2, (String)"device");
        Intrinsics.checkNotNullParameter((Object)app, (String)"app");
        Intrinsics.checkNotNullParameter((Object)console, (String)"console");
        AppComponent.Mode mode = isDebug ? AppComponent.Mode.DEBUG : AppComponent.Mode.RUN;
        int version2 = UtilsKt.getWearDebugSurfaceVersion(device2);
        if (version2 < 2) {
            throw new SurfaceVersionException(2, version2, device2.isEmulator());
        }
        if (version2 < 3) {
            String string = AndroidBundle.message("android.run.configuration.debug.surface.warn", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(\"android.run.con\u2026tion.debug.surface.warn\")");
            UtilsKt.printError(console, string);
        }
        ProgressManager.checkCanceled();
        Collection<ApkInfo> collection2 = this.getApkProvider().getApks(device2);
        Intrinsics.checkNotNullExpressionValue(collection2, (String)"apkProvider.getApks(device)");
        this.complicationLaunchOptions.verifyProviderTypes$intellij_android_core(ComplicationTypeUtilsKt.parseRawComplicationTypes(this.getComplicationSourceTypes$intellij_android_core(collection2)));
        ProgressManager.checkCanceled();
        this.installWatchApp(device2, console);
        Iterable $this$forEach$iv = this.complicationLaunchOptions.getChosenSlots();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            AndroidComplicationConfiguration.ChosenSlot slot = (AndroidComplicationConfiguration.ChosenSlot)element$iv;
            boolean bl = false;
            this.setComplicationOnWatchFace(app, slot, mode, ProgressIndicatorProvider.getGlobalProgressIndicator());
        }
        this.showWatchFace(device2, console);
    }

    private final void setComplicationOnWatchFace(App app, AndroidComplicationConfiguration.ChosenSlot slot, AppComponent.Mode mode, ProgressIndicator indicator) {
        if (slot.getType() == null) {
            throw new ExecutionException("Slot type is not specified for slot(id: " + slot.getId() + ").");
        }
        RecordOutputReceiver receiver2 = new RecordOutputReceiver((Function0<Boolean>)((Function0)new Function0<Boolean>(indicator){
            final /* synthetic */ ProgressIndicator $indicator;
            {
                this.$indicator = $indicator;
                super(0);
            }

            @NotNull
            public final Boolean invoke() {
                ProgressIndicator progressIndicator = this.$indicator;
                return progressIndicator != null ? progressIndicator.isCanceled() : false;
            }
        }));
        String watchFaceInfo = this.complicationLaunchOptions.watchFaceInfo.getAppId() + " " + this.complicationLaunchOptions.watchFaceInfo.getWatchFaceFQName();
        try {
            ComponentType componentType = this.complicationLaunchOptions.getComponentType();
            String string = this.complicationLaunchOptions.getComponentName();
            Intrinsics.checkNotNull((Object)string);
            app.activateComponent(componentType, string, watchFaceInfo + " " + slot.getId() + " " + slot.getType(), mode, (IShellOutputReceiver)receiver2);
        }
        catch (DeployerException ex) {
            CharSequence charSequence;
            CharSequence charSequence2 = receiver2.getOutput();
            if (charSequence2.length() == 0) {
                boolean bl = false;
                charSequence = ex.getDetails();
            } else {
                charSequence = charSequence2;
            }
            Throwable throwable = ex;
            String string = "Error while launching complication, message: " + charSequence;
            throw new ExecutionException(string, throwable);
        }
    }

    @NotNull
    public final List<String> getComplicationSourceTypes$intellij_android_core(@NotNull Collection<ApkInfo> apks2) {
        List list2;
        Intrinsics.checkNotNullParameter(apks2, (String)"apks");
        try {
            String string = this.complicationLaunchOptions.getComponentName();
            Intrinsics.checkNotNull((Object)string);
            list2 = ComplicationTypeUtilsKt.getComplicationSourceTypes(apks2, string);
        }
        catch (Exception exception) {
            Logger.getInstance(this.getClass()).warn((Throwable)exception);
            list2 = CollectionsKt.emptyList();
        }
        return list2;
    }

    private final App installWatchApp(IDevice device2, ConsoleView console) {
        ComplicationWatchFaceInfo watchFaceInfo = this.complicationLaunchOptions.watchFaceInfo;
        ApkInfo apkInfo = new ApkInfo(new File(watchFaceInfo.getApk()), watchFaceInfo.getAppId());
        App app = this.getApplicationDeployer((ConsoleView)console).fullDeploy((IDevice)device2, (ApkInfo)apkInfo, (DeployOptions)this.getAppRunSettings().getDeployOptions()).app;
        Intrinsics.checkNotNullExpressionValue((Object)app, (String)"getApplicationDeployer(c\u2026ttings.deployOptions).app");
        return app;
    }

    @Override
    @NotNull
    protected Function1<IDevice, Unit> getStopCallback(@NotNull ConsoleView console, boolean isDebug) {
        Intrinsics.checkNotNullParameter((Object)console, (String)"console");
        String string = this.getAppId();
        String string2 = this.complicationLaunchOptions.getComponentName();
        Intrinsics.checkNotNull((Object)string2);
        String complicationComponentName = AppComponent.getFQEscapedName((String)string, (String)string2);
        Intrinsics.checkNotNullExpressionValue((Object)complicationComponentName, (String)"complicationComponentName");
        return AndroidComplicationConfigurationExecutorKt.access$getStopComplicationCallback(complicationComponentName, console, isDebug);
    }
}

