/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.run.activity.launch;

import com.android.ddmlib.IDevice;
import com.android.ddmlib.IShellOutputReceiver;
import com.android.tools.deployer.model.App;
import com.android.tools.idea.instantapp.InstantAppUrlFinder;
import com.android.tools.idea.instantapp.InstantApps;
import com.android.tools.idea.run.ApkProvider;
import com.android.tools.idea.run.ValidationError;
import com.android.tools.idea.run.activity.StartActivityFlagsProvider;
import com.android.tools.idea.run.activity.launch.ActivityLaunchOption;
import com.android.tools.idea.run.activity.launch.ActivityLaunchOptionState;
import com.android.tools.idea.run.activity.launch.DeepLinkConfigurable;
import com.android.tools.idea.run.activity.launch.LaunchOptionConfigurable;
import com.android.tools.idea.run.activity.launch.LaunchOptionConfigurableContext;
import com.android.tools.idea.run.configuration.AndroidBackgroundTaskReceiver;
import com.android.tools.idea.run.editor.ProfilerState;
import com.android.tools.idea.run.tasks.AndroidDeepLinkLaunchTask;
import com.android.tools.idea.run.tasks.AppLaunchTask;
import com.google.common.collect.ImmutableList;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.facet.AndroidFacetConfiguration;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DeepLinkLaunch
extends ActivityLaunchOption<State> {
    public static final DeepLinkLaunch INSTANCE = new DeepLinkLaunch();

    @Override
    @NotNull
    public String getId() {
        return "launch_deep_link";
    }

    @Override
    @NotNull
    public String getDisplayName() {
        return "URL";
    }

    @Override
    @NotNull
    public State createState() {
        return new State();
    }

    @Override
    @NotNull
    public LaunchOptionConfigurable<State> createConfigurable(@NotNull Project project, @NotNull LaunchOptionConfigurableContext context2) {
        return new DeepLinkConfigurable(project, context2);
    }

    public static final class State
    extends ActivityLaunchOptionState {
        public String DEEP_LINK = "";

        @Override
        @Nullable
        public AppLaunchTask getLaunchTask(@NotNull String applicationId2, @NotNull AndroidFacet facet2, @NotNull StartActivityFlagsProvider startActivityFlagsProvider, @NotNull ProfilerState profilerState, @NotNull ApkProvider apkProvider) {
            return new AndroidDeepLinkLaunchTask(this.DEEP_LINK, startActivityFlagsProvider);
        }

        @Override
        public void launch(@NotNull IDevice device2, @NotNull App app, @NotNull ApkProvider apkProvider, boolean isDebug, @NotNull String extraFlags, @NotNull ConsoleView console) throws ExecutionException {
            AndroidBackgroundTaskReceiver receiver2 = new AndroidBackgroundTaskReceiver(console);
            String quotedLink = "'" + this.DEEP_LINK.replace("'", "'\\''") + "'";
            String command2 = "am start -a android.intent.action.VIEW -c android.intent.category.BROWSABLE -d " + quotedLink + (String)(extraFlags.isEmpty() ? "" : " " + extraFlags);
            console.print("$ adb shell " + command2, ConsoleViewContentType.NORMAL_OUTPUT);
            try {
                device2.executeShellCommand(command2, (IShellOutputReceiver)receiver2, 15L, TimeUnit.SECONDS);
            }
            catch (Exception e) {
                Logger logger2 = Logger.getInstance(DeepLinkLaunch.class);
                logger2.warn("Unexpected exception while executing shell command: " + command2);
                logger2.warn((Throwable)e);
                throw new ExecutionException("Unexpected error while executing: " + command2);
            }
        }

        @Override
        @NotNull
        public List<ValidationError> checkConfiguration(@NotNull AndroidFacet facet2) {
            boolean isInstantApp;
            boolean bl = isInstantApp = ((AndroidFacetConfiguration)facet2.getConfiguration()).getProjectType() == 4;
            if (this.DEEP_LINK == null || this.DEEP_LINK.isEmpty()) {
                if (isInstantApp) {
                    return ImmutableList.of();
                }
                return ImmutableList.of((Object)ValidationError.warning("URL not specified"));
            }
            if (isInstantApp) {
                boolean matched = false;
                List<Module> featureModules = InstantApps.findFeatureModules(facet2);
                for (Module featureModule : featureModules) {
                    if (!new InstantAppUrlFinder(featureModule).matchesUrl(this.DEEP_LINK)) continue;
                    matched = true;
                    break;
                }
                if (!matched) {
                    return ImmutableList.of((Object)ValidationError.warning("URL \"" + this.DEEP_LINK + "\" not defined in the manifest."));
                }
            }
            return ImmutableList.of();
        }
    }
}

