/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.run.activity;

import com.android.ddmlib.IDevice;
import com.android.tools.idea.model.ActivitiesAndAliases;
import com.android.tools.idea.model.AndroidManifestIndexQueryUtils;
import com.android.tools.idea.run.activity.ActivityLocator;
import com.android.tools.idea.run.activity.ActivityLocatorUtils;
import com.android.tools.idea.run.activity.DefaultActivityLocator;
import com.intellij.execution.JavaExecutionUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.ProjectScope;
import com.intellij.util.Function;
import org.jetbrains.android.dom.manifest.Manifest;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SpecificActivityLocator
extends ActivityLocator {
    @NotNull
    private final AndroidFacet myFacet;
    @Nullable
    private final String myActivityName;
    @NotNull
    private final GlobalSearchScope mySearchScope;

    public SpecificActivityLocator(@NotNull AndroidFacet facet2, @Nullable String activityName, @NotNull GlobalSearchScope searchScope) {
        this.myFacet = facet2;
        this.myActivityName = activityName;
        this.mySearchScope = searchScope;
    }

    public SpecificActivityLocator(@NotNull AndroidFacet facet2, @Nullable String activityName) {
        this(facet2, activityName, GlobalSearchScope.projectScope((Project)facet2.getModule().getProject()));
    }

    @Override
    @NotNull
    public String getQualifiedActivityName(@NotNull IDevice device2) {
        assert (this.myActivityName != null);
        return this.myActivityName;
    }

    @Override
    public void validate() throws ActivityLocator.ActivityLocatorException {
        if (this.myActivityName == null || this.myActivityName.isEmpty()) {
            throw new ActivityLocator.ActivityLocatorException(AndroidBundle.message("activity.class.not.specified.error", new Object[0]));
        }
        if (SpecificActivityLocator.doesPackageContainMavenProperty(this.myFacet)) {
            return;
        }
        Module module2 = this.myFacet.getModule();
        Project project = module2.getProject();
        JavaPsiFacade facade = JavaPsiFacade.getInstance((Project)project);
        PsiClass activityClass = facade.findClass("android.app.Activity", ProjectScope.getAllScope((Project)project));
        if (activityClass == null) {
            throw new ActivityLocator.ActivityLocatorException(AndroidBundle.message("cant.find.activity.class.error", new Object[0]));
        }
        PsiClass specifiedActivityClass = JavaExecutionUtil.findMainClass((Project)project, (String)this.myActivityName, (GlobalSearchScope)this.mySearchScope);
        this.validateBasedOnManifestIndex(activityClass, specifiedActivityClass);
    }

    private void validateBasedOnManifestIndex(@NotNull PsiClass activityClass, @Nullable PsiClass specifiedActivityClass) throws ActivityLocator.ActivityLocatorException {
        if (DumbService.isDumb((Project)this.myFacet.getModule().getProject())) {
            return;
        }
        ActivitiesAndAliases activityWrappers = AndroidManifestIndexQueryUtils.queryActivitiesFromManifestIndex(this.myFacet);
        this.validateHelper(activityClass, specifiedActivityClass, (Function<String, DefaultActivityLocator.ActivityWrapper>)((Function)activityWrappers::findActivityByName), (Function<String, DefaultActivityLocator.ActivityWrapper>)((Function)activityWrappers::findAliasByName));
    }

    private void validateHelper(@NotNull PsiClass activityClass, @Nullable PsiClass specifiedActivityClass, Function<String, DefaultActivityLocator.ActivityWrapper> getActivity, Function<String, DefaultActivityLocator.ActivityWrapper> getAlias) throws ActivityLocator.ActivityLocatorException {
        DefaultActivityLocator.ActivityWrapper specifiedActivity;
        if (specifiedActivityClass == null || !specifiedActivityClass.isInheritor(activityClass, true)) {
            specifiedActivity = (DefaultActivityLocator.ActivityWrapper)getAlias.fun((Object)this.myActivityName);
            if (specifiedActivity == null) {
                throw new ActivityLocator.ActivityLocatorException(AndroidBundle.message("not.activity.subclass.error", this.myActivityName));
            }
        } else {
            String qualifiedActivityName = ActivityLocatorUtils.getQualifiedActivityName(specifiedActivityClass);
            specifiedActivity = (DefaultActivityLocator.ActivityWrapper)getActivity.fun((Object)qualifiedActivityName);
            if (specifiedActivity == null) {
                throw new ActivityLocator.ActivityLocatorException(AndroidBundle.message("activity.not.declared.in.manifest", specifiedActivityClass.getName()));
            }
        }
        if (!specifiedActivity.isLogicallyExported()) {
            throw new ActivityLocator.ActivityLocatorException(AndroidBundle.message("specific.activity.not.launchable.error", new Object[0]));
        }
    }

    private static boolean doesPackageContainMavenProperty(@NotNull AndroidFacet facet2) {
        Manifest manifest = Manifest.getMainManifest(facet2);
        if (manifest == null) {
            return false;
        }
        String aPackage = manifest.getPackage().getStringValue();
        return aPackage != null && aPackage.contains("${");
    }
}

