/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.run;

import com.android.tools.idea.execution.common.AndroidExecutionTarget;
import com.android.tools.idea.execution.common.AndroidSessionInfo;
import com.android.tools.idea.gradle.project.sync.GradleSyncState;
import com.android.tools.idea.run.AndroidProgramRunner;
import com.android.tools.idea.run.AndroidRunConfiguration;
import com.android.tools.idea.run.AndroidRunConfigurationBase;
import com.android.tools.idea.run.configuration.AndroidConfigurationProgramRunner;
import com.android.tools.idea.run.util.SwapInfo;
import com.android.tools.idea.testartifacts.instrumented.AndroidTestRunConfiguration;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.ExecutionResult;
import com.intellij.execution.Executor;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.runners.DefaultProgramRunnerKt;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.runners.ProgramRunner;
import com.intellij.execution.ui.ExecutionConsole;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.execution.ui.RunContentDescriptorReusePolicy;
import com.intellij.execution.ui.RunContentManager;
import com.intellij.execution.ui.RunnerLayoutUi;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Disposer;
import com.intellij.ui.content.Content;
import com.intellij.util.ThreeState;
import java.util.function.BiFunction;
import java.util.function.Function;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class StudioProgramRunner
extends AndroidProgramRunner {
    @NotNull
    private final Function<Project, GradleSyncState> mySyncStateGetter;

    public StudioProgramRunner() {
        this.mySyncStateGetter = project -> GradleSyncState.getInstance(project);
    }

    StudioProgramRunner(@NotNull Function<Project, GradleSyncState> syncStateGetter, @NotNull @NotNull BiFunction<@NotNull Project, @NotNull RunConfiguration, @NotNull AndroidExecutionTarget> executionTargetGetter) {
        super(executionTargetGetter);
        this.mySyncStateGetter = syncStateGetter;
    }

    @Override
    public boolean canRun(@NotNull String executorId, @NotNull RunProfile profile) {
        if (!super.canRun(executorId, profile) || !(profile instanceof AndroidRunConfigurationBase)) {
            return false;
        }
        AndroidRunConfigurationBase config2 = (AndroidRunConfigurationBase)profile;
        if (config2.canRunWithoutSync()) {
            return true;
        }
        if (config2 instanceof AndroidRunConfiguration && AndroidConfigurationProgramRunner.Companion.getUseNewExecutionForActivities()) {
            return false;
        }
        GradleSyncState syncState = this.mySyncStateGetter.apply(config2.getProject());
        return !syncState.isSyncInProgress() && syncState.isSyncNeeded().equals((Object)ThreeState.NO);
    }

    @Nullable
    protected RunContentDescriptor doExecute(@NotNull RunProfileState state2, @NotNull ExecutionEnvironment env) throws ExecutionException {
        Project project = env.getProject();
        Executor executor2 = env.getExecutor();
        String executorId = executor2.getId();
        boolean isTestConfig = env.getRunProfile() instanceof AndroidTestRunConfiguration;
        RunnerAndConfigurationSettings settings = env.getRunnerAndConfigurationSettings();
        SwapInfo swapInfo = (SwapInfo)env.getUserData(SwapInfo.SWAP_INFO_KEY);
        if (settings != null && swapInfo == null) {
            settings.setActivateToolWindowBeforeRun(isTestConfig || settings.isActivateToolWindowBeforeRun());
        }
        FileDocumentManager.getInstance().saveAllDocuments();
        ExecutionResult result2 = state2.execute(executor2, (ProgramRunner)this);
        RunContentDescriptor descriptor2 = null;
        if (swapInfo != null && result2 != null) {
            RunContentManager manager = RunContentManager.getInstance((Project)project);
            descriptor2 = manager.findContentDescriptor(executor2, result2.getProcessHandler());
        }
        if (descriptor2 == null || descriptor2.getAttachedContent() == null) {
            descriptor2 = DefaultProgramRunnerKt.showRunContent((ExecutionResult)result2, (ExecutionEnvironment)env);
        } else if (!(descriptor2 instanceof HiddenRunContentDescriptor)) {
            Content content2 = descriptor2.getAttachedContent();
            descriptor2 = new HiddenRunContentDescriptor(descriptor2);
            content2.putUserData(RunContentDescriptor.DESCRIPTOR_KEY, (Object)descriptor2);
        }
        if (descriptor2 != null) {
            if (swapInfo != null) {
                descriptor2.setActivateToolWindowWhenAdded(false);
            }
            ProcessHandler processHandler2 = descriptor2.getProcessHandler();
            assert (processHandler2 != null);
            RunProfile runProfile = env.getRunProfile();
            RunConfiguration runConfiguration = runProfile instanceof RunConfiguration ? (RunConfiguration)runProfile : null;
            AndroidSessionInfo.create(processHandler2, runConfiguration, executorId, env.getExecutionTarget());
        }
        return descriptor2;
    }

    @VisibleForTesting
    static class HiddenRunContentDescriptor
    extends RunContentDescriptor {
        @NotNull
        private final RunContentDescriptor myDelegate;

        private HiddenRunContentDescriptor(@NotNull RunContentDescriptor delegate2) {
            super(null, null, (JComponent)new JLabel(), "hidden", null, null, null);
            this.myDelegate = delegate2;
            Disposer.register((Disposable)this, (Disposable)this.myDelegate);
        }

        public Runnable getActivationCallback() {
            return this.myDelegate.getActivationCallback();
        }

        @NotNull
        public AnAction[] getRestartActions() {
            return this.myDelegate.getRestartActions();
        }

        public ExecutionConsole getExecutionConsole() {
            return this.myDelegate.getExecutionConsole();
        }

        public void dispose() {
        }

        @Nullable
        public Icon getIcon() {
            return this.myDelegate.getIcon();
        }

        @Nullable
        public ProcessHandler getProcessHandler() {
            return this.myDelegate.getProcessHandler();
        }

        public void setProcessHandler(ProcessHandler processHandler2) {
            this.myDelegate.setProcessHandler(processHandler2);
        }

        public boolean isContentReuseProhibited() {
            return this.myDelegate.isContentReuseProhibited();
        }

        public JComponent getComponent() {
            return this.myDelegate.getComponent();
        }

        public String getDisplayName() {
            return this.myDelegate.getDisplayName();
        }

        public String getHelpId() {
            return this.myDelegate.getHelpId();
        }

        @Nullable
        public Content getAttachedContent() {
            return this.myDelegate.getAttachedContent();
        }

        public void setAttachedContent(@NotNull Content content2) {
            this.myDelegate.setAttachedContent(content2);
        }

        @Nullable
        public String getContentToolWindowId() {
            return this.myDelegate.getContentToolWindowId();
        }

        public void setContentToolWindowId(@Nullable String contentToolWindowId) {
            this.myDelegate.setContentToolWindowId(contentToolWindowId);
        }

        public boolean isActivateToolWindowWhenAdded() {
            return this.myDelegate.isActivateToolWindowWhenAdded();
        }

        public void setActivateToolWindowWhenAdded(boolean activateToolWindowWhenAdded) {
            this.myDelegate.setActivateToolWindowWhenAdded(activateToolWindowWhenAdded);
        }

        public boolean isSelectContentWhenAdded() {
            return this.myDelegate.isSelectContentWhenAdded();
        }

        public void setSelectContentWhenAdded(boolean selectContentWhenAdded) {
            this.myDelegate.setSelectContentWhenAdded(selectContentWhenAdded);
        }

        public boolean isReuseToolWindowActivation() {
            return this.myDelegate.isReuseToolWindowActivation();
        }

        public void setReuseToolWindowActivation(boolean reuseToolWindowActivation) {
            this.myDelegate.setReuseToolWindowActivation(reuseToolWindowActivation);
        }

        public long getExecutionId() {
            return this.myDelegate.getExecutionId();
        }

        public void setExecutionId(long executionId) {
            this.myDelegate.setExecutionId(executionId);
        }

        public String toString() {
            return this.myDelegate.toString();
        }

        public Computable<JComponent> getPreferredFocusComputable() {
            return this.myDelegate.getPreferredFocusComputable();
        }

        public void setFocusComputable(Computable<JComponent> focusComputable) {
            this.myDelegate.setFocusComputable(focusComputable);
        }

        public boolean isAutoFocusContent() {
            return this.myDelegate.isAutoFocusContent();
        }

        public void setAutoFocusContent(boolean autoFocusContent) {
            this.myDelegate.setAutoFocusContent(autoFocusContent);
        }

        @Nullable
        public RunnerLayoutUi getRunnerLayoutUi() {
            return this.myDelegate.getRunnerLayoutUi();
        }

        public void setRunnerLayoutUi(@Nullable RunnerLayoutUi runnerLayoutUi) {
            this.myDelegate.setRunnerLayoutUi(runnerLayoutUi);
        }

        public boolean isHiddenContent() {
            return true;
        }

        @NotNull
        public RunContentDescriptorReusePolicy getReusePolicy() {
            return this.myDelegate.getReusePolicy();
        }

        public void setReusePolicy(@NotNull RunContentDescriptorReusePolicy reusePolicy) {
            this.myDelegate.setReusePolicy(reusePolicy);
        }
    }
}

