/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.run;

import com.android.tools.idea.run.ConsolePrinter;
import com.google.common.collect.Lists;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.openapi.util.Key;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ProcessHandlerConsolePrinter
implements ConsolePrinter {
    @NotNull
    private final Object myLock = new Object();
    @NotNull
    private final List<Message> myStoredMessages = new ArrayList<Message>();
    @NotNull
    private WeakReference<ProcessHandler> myProcessHandler;

    public ProcessHandlerConsolePrinter(@Nullable ProcessHandler processHandler2) {
        this.myProcessHandler = new WeakReference<ProcessHandler>(processHandler2);
    }

    @Override
    public void stdout(@NotNull String text2) {
        this.print(text2, ProcessOutputTypes.STDOUT);
    }

    @Override
    public void stderr(@NotNull String text2) {
        this.print(text2, ProcessOutputTypes.STDERR);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setProcessHandler(@NotNull ProcessHandler processHandler2) {
        ArrayList storedMessages;
        Object object = this.myLock;
        synchronized (object) {
            this.myProcessHandler = new WeakReference<ProcessHandler>(processHandler2);
            storedMessages = Lists.newArrayList(this.myStoredMessages);
            this.myStoredMessages.clear();
        }
        if (Thread.holdsLock(this.myLock)) {
            throw new RuntimeException("Lock incorrectly held while setting process handler.");
        }
        storedMessages.forEach(message2 -> processHandler2.notifyTextAvailable(message2.text + "\n", message2.outputType));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void print(@NotNull String text2, @NotNull Key<?> outputType) {
        ProcessHandler processHandler2;
        Object object = this.myLock;
        synchronized (object) {
            processHandler2 = (ProcessHandler)this.myProcessHandler.get();
            if (processHandler2 == null) {
                this.myStoredMessages.add(new Message(text2, outputType));
                return;
            }
        }
        if (Thread.holdsLock(this.myLock)) {
            throw new RuntimeException("Lock incorrectly held while printing.");
        }
        processHandler2.notifyTextAvailable(text2 + "\n", outputType);
    }

    private static class Message {
        @NotNull
        final String text;
        @NotNull
        final Key<?> outputType;

        Message(@NotNull String text2, @NotNull Key<?> outputType) {
            this.text = text2;
            this.outputType = outputType;
        }
    }
}

