/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.run;

import com.android.ddmlib.IDevice;
import com.android.tools.idea.execution.common.ApplicationTerminator;
import com.android.tools.idea.execution.common.processhandler.AndroidProcessHandler;
import com.android.tools.idea.flags.StudioFlags;
import com.android.tools.idea.run.ConsolePrinter;
import com.android.tools.idea.run.DeploymentApplicationService;
import com.android.tools.idea.run.DeviceFutures;
import com.android.tools.idea.run.DeviceHeadsUpListener;
import com.android.tools.idea.run.ProcessHandlerConsolePrinter;
import com.android.tools.idea.run.ShowLogcatListener;
import com.android.tools.idea.run.debug.CaptureLogcatOutputToProcessHandlerKt;
import com.android.tools.idea.run.tasks.ConnectDebuggerTask;
import com.android.tools.idea.run.tasks.LaunchContext;
import com.android.tools.idea.run.tasks.LaunchResult;
import com.android.tools.idea.run.tasks.LaunchTask;
import com.android.tools.idea.run.tasks.LaunchTasksProvider;
import com.android.tools.idea.run.util.LaunchStatus;
import com.android.tools.idea.run.util.ProcessHandlerLaunchStatus;
import com.android.tools.idea.run.util.SwapInfo;
import com.android.tools.idea.stats.RunStats;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.wireless.android.sdk.stats.LaunchTaskDetail;
import com.intellij.execution.executors.DefaultDebugExecutor;
import com.intellij.execution.filters.HyperlinkInfo;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.ui.RunContentManager;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationListener;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.progress.util.ProgressIndicatorUtils;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.containers.ContainerUtil;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LaunchTaskRunner
extends Task.Backgroundable {
    @NotNull
    private final String myConfigName;
    @NotNull
    private final String myApplicationId;
    @Nullable
    private final String myExecutionTargetName;
    private ExecutionEnvironment myEnv;
    @NotNull
    private final ProcessHandler myProcessHandler;
    @NotNull
    private final DeviceFutures myDeviceFutures;
    @NotNull
    private final LaunchTasksProvider myLaunchTasksProvider;
    @NotNull
    private final RunStats myStats;
    @NotNull
    private final BiConsumer<String, HyperlinkInfo> myConsoleConsumer;
    @NotNull
    private final List<Runnable> myOnFinished;
    @Nullable
    private String myError;
    @Nullable
    private NotificationListener myErrorNotificationListener;

    public LaunchTaskRunner(@NotNull Project project, @NotNull String configName, @NotNull String applicationId2, @Nullable String executionTargetName, @NotNull ExecutionEnvironment env, @NotNull ProcessHandler processHandler2, @NotNull DeviceFutures deviceFutures, @NotNull LaunchTasksProvider launchTasksProvider, @NotNull RunStats stats, @NotNull BiConsumer<String, HyperlinkInfo> consoleConsumer) {
        super(project, "Launching " + configName);
        this.myConfigName = configName;
        this.myApplicationId = applicationId2;
        this.myExecutionTargetName = executionTargetName;
        this.myEnv = env;
        this.myProcessHandler = processHandler2;
        this.myDeviceFutures = deviceFutures;
        this.myLaunchTasksProvider = launchTasksProvider;
        this.myStats = stats;
        this.myConsoleConsumer = consoleConsumer;
        this.myOnFinished = new ArrayList<Runnable>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void run(@NotNull ProgressIndicator indicator) {
        block23: {
            this.myStats.beginLaunchTasks();
            try {
                boolean shouldConnectDebugger;
                boolean destroyProcessOnCancellation = !this.isSwap();
                indicator.setText(this.getTitle());
                indicator.setIndeterminate(false);
                ProcessHandlerLaunchStatus launchStatus = new ProcessHandlerLaunchStatus(this.myProcessHandler);
                ProcessHandlerConsolePrinter consolePrinter = new ProcessHandlerConsolePrinter(this.myProcessHandler);
                List<ListenableFuture<IDevice>> listenableDeviceFutures = this.myDeviceFutures.get();
                boolean bl = shouldConnectDebugger = this.myEnv.getExecutor() instanceof DefaultDebugExecutor && !this.isSwap();
                if (shouldConnectDebugger && listenableDeviceFutures.size() != 1) {
                    launchStatus.terminateLaunch("Cannot launch a debug session on more than 1 device.", true);
                    return;
                }
                this.printLaunchTaskStartedMessage(consolePrinter);
                indicator.setText("Waiting for all target devices to come online");
                List devices2 = listenableDeviceFutures.stream().map(deviceFuture -> this.waitForDevice((ListenableFuture<IDevice>)deviceFuture, indicator, launchStatus, destroyProcessOnCancellation)).filter(Objects::nonNull).collect(Collectors.toList());
                if (devices2.size() != listenableDeviceFutures.size()) {
                    return;
                }
                if (!this.isSwap() && this.myProcessHandler instanceof AndroidProcessHandler) {
                    ListenableFuture waitApplicationTerminationTask = Futures.whenAllSucceed((Iterable)ContainerUtil.map(devices2, device2 -> MoreExecutors.listeningDecorator((ExecutorService)AppExecutorUtil.getAppExecutorService()).submit(() -> {
                        ApplicationTerminator terminator = new ApplicationTerminator((IDevice)device2, this.myApplicationId);
                        try {
                            if (!terminator.killApp()) {
                                throw new CancellationException("Could not terminate running app " + this.myApplicationId);
                            }
                        }
                        catch (com.intellij.execution.ExecutionException e) {
                            throw new CancellationException("Could not terminate running app " + this.myApplicationId);
                        }
                        if (device2.isOnline()) {
                            ((AndroidProcessHandler)this.myProcessHandler).addTargetDevice((IDevice)device2);
                        }
                    }))).run(() -> {}, (Executor)AppExecutorUtil.getAppExecutorService());
                    ProgressIndicatorUtils.awaitWithCheckCanceled((Future)waitApplicationTerminationTask, (ProgressIndicator)indicator);
                    if (waitApplicationTerminationTask.isCancelled()) {
                        launchStatus.terminateLaunch(String.format("Couldn't terminate the existing process for %s.", this.myApplicationId), true);
                        return;
                    }
                }
                this.myLaunchTasksProvider.fillStats(this.myStats);
                HashMap<IDevice, List<LaunchTask>> launchTaskMap = new HashMap<IDevice, List<LaunchTask>>(devices2.size());
                for (IDevice device3 : devices2) {
                    try {
                        List<LaunchTask> launchTasks2 = this.myLaunchTasksProvider.getTasks(device3, launchStatus, consolePrinter);
                        launchTaskMap.put(device3, launchTasks2);
                    }
                    catch (com.intellij.execution.ExecutionException e) {
                        launchStatus.terminateLaunch(e.getMessage(), !this.isSwap());
                        this.myStats.endLaunchTasks();
                        return;
                    }
                    catch (IllegalStateException e) {
                        launchStatus.terminateLaunch(e.getMessage(), !this.isSwap());
                        Logger.getInstance(LaunchTaskRunner.class).error((Throwable)e);
                        this.myStats.endLaunchTasks();
                        return;
                    }
                }
                Ref completedStepsCount = new Ref((Object)0);
                int totalScheduledStepsCount = launchTaskMap.values().stream().mapToInt(launchTasks -> LaunchTaskRunner.getTotalDuration(launchTasks, shouldConnectDebugger)).sum();
                ArrayList<IDevice> launchedDevices = new ArrayList<IDevice>();
                for (Map.Entry entry : launchTaskMap.entrySet()) {
                    IDevice device4 = (IDevice)entry.getKey();
                    boolean isSucceeded = this.runLaunchTasks((List)entry.getValue(), new LaunchContext(this.myProject, this.myEnv.getExecutor(), device4, launchStatus, consolePrinter, this.myProcessHandler, indicator), destroyProcessOnCancellation, (Ref<Integer>)completedStepsCount, totalScheduledStepsCount);
                    if (isSucceeded) {
                        launchedDevices.add(device4);
                        continue;
                    }
                    this.detachDevice(device4);
                }
                if (launchedDevices.isEmpty()) {
                    launchStatus.terminateLaunch("Failed to launch an application on all devices", destroyProcessOnCancellation);
                    return;
                }
                if (shouldConnectDebugger) {
                    assert (launchedDevices.size() == 1);
                    IDevice device5 = (IDevice)launchedDevices.get(0);
                    ConnectDebuggerTask debuggerTask = this.myLaunchTasksProvider.getConnectDebuggerTask();
                    if (debuggerTask == null) {
                        throw new RuntimeException("ConnectDebuggerTask is null for task provider " + this.myLaunchTasksProvider.getClass().getName());
                    }
                    indicator.setText("Connecting debugger");
                    debuggerTask.perform(device5, this.myApplicationId, this.myEnv, this.myProcessHandler).onSuccess(session -> ApplicationManager.getApplication().executeOnPooledThread(() -> DeploymentApplicationService.getInstance().findClient(device5, this.myApplicationId).stream().findAny().ifPresent(client2 -> CaptureLogcatOutputToProcessHandlerKt.captureLogcatOutputToProcessHandler(client2, session.getConsoleView(), session.getDebugProcess().getProcessHandler()))));
                    completedStepsCount.set((Object)((Integer)completedStepsCount.get() + 10));
                    indicator.setFraction((double)(((Integer)completedStepsCount.get()).floatValue() / (float)totalScheduledStepsCount));
                }
                break block23;
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
            }
            finally {
                this.myStats.endLaunchTasks();
            }
        }
    }

    private boolean runLaunchTasks(@NotNull List<LaunchTask> launchTasks, @NotNull LaunchContext launchContext, boolean destroyProcessOnCancellation, @NotNull Ref<Integer> completedStepsCount, int totalScheduledStepsCount) {
        String content2;
        NotificationType notificationType;
        ProgressIndicator indicator = launchContext.getProgressIndicator();
        indicator.setFraction((double)(((Integer)completedStepsCount.get()).floatValue() / (float)totalScheduledStepsCount));
        IDevice device2 = launchContext.getDevice();
        LaunchStatus launchStatus = launchContext.getLaunchStatus();
        String groupId = "LaunchTaskRunner for " + launchContext.getExecutor().getId();
        NotificationGroup notificationGroup2 = NotificationGroup.findRegisteredGroup((String)groupId);
        if (notificationGroup2 == null) {
            notificationGroup2 = NotificationGroup.toolWindowGroup((String)groupId, (String)launchContext.getExecutor().getId());
        }
        int numWarnings = 0;
        for (LaunchTask task2 : launchTasks) {
            if (!LaunchTaskRunner.checkIfLaunchIsAliveAndTerminateIfCancelIsRequested(indicator, launchStatus, destroyProcessOnCancellation)) {
                return false;
            }
            if (task2.shouldRun(launchContext)) {
                LaunchTaskDetail.Builder details = this.myStats.beginLaunchTask(task2);
                indicator.setText(task2.getDescription());
                LaunchResult launchResult = task2.run(launchContext);
                this.myOnFinished.addAll(launchResult.onFinishedCallbacks());
                LaunchResult.Result result2 = launchResult.getResult();
                this.myStats.endLaunchTask(task2, details, result2 != LaunchResult.Result.ERROR);
                if (result2 != LaunchResult.Result.SUCCESS) {
                    NotificationType type;
                    String title;
                    this.myErrorNotificationListener = launchResult.getNotificationListener();
                    this.myError = launchResult.getMessage();
                    launchContext.getConsolePrinter().stderr(launchResult.getConsoleMessage());
                    if (launchResult.getConsoleHyperlinkInfo() != null) {
                        this.myConsoleConsumer.accept(launchResult.getConsoleHyperlinkText() + "\n", launchResult.getConsoleHyperlinkInfo());
                    }
                    if (result2 == LaunchResult.Result.ERROR) {
                        title = "Error";
                        type = NotificationType.ERROR;
                    } else {
                        title = "Warning";
                        type = NotificationType.WARNING;
                    }
                    notificationGroup2.createNotification(title, launchResult.getMessage(), type).setListener(this.myErrorNotificationListener).setImportant(true).notify(this.myProject);
                    ApplicationManager.getApplication().invokeLater(() -> RunContentManager.getInstance((Project)this.myProject).toFrontRunContent(this.myEnv.getExecutor(), this.myProcessHandler));
                    if (result2 == LaunchResult.Result.ERROR) {
                        this.myStats.setErrorId(launchResult.getErrorId());
                        return false;
                    }
                    ++numWarnings;
                }
                ((DeviceHeadsUpListener)this.myProject.getMessageBus().syncPublisher(DeviceHeadsUpListener.TOPIC)).deviceNeedsAttention(device2.getSerialNumber(), this.myProject);
            }
            completedStepsCount.set((Object)((Integer)completedStepsCount.get() + task2.getDuration()));
            indicator.setFraction((double)(((Integer)completedStepsCount.get()).floatValue() / (float)totalScheduledStepsCount));
        }
        if (!((Boolean)StudioFlags.RUNDEBUG_LOGCAT_CONSOLE_OUTPUT_ENABLED.get()).booleanValue()) {
            this.myConsoleConsumer.accept(ShowLogcatListener.getShowLogcatLinkText(device2), project -> ((ShowLogcatListener)project.getMessageBus().syncPublisher(ShowLogcatListener.TOPIC)).showLogcat(device2, this.myApplicationId));
        }
        String launchType = this.myLaunchTasksProvider.getLaunchTypeDisplayName();
        if (numWarnings == 0) {
            notificationType = NotificationType.INFORMATION;
            content2 = AndroidBundle.message("android.launch.task.succeeded", launchType);
        } else {
            notificationType = NotificationType.WARNING;
            content2 = AndroidBundle.message("android.launch.task.succeeded.with.warnings", launchType, numWarnings);
        }
        notificationGroup2.createNotification("", content2, notificationType).setImportant(false).notify(this.myProject);
        return true;
    }

    private void detachDevice(IDevice device2) {
        if (!this.isSwap() && this.myProcessHandler instanceof AndroidProcessHandler) {
            AndroidProcessHandler androidProcessHandler = (AndroidProcessHandler)this.myProcessHandler;
            androidProcessHandler.detachDevice(device2);
        }
    }

    private void printLaunchTaskStartedMessage(ConsolePrinter consolePrinter) {
        StringBuilder launchString = new StringBuilder("\n");
        SimpleDateFormat dateFormat = new SimpleDateFormat("MM/dd HH:mm:ss");
        launchString.append(dateFormat.format(new Date())).append(": ");
        launchString.append(this.getLaunchVerb()).append(" ");
        launchString.append("'").append(this.myConfigName).append("'");
        if (!StringUtil.isEmpty((String)this.myExecutionTargetName)) {
            launchString.append(" on ");
            launchString.append(this.myExecutionTargetName);
        }
        launchString.append(".");
        consolePrinter.stdout(launchString.toString());
    }

    public void onSuccess() {
        if (this.myError == null) {
            this.myStats.success();
        }
    }

    public void onFinished() {
        super.onFinished();
        if (this.myError != null) {
            this.myStats.fail();
        }
        for (Runnable runnable2 : this.myOnFinished) {
            ApplicationManager.getApplication().invokeLater(runnable2);
        }
    }

    @Nullable
    private IDevice waitForDevice(@NotNull ListenableFuture<IDevice> deviceFuture, @NotNull ProgressIndicator indicator, @NotNull LaunchStatus launchStatus, boolean destroyProcess) {
        this.myStats.beginWaitForDevice();
        IDevice device2 = null;
        while (LaunchTaskRunner.checkIfLaunchIsAliveAndTerminateIfCancelIsRequested(indicator, launchStatus, destroyProcess)) {
            try {
                device2 = (IDevice)deviceFuture.get(1L, TimeUnit.SECONDS);
                break;
            }
            catch (TimeoutException timeoutException) {
            }
            catch (InterruptedException e) {
                launchStatus.terminateLaunch("Interrupted while waiting for device", destroyProcess);
                break;
            }
            catch (ExecutionException e) {
                launchStatus.terminateLaunch("Error while waiting for device: " + e.getCause().getMessage(), destroyProcess);
                break;
            }
        }
        this.myStats.endWaitForDevice(device2);
        return device2;
    }

    private static boolean checkIfLaunchIsAliveAndTerminateIfCancelIsRequested(@NotNull ProgressIndicator indicator, @NotNull LaunchStatus launchStatus, boolean destroyProcess) {
        if (launchStatus.isLaunchTerminated()) {
            return false;
        }
        if (indicator.isCanceled()) {
            launchStatus.terminateLaunch("User cancelled launch", destroyProcess);
            return false;
        }
        return true;
    }

    private static int getTotalDuration(@NotNull List<LaunchTask> launchTasks, boolean shouldConnectDebugger) {
        int total = 0;
        for (LaunchTask task2 : launchTasks) {
            total += task2.getDuration();
        }
        if (shouldConnectDebugger) {
            total += 10;
        }
        return total;
    }

    private boolean isSwap() {
        return this.myEnv.getUserData(SwapInfo.SWAP_INFO_KEY) != null;
    }

    @NotNull
    private String getLaunchVerb() {
        SwapInfo swapInfo = (SwapInfo)this.myEnv.getUserData(SwapInfo.SWAP_INFO_KEY);
        if (swapInfo != null) {
            if (swapInfo.getType() == SwapInfo.SwapType.APPLY_CHANGES) {
                return "Applying changes to";
            }
            if (swapInfo.getType() == SwapInfo.SwapType.APPLY_CODE_CHANGES) {
                return "Applying code changes to";
            }
        }
        return "Launching";
    }
}

