/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.run;

import com.android.ddmlib.IDevice;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class LaunchOptions {
    private final boolean myDeploy;
    private final Function<Optional<IDevice>, String> myPmInstallOptions;
    private final boolean myAllUsers;
    private List<String> myDisabledDynamicFeatures;
    private final boolean myDebug;
    private final boolean myOpenLogcatAutomatically;
    private final boolean myClearLogcatBeforeStart;
    private final Map<String, Object> myExtraOptions;
    private final boolean myDeployAsInstant;
    private final boolean myAlwaysInstallWithPm;
    private final boolean myClearAppStorage;

    @NotNull
    public static Builder builder() {
        return new Builder();
    }

    private LaunchOptions(boolean deploy, @Nullable Function<Optional<IDevice>, String> pmInstallOptions, boolean allUsers, @NotNull List<String> disabledDynamicFeatures, boolean debug2, boolean openLogcatAutomatically, boolean clearLogcatBeforeStart, @NotNull Map<String, Object> extraOptions, boolean deployAsInstant, boolean alwaysInstallWithPm, boolean clearAppStorage) {
        this.myDeploy = deploy;
        this.myPmInstallOptions = pmInstallOptions;
        this.myAllUsers = allUsers;
        this.myDisabledDynamicFeatures = disabledDynamicFeatures;
        this.myDebug = debug2;
        this.myOpenLogcatAutomatically = openLogcatAutomatically;
        this.myClearLogcatBeforeStart = clearLogcatBeforeStart;
        this.myExtraOptions = ImmutableMap.copyOf(extraOptions);
        this.myDeployAsInstant = deployAsInstant;
        this.myAlwaysInstallWithPm = alwaysInstallWithPm;
        this.myClearAppStorage = clearAppStorage;
    }

    public boolean isDeploy() {
        return this.myDeploy;
    }

    @Nullable
    public String getPmInstallOptions(@Nullable IDevice device2) {
        if (this.myPmInstallOptions == null) {
            return null;
        }
        return this.myPmInstallOptions.apply(Optional.ofNullable(device2));
    }

    public boolean getInstallOnAllUsers() {
        return this.myAllUsers;
    }

    public boolean getAlwaysInstallWithPm() {
        return this.myAlwaysInstallWithPm;
    }

    public boolean isClearAppStorage() {
        return this.myClearAppStorage;
    }

    @NotNull
    public List<String> getDisabledDynamicFeatures() {
        return this.myDisabledDynamicFeatures;
    }

    public boolean isDebug() {
        return this.myDebug;
    }

    public boolean isOpenLogcatAutomatically() {
        return this.myOpenLogcatAutomatically;
    }

    public boolean isClearLogcatBeforeStart() {
        return this.myClearLogcatBeforeStart;
    }

    @Nullable
    public Object getExtraOption(@NotNull String key) {
        return this.myExtraOptions.get(key);
    }

    public boolean isDeployAsInstant() {
        return this.myDeployAsInstant;
    }

    public static final class Builder {
        private boolean myDeploy = true;
        private Function<Optional<IDevice>, String> myPmInstallOptions = null;
        private boolean myAllUsers = false;
        private List<String> myDisabledDynamicFeatures = new ArrayList<String>();
        private boolean myDebug = false;
        private boolean myOpenLogcatAutomatically = false;
        private boolean myClearLogcatBeforeStart = false;
        private final Map<String, Object> myExtraOptions = new HashMap<String, Object>();
        private boolean myDeployAsInstant = false;
        private boolean myAlwaysInstallWithPm = false;
        private boolean myClearAppStorage = false;

        private Builder() {
        }

        @NotNull
        public LaunchOptions build() {
            return new LaunchOptions(this.myDeploy, this.myPmInstallOptions, this.myAllUsers, this.myDisabledDynamicFeatures, this.myDebug, this.myOpenLogcatAutomatically, this.myClearLogcatBeforeStart, this.myExtraOptions, this.myDeployAsInstant, this.myAlwaysInstallWithPm, this.myClearAppStorage);
        }

        @NotNull
        public Builder setDeploy(boolean deploy) {
            this.myDeploy = deploy;
            return this;
        }

        @NotNull
        public Builder setPmInstallOptions(@Nullable Function<Optional<IDevice>, String> options2) {
            this.myPmInstallOptions = options2;
            return this;
        }

        @NotNull
        public Builder setAllUsers(boolean allUsers) {
            this.myAllUsers = allUsers;
            return this;
        }

        @NotNull
        public Builder setDebug(boolean debug2) {
            this.myDebug = debug2;
            return this;
        }

        @NotNull
        public Builder setOpenLogcatAutomatically(boolean openLogcatAutomatically) {
            this.myOpenLogcatAutomatically = openLogcatAutomatically;
            return this;
        }

        @NotNull
        public Builder setClearLogcatBeforeStart(boolean clearLogcatBeforeStart) {
            this.myClearLogcatBeforeStart = clearLogcatBeforeStart;
            return this;
        }

        @NotNull
        public Builder addExtraOptions(@NotNull Map<String, Object> extraOptions) {
            this.myExtraOptions.putAll(extraOptions);
            return this;
        }

        public Builder setDisabledDynamicFeatures(List<String> disabledDynamicFeatures) {
            this.myDisabledDynamicFeatures = ImmutableList.copyOf(disabledDynamicFeatures);
            return this;
        }

        @NotNull
        public Builder setDeployAsInstant(boolean deployAsInstant) {
            this.myDeployAsInstant = deployAsInstant;
            return this;
        }

        @NotNull
        public Builder setAlwaysInstallWithPm(boolean alwaysInstallWithPm) {
            this.myAlwaysInstallWithPm = alwaysInstallWithPm;
            return this;
        }

        @NotNull
        public Builder setClearAppStorage(boolean clearAppStorage) {
            this.myClearAppStorage = clearAppStorage;
            return this;
        }
    }
}

