/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.run;

import com.android.ddmlib.IDevice;
import com.android.tools.idea.run.DeviceStateCache;
import com.google.common.hash.HashCode;
import com.intellij.openapi.Disposable;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InstalledPatchCache
implements Disposable {
    private final DeviceStateCache<PatchState> myCache = new DeviceStateCache(this);

    @Nullable
    public HashCode getInstalledManifestResourcesHash(@NotNull IDevice device2, @NotNull String pkgName) {
        PatchState state2 = this.getState(device2, pkgName, false);
        return state2 == null ? null : state2.manifestResources;
    }

    public void setInstalledManifestResourcesHash(@NotNull IDevice device2, @NotNull String pkgName, HashCode hash2) {
        this.getState((IDevice)device2, (String)pkgName, (boolean)true).manifestResources = hash2;
    }

    @Contract(value="!null, !null, true -> !null")
    @Nullable
    private PatchState getState(@NotNull IDevice device2, @NotNull String pkgName, boolean create2) {
        PatchState state2 = this.myCache.get(device2, pkgName);
        if (state2 == null && create2) {
            state2 = new PatchState();
            this.myCache.put(device2, pkgName, state2);
        }
        return state2;
    }

    public void dispose() {
    }

    private static class PatchState {
        @Nullable
        public HashCode manifestResources;

        private PatchState() {
        }
    }
}

