/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.run;

import com.android.ddmlib.IDevice;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class DeviceStateAtLaunch {
    private final Set<String> myDevicesUsedInLaunch;
    private final Set<String> myDevicesAvailableAtLaunch;

    public DeviceStateAtLaunch(@NotNull Collection<IDevice> usedDevices, @NotNull Collection<IDevice> allDevices) {
        this.myDevicesUsedInLaunch = DeviceStateAtLaunch.serialize(usedDevices);
        this.myDevicesAvailableAtLaunch = DeviceStateAtLaunch.serialize(allDevices);
    }

    public Collection<IDevice> filterByUsed(@NotNull Collection<IDevice> devices2) {
        HashSet used = Sets.newHashSetWithExpectedSize((int)this.myDevicesUsedInLaunch.size());
        for (IDevice d : devices2) {
            if (!this.myDevicesUsedInLaunch.contains(d.getSerialNumber())) continue;
            used.add(d);
        }
        return used;
    }

    public boolean matchesCurrentAvailableDevices(@NotNull Collection<IDevice> devices2) {
        if (this.myDevicesAvailableAtLaunch.size() != devices2.size()) {
            return false;
        }
        for (IDevice d : devices2) {
            if (this.myDevicesAvailableAtLaunch.contains(d.getSerialNumber())) continue;
            return false;
        }
        return true;
    }

    public boolean usedDevice(@NotNull IDevice device2) {
        return this.myDevicesUsedInLaunch.contains(device2.getSerialNumber());
    }

    private static Set<String> serialize(Collection<IDevice> usedDevices) {
        HashSet s = Sets.newHashSetWithExpectedSize((int)usedDevices.size());
        for (IDevice d : usedDevices) {
            s.add(d.getSerialNumber());
        }
        return s;
    }
}

