/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.run;

import com.android.ddmlib.logcat.LogCatMessage;
import com.android.tools.idea.logcat.AndroidLogcatService;
import com.android.tools.idea.logcat.AndroidLogcatUtils;
import com.intellij.openapi.util.Key;
import org.jetbrains.annotations.NotNull;

public abstract class ApplicationLogListener
implements AndroidLogcatService.LogcatListener {
    @NotNull
    private final String myPackageName;
    private final int myPid;

    public ApplicationLogListener(@NotNull String packageName2, int pid) {
        this.myPackageName = packageName2;
        this.myPid = pid;
    }

    @Override
    public void onLogLineReceived(@NotNull LogCatMessage line2) {
        if (!this.myPackageName.equals(line2.getHeader().getAppName()) || this.myPid != line2.getHeader().getPid()) {
            return;
        }
        this.notifyTextAvailable(this.formatLogLine(line2) + "\n", AndroidLogcatUtils.getProcessOutputType(line2.getHeader().getLogLevel()));
    }

    protected abstract String formatLogLine(@NotNull LogCatMessage var1);

    protected abstract void notifyTextAvailable(@NotNull String var1, @NotNull Key var2);
}

