/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.run;

import com.android.tools.idea.run.ApkFileUnit;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.io.File;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public final class ApkInfo {
    @NotNull
    private final List<ApkFileUnit> myFiles;
    @NotNull
    private final String myApplicationId;
    @NotNull
    private final Set<AppInstallOption> myRequiredInstallOptions;

    public ApkInfo(@NotNull File file2, @NotNull String applicationId2) {
        this(file2, applicationId2, (Set<AppInstallOption>)ImmutableSet.of());
    }

    public ApkInfo(@NotNull File file2, @NotNull String applicationId2, @NotNull Set<AppInstallOption> requiredInstallOptions) {
        this.myFiles = ImmutableList.of((Object)new ApkFileUnit("", file2));
        this.myApplicationId = applicationId2;
        this.myRequiredInstallOptions = requiredInstallOptions;
    }

    public ApkInfo(@NotNull List<ApkFileUnit> files2, @NotNull String applicationId2) {
        Preconditions.checkArgument((!files2.isEmpty() ? 1 : 0) != 0);
        this.myFiles = files2;
        this.myApplicationId = applicationId2;
        this.myRequiredInstallOptions = ImmutableSet.of();
    }

    @NotNull
    public List<ApkFileUnit> getFiles() {
        return this.myFiles;
    }

    @NotNull
    public String getApplicationId() {
        return this.myApplicationId;
    }

    @NotNull
    public Set<AppInstallOption> getRequiredInstallOptions() {
        return this.myRequiredInstallOptions;
    }

    public static enum AppInstallOption {
        GRANT_ALL_PERMISSIONS(23),
        FORCE_QUERYABLE(30);

        public final int minSupportedApiLevel;

        private AppInstallOption(int minSupportedApiLevel) {
            this.minSupportedApiLevel = minSupportedApiLevel;
        }
    }
}

