/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.run;

import com.android.ddmlib.IDevice;
import com.android.tools.idea.execution.common.processhandler.AndroidProcessHandler;
import com.android.tools.idea.run.ApkProvisionException;
import com.android.tools.idea.run.ApplicationIdProvider;
import com.android.tools.idea.run.ConsoleProvider;
import com.android.tools.idea.run.DeviceFutures;
import com.android.tools.idea.run.LaunchTaskRunner;
import com.android.tools.idea.run.applychanges.ApplyChangesUtilsKt;
import com.android.tools.idea.run.applychanges.ExistingSession;
import com.android.tools.idea.run.tasks.LaunchTasksProvider;
import com.android.tools.idea.stats.RunStats;
import com.android.tools.idea.testartifacts.instrumented.AndroidTestRunConfiguration;
import com.android.tools.idea.testartifacts.instrumented.AndroidTestRunConfigurationType;
import com.android.tools.idea.testartifacts.instrumented.orchestrator.OrchestratorUtilsKt;
import com.intellij.execution.DefaultExecutionResult;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.ExecutionResult;
import com.intellij.execution.Executor;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.filters.HyperlinkInfo;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.runners.ProgramRunner;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.execution.ui.ExecutionConsole;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import java.util.function.BiConsumer;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AndroidRunState
implements RunProfileState {
    @NotNull
    private final ExecutionEnvironment myEnv;
    @NotNull
    private final String myLaunchConfigName;
    @NotNull
    private final Module myModule;
    @NotNull
    private final ApplicationIdProvider myApplicationIdProvider;
    @NotNull
    private final ConsoleProvider myConsoleProvider;
    @NotNull
    private final DeviceFutures myDeviceFutures;
    @NotNull
    private final LaunchTasksProvider myLaunchTasksProvider;

    public AndroidRunState(@NotNull ExecutionEnvironment env, @NotNull String launchConfigName, @NotNull Module module2, @NotNull ApplicationIdProvider applicationIdProvider, @NotNull ConsoleProvider consoleProvider, @NotNull DeviceFutures deviceFutures, @NotNull LaunchTasksProvider launchTasksProvider) {
        this.myEnv = env;
        this.myLaunchConfigName = launchConfigName;
        this.myModule = module2;
        this.myApplicationIdProvider = applicationIdProvider;
        this.myConsoleProvider = consoleProvider;
        this.myDeviceFutures = deviceFutures;
        this.myLaunchTasksProvider = launchTasksProvider;
    }

    @Nullable
    public ExecutionResult execute(Executor executor2, @NotNull ProgramRunner runner) throws ExecutionException {
        ExistingSession prevHandler = ApplyChangesUtilsKt.findExistingSessionAndMaybeDetachForColdSwap(this.myEnv);
        ProcessHandler processHandler2 = prevHandler.getProcessHandler();
        ExecutionConsole console = prevHandler.getExecutionConsole();
        if (processHandler2 == null) {
            String appId = this.getMasterAndroidProcessId(this.myEnv.getRunProfile());
            processHandler2 = new AndroidProcessHandler(this.myEnv.getProject(), appId, (Function1<? super IDevice, Unit>)((Function1)device2 -> {
                device2.forceStop(appId);
                return Unit.INSTANCE;
            }), AndroidRunState.shouldAutoTerminate(this.myEnv.getRunnerAndConfigurationSettings()));
        }
        if (console == null) {
            console = this.myConsoleProvider.createAndAttach((Disposable)this.myModule.getProject(), processHandler2, executor2);
        }
        BiConsumer<String, HyperlinkInfo> hyperlinkConsumer = console instanceof ConsoleView ? (arg_0, arg_1) -> ((ConsoleView)((ConsoleView)console)).printHyperlink(arg_0, arg_1) : (s, h) -> {};
        LaunchTaskRunner task2 = new LaunchTaskRunner(this.myModule.getProject(), this.myLaunchConfigName, this.getApplicationId(), this.myEnv.getExecutionTarget().getDisplayName(), this.myEnv, processHandler2, this.myDeviceFutures, this.myLaunchTasksProvider, this.createRunStats(), hyperlinkConsumer);
        ProgressManager.getInstance().run((Task)task2);
        return new DefaultExecutionResult(console, processHandler2);
    }

    private static boolean shouldAutoTerminate(@Nullable RunnerAndConfigurationSettings runnerAndConfigurationSettings) {
        return !AndroidRunState.isAndroidInstrumentationTest(runnerAndConfigurationSettings);
    }

    private static boolean isAndroidInstrumentationTest(@Nullable RunnerAndConfigurationSettings runnerAndConfigurationSettings) {
        if (runnerAndConfigurationSettings == null) {
            return false;
        }
        return AndroidTestRunConfigurationType.getInstance().equals(runnerAndConfigurationSettings.getType());
    }

    private RunStats createRunStats() throws ExecutionException {
        RunStats stats = RunStats.from(this.myEnv);
        stats.setPackage(this.getApplicationId());
        return stats;
    }

    private String getApplicationId() throws ExecutionException {
        try {
            return this.myApplicationIdProvider.getPackageName();
        }
        catch (ApkProvisionException e) {
            throw new ExecutionException("Unable to obtain application id", (Throwable)e);
        }
    }

    private String getMasterAndroidProcessId(@NotNull RunProfile runProfile) throws ExecutionException {
        if (!(runProfile instanceof AndroidTestRunConfiguration)) {
            return this.getApplicationId();
        }
        AndroidTestRunConfiguration testRunConfiguration = (AndroidTestRunConfiguration)runProfile;
        return OrchestratorUtilsKt.MAP_EXECUTION_TYPE_TO_MASTER_ANDROID_PROCESS_NAME.getOrDefault((Object)testRunConfiguration.getTestExecutionOption(AndroidFacet.getInstance((Module)this.myModule)), this.getApplicationId());
    }
}

