/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.run;

import com.android.ddmlib.IDevice;
import com.android.tools.idea.execution.common.debug.AndroidDebugger;
import com.android.tools.idea.execution.common.debug.AndroidDebuggerContext;
import com.android.tools.idea.execution.common.debug.AndroidDebuggerState;
import com.android.tools.idea.projectsystem.AndroidProjectSystem;
import com.android.tools.idea.projectsystem.ProjectSystemUtil;
import com.android.tools.idea.run.AndroidDevice;
import com.android.tools.idea.run.AndroidLaunchTasksProvider;
import com.android.tools.idea.run.AndroidRunConfigurationModule;
import com.android.tools.idea.run.AndroidRunState;
import com.android.tools.idea.run.ApkProvider;
import com.android.tools.idea.run.ApkProvisionException;
import com.android.tools.idea.run.ApplicationIdProvider;
import com.android.tools.idea.run.ConsolePrinter;
import com.android.tools.idea.run.ConsoleProvider;
import com.android.tools.idea.run.DeviceFutures;
import com.android.tools.idea.run.LaunchOptions;
import com.android.tools.idea.run.LaunchableAndroidDevice;
import com.android.tools.idea.run.PreferGradleMake;
import com.android.tools.idea.run.ValidationError;
import com.android.tools.idea.run.ValidationUtil;
import com.android.tools.idea.run.editor.DeployTarget;
import com.android.tools.idea.run.editor.DeployTargetContext;
import com.android.tools.idea.run.editor.DeployTargetProvider;
import com.android.tools.idea.run.editor.DeployTargetState;
import com.android.tools.idea.run.editor.ProfilerState;
import com.android.tools.idea.run.editor.RunConfigurationWithDebugger;
import com.android.tools.idea.run.tasks.AppLaunchTask;
import com.android.tools.idea.run.tasks.LaunchTasksProvider;
import com.android.tools.idea.run.util.LaunchStatus;
import com.android.tools.idea.run.util.LaunchUtils;
import com.android.tools.idea.stats.RunStats;
import com.android.tools.idea.stats.RunStatsService;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Ordering;
import com.google.common.util.concurrent.Futures;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.Executor;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.JavaRunConfigurationModule;
import com.intellij.execution.configurations.ModuleBasedConfiguration;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.configurations.RunConfigurationModule;
import com.intellij.execution.configurations.RunConfigurationWithSuppressedDefaultDebugAction;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.configurations.RuntimeConfigurationError;
import com.intellij.execution.configurations.RuntimeConfigurationException;
import com.intellij.execution.configurations.RuntimeConfigurationWarning;
import com.intellij.execution.executors.DefaultDebugExecutor;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.runners.RunConfigurationWithSuppressedDefaultRunAction;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.DefaultJDOMExternalizer;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.WriteExternalException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.jdom.Element;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.facet.AndroidFacetConfiguration;
import org.jetbrains.android.sdk.AndroidPlatform;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AndroidRunConfigurationBase
extends ModuleBasedConfiguration<AndroidRunConfigurationModule, Element>
implements PreferGradleMake,
RunConfigurationWithSuppressedDefaultRunAction,
RunConfigurationWithSuppressedDefaultDebugAction,
RunConfigurationWithDebugger {
    private static final String PROFILERS_ELEMENT_NAME = "Profilers";
    public boolean CLEAR_LOGCAT = false;
    public boolean SHOW_LOGCAT_AUTOMATICALLY = false;
    public boolean INSPECTION_WITHOUT_ACTIVITY_RESTART = false;
    private final ProfilerState myProfilerState;
    private final DeployTargetContext myDeployTargetContext = new DeployTargetContext();
    private final AndroidDebuggerContext myAndroidDebuggerContext = new AndroidDebuggerContext("Java");
    private final boolean myIsTestConfiguration;

    public AndroidRunConfigurationBase(Project project, ConfigurationFactory factory2, boolean isTestConfiguration) {
        super((RunConfigurationModule)new AndroidRunConfigurationModule(project, isTestConfiguration), factory2);
        this.myIsTestConfiguration = isTestConfiguration;
        this.myProfilerState = new ProfilerState();
        this.getOptions().setAllowRunningInParallel(true);
    }

    public final void checkConfiguration() throws RuntimeConfigurationException {
        List<ValidationError> errors2 = this.validate(null);
        if (errors2.isEmpty()) {
            return;
        }
        ValidationError topError = (ValidationError)Ordering.natural().max(errors2);
        switch (topError.getSeverity()) {
            case FATAL: {
                throw new RuntimeConfigurationError(topError.getMessage(), topError.getQuickfix());
            }
            case WARNING: {
                throw new RuntimeConfigurationWarning(topError.getMessage(), topError.getQuickfix());
            }
        }
    }

    public List<ValidationError> validate(@Nullable Executor executor2) {
        ArrayList<ValidationError> errors2 = new ArrayList<ValidationError>();
        JavaRunConfigurationModule configurationModule = (JavaRunConfigurationModule)this.getConfigurationModule();
        try {
            configurationModule.checkForWarning();
        }
        catch (RuntimeConfigurationException e) {
            errors2.add(ValidationError.fromException(e));
        }
        Module module2 = configurationModule.getModule();
        if (module2 == null) {
            return errors2;
        }
        AndroidFacet facet2 = AndroidFacet.getInstance((Module)module2);
        if (facet2 == null) {
            return ImmutableList.of((Object)ValidationError.fatal(AndroidBundle.message("no.facet.error", module2.getName())));
        }
        int projectType = ((AndroidFacetConfiguration)facet2.getConfiguration()).getProjectType();
        switch (projectType) {
            case 0: 
            case 2: 
            case 4: {
                break;
            }
            case 1: 
            case 5: 
            case 6: {
                Pair<Boolean, String> result2 = this.supportsRunningLibraryProjects(facet2);
                if (((Boolean)result2.getFirst()).booleanValue()) break;
                errors2.add(ValidationError.fatal((String)result2.getSecond()));
                break;
            }
            default: {
                errors2.add(ValidationError.fatal(AndroidBundle.message("run.error.apk.not.valid", new Object[0])));
                return errors2;
            }
        }
        if (AndroidPlatform.getInstance(module2) == null) {
            errors2.add(ValidationError.fatal(AndroidBundle.message("select.platform.error", new Object[0])));
        }
        errors2.addAll(this.getDeployTargetContext().getCurrentDeployTargetState().validate(facet2));
        ApplicationIdProvider applicationIdProvider = this.getApplicationIdProvider();
        if (applicationIdProvider == null) {
            errors2.add(ValidationError.fatal(AndroidBundle.message("android.run.configuration.not.supported.applicationid", this.getName())));
        } else {
            try {
                String string = applicationIdProvider.getPackageName();
            }
            catch (ApkProvisionException e) {
                errors2.add(ValidationError.fatal(AndroidBundle.message("android.run.configuration.not.supported.package", this.getName())));
            }
        }
        AndroidProjectSystem projectSystem2 = ProjectSystemUtil.getProjectSystem(this.getProject());
        errors2.addAll(projectSystem2.validateRunConfiguration((RunConfiguration)this));
        errors2.addAll(this.checkConfiguration(facet2));
        Object androidDebuggerState = this.myAndroidDebuggerContext.getAndroidDebuggerState();
        if (androidDebuggerState != null) {
            errors2.addAll(((AndroidDebuggerState)androidDebuggerState).validate(facet2, executor2));
        }
        errors2.addAll(this.myProfilerState.validate());
        return errors2;
    }

    protected abstract Pair<Boolean, String> supportsRunningLibraryProjects(@NotNull AndroidFacet var1);

    @NotNull
    protected abstract List<ValidationError> checkConfiguration(@NotNull AndroidFacet var1);

    @NotNull
    protected LaunchOptions.Builder getLaunchOptions() {
        return LaunchOptions.builder().setClearLogcatBeforeStart(this.CLEAR_LOGCAT);
    }

    public Collection<Module> getValidModules() {
        ArrayList<Module> result2 = new ArrayList<Module>();
        for (AndroidFacet facet2 : ProjectSystemUtil.getAndroidFacets(this.getProject())) {
            result2.add(facet2.getModule());
        }
        return result2;
    }

    @NotNull
    public abstract List<DeployTargetProvider> getApplicableDeployTargetProviders();

    protected void validateBeforeRun(@NotNull Executor executor2) throws ExecutionException {
        List<ValidationError> errors2 = this.validate(executor2);
        ValidationUtil.promptAndQuickFixErrors(this.getProject(), errors2);
    }

    public RunProfileState getState(@NotNull Executor executor2, @NotNull ExecutionEnvironment env) throws ExecutionException {
        RunStats stats = RunStatsService.get(this.getProject()).create();
        try {
            stats.start();
            RunProfileState state2 = this.doGetState(executor2, env, stats);
            stats.markStateCreated();
            return state2;
        }
        catch (Throwable t) {
            stats.abort();
            throw t;
        }
    }

    @Nullable
    public RunProfileState doGetState(@NotNull Executor executor2, @NotNull ExecutionEnvironment env, @NotNull RunStats stats) throws ExecutionException {
        String error;
        this.validateBeforeRun(executor2);
        Module module2 = ((AndroidRunConfigurationModule)this.getConfigurationModule()).getModule();
        assert (module2 != null) : "Enforced by fatal validation check in checkConfiguration.";
        AndroidFacet facet2 = AndroidFacet.getInstance((Module)module2);
        assert (facet2 != null) : "Enforced by fatal validation check in checkConfiguration.";
        stats.setDebuggable(LaunchUtils.canDebugApp(facet2));
        stats.setExecutor(executor2.getId());
        this.updateExtraRunStats(stats);
        boolean isDebugging = executor2 instanceof DefaultDebugExecutor;
        DeployTargetContext context2 = this.getDeployTargetContext();
        stats.setUserSelectedTarget(context2.getCurrentDeployTargetProvider().requiresRuntimePrompt(facet2.getModule().getProject()));
        DeployTarget deployTarget2 = this.getDeployTarget();
        if (deployTarget2 == null) {
            return null;
        }
        DeployTargetState deployTargetState = context2.getCurrentDeployTargetState();
        if (deployTarget2.hasCustomRunProfileState(executor2)) {
            return deployTarget2.getRunProfileState(executor2, env, deployTargetState);
        }
        DeviceFutures deviceFutures = deployTarget2.getDevices(this.getProject());
        if (deviceFutures == null) {
            return null;
        }
        stats.setLaunchedDevices(deviceFutures.getDevices().stream().anyMatch(device2 -> device2 instanceof LaunchableAndroidDevice));
        if (deviceFutures.get().isEmpty()) {
            throw new ExecutionException(AndroidBundle.message("deployment.target.not.found", new Object[0]));
        }
        if (isDebugging && (error = AndroidRunConfigurationBase.canDebug(deviceFutures, facet2, module2.getName())) != null) {
            throw new ExecutionException(error);
        }
        env.putCopyableUserData(DeviceFutures.KEY, (Object)deviceFutures);
        env.putUserData(RunStats.KEY, (Object)stats);
        ApplicationIdProvider applicationIdProvider = this.getApplicationIdProvider();
        if (applicationIdProvider == null) {
            throw new RuntimeException("Cannot get ApplicationIdProvider");
        }
        LaunchOptions.Builder launchOptions = this.getLaunchOptions().setDebug(isDebugging);
        ApkProvider apkProvider = this.getApkProvider();
        if (apkProvider == null) {
            return null;
        }
        LaunchTasksProvider launchTasksProvider = this.createLaunchTasksProvider(env, facet2, applicationIdProvider, apkProvider, launchOptions.build());
        return new AndroidRunState(env, this.getName(), module2, applicationIdProvider, this.getConsoleProvider(deviceFutures.getDevices().size() > 1), deviceFutures, launchTasksProvider);
    }

    private LaunchTasksProvider createLaunchTasksProvider(@NotNull ExecutionEnvironment env, @NotNull AndroidFacet facet2, @NotNull ApplicationIdProvider applicationIdProvider, @NotNull ApkProvider apkProvider, @NotNull LaunchOptions launchOptions) {
        Optional<LaunchTasksProvider> provided = LaunchTasksProvider.Provider.EP_NAME.extensions().map(it -> it.createLaunchTasksProvider(this, env, facet2, applicationIdProvider, apkProvider, launchOptions)).filter(Objects::nonNull).findFirst();
        return provided.orElseGet(() -> new AndroidLaunchTasksProvider(this, env, facet2, applicationIdProvider, apkProvider, launchOptions));
    }

    private static String canDebug(@NotNull DeviceFutures deviceFutures, @NotNull AndroidFacet facet2, @NotNull String moduleName2) {
        for (AndroidDevice androidDevice : deviceFutures.getDevices()) {
            String deviceName;
            if (androidDevice.isDebuggable() || LaunchUtils.canDebugApp(facet2)) continue;
            if (!androidDevice.getLaunchedDevice().isDone()) {
                deviceName = androidDevice.getName();
            } else {
                IDevice device2 = (IDevice)Futures.getUnchecked(androidDevice.getLaunchedDevice());
                deviceName = device2.getName();
            }
            return AndroidBundle.message("android.cannot.debug.noDebugPermissions", moduleName2, deviceName);
        }
        return null;
    }

    @Nullable
    protected DeployTarget getDeployTarget() {
        Project project;
        DeployTargetProvider currentTargetProvider = this.getDeployTargetContext().getCurrentDeployTargetProvider();
        return currentTargetProvider.requiresRuntimePrompt(project = this.getProject()) ? currentTargetProvider.showPrompt(project) : currentTargetProvider.getDeployTarget(project);
    }

    @Nullable
    public ApplicationIdProvider getApplicationIdProvider() {
        return ProjectSystemUtil.getProjectSystem(this.getProject()).getApplicationIdProvider((RunConfiguration)this);
    }

    @Nullable
    public final ApkProvider getApkProvider() {
        return ProjectSystemUtil.getProjectSystem(this.getProject()).getApkProvider((RunConfiguration)this);
    }

    public boolean isTestConfiguration() {
        return this.myIsTestConfiguration;
    }

    @NotNull
    protected abstract ConsoleProvider getConsoleProvider(boolean var1);

    @Nullable
    protected abstract AppLaunchTask getApplicationLaunchTask(@NotNull ApplicationIdProvider var1, @NotNull AndroidFacet var2, @NotNull String var3, boolean var4, @NotNull LaunchStatus var5, @NotNull ApkProvider var6, @NotNull ConsolePrinter var7, @NotNull IDevice var8);

    public boolean canRunWithoutSync() {
        return false;
    }

    public void updateExtraRunStats(RunStats runStats) {
    }

    public void readExternal(@NotNull Element element2) throws InvalidDataException {
        super.readExternal(element2);
        DefaultJDOMExternalizer.readExternal((Object)this, (Element)element2);
        this.myDeployTargetContext.readExternal(element2);
        this.myAndroidDebuggerContext.readExternal(element2);
        Element profilersElement = element2.getChild(PROFILERS_ELEMENT_NAME);
        if (profilersElement != null) {
            this.myProfilerState.readExternal(profilersElement);
        }
    }

    public void writeExternal(@NotNull Element element2) throws WriteExternalException {
        super.writeExternal(element2);
        DefaultJDOMExternalizer.writeExternal((Object)this, (Element)element2);
        this.myDeployTargetContext.writeExternal(element2);
        this.myAndroidDebuggerContext.writeExternal(element2);
        Element profilersElement = new Element(PROFILERS_ELEMENT_NAME);
        element2.addContent(profilersElement);
        this.myProfilerState.writeExternal(profilersElement);
    }

    public boolean isNativeLaunch() {
        AndroidDebugger androidDebugger = this.myAndroidDebuggerContext.getAndroidDebugger();
        if (androidDebugger == null) {
            return false;
        }
        return !androidDebugger.getId().equals("Java");
    }

    @NotNull
    public DeployTargetContext getDeployTargetContext() {
        return this.myDeployTargetContext;
    }

    @Override
    @NotNull
    public AndroidDebuggerContext getAndroidDebuggerContext() {
        return this.myAndroidDebuggerContext;
    }

    @NotNull
    public ProfilerState getProfilerState() {
        return this.myProfilerState;
    }

    public boolean isProfilable() {
        return true;
    }
}

