/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.run;

import com.android.ddmlib.IDevice;
import com.android.tools.deployer.model.component.ComponentType;
import com.android.tools.idea.execution.common.AndroidExecutionTarget;
import com.android.tools.idea.execution.common.AppRunConfiguration;
import com.android.tools.idea.execution.common.AppRunSettings;
import com.android.tools.idea.execution.common.ComponentLaunchOptions;
import com.android.tools.idea.execution.common.DeployOptions;
import com.android.tools.idea.projectsystem.AndroidModuleSystem;
import com.android.tools.idea.projectsystem.ModuleSystemUtil;
import com.android.tools.idea.projectsystem.ProjectSystemUtil;
import com.android.tools.idea.run.AndroidRunConfigurationBase;
import com.android.tools.idea.run.AndroidRunConfigurationModule;
import com.android.tools.idea.run.ApkProvider;
import com.android.tools.idea.run.ApkProvisionException;
import com.android.tools.idea.run.ApplicationIdProvider;
import com.android.tools.idea.run.ConsolePrinter;
import com.android.tools.idea.run.ConsoleProvider;
import com.android.tools.idea.run.ExecutorIconProvider;
import com.android.tools.idea.run.LaunchOptions;
import com.android.tools.idea.run.ValidationError;
import com.android.tools.idea.run.activity.DefaultStartActivityFlagsProvider;
import com.android.tools.idea.run.activity.InstantAppStartActivityFlagsProvider;
import com.android.tools.idea.run.activity.StartActivityFlagsProvider;
import com.android.tools.idea.run.activity.launch.ActivityLaunchOption;
import com.android.tools.idea.run.activity.launch.ActivityLaunchOptionState;
import com.android.tools.idea.run.activity.launch.DeepLinkLaunch;
import com.android.tools.idea.run.activity.launch.DefaultActivityLaunch;
import com.android.tools.idea.run.activity.launch.NoLaunch;
import com.android.tools.idea.run.activity.launch.SpecificActivityLaunch;
import com.android.tools.idea.run.configuration.AndroidConfigurationProgramRunner;
import com.android.tools.idea.run.configuration.execution.AndroidActivityConfigurationExecutor;
import com.android.tools.idea.run.configuration.execution.AndroidConfigurationExecutor;
import com.android.tools.idea.run.configuration.execution.AndroidConfigurationExecutorRunProfileState;
import com.android.tools.idea.run.editor.AndroidRunConfigurationEditor;
import com.android.tools.idea.run.editor.ApplicationRunParameters;
import com.android.tools.idea.run.editor.DeployTargetProvider;
import com.android.tools.idea.run.tasks.AppLaunchTask;
import com.android.tools.idea.run.ui.BaseAction;
import com.android.tools.idea.run.util.LaunchStatus;
import com.android.tools.idea.stats.RunStats;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.ExecutionTarget;
import com.intellij.execution.ExecutionTargetManager;
import com.intellij.execution.Executor;
import com.intellij.execution.JavaExecutionUtil;
import com.intellij.execution.RunnerIconProvider;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.RefactoringListenerProvider;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.filters.TextConsoleBuilder;
import com.intellij.execution.filters.TextConsoleBuilderFactory;
import com.intellij.execution.junit.RefactoringListeners;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.ui.ConfigurationModuleSelector;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.DefaultJDOMExternalizer;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.refactoring.listeners.RefactoringElementListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.swing.Icon;
import org.jdom.Element;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.facet.AndroidFacetConfiguration;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AndroidRunConfiguration
extends AndroidRunConfigurationBase
implements RefactoringListenerProvider,
RunnerIconProvider,
AppRunConfiguration {
    @NonNls
    public static final String LAUNCH_DEFAULT_ACTIVITY = "default_activity";
    @NonNls
    public static final String LAUNCH_SPECIFIC_ACTIVITY = "specific_activity";
    @NonNls
    public static final String DO_NOTHING = "do_nothing";
    @NonNls
    public static final String LAUNCH_DEEP_LINK = "launch_deep_link";
    public static final List<? extends ActivityLaunchOption> LAUNCH_OPTIONS = Arrays.asList(NoLaunch.INSTANCE, DefaultActivityLaunch.INSTANCE, SpecificActivityLaunch.INSTANCE, DeepLinkLaunch.INSTANCE);
    @NonNls
    private static final String FEATURE_LIST_SEPARATOR = ",";
    private final Map<String, ActivityLaunchOptionState> myLaunchOptionStates = Maps.newHashMap();
    public boolean DEPLOY = true;
    public boolean DEPLOY_APK_FROM_BUNDLE = false;
    public boolean DEPLOY_AS_INSTANT = false;
    public String ARTIFACT_NAME = "";
    public String PM_INSTALL_OPTIONS = "";
    public boolean ALL_USERS = false;
    public boolean ALWAYS_INSTALL_WITH_PM = false;
    public boolean CLEAR_APP_STORAGE = false;
    public String DYNAMIC_FEATURES_DISABLED_LIST = "";
    public String ACTIVITY_EXTRA_FLAGS = "";
    public String MODE = "default_activity";

    public AndroidRunConfiguration(Project project, ConfigurationFactory factory2) {
        super(project, factory2, false);
        for (ActivityLaunchOption activityLaunchOption : LAUNCH_OPTIONS) {
            this.myLaunchOptionStates.put(activityLaunchOption.getId(), (ActivityLaunchOptionState)activityLaunchOption.createState());
        }
        this.putUserData(BaseAction.SHOW_APPLY_CHANGES_UI, true);
    }

    @Override
    @NotNull
    public List<DeployTargetProvider> getApplicableDeployTargetProviders() {
        return this.getDeployTargetContext().getApplicableDeployTargetProviders(false);
    }

    @Override
    protected Pair<Boolean, String> supportsRunningLibraryProjects(@NotNull AndroidFacet facet2) {
        return Pair.create((Object)Boolean.FALSE, (Object)AndroidBundle.message("android.cannot.run.library.project.error", new Object[0]));
    }

    @Override
    @NotNull
    protected List<ValidationError> checkConfiguration(@NotNull AndroidFacet facet2) {
        ArrayList<ValidationError> errors2 = new ArrayList<ValidationError>();
        ActivityLaunchOptionState activityLaunchOptionState = this.getLaunchOptionState(this.MODE);
        if (activityLaunchOptionState != null) {
            errors2.addAll(activityLaunchOptionState.checkConfiguration(facet2));
        }
        return errors2;
    }

    @Override
    @NotNull
    protected LaunchOptions.Builder getLaunchOptions() {
        return super.getLaunchOptions().setDeploy(this.DEPLOY).setPmInstallOptions(device2 -> this.PM_INSTALL_OPTIONS).setAllUsers(this.ALL_USERS).setDisabledDynamicFeatures(this.getDisabledDynamicFeatures()).setOpenLogcatAutomatically(this.SHOW_LOGCAT_AUTOMATICALLY).setDeployAsInstant(this.DEPLOY_AS_INSTANT).setAlwaysInstallWithPm(this.ALWAYS_INSTALL_WITH_PM).setClearAppStorage(this.CLEAR_APP_STORAGE);
    }

    @NotNull
    public List<String> getDisabledDynamicFeatures() {
        if (StringUtil.isEmpty((String)this.DYNAMIC_FEATURES_DISABLED_LIST)) {
            return ImmutableList.of();
        }
        return StringUtil.split((String)this.DYNAMIC_FEATURES_DISABLED_LIST, (String)FEATURE_LIST_SEPARATOR);
    }

    public void setDisabledDynamicFeatures(@NotNull List<String> features) {
        List sortedFeatures = features.stream().distinct().sorted().collect(Collectors.toList());
        this.DYNAMIC_FEATURES_DISABLED_LIST = StringUtil.join(sortedFeatures, (String)FEATURE_LIST_SEPARATOR);
    }

    @NotNull
    public SettingsEditor<? extends RunConfiguration> getConfigurationEditor() {
        return new AndroidRunConfigurationEditor<AndroidRunConfiguration>(this.getProject(), (Predicate<Module>)((Predicate)module2 -> {
            if (module2 == null) {
                return false;
            }
            AndroidFacet facet2 = AndroidFacet.getInstance((Module)module2);
            if (facet2 == null) {
                return false;
            }
            AndroidModuleSystem moduleSystem = ProjectSystemUtil.getModuleSystem(facet2);
            AndroidModuleSystem.Type moduleType = moduleSystem.getType();
            switch (moduleType) {
                case TYPE_APP: 
                case TYPE_DYNAMIC_FEATURE: {
                    return ModuleSystemUtil.isMainModule(module2);
                }
                case TYPE_ATOM: 
                case TYPE_FEATURE: 
                case TYPE_INSTANTAPP: {
                    return false;
                }
                case TYPE_NON_ANDROID: {
                    return false;
                }
                case TYPE_LIBRARY: 
                case TYPE_TEST: {
                    return false;
                }
            }
            return false;
        }), this, true, false, moduleSelector2 -> new ApplicationRunParameters(this.getProject(), (ConfigurationModuleSelector)moduleSelector2));
    }

    @Nullable
    public RefactoringElementListener getRefactoringElementListener(PsiElement element2) {
        final SpecificActivityLaunch.State state2 = (SpecificActivityLaunch.State)this.getLaunchOptionState(LAUNCH_SPECIFIC_ACTIVITY);
        assert (state2 != null);
        return RefactoringListeners.getClassOrPackageListener((PsiElement)element2, (RefactoringListeners.Accessor)new RefactoringListeners.Accessor<PsiClass>(){

            public void setName(String qualifiedName) {
                state2.ACTIVITY_CLASS = qualifiedName;
            }

            @Nullable
            public PsiClass getPsiElement() {
                return ((AndroidRunConfigurationModule)AndroidRunConfiguration.this.getConfigurationModule()).findClass(state2.ACTIVITY_CLASS);
            }

            public void setPsiElement(PsiClass psiClass) {
                state2.ACTIVITY_CLASS = JavaExecutionUtil.getRuntimeQualifiedName((PsiClass)psiClass);
            }
        });
    }

    @Override
    @NotNull
    protected ConsoleProvider getConsoleProvider(boolean runOnMultipleDevices) {
        return new ConsoleProvider(){

            @Override
            @NotNull
            public ConsoleView createAndAttach(@NotNull Disposable parent2, @NotNull ProcessHandler handler2, @NotNull Executor executor2) throws ExecutionException {
                Project project = ((AndroidRunConfigurationModule)AndroidRunConfiguration.this.getConfigurationModule()).getProject();
                TextConsoleBuilder builder2 = TextConsoleBuilderFactory.getInstance().createBuilder(project);
                ConsoleView console = builder2.getConsole();
                console.attachToProcess(handler2);
                return console;
            }
        };
    }

    @Override
    @Nullable
    protected AppLaunchTask getApplicationLaunchTask(@NotNull ApplicationIdProvider applicationIdProvider, @NotNull AndroidFacet facet2, @NotNull String contributorsAmStartOptions, boolean waitForDebugger, @NotNull LaunchStatus launchStatus, @NotNull ApkProvider apkProvider, @NotNull ConsolePrinter consolePrinter, @NotNull IDevice device2) {
        ActivityLaunchOptionState state2 = this.getLaunchOptionState(this.MODE);
        assert (state2 != null);
        Object extraFlags = this.ACTIVITY_EXTRA_FLAGS;
        if (!contributorsAmStartOptions.isEmpty()) {
            extraFlags = (String)extraFlags + (((String)extraFlags).isEmpty() ? "" : " ") + contributorsAmStartOptions;
        }
        if (device2.getVersion().isGreaterOrEqualThan(33)) {
            extraFlags = (String)extraFlags + (((String)extraFlags).isEmpty() ? "" : " ") + "--splashscreen-show-icon";
        }
        StartActivityFlagsProvider startActivityFlagsProvider = ((AndroidFacetConfiguration)facet2.getConfiguration()).getProjectType() == 4 ? new InstantAppStartActivityFlagsProvider() : new DefaultStartActivityFlagsProvider(waitForDebugger, (String)extraFlags);
        try {
            return state2.getLaunchTask(applicationIdProvider.getPackageName(), facet2, startActivityFlagsProvider, this.getProfilerState(), apkProvider);
        }
        catch (ApkProvisionException e) {
            Logger.getInstance(AndroidRunConfiguration.class).error((Throwable)e);
            launchStatus.terminateLaunch("Unable to identify application id", true);
            return null;
        }
    }

    public void setLaunchActivity(@NotNull String activityName, boolean searchActivityInGlobalScope) {
        this.MODE = LAUNCH_SPECIFIC_ACTIVITY;
        ActivityLaunchOptionState state2 = this.getLaunchOptionState(LAUNCH_SPECIFIC_ACTIVITY);
        assert (state2 instanceof SpecificActivityLaunch.State);
        SpecificActivityLaunch.State specificActivityLaunchState = (SpecificActivityLaunch.State)state2;
        specificActivityLaunchState.ACTIVITY_CLASS = activityName;
        specificActivityLaunchState.SEARCH_ACTIVITY_IN_GLOBAL_SCOPE = searchActivityInGlobalScope;
    }

    public void setLaunchActivity(@NotNull String activityName) {
        this.setLaunchActivity(activityName, false);
    }

    public void setLaunchUrl(@NotNull String url) {
        this.MODE = LAUNCH_DEEP_LINK;
        ActivityLaunchOptionState state2 = this.getLaunchOptionState(LAUNCH_DEEP_LINK);
        assert (state2 instanceof DeepLinkLaunch.State);
        ((DeepLinkLaunch.State)state2).DEEP_LINK = url;
    }

    public boolean isLaunchingActivity(@Nullable String activityName) {
        if (!StringUtil.equals((CharSequence)this.MODE, (CharSequence)LAUNCH_SPECIFIC_ACTIVITY)) {
            return false;
        }
        ActivityLaunchOptionState state2 = this.getLaunchOptionState(LAUNCH_SPECIFIC_ACTIVITY);
        assert (state2 instanceof SpecificActivityLaunch.State);
        return StringUtil.equals((CharSequence)((SpecificActivityLaunch.State)state2).ACTIVITY_CLASS, (CharSequence)activityName);
    }

    @NotNull
    public ActivityLaunchOptionState getLaunchOptionState(@NotNull String launchOptionId) {
        return this.myLaunchOptionStates.get(launchOptionId);
    }

    @Override
    public void readExternal(@NotNull Element element2) throws InvalidDataException {
        super.readExternal(element2);
        for (ActivityLaunchOptionState state2 : this.myLaunchOptionStates.values()) {
            DefaultJDOMExternalizer.readExternal((Object)state2, (Element)element2);
        }
        if (this.DEPLOY_APK_FROM_BUNDLE) {
            this.DEPLOY = true;
        }
    }

    @Override
    public void writeExternal(@NotNull Element element2) throws WriteExternalException {
        super.writeExternal(element2);
        for (ActivityLaunchOptionState state2 : this.myLaunchOptionStates.values()) {
            DefaultJDOMExternalizer.writeExternal((Object)state2, (Element)element2);
        }
    }

    @Nullable
    public Icon getExecutorIcon(@NotNull RunConfiguration configuration, @NotNull Executor executor2) {
        boolean isRunning;
        Project project = configuration.getProject();
        ExecutionTarget executionTarget = ExecutionTargetManager.getInstance((Project)project).getActiveTarget();
        ApplicationIdProvider applicationIdProvider = this.getApplicationIdProvider();
        String applicationId2 = null;
        try {
            applicationId2 = applicationIdProvider == null ? null : applicationIdProvider.getPackageName();
        }
        catch (ApkProvisionException apkProvisionException) {
            // empty catch block
        }
        boolean bl = isRunning = executionTarget instanceof AndroidExecutionTarget && applicationId2 != null && ((AndroidExecutionTarget)executionTarget).isApplicationRunning(applicationId2);
        if ("Run".equals(executor2.getId())) {
            if (isRunning) {
                return AllIcons.Actions.Restart;
            }
            return executor2 instanceof ExecutorIconProvider ? ((ExecutorIconProvider)executor2).getExecutorIcon(this.getProject(), executor2) : executor2.getIcon();
        }
        return null;
    }

    @Override
    public void updateExtraRunStats(RunStats runStats) {
        runStats.setAppComponentType(ComponentType.ACTIVITY);
        runStats.setDeployedAsInstant(this.DEPLOY_AS_INSTANT);
        runStats.setDeployedFromBundle(this.DEPLOY_APK_FROM_BUNDLE);
    }

    @NotNull
    public AndroidConfigurationExecutor getExecutor(@NotNull ExecutionEnvironment environment) {
        final Module myModule = ((AndroidRunConfigurationModule)this.getConfigurationModule()).getModule();
        final ActivityLaunchOptionState launchOptions = this.getLaunchOptionState(this.MODE);
        final DeployOptions deployOptions = new DeployOptions(this.getDisabledDynamicFeatures(), this.PM_INSTALL_OPTIONS, this.ALL_USERS, this.ALWAYS_INSTALL_WITH_PM);
        AppRunSettings settings = new AppRunSettings(){

            @Override
            @Nullable
            public Module getModule() {
                return myModule;
            }

            @Override
            @NotNull
            public ComponentLaunchOptions getComponentLaunchOptions() {
                return launchOptions;
            }

            @Override
            @NotNull
            public DeployOptions getDeployOptions() {
                return deployOptions;
            }
        };
        return new AndroidActivityConfigurationExecutor(environment, this.getDeployTarget(), settings, this.getApplicationIdProvider(), this.getApkProvider());
    }

    @Override
    public RunProfileState getState(@NotNull Executor executor2, @NotNull ExecutionEnvironment env) throws ExecutionException {
        if (AndroidConfigurationProgramRunner.Companion.getUseNewExecutionForActivities()) {
            return new AndroidConfigurationExecutorRunProfileState(this.getExecutor(env));
        }
        return super.getState(executor2, env);
    }

    @Override
    @Nullable
    public String getAppId() {
        try {
            ApplicationIdProvider provider2 = this.getApplicationIdProvider();
            if (provider2 == null) {
                return null;
            }
            return provider2.getPackageName();
        }
        catch (ApkProvisionException e) {
            Logger.getInstance(AndroidRunConfiguration.class).error((Throwable)e);
            return null;
        }
    }
}

