/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.run;

import com.android.tools.idea.execution.common.AndroidExecutionTarget;
import com.intellij.execution.ExecutionTargetManager;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.execution.configurations.RunnerSettings;
import com.intellij.execution.runners.GenericProgramRunner;
import com.intellij.openapi.project.Project;
import java.util.function.BiFunction;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AndroidProgramRunner
extends GenericProgramRunner<RunnerSettings> {
    @NotNull
    private final @NotNull BiFunction<@NotNull Project, @NotNull RunConfiguration, @Nullable AndroidExecutionTarget> myGetAndroidTarget;

    public AndroidProgramRunner() {
        this(AndroidProgramRunner::getAvailableAndroidTarget);
    }

    AndroidProgramRunner(@NotNull @NotNull BiFunction<@NotNull Project, @NotNull RunConfiguration, @Nullable AndroidExecutionTarget> getTarget) {
        this.myGetAndroidTarget = getTarget;
    }

    public boolean canRun(@NotNull String executorId, @NotNull RunProfile profile) {
        if (profile instanceof RunConfiguration) {
            Project project = ((RunConfiguration)profile).getProject();
            AndroidExecutionTarget target2 = this.myGetAndroidTarget.apply(project, (RunConfiguration)profile);
            if (target2 == null) {
                return false;
            }
            if (target2.getAvailableDeviceCount() <= 1) {
                return true;
            }
            return this.canRunWithMultipleDevices(executorId);
        }
        return false;
    }

    @Nullable
    private static AndroidExecutionTarget getAvailableAndroidTarget(Project project, RunConfiguration profile) {
        return ExecutionTargetManager.getInstance((Project)project).getTargetsFor(profile).stream().filter(AndroidExecutionTarget.class::isInstance).map(AndroidExecutionTarget.class::cast).findFirst().orElse(null);
    }

    protected abstract boolean canRunWithMultipleDevices(@NotNull String var1);
}

