/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.run;

import com.android.ddmlib.IDevice;
import com.android.tools.idea.deploy.DeploymentConfiguration;
import com.android.tools.idea.editors.literals.LiveEditService;
import com.android.tools.idea.execution.common.debug.AndroidDebuggerContext;
import com.android.tools.idea.gradle.util.DynamicAppUtils;
import com.android.tools.idea.projectsystem.AndroidProjectSystem;
import com.android.tools.idea.projectsystem.ProjectSystemService;
import com.android.tools.idea.run.AndroidLaunchTaskContributor;
import com.android.tools.idea.run.AndroidLiveLiteralDeployMonitor;
import com.android.tools.idea.run.AndroidRunConfiguration;
import com.android.tools.idea.run.AndroidRunConfigurationBase;
import com.android.tools.idea.run.ApkFileUnit;
import com.android.tools.idea.run.ApkInfo;
import com.android.tools.idea.run.ApkProvider;
import com.android.tools.idea.run.ApkProvisionException;
import com.android.tools.idea.run.ApplicationIdProvider;
import com.android.tools.idea.run.ConsolePrinter;
import com.android.tools.idea.run.LaunchOptions;
import com.android.tools.idea.run.activity.launch.DeepLinkLaunch;
import com.android.tools.idea.run.tasks.AppLaunchTask;
import com.android.tools.idea.run.tasks.ApplyChangesTask;
import com.android.tools.idea.run.tasks.ApplyCodeChangesTask;
import com.android.tools.idea.run.tasks.ClearAppStorageTask;
import com.android.tools.idea.run.tasks.ClearLogcatTask;
import com.android.tools.idea.run.tasks.ConnectDebuggerTask;
import com.android.tools.idea.run.tasks.DefaultConnectDebuggerTaskKt;
import com.android.tools.idea.run.tasks.DeployTask;
import com.android.tools.idea.run.tasks.DismissKeyguardTask;
import com.android.tools.idea.run.tasks.KillAndRestartAppLaunchTask;
import com.android.tools.idea.run.tasks.LaunchTask;
import com.android.tools.idea.run.tasks.LaunchTasksProvider;
import com.android.tools.idea.run.tasks.RunInstantAppTask;
import com.android.tools.idea.run.tasks.ShowLogcatTask;
import com.android.tools.idea.run.tasks.StartLiveUpdateMonitoringTask;
import com.android.tools.idea.run.util.LaunchStatus;
import com.android.tools.idea.run.util.SwapInfo;
import com.android.tools.idea.stats.RunStats;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.intellij.execution.executors.DefaultDebugExecutor;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.facet.AndroidFacetConfiguration;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.util.projectStructure.ProjectStructureUtilKt;

public class AndroidLaunchTasksProvider
implements LaunchTasksProvider {
    private final Logger myLogger = Logger.getInstance(AndroidLaunchTasksProvider.class);
    private final AndroidRunConfigurationBase myRunConfig;
    private final ExecutionEnvironment myEnv;
    private final AndroidFacet myFacet;
    private final ApplicationIdProvider myApplicationIdProvider;
    private final ApkProvider myApkProvider;
    private final LaunchOptions myLaunchOptions;
    private final Project myProject;

    public AndroidLaunchTasksProvider(@NotNull AndroidRunConfigurationBase runConfig, @NotNull ExecutionEnvironment env, @NotNull AndroidFacet facet2, @NotNull ApplicationIdProvider applicationIdProvider, @NotNull ApkProvider apkProvider, @NotNull LaunchOptions launchOptions) {
        this.myRunConfig = runConfig;
        this.myEnv = env;
        this.myProject = facet2.getModule().getProject();
        this.myFacet = facet2;
        this.myApplicationIdProvider = applicationIdProvider;
        this.myApkProvider = apkProvider;
        this.myLaunchOptions = launchOptions;
    }

    @Override
    @NotNull
    public List<LaunchTask> getTasks(@NotNull IDevice device2, @NotNull LaunchStatus launchStatus, @NotNull ConsolePrinter consolePrinter) {
        String packageName2;
        ArrayList<LaunchTask> launchTasks = new ArrayList<LaunchTask>();
        if (this.myLaunchOptions.isClearLogcatBeforeStart()) {
            launchTasks.add(new ClearLogcatTask(this.myProject));
        }
        launchTasks.add(new DismissKeyguardTask());
        boolean useApplyChanges = this.shouldApplyChanges() || this.shouldApplyCodeChanges();
        boolean terminateLaunchOnError = !useApplyChanges && !this.shouldDeployAsInstant();
        try {
            AppLaunchTask appLaunchTask;
            packageName2 = this.myApplicationIdProvider.getPackageName();
            launchTasks.addAll(this.getDeployTasks(device2, packageName2));
            StringBuilder amStartOptions = new StringBuilder();
            for (AndroidLaunchTaskContributor taskContributor : (AndroidLaunchTaskContributor[])AndroidLaunchTaskContributor.EP_NAME.getExtensions()) {
                String amOptions = taskContributor.getAmStartOptions(packageName2, this.myRunConfig, device2, this.myEnv.getExecutor());
                amStartOptions.append(amStartOptions.length() == 0 ? "" : " ").append(amOptions);
                LaunchTask task2 = taskContributor.getTask(packageName2, this.myRunConfig, device2, this.myEnv.getExecutor());
                if (task2 == null) continue;
                launchTasks.add(task2);
            }
            if (!this.shouldDeployAsInstant() && (appLaunchTask = this.myRunConfig.getApplicationLaunchTask(this.myApplicationIdProvider, this.myFacet, amStartOptions.toString(), this.myLaunchOptions.isDebug(), launchStatus, this.myApkProvider, consolePrinter, device2)) != null) {
                launchTasks.add(new KillAndRestartAppLaunchTask(packageName2));
                launchTasks.add(appLaunchTask);
            }
        }
        catch (ApkProvisionException e) {
            if (useApplyChanges) {
                this.myLogger.error((Throwable)e);
            } else {
                this.myLogger.warn((Throwable)e);
            }
            launchStatus.terminateLaunch(e.getMessage(), terminateLaunchOnError);
            return Collections.emptyList();
        }
        catch (IllegalStateException e) {
            this.myLogger.error((Throwable)e);
            launchStatus.terminateLaunch(e.getMessage(), terminateLaunchOnError);
            return Collections.emptyList();
        }
        if (!this.myLaunchOptions.isDebug() && this.myLaunchOptions.isOpenLogcatAutomatically()) {
            launchTasks.add(new ShowLogcatTask(this.myProject, packageName2));
        }
        return launchTasks;
    }

    @NotNull
    @VisibleForTesting
    List<LaunchTask> getDeployTasks(@NotNull IDevice device2, @NotNull String packageName2) throws ApkProvisionException {
        if (!this.myLaunchOptions.isDeploy()) {
            return Collections.emptyList();
        }
        ArrayList<LaunchTask> tasks = new ArrayList<LaunchTask>();
        DeployType deployType = this.getDeployType();
        List<String> disabledFeatures = this.myLaunchOptions.getDisabledDynamicFeatures();
        List<ApkInfo> packages = this.myApkProvider.getApks(device2).stream().map(apkInfo -> AndroidLaunchTasksProvider.filterDisabledFeatures(apkInfo, disabledFeatures)).collect(Collectors.toList());
        switch (deployType) {
            case RUN_INSTANT_APP: {
                if (this.myLaunchOptions.isClearAppStorage()) {
                    tasks.add(new ClearAppStorageTask(packageName2));
                }
                AndroidRunConfiguration runConfig = (AndroidRunConfiguration)this.myRunConfig;
                DeepLinkLaunch.State state2 = (DeepLinkLaunch.State)runConfig.getLaunchOptionState("launch_deep_link");
                assert (state2 != null);
                tasks.add(new RunInstantAppTask(this.myApkProvider.getApks(device2), state2.DEEP_LINK, disabledFeatures));
                break;
            }
            case APPLY_CHANGES: {
                tasks.add(new ApplyChangesTask(this.myProject, packages, this.isApplyChangesFallbackToRun(), this.myLaunchOptions.getAlwaysInstallWithPm()));
                tasks.add(new StartLiveUpdateMonitoringTask(AndroidLiveLiteralDeployMonitor.getCallback(this.myProject, packageName2, device2)));
                tasks.add(new StartLiveUpdateMonitoringTask(LiveEditService.getInstance(this.myProject).getCallback(packageName2, device2)));
                break;
            }
            case APPLY_CODE_CHANGES: {
                tasks.add(new ApplyCodeChangesTask(this.myProject, packages, this.isApplyCodeChangesFallbackToRun(), this.myLaunchOptions.getAlwaysInstallWithPm()));
                tasks.add(new StartLiveUpdateMonitoringTask(AndroidLiveLiteralDeployMonitor.getCallback(this.myProject, packageName2, device2)));
                tasks.add(new StartLiveUpdateMonitoringTask(LiveEditService.getInstance(this.myProject).getCallback(packageName2, device2)));
                break;
            }
            case DEPLOY: {
                if (this.myLaunchOptions.isClearAppStorage()) {
                    tasks.add(new ClearAppStorageTask(packageName2));
                }
                tasks.add(new DeployTask(this.myProject, packages, this.myLaunchOptions.getPmInstallOptions(device2), this.myLaunchOptions.getInstallOnAllUsers(), this.myLaunchOptions.getAlwaysInstallWithPm()));
                tasks.add(new StartLiveUpdateMonitoringTask(AndroidLiveLiteralDeployMonitor.getCallback(this.myProject, packageName2, device2)));
                if (this.myEnv.getExecutor() == DefaultDebugExecutor.getDebugExecutorInstance()) {
                    LiveEditService.getInstance(this.myProject).notifyDebug(packageName2, device2);
                    break;
                }
                AndroidProjectSystem androidProjectSystem = ProjectSystemService.getInstance(this.myProject).getProjectSystem();
                if (!ProjectStructureUtilKt.allModules((Project)this.myProject).stream().anyMatch(m -> androidProjectSystem.getModuleSystem((Module)m).getUsesCompose())) break;
                tasks.add(new StartLiveUpdateMonitoringTask(LiveEditService.getInstance(this.myProject).getCallback(packageName2, device2)));
                break;
            }
            default: {
                throw new IllegalStateException("Unhandled Deploy Type");
            }
        }
        return ImmutableList.copyOf(tasks);
    }

    @Override
    public String getLaunchTypeDisplayName() {
        return this.getDeployType().asDisplayName();
    }

    private boolean isApplyCodeChangesFallbackToRun() {
        return DeploymentConfiguration.getInstance().APPLY_CODE_CHANGES_FALLBACK_TO_RUN;
    }

    private boolean isApplyChangesFallbackToRun() {
        return DeploymentConfiguration.getInstance().APPLY_CHANGES_FALLBACK_TO_RUN;
    }

    @Override
    public void fillStats(RunStats stats) {
        stats.setApplyChangesFallbackToRun(this.isApplyChangesFallbackToRun());
        stats.setApplyCodeChangesFallbackToRun(this.isApplyCodeChangesFallbackToRun());
        stats.setRunAlwaysInstallWithPm(this.myLaunchOptions.getAlwaysInstallWithPm());
    }

    @NotNull
    private static ApkInfo filterDisabledFeatures(ApkInfo apkInfo, List<String> disabledFeatures) {
        if (apkInfo.getFiles().size() > 1) {
            List<ApkFileUnit> filtered = apkInfo.getFiles().stream().filter(feature -> DynamicAppUtils.isFeatureEnabled(disabledFeatures, feature)).collect(Collectors.toList());
            return new ApkInfo(filtered, apkInfo.getApplicationId());
        }
        return apkInfo;
    }

    @Override
    @Nullable
    public ConnectDebuggerTask getConnectDebuggerTask() {
        if (!this.myLaunchOptions.isDebug()) {
            return null;
        }
        AndroidDebuggerContext androidDebuggerContext = this.myRunConfig.getAndroidDebuggerContext();
        return DefaultConnectDebuggerTaskKt.getBaseDebuggerTask(androidDebuggerContext, this.myFacet, this.myApplicationIdProvider, this.myEnv);
    }

    private boolean shouldDeployAsInstant() {
        return ((AndroidFacetConfiguration)this.myFacet.getConfiguration()).getProjectType() == 4 || this.myLaunchOptions.isDeployAsInstant();
    }

    private boolean shouldApplyChanges() {
        SwapInfo swapInfo = (SwapInfo)this.myEnv.getUserData(SwapInfo.SWAP_INFO_KEY);
        return swapInfo != null && swapInfo.getType() == SwapInfo.SwapType.APPLY_CHANGES;
    }

    private boolean shouldApplyCodeChanges() {
        SwapInfo swapInfo = (SwapInfo)this.myEnv.getUserData(SwapInfo.SWAP_INFO_KEY);
        return swapInfo != null && swapInfo.getType() == SwapInfo.SwapType.APPLY_CODE_CHANGES;
    }

    private DeployType getDeployType() {
        if (this.shouldDeployAsInstant()) {
            return DeployType.RUN_INSTANT_APP;
        }
        if (this.shouldApplyChanges()) {
            return DeployType.APPLY_CHANGES;
        }
        if (this.shouldApplyCodeChanges()) {
            return DeployType.APPLY_CODE_CHANGES;
        }
        return DeployType.DEPLOY;
    }

    private static enum DeployType {
        RUN_INSTANT_APP{

            @Override
            public String asDisplayName() {
                return "Instant App Launch";
            }
        }
        ,
        APPLY_CHANGES{

            @Override
            public String asDisplayName() {
                return "Apply Changes";
            }
        }
        ,
        APPLY_CODE_CHANGES{

            @Override
            public String asDisplayName() {
                return "Apply Code Changes";
            }
        }
        ,
        DEPLOY{

            @Override
            public String asDisplayName() {
                return "Launch";
            }
        };


        public abstract String asDisplayName();
    }
}

