/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.room.migrations.ui;

import com.android.tools.idea.room.migrations.ui.GenerateMigrationWizardData;
import com.android.tools.idea.room.migrations.ui.GenerateMigrationWizardStep;
import com.intellij.ide.wizard.CommitStepException;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.refactoring.MoveDestination;
import com.intellij.refactoring.PackageWrapper;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.move.moveClassesOrPackages.DestinationFolderComboBox;
import com.intellij.refactoring.ui.PackageNameReferenceEditorCombo;
import com.intellij.ui.EditorComboBox;
import com.intellij.ui.ReferenceEditorComboWithBrowseButton;
import com.intellij.ui.components.JBLabel;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;

public class GenerateMigrationWizardSelectDestinationStep
implements GenerateMigrationWizardStep {
    private static final String TARGET_PACKAGE_LABEL = "Choose target package package";
    private static final String MIGRATION_CLASS_COMBO_BOX_LABEL = "Choose destination directory for the migration class";
    private static final String MIGRATION_TEST_COMBO_BOX_LABEL = "Choose destination directory for the migration test";
    private GenerateMigrationWizardData wizardData;
    private Project project;
    private PsiPackage targetPackage;
    private PsiDirectory migrationClassDirectory;
    private PsiDirectory migrationTestDirectory;
    private DestinationFolderComboBox migrationClassDirectoryComboBox;
    private DestinationFolderComboBox migrationTestDirectoryComboBox;
    private ReferenceEditorComboWithBrowseButton targetPackageComboBox;
    private JPanel centerPanel;

    public GenerateMigrationWizardSelectDestinationStep(@NotNull GenerateMigrationWizardData wizardData) {
        this.wizardData = wizardData;
        this.project = wizardData.getProject();
        this.targetPackage = wizardData.getTargetPackage();
        this.migrationClassDirectory = wizardData.getMigrationClassDirectory();
        this.migrationTestDirectory = wizardData.getMigrationTestDirectory();
        this.targetPackageComboBox = new PackageNameReferenceEditorCombo(this.targetPackage.getQualifiedName(), this.project, "", TARGET_PACKAGE_LABEL);
        this.migrationClassDirectoryComboBox = this.createDestinationFolderComboBox();
        this.migrationClassDirectoryComboBox.setData(this.project, this.migrationClassDirectory, (EditorComboBox)this.targetPackageComboBox.getChildComponent());
        this.migrationTestDirectoryComboBox = this.createDestinationFolderComboBox();
        this.migrationTestDirectoryComboBox.setData(this.project, this.migrationTestDirectory, (EditorComboBox)this.targetPackageComboBox.getChildComponent());
    }

    public void _init() {
        if (this.centerPanel == null) {
            this.createCenterPanel();
        }
    }

    public void _commit(boolean finishChosen) throws CommitStepException {
        MoveDestination testMoveDestination;
        MoveDestination classMoveDestination = this.migrationClassDirectoryComboBox.selectDirectory(PackageWrapper.create((PsiPackage)this.targetPackage), false);
        if (classMoveDestination != null) {
            assert (this.migrationClassDirectory != null);
            this.migrationClassDirectory = (PsiDirectory)WriteAction.compute(() -> classMoveDestination.getTargetDirectory(this.migrationClassDirectory));
        }
        if ((testMoveDestination = this.migrationTestDirectoryComboBox.selectDirectory(PackageWrapper.create((PsiPackage)this.targetPackage), false)) != null) {
            assert (this.migrationTestDirectory != null);
            this.migrationTestDirectory = (PsiDirectory)WriteAction.compute(() -> testMoveDestination.getTargetDirectory(this.migrationTestDirectory));
        }
        this.wizardData.updateTargetPackage(this.targetPackage);
        this.wizardData.updateMigrationClassDirectory(this.migrationClassDirectory);
        this.wizardData.updateMigrationTestDirectory(this.migrationTestDirectory);
    }

    public Icon getIcon() {
        return null;
    }

    public JComponent getComponent() {
        return this.centerPanel;
    }

    public JComponent getPreferredFocusedComponent() {
        return this.targetPackageComboBox;
    }

    private DestinationFolderComboBox createDestinationFolderComboBox() {
        return new DestinationFolderComboBox(){

            public String getTargetPackage() {
                if (GenerateMigrationWizardSelectDestinationStep.this.packageWasChanged()) {
                    GenerateMigrationWizardSelectDestinationStep.this.onPackageChange();
                }
                return GenerateMigrationWizardSelectDestinationStep.this.targetPackage.getQualifiedName();
            }
        };
    }

    private boolean packageWasChanged() {
        return !this.targetPackage.getQualifiedName().equals(this.targetPackageComboBox.getText().trim());
    }

    private void onPackageChange() {
        PsiPackage newPackage = JavaPsiFacade.getInstance((Project)this.project).findPackage(this.targetPackageComboBox.getText().trim());
        if (newPackage == null) {
            return;
        }
        PsiDirectory[] newDirectories = newPackage.getDirectories(GlobalSearchScope.projectScope((Project)this.project));
        if (newDirectories.length > 0) {
            this.targetPackage = newPackage;
            this.migrationClassDirectory = newDirectories[0];
            this.migrationClassDirectoryComboBox.setData(this.project, this.migrationClassDirectory, (EditorComboBox)this.targetPackageComboBox.getChildComponent());
        }
    }

    private JPanel createTargetDirectoryPanel(@NotNull DestinationFolderComboBox comboBox2, @NotNull String labelText) {
        JPanel targetDirectoryPanel = new JPanel(new BorderLayout());
        JBLabel label = new JBLabel(labelText);
        targetDirectoryPanel.setBorder(BorderFactory.createEmptyBorder(10, 0, 0, 0));
        targetDirectoryPanel.add((Component)comboBox2, "Center");
        targetDirectoryPanel.add((Component)label, "North");
        label.setLabelFor((Component)comboBox2);
        return targetDirectoryPanel;
    }

    private JPanel createTargetPackagePanel() {
        JPanel targetPackagePanel = new JPanel(new BorderLayout());
        JBLabel label = new JBLabel(RefactoringBundle.message((String)"choose.destination.package"));
        targetPackagePanel.add((Component)this.targetPackageComboBox, "Center");
        targetPackagePanel.add((Component)label, "North");
        label.setLabelFor((Component)this.targetPackageComboBox);
        return targetPackagePanel;
    }

    protected void createCenterPanel() {
        this.centerPanel = new JPanel(new BorderLayout());
        this.centerPanel.add((Component)this.createTargetPackagePanel(), "North");
        JPanel directoriesPanel = new JPanel(new BorderLayout());
        directoriesPanel.add((Component)this.createTargetDirectoryPanel(this.migrationClassDirectoryComboBox, MIGRATION_CLASS_COMBO_BOX_LABEL), "North");
        directoriesPanel.add((Component)this.createTargetDirectoryPanel(this.migrationTestDirectoryComboBox, MIGRATION_TEST_COMBO_BOX_LABEL), "South");
        this.centerPanel.add((Component)directoriesPanel, "South");
    }

    @Override
    public boolean shouldBeSkipped() {
        return false;
    }
}

