/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.room.migrations.json;

import com.android.tools.idea.room.migrations.json.EntityBundle;
import com.android.tools.idea.room.migrations.json.FieldBundle;
import com.android.tools.idea.room.migrations.json.FtsOptionsBundle;
import com.android.tools.idea.room.migrations.json.PrimaryKeyBundle;
import com.android.tools.idea.room.migrations.json.SchemaEqualityUtil;
import com.google.gson.annotations.SerializedName;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class FtsEntityBundle
extends EntityBundle {
    private static final String[] SHADOW_TABLE_NAME_SUFFIXES = new String[]{"_content", "_segdir", "_segments", "_stat", "_docsize"};
    @SerializedName(value="ftsVersion")
    private final String mFtsVersion;
    @SerializedName(value="ftsOptions")
    private final FtsOptionsBundle mFtsOptions;
    @SerializedName(value="contentSyncTriggers")
    private final List<String> mContentSyncSqlTriggers;

    public FtsEntityBundle(String tableName, String createSql, List<FieldBundle> fields, PrimaryKeyBundle primaryKey, String ftsVersion, FtsOptionsBundle ftsOptions, List<String> contentSyncSqlTriggers) {
        super(tableName, createSql, fields, primaryKey, Collections.emptyList(), Collections.emptyList());
        this.mFtsVersion = ftsVersion;
        this.mFtsOptions = ftsOptions;
        this.mContentSyncSqlTriggers = contentSyncSqlTriggers;
    }

    public FtsOptionsBundle getFtsOptions() {
        return this.mFtsOptions;
    }

    @Override
    public Collection<String> buildCreateQueries() {
        ArrayList<String> result2 = new ArrayList<String>();
        result2.add(this.createTable());
        result2.addAll(this.mContentSyncSqlTriggers);
        return result2;
    }

    @Override
    public boolean isSchemaEqual(EntityBundle other) {
        boolean isSuperSchemaEqual = super.isSchemaEqual(other);
        if (other instanceof FtsEntityBundle) {
            FtsEntityBundle otherFtsBundle = (FtsEntityBundle)other;
            return isSuperSchemaEqual && this.mFtsVersion.equals(otherFtsBundle.mFtsVersion) && SchemaEqualityUtil.checkSchemaEquality(this.mFtsOptions, otherFtsBundle.mFtsOptions);
        }
        return isSuperSchemaEqual;
    }

    public List<String> getShadowTableNames() {
        ArrayList<String> names = new ArrayList<String>(SHADOW_TABLE_NAME_SUFFIXES.length);
        for (String suffix : SHADOW_TABLE_NAME_SUFFIXES) {
            names.add(this.getTableName() + suffix);
        }
        return names;
    }
}

