/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.room.migrations.json;

import com.android.tools.idea.room.migrations.json.DatabaseViewBundle;
import com.android.tools.idea.room.migrations.json.EntityBundle;
import com.android.tools.idea.room.migrations.json.FtsEntityBundle;
import com.android.tools.idea.room.migrations.json.SchemaEquality;
import com.android.tools.idea.room.migrations.json.SchemaEqualityUtil;
import com.google.gson.annotations.SerializedName;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DatabaseBundle
implements SchemaEquality<DatabaseBundle> {
    @SerializedName(value="version")
    private int mVersion;
    @SerializedName(value="identityHash")
    private String mIdentityHash;
    @SerializedName(value="entities")
    private List<EntityBundle> mEntities;
    @SerializedName(value="views")
    private List<DatabaseViewBundle> mViews;
    @SerializedName(value="setupQueries")
    private List<String> mSetupQueries;
    private transient Map<String, EntityBundle> mEntitiesByTableName;

    public DatabaseBundle(int version2, String identityHash, List<EntityBundle> entities2, List<DatabaseViewBundle> views2, List<String> setupQueries) {
        this.mVersion = version2;
        this.mIdentityHash = identityHash;
        this.mEntities = entities2;
        this.mViews = views2;
        this.mSetupQueries = setupQueries;
    }

    public DatabaseBundle() {
        this.mViews = Collections.emptyList();
    }

    public String getIdentityHash() {
        return this.mIdentityHash;
    }

    public int getVersion() {
        return this.mVersion;
    }

    public List<EntityBundle> getEntities() {
        return this.mEntities;
    }

    public Map<String, EntityBundle> getEntitiesByTableName() {
        if (this.mEntitiesByTableName == null) {
            this.mEntitiesByTableName = new HashMap<String, EntityBundle>();
            for (EntityBundle bundle2 : this.mEntities) {
                this.mEntitiesByTableName.put(bundle2.getTableName(), bundle2);
            }
        }
        return this.mEntitiesByTableName;
    }

    public List<DatabaseViewBundle> getViews() {
        return this.mViews;
    }

    public List<String> buildCreateQueries() {
        ArrayList<String> result2 = new ArrayList<String>();
        Collections.sort(this.mEntities, new FtsEntityCreateComparator());
        for (EntityBundle entityBundle : this.mEntities) {
            result2.addAll(entityBundle.buildCreateQueries());
        }
        for (DatabaseViewBundle viewBundle : this.mViews) {
            result2.add(viewBundle.createView());
        }
        result2.addAll(this.mSetupQueries);
        return result2;
    }

    @Override
    public boolean isSchemaEqual(DatabaseBundle other) {
        return SchemaEqualityUtil.checkSchemaEquality(this.getEntitiesByTableName(), other.getEntitiesByTableName());
    }

    static final class FtsEntityCreateComparator
    implements Comparator<EntityBundle> {
        FtsEntityCreateComparator() {
        }

        @Override
        public int compare(EntityBundle firstEntity, EntityBundle secondEntity) {
            FtsEntityBundle ftsEntity;
            String contentTable;
            if (firstEntity instanceof FtsEntityBundle) {
                FtsEntityBundle ftsEntity2 = (FtsEntityBundle)firstEntity;
                String contentTable2 = ftsEntity2.getFtsOptions().getContentTable();
                if (contentTable2.equals(secondEntity.getTableName())) {
                    return 1;
                }
            } else if (secondEntity instanceof FtsEntityBundle && (contentTable = (ftsEntity = (FtsEntityBundle)secondEntity).getFtsOptions().getContentTable()).equals(firstEntity.getTableName())) {
                return -1;
            }
            return 0;
        }
    }
}

