/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.room.migrations.generators;

import com.android.tools.idea.room.migrations.generators.GeneratorsUtil;
import com.android.tools.idea.room.migrations.generators.MigrationClassGenerator;
import com.android.tools.idea.room.migrations.generators.SqlStatementsGenerator;
import com.android.tools.idea.room.migrations.update.DatabaseUpdate;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaDirectoryService;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiReferenceList;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.search.GlobalSearchScope;
import java.util.List;
import java.util.Locale;
import org.jetbrains.annotations.NotNull;

public class JavaMigrationClassGenerator
implements MigrationClassGenerator<PsiClass> {
    private static final String NOT_NULL_ANNOTATION = "androidx.annotation.NonNull";
    private static final String OVERRIDE_ANNOTATION = "java.lang.Override";
    private static final String SUPER_CONSTRUCTOR_CALL_TEMPLATE = "super(%d, %d);";
    private static final String DATABASE_UPDATE_STATEMENT_TEMPLATE = "database.execSQL(\"%s\");";
    private JavaPsiFacade myJavaPsiFacade;
    private PsiElementFactory myPsiElementFactory;
    private Project myProject;

    public JavaMigrationClassGenerator(@NotNull Project project) {
        this.myProject = project;
        this.myJavaPsiFacade = JavaPsiFacade.getInstance((Project)project);
        this.myPsiElementFactory = this.myJavaPsiFacade.getElementFactory();
    }

    @Override
    @NotNull
    public PsiClass createMigrationClass(@NotNull PsiPackage targetPackage, @NotNull PsiDirectory targetDirectory, @NotNull DatabaseUpdate databaseUpdate) {
        String migrationClassName = MigrationClassGenerator.getMigrationClassName(databaseUpdate.getPreviousVersion(), databaseUpdate.getCurrentVersion());
        PsiClass migrationClass = JavaDirectoryService.getInstance().createClass(targetDirectory, migrationClassName);
        GeneratorsUtil.makePublic(migrationClass);
        this.addSuperClass(migrationClass);
        this.addMigrationConstructor(migrationClass, databaseUpdate);
        this.addMigrationMethod(migrationClass, databaseUpdate);
        JavaCodeStyleManager.getInstance((Project)this.myProject).shortenClassReferences((PsiElement)migrationClass);
        CodeStyleManager.getInstance((Project)this.myProject).reformat((PsiElement)migrationClass);
        migrationClass.navigate(true);
        return migrationClass;
    }

    private void addSuperClass(@NotNull PsiClass migrationClass) {
        GlobalSearchScope scope2 = GlobalSearchScope.allScope((Project)this.myProject);
        PsiReferenceList extendsList = migrationClass.getExtendsList();
        assert (extendsList != null);
        PsiJavaCodeReferenceElement superClassRef = this.myPsiElementFactory.createFQClassNameReferenceElement("androidx.room.migration.Migration", scope2);
        extendsList.add((PsiElement)superClassRef);
    }

    private void addMigrationMethod(@NotNull PsiClass migrationClass, @NotNull DatabaseUpdate databaseUpdate) {
        PsiMethod migrationMethod = this.myPsiElementFactory.createMethod("migrate", (PsiType)PsiType.VOID);
        migrationMethod.getModifierList().addAnnotation(OVERRIDE_ANNOTATION);
        PsiClassType parameterType = this.myPsiElementFactory.createTypeByFQClassName("androidx.sqlite.db.SupportSQLiteDatabase", migrationClass.getResolveScope());
        PsiParameter parameter = this.myPsiElementFactory.createParameter("database", (PsiType)parameterType);
        assert (parameter.getModifierList() != null);
        if (this.myJavaPsiFacade.findClass(NOT_NULL_ANNOTATION, migrationClass.getResolveScope()) != null) {
            parameter.getModifierList().addAnnotation(NOT_NULL_ANNOTATION);
        }
        migrationMethod.getParameterList().add((PsiElement)parameter);
        List<String> sqlUpdateStatements = SqlStatementsGenerator.getMigrationStatements(databaseUpdate);
        for (String sqlStatement : sqlUpdateStatements) {
            this.addMigrationStatement(migrationMethod, sqlStatement);
        }
        migrationClass.add((PsiElement)migrationMethod);
    }

    private void addMigrationStatement(@NotNull PsiMethod migrationMethod, @NotNull String sqlStatement) {
        PsiStatement migrationStatement = this.myPsiElementFactory.createStatementFromText(MigrationClassGenerator.trimSqlStatement(String.format(DATABASE_UPDATE_STATEMENT_TEMPLATE, sqlStatement)), null);
        PsiCodeBlock methodBody = migrationMethod.getBody();
        assert (methodBody != null);
        methodBody.addAfter((PsiElement)migrationStatement, methodBody.getLastBodyElement());
    }

    private void addMigrationConstructor(@NotNull PsiClass migrationClass, @NotNull DatabaseUpdate databaseUpdate) {
        PsiMethod migrationConstructor = this.myPsiElementFactory.createConstructor();
        assert (migrationConstructor.getBody() != null);
        migrationConstructor.getBody().add((PsiElement)this.myPsiElementFactory.createStatementFromText(String.format(Locale.US, SUPER_CONSTRUCTOR_CALL_TEMPLATE, databaseUpdate.getPreviousVersion(), databaseUpdate.getCurrentVersion()), null));
        migrationClass.add((PsiElement)migrationConstructor);
    }
}

