/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.res;

import com.android.ide.common.rendering.api.ResourceNamespace;
import com.android.ide.common.resources.ResourceItem;
import com.android.ide.common.resources.ResourceVisitor;
import com.android.ide.common.resources.SingleNamespaceResourceRepository;
import com.android.resources.ResourceType;
import com.android.tools.idea.projectsystem.ProjectSystemUtil;
import com.android.tools.idea.res.LocalResourceRepository;
import com.android.tools.idea.res.MultiResourceRepository;
import com.android.tools.idea.res.ResourceRepositoryImplUtil;
import com.android.tools.idea.res.ResourceRepositoryManager;
import com.android.tools.idea.res.SampleDataListener;
import com.android.tools.idea.res.SampleDataResourceItem;
import com.android.tools.idea.util.FileExtensions;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ListMultimap;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiManager;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.facet.AndroidFacetScopedService;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SampleDataResourceRepository
extends LocalResourceRepository
implements SingleNamespaceResourceRepository,
Disposable {
    private static final Logger LOG = Logger.getInstance(SampleDataResourceRepository.class);
    @NotNull
    private final AndroidFacet myAndroidFacet;
    @NotNull
    private final ResourceNamespace myNamespace;
    @NotNull
    private final Map<ResourceType, ListMultimap<String, ResourceItem>> myResourceTable = new EnumMap<ResourceType, ListMultimap<String, ResourceItem>>(ResourceType.class);

    @NotNull
    public static SampleDataResourceRepository getInstance(@NotNull AndroidFacet facet2) {
        return SampleDataRepositoryManager.getInstance(facet2).getRepository();
    }

    private SampleDataResourceRepository(@NotNull AndroidFacet androidFacet) {
        super("Sample Data");
        this.myAndroidFacet = androidFacet;
        ResourceRepositoryManager repositoryManager = ResourceRepositoryManager.getInstance(androidFacet);
        this.myNamespace = repositoryManager.getNamespace();
        this.loadItems();
        SampleDataListener.ensureSubscribed(androidFacet.getModule().getProject());
    }

    @Override
    public void addParent(@NotNull MultiResourceRepository parent2) {
        if (!this.myAndroidFacet.isDisposed()) {
            super.addParent(parent2);
        }
    }

    void reload() {
        this.loadItems();
    }

    @Override
    @Nullable
    protected ListMultimap<String, ResourceItem> getMap(@NotNull ResourceNamespace namespace, @NotNull ResourceType type) {
        if (!namespace.equals((Object)this.myNamespace)) {
            return null;
        }
        return this.myResourceTable.get(type);
    }

    @NotNull
    public ResourceNamespace getNamespace() {
        return this.myNamespace;
    }

    @Nullable
    public String getPackageName() {
        return ResourceRepositoryImplUtil.getPackageName(this.myNamespace, this.myAndroidFacet);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public ResourceVisitor.VisitResult accept(@NotNull ResourceVisitor visitor2) {
        if (visitor2.shouldVisitNamespace(this.myNamespace)) {
            Object object = ITEM_MAP_LOCK;
            synchronized (object) {
                if (SampleDataResourceRepository.acceptByResources(this.myResourceTable, (ResourceVisitor)visitor2) == ResourceVisitor.VisitResult.ABORT) {
                    return ResourceVisitor.VisitResult.ABORT;
                }
            }
        }
        return ResourceVisitor.VisitResult.CONTINUE;
    }

    @Override
    @NotNull
    protected Set<VirtualFile> computeResourceDirs() {
        return ImmutableSet.of();
    }

    public void dispose() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadItems() {
        if (this.myAndroidFacet.isDisposed()) {
            return;
        }
        PsiManager psiManager = PsiManager.getInstance((Project)this.myAndroidFacet.getMainModule().getProject());
        List items2 = Stream.concat(Stream.of(this.myAndroidFacet.getMainModule()), ProjectSystemUtil.getModuleSystem(this.myAndroidFacet.getMainModule()).getResourceModuleDependencies().stream()).map(module2 -> FileExtensions.toVirtualFile(ProjectSystemUtil.getModuleSystem(module2).getSampleDataDirectory())).filter(Objects::nonNull).flatMap(sampleDataDir -> Arrays.stream(sampleDataDir.getChildren())).map(sampleDataDir -> sampleDataDir.isDirectory() ? psiManager.findDirectory(sampleDataDir) : psiManager.findFile(sampleDataDir)).filter(Objects::nonNull).flatMap(psiElement -> this.loadItemsFromFile((PsiFileSystemItem)psiElement).stream()).collect(Collectors.toUnmodifiableList());
        Object object = ITEM_MAP_LOCK;
        synchronized (object) {
            this.myResourceTable.clear();
            if (!items2.isEmpty()) {
                HashSet<String> alreadyParsedItems = new HashSet<String>();
                ImmutableListMultimap.Builder mapBuilder = ImmutableListMultimap.builder();
                for (ResourceItem item2 : items2) {
                    assert (item2.getNamespace().equals((Object)this.myNamespace));
                    if (!alreadyParsedItems.add(item2.getName())) continue;
                    mapBuilder.put((Object)item2.getName(), (Object)item2);
                }
                this.myResourceTable.put(ResourceType.SAMPLE_DATA, (ListMultimap<String, ResourceItem>)mapBuilder.build());
            }
            this.setModificationCount(ourModificationCounter.incrementAndGet());
            this.invalidateParentCaches(this, ResourceType.SAMPLE_DATA);
        }
    }

    @NotNull
    private List<SampleDataResourceItem> loadItemsFromFile(@NotNull PsiFileSystemItem sampleDataFile) {
        try {
            return SampleDataResourceItem.getFromPsiFileSystemItem(this, sampleDataFile);
        }
        catch (IOException e) {
            LOG.warn("Error loading sample data file " + sampleDataFile.getName(), (Throwable)e);
            return Collections.emptyList();
        }
    }

    static class SampleDataRepositoryManager
    extends AndroidFacetScopedService {
        private static final Key<SampleDataRepositoryManager> KEY = Key.create((String)SampleDataRepositoryManager.class.getName());
        private final Object repositoryLock = new Object();
        private SampleDataResourceRepository repository;

        @NotNull
        public static SampleDataRepositoryManager getInstance(@NotNull AndroidFacet facet2) {
            SampleDataRepositoryManager manager = (SampleDataRepositoryManager)facet2.getUserData(KEY);
            if (manager == null) {
                manager = new SampleDataRepositoryManager(facet2);
                facet2.putUserData(KEY, (Object)manager);
            }
            return manager;
        }

        private SampleDataRepositoryManager(@NotNull AndroidFacet facet2) {
            super(facet2);
        }

        @Override
        protected void onServiceDisposal(@NotNull AndroidFacet facet2) {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @NotNull
        public SampleDataResourceRepository getRepository() {
            if (this.isDisposed()) {
                throw new IllegalStateException(this.getClass().getSimpleName() + " is disposed");
            }
            Object object = this.repositoryLock;
            synchronized (object) {
                if (this.repository == null) {
                    this.repository = new SampleDataResourceRepository(this.getFacet());
                    Disposer.register((Disposable)this, (Disposable)this.repository);
                }
                return this.repository;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean hasRepository() {
            Object object = this.repositoryLock;
            synchronized (object) {
                return this.repository != null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void reset() {
            SampleDataResourceRepository localRepository;
            Object object = this.repositoryLock;
            synchronized (object) {
                localRepository = this.repository;
                this.repository = null;
            }
            if (localRepository != null) {
                Disposer.dispose((Disposable)localRepository);
            }
        }
    }
}

