/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.res;

import com.android.ide.common.rendering.api.ResourceNamespace;
import com.android.ide.common.rendering.api.ResourceReference;
import com.android.resources.ResourceType;
import com.android.tools.idea.layoutlib.LayoutLibraryLoader;
import com.android.tools.idea.model.Namespacing;
import com.android.tools.idea.res.IdeResourcesUtil;
import com.android.tools.idea.res.ResourceIdManager;
import com.android.tools.idea.res.ResourceIdManagerImpl;
import com.android.tools.idea.res.ResourceRepositoryManager;
import com.intellij.openapi.module.Module;
import gnu.trove.TIntObjectHashMap;
import gnu.trove.TObjectIntHashMap;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.Comparator;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin._Assertions;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.facet.AndroidFacetConfiguration;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\u0005\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\b\u0016\u0018\u00002\u00020\u0001:\u000223B\u000f\b\u0004\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0012\u0010\u001f\u001a\u0004\u0018\u00010\t2\u0006\u0010 \u001a\u00020!H\u0016J\u0017\u0010\"\u001a\u0004\u0018\u00010!2\u0006\u0010#\u001a\u00020\tH\u0016\u00a2\u0006\u0002\u0010$J\b\u0010%\u001a\u00020\u0015H\u0016J\u0010\u0010&\u001a\u00020!2\u0006\u0010#\u001a\u00020\tH\u0016J\u0014\u0010'\u001a\u00020(2\n\u0010)\u001a\u0006\u0012\u0002\b\u00030*H\u0016J\b\u0010+\u001a\u00020\u0006H\u0002J&\u0010,\u001a\u00020(2\n\u0010)\u001a\u0006\u0012\u0002\b\u00030*2\u0006\u0010-\u001a\u00020\u00062\b\b\u0002\u0010.\u001a\u00020\u0010H\u0002J\b\u0010/\u001a\u00020(H\u0016J\b\u00100\u001a\u00020(H\u0016J\b\u00101\u001a\u00020(H\u0002R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\t0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\f\u001a\u00070\r\u00a2\u0006\u0002\b\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\u00020\u00108VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u000e\u0010\u0013\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u000e\u00a2\u0006\u0002\n\u0000R*\u0010\u001a\u001a\u001e\u0012\u0004\u0012\u00020\u001c\u0012\u0004\u0012\u00020\u001d0\u001bj\u000e\u0012\u0004\u0012\u00020\u001c\u0012\u0004\u0012\u00020\u001d`\u001eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00064"}, d2={"Lcom/android/tools/idea/res/ResourceIdManagerImpl;", "Lcom/android/tools/idea/res/ResourceIdManager;", "module", "Lcom/intellij/openapi/module/Module;", "(Lcom/intellij/openapi/module/Module;)V", "compiledIds", "Lcom/android/tools/idea/res/ResourceIdManagerImpl$SingleNamespaceIdMapping;", "dynamicFromIdMap", "Lgnu/trove/TIntObjectHashMap;", "Lcom/android/ide/common/rendering/api/ResourceReference;", "dynamicToIdMap", "Lgnu/trove/TObjectIntHashMap;", "facet", "Lorg/jetbrains/android/facet/AndroidFacet;", "Lorg/jetbrains/annotations/Nullable;", "finalIdsUsed", "", "getFinalIdsUsed", "()Z", "frameworkIds", "generationCounter", "", "getModule", "()Lcom/intellij/openapi/module/Module;", "nextPackageId", "", "perNamespaceProviders", "Ljava/util/HashMap;", "Lcom/android/ide/common/rendering/api/ResourceNamespace;", "Lcom/android/tools/idea/res/ResourceIdManagerImpl$IdProvider;", "Lkotlin/collections/HashMap;", "findById", "id", "", "getCompiledId", "resource", "(Lcom/android/ide/common/rendering/api/ResourceReference;)Ljava/lang/Integer;", "getGeneration", "getOrGenerateId", "loadCompiledIds", "", "klass", "Ljava/lang/Class;", "loadFrameworkIds", "loadIdsFromResourceClass", "into", "lookForAttrsInStyleables", "resetCompiledIds", "resetDynamicIds", "resetProviders", "IdProvider", "SingleNamespaceIdMapping", "intellij.android.core"})
public class ResourceIdManagerImpl
implements ResourceIdManager {
    @NotNull
    private final Module module;
    @NotNull
    private final AndroidFacet facet;
    private long generationCounter;
    private byte nextPackageId;
    @NotNull
    private final HashMap<ResourceNamespace, IdProvider> perNamespaceProviders;
    @NotNull
    private final TObjectIntHashMap<ResourceReference> dynamicToIdMap;
    @NotNull
    private final TIntObjectHashMap<ResourceReference> dynamicFromIdMap;
    @Nullable
    private SingleNamespaceIdMapping compiledIds;
    @NotNull
    private SingleNamespaceIdMapping frameworkIds;

    protected ResourceIdManagerImpl(@NotNull Module module2) {
        Intrinsics.checkNotNullParameter((Object)module2, (String)"module");
        this.module = module2;
        AndroidFacet androidFacet = AndroidFacet.getInstance((Module)this.module);
        if (androidFacet == null) {
            throw new IllegalStateException((Reflection.getOrCreateKotlinClass(ResourceIdManager.class).getQualifiedName() + " used on a non-Android module.").toString());
        }
        this.facet = androidFacet;
        this.generationCounter = 1L;
        this.nextPackageId = (byte)2;
        this.perNamespaceProviders = new HashMap();
        this.resetProviders();
        this.dynamicToIdMap = new TObjectIntHashMap();
        this.dynamicFromIdMap = new TIntObjectHashMap();
        this.frameworkIds = this.loadFrameworkIds();
    }

    @NotNull
    public final Module getModule() {
        return this.module;
    }

    private final synchronized void resetProviders() {
        this.nextPackageId = (byte)2;
        this.perNamespaceProviders.clear();
        Map map2 = this.perNamespaceProviders;
        ResourceNamespace resourceNamespace = ResourceNamespace.RES_AUTO;
        Intrinsics.checkNotNullExpressionValue((Object)resourceNamespace, (String)"RES_AUTO");
        ResourceNamespace resourceNamespace2 = resourceNamespace;
        IdProvider idProvider = new IdProvider(127);
        map2.put(resourceNamespace2, idProvider);
        map2 = this.perNamespaceProviders;
        ResourceNamespace resourceNamespace3 = ResourceNamespace.ANDROID;
        Intrinsics.checkNotNullExpressionValue((Object)resourceNamespace3, (String)"ANDROID");
        resourceNamespace2 = resourceNamespace3;
        idProvider = new IdProvider(1);
        map2.put(resourceNamespace2, idProvider);
    }

    @Override
    public boolean getFinalIdsUsed() {
        return ((AndroidFacetConfiguration)this.facet.getConfiguration()).isAppOrFeature() && ResourceRepositoryManager.getInstance(this.facet).getNamespacing() == Namespacing.DISABLED;
    }

    @Override
    @Nullable
    public synchronized ResourceReference findById(int id2) {
        SingleNamespaceIdMapping singleNamespaceIdMapping = this.compiledIds;
        if (singleNamespaceIdMapping == null || (singleNamespaceIdMapping = singleNamespaceIdMapping.findById(id2)) == null) {
            singleNamespaceIdMapping = (ResourceReference)this.dynamicFromIdMap.get(id2);
        }
        return singleNamespaceIdMapping;
    }

    @Override
    @Nullable
    public synchronized Integer getCompiledId(@NotNull ResourceReference resource) {
        Integer n;
        SingleNamespaceIdMapping knownIds;
        Intrinsics.checkNotNullParameter((Object)resource, (String)"resource");
        ResourceNamespace resourceNamespace = resource.getNamespace();
        SingleNamespaceIdMapping singleNamespaceIdMapping = knownIds = Intrinsics.areEqual((Object)resourceNamespace, (Object)ResourceNamespace.ANDROID) ? this.frameworkIds : (Intrinsics.areEqual((Object)resourceNamespace, (Object)ResourceNamespace.RES_AUTO) ? this.compiledIds : null);
        if (singleNamespaceIdMapping != null) {
            int id2 = singleNamespaceIdMapping.getId(resource);
            boolean bl = false;
            n = id2 == 0 ? null : Integer.valueOf(id2);
        } else {
            n = null;
        }
        return n;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public synchronized int getOrGenerateId(@NotNull ResourceReference resource) {
        Object object;
        void $this$getOrPut$iv;
        Intrinsics.checkNotNullParameter((Object)resource, (String)"resource");
        Integer compiledId = this.getCompiledId(resource);
        if (compiledId != null) {
            return compiledId;
        }
        int dynamicId = this.dynamicToIdMap.get((Object)resource);
        if (dynamicId != 0) {
            return dynamicId;
        }
        Map map2 = this.perNamespaceProviders;
        ResourceNamespace resourceNamespace = resource.getNamespace();
        Intrinsics.checkNotNullExpressionValue((Object)resourceNamespace, (String)"resource.namespace");
        ResourceNamespace key$iv = resourceNamespace;
        boolean $i$f$getOrPut = false;
        Object value$iv = $this$getOrPut$iv.get(key$iv);
        if (value$iv == null) {
            boolean bl = false;
            byte by = this.nextPackageId;
            this.nextPackageId = (byte)(by + 1);
            IdProvider answer$iv = new IdProvider(by);
            $this$getOrPut$iv.put(key$iv, answer$iv);
            object = answer$iv;
        } else {
            object = value$iv;
        }
        IdProvider provider2 = (IdProvider)object;
        ResourceType resourceType = resource.getResourceType();
        Intrinsics.checkNotNullExpressionValue((Object)resourceType, (String)"resource.resourceType");
        int newId = provider2.getNext(resourceType);
        this.dynamicToIdMap.put((Object)resource, newId);
        this.dynamicFromIdMap.put(newId, (Object)resource);
        return newId;
    }

    @Override
    public synchronized void resetDynamicIds() {
        long l = this.generationCounter;
        this.generationCounter = l + 1L;
        this.resetProviders();
        this.dynamicToIdMap.clear();
        this.dynamicFromIdMap.clear();
    }

    @Override
    public synchronized long getGeneration() {
        return this.generationCounter;
    }

    @Override
    public synchronized void loadCompiledIds(@NotNull Class<?> klass) {
        Intrinsics.checkNotNullParameter(klass, (String)"klass");
        if (this.compiledIds == null) {
            ResourceNamespace resourceNamespace = ResourceNamespace.RES_AUTO;
            Intrinsics.checkNotNullExpressionValue((Object)resourceNamespace, (String)"RES_AUTO");
            this.compiledIds = new SingleNamespaceIdMapping(resourceNamespace);
        }
        SingleNamespaceIdMapping singleNamespaceIdMapping = this.compiledIds;
        Intrinsics.checkNotNull((Object)singleNamespaceIdMapping);
        ResourceIdManagerImpl.loadIdsFromResourceClass$default(this, klass, singleNamespaceIdMapping, false, 4, null);
    }

    private final SingleNamespaceIdMapping loadFrameworkIds() {
        SingleNamespaceIdMapping singleNamespaceIdMapping;
        ResourceNamespace resourceNamespace = ResourceNamespace.ANDROID;
        Intrinsics.checkNotNullExpressionValue((Object)resourceNamespace, (String)"ANDROID");
        SingleNamespaceIdMapping $this$loadFrameworkIds_u24lambda_u2d2 = singleNamespaceIdMapping = new SingleNamespaceIdMapping(resourceNamespace);
        boolean bl = false;
        ((Map)$this$loadFrameworkIds_u24lambda_u2d2.getToIdMap()).put(ResourceType.ANIM, new TObjectIntHashMap(75));
        ((Map)$this$loadFrameworkIds_u24lambda_u2d2.getToIdMap()).put(ResourceType.ATTR, new TObjectIntHashMap(1752));
        ((Map)$this$loadFrameworkIds_u24lambda_u2d2.getToIdMap()).put(ResourceType.ARRAY, new TObjectIntHashMap(181));
        ((Map)$this$loadFrameworkIds_u24lambda_u2d2.getToIdMap()).put(ResourceType.BOOL, new TObjectIntHashMap(382));
        ((Map)$this$loadFrameworkIds_u24lambda_u2d2.getToIdMap()).put(ResourceType.COLOR, new TObjectIntHashMap(151));
        ((Map)$this$loadFrameworkIds_u24lambda_u2d2.getToIdMap()).put(ResourceType.DIMEN, new TObjectIntHashMap(310));
        ((Map)$this$loadFrameworkIds_u24lambda_u2d2.getToIdMap()).put(ResourceType.DRAWABLE, new TObjectIntHashMap(519));
        ((Map)$this$loadFrameworkIds_u24lambda_u2d2.getToIdMap()).put(ResourceType.ID, new TObjectIntHashMap(526));
        ((Map)$this$loadFrameworkIds_u24lambda_u2d2.getToIdMap()).put(ResourceType.INTEGER, new TObjectIntHashMap(226));
        ((Map)$this$loadFrameworkIds_u24lambda_u2d2.getToIdMap()).put(ResourceType.LAYOUT, new TObjectIntHashMap(221));
        ((Map)$this$loadFrameworkIds_u24lambda_u2d2.getToIdMap()).put(ResourceType.PLURALS, new TObjectIntHashMap(33));
        ((Map)$this$loadFrameworkIds_u24lambda_u2d2.getToIdMap()).put(ResourceType.STRING, new TObjectIntHashMap(1585));
        ((Map)$this$loadFrameworkIds_u24lambda_u2d2.getToIdMap()).put(ResourceType.STYLE, new TObjectIntHashMap(794));
        SingleNamespaceIdMapping frameworkIds = singleNamespaceIdMapping;
        Class rClass2 = (Class)LayoutLibraryLoader.LayoutLibraryProvider.EP_NAME.computeSafeIfAny((Function)loadFrameworkIds.rClass.1.INSTANCE);
        if (rClass2 != null) {
            this.loadIdsFromResourceClass(rClass2, frameworkIds, true);
        }
        return frameworkIds;
    }

    private final void loadIdsFromResourceClass(Class<?> klass, SingleNamespaceIdMapping into, boolean lookForAttrsInStyleables) {
        boolean bl = Intrinsics.areEqual((Object)klass.getSimpleName(), (Object)"R");
        if (_Assertions.ENABLED && !bl) {
            boolean bl2 = false;
            String string = "Numeric ids can only be loaded from top-level R classes.";
            throw new AssertionError((Object)string);
        }
        Comparator fieldOrdering2 = loadIdsFromResourceClass.fieldOrdering.1.INSTANCE;
        Class<?>[] classArray = klass.getDeclaredClasses();
        Intrinsics.checkNotNullExpressionValue(classArray, (String)"klass.declaredClasses");
        for (Class<?> innerClass : classArray) {
            Object object;
            TIntObjectHashMap<Pair<ResourceType, String>> fromIdMap;
            TObjectIntHashMap toIdMap;
            Map $this$getOrPut$iv;
            ResourceType type;
            if (ResourceType.fromClassName((String)innerClass.getSimpleName()) == null) continue;
            if (type != ResourceType.STYLEABLE) {
                Object object2;
                $this$getOrPut$iv = into.getToIdMap();
                boolean $i$f$getOrPut = false;
                Object value$iv = $this$getOrPut$iv.get(type);
                if (value$iv == null) {
                    boolean bl3 = false;
                    TObjectIntHashMap answer$iv = new TObjectIntHashMap();
                    $this$getOrPut$iv.put(type, answer$iv);
                    object2 = answer$iv;
                } else {
                    object2 = value$iv;
                }
                toIdMap = (TObjectIntHashMap)object2;
                fromIdMap = into.getFromIdMap();
                Intrinsics.checkNotNullExpressionValue((Object)innerClass.getDeclaredFields(), (String)"innerClass.declaredFields");
                for (Field field2 : $i$f$getOrPut) {
                    if (!Intrinsics.areEqual(field2.getType(), Integer.TYPE) || !Modifier.isStatic(field2.getModifiers())) continue;
                    int id2 = field2.getInt(null);
                    String name = field2.getName();
                    toIdMap.put((Object)name, id2);
                    fromIdMap.put(id2, (Object)new Pair((Object)type, (Object)name));
                }
                continue;
            }
            if (type != ResourceType.STYLEABLE || !lookForAttrsInStyleables) continue;
            fromIdMap = (TIntObjectHashMap<Pair<ResourceType, String>>)into.getToIdMap();
            ResourceType key$iv = ResourceType.ATTR;
            boolean $i$f$getOrPut = false;
            Object value$iv = $this$getOrPut$iv.get(key$iv);
            if (value$iv == null) {
                boolean bl4 = false;
                TObjectIntHashMap answer$iv = new TObjectIntHashMap();
                $this$getOrPut$iv.put(key$iv, answer$iv);
                object = answer$iv;
            } else {
                object = value$iv;
            }
            toIdMap = (TObjectIntHashMap)object;
            fromIdMap = into.getFromIdMap();
            int[] currentArray = new int[]{};
            String currentStyleable = "";
            Field[] fieldArray = innerClass.getFields();
            Intrinsics.checkNotNullExpressionValue((Object)fieldArray, (String)"innerClass.fields");
            for (Field field3 : (Field[])ArraysKt.sortedArrayWith((Object[])fieldArray, (Comparator)fieldOrdering2)) {
                String attrName;
                String string;
                if (field3.getType().isArray()) {
                    Object object3 = field3.get(null);
                    Intrinsics.checkNotNull((Object)object3, (String)"null cannot be cast to non-null type kotlin.IntArray");
                    currentArray = (int[])object3;
                    Intrinsics.checkNotNullExpressionValue((Object)field3.getName(), (String)"field.name");
                    continue;
                }
                Intrinsics.checkNotNullExpressionValue((Object)field3.getName(), (String)"field.name");
                int n = currentStyleable.length() + 1;
                Intrinsics.checkNotNullExpressionValue((Object)string.substring(n), (String)"this as java.lang.String).substring(startIndex)");
                int attrId = currentArray[field3.getInt(null)];
                toIdMap.put((Object)attrName, attrId);
                fromIdMap.put(attrId, (Object)new Pair((Object)ResourceType.ATTR, (Object)attrName));
            }
        }
    }

    static /* synthetic */ void loadIdsFromResourceClass$default(ResourceIdManagerImpl resourceIdManagerImpl, Class clazz, SingleNamespaceIdMapping singleNamespaceIdMapping, boolean bl, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: loadIdsFromResourceClass");
        }
        if ((n & 4) != 0) {
            bl = false;
        }
        resourceIdManagerImpl.loadIdsFromResourceClass(clazz, singleNamespaceIdMapping, bl);
    }

    @Override
    public void resetCompiledIds() {
        this.compiledIds = null;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0005\n\u0002\b\u0002\n\u0002\u0010\u0017\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nJ\b\u0010\u000b\u001a\u00020\fH\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/android/tools/idea/res/ResourceIdManagerImpl$IdProvider;", "", "packageByte", "", "(B)V", "counters", "", "getNext", "", "type", "Lcom/android/resources/ResourceType;", "toString", "", "intellij.android.core"})
    private static final class IdProvider {
        private final byte packageByte;
        @NotNull
        private final short[] counters;

        public IdProvider(byte packageByte) {
            this.packageByte = packageByte;
            int n = 0;
            int n2 = ResourceType.values().length;
            short[] sArray = new short[n2];
            IdProvider idProvider = this;
            while (n < n2) {
                int n3 = n++;
                sArray[n3] = -1;
            }
            idProvider.counters = sArray;
        }

        public final int getNext(@NotNull ResourceType type) {
            Intrinsics.checkNotNullParameter((Object)type, (String)"type");
            short[] sArray = this.counters;
            int n = type.ordinal();
            sArray[n] = (short)(sArray[n] + -1);
            return IdeResourcesUtil.buildResourceId(this.packageByte, (byte)(type.ordinal() + 1), sArray[n]);
        }

        @NotNull
        public String toString() {
            String string = Arrays.toString(this.counters);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(counters)");
            return string;
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0017\u001a\u0004\u0018\u00010\u00182\u0006\u0010\u0019\u001a\u00020\u001aJ\u000e\u0010\u001b\u001a\u00020\u001a2\u0006\u0010\u001c\u001a\u00020\u0018R,\u0010\u0005\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u00070\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR,\u0010\u0010\u001a\u0014\u0012\u0004\u0012\u00020\b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\u00120\u0011X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016\u00a8\u0006\u001d"}, d2={"Lcom/android/tools/idea/res/ResourceIdManagerImpl$SingleNamespaceIdMapping;", "", "namespace", "Lcom/android/ide/common/rendering/api/ResourceNamespace;", "(Lcom/android/ide/common/rendering/api/ResourceNamespace;)V", "fromIdMap", "Lgnu/trove/TIntObjectHashMap;", "Lkotlin/Pair;", "Lcom/android/resources/ResourceType;", "", "getFromIdMap", "()Lgnu/trove/TIntObjectHashMap;", "setFromIdMap", "(Lgnu/trove/TIntObjectHashMap;)V", "getNamespace", "()Lcom/android/ide/common/rendering/api/ResourceNamespace;", "toIdMap", "Ljava/util/EnumMap;", "Lgnu/trove/TObjectIntHashMap;", "getToIdMap", "()Ljava/util/EnumMap;", "setToIdMap", "(Ljava/util/EnumMap;)V", "findById", "Lcom/android/ide/common/rendering/api/ResourceReference;", "id", "", "getId", "resourceReference", "intellij.android.core"})
    private static final class SingleNamespaceIdMapping {
        @NotNull
        private final ResourceNamespace namespace;
        @NotNull
        private EnumMap<ResourceType, TObjectIntHashMap<String>> toIdMap;
        @NotNull
        private TIntObjectHashMap<Pair<ResourceType, String>> fromIdMap;

        public SingleNamespaceIdMapping(@NotNull ResourceNamespace namespace) {
            Intrinsics.checkNotNullParameter((Object)namespace, (String)"namespace");
            this.namespace = namespace;
            this.toIdMap = new EnumMap(ResourceType.class);
            this.fromIdMap = new TIntObjectHashMap();
        }

        @NotNull
        public final ResourceNamespace getNamespace() {
            return this.namespace;
        }

        @NotNull
        public final EnumMap<ResourceType, TObjectIntHashMap<String>> getToIdMap() {
            return this.toIdMap;
        }

        public final void setToIdMap(@NotNull EnumMap<ResourceType, TObjectIntHashMap<String>> enumMap) {
            Intrinsics.checkNotNullParameter(enumMap, (String)"<set-?>");
            this.toIdMap = enumMap;
        }

        @NotNull
        public final TIntObjectHashMap<Pair<ResourceType, String>> getFromIdMap() {
            return this.fromIdMap;
        }

        public final void setFromIdMap(@NotNull TIntObjectHashMap<Pair<ResourceType, String>> tIntObjectHashMap) {
            Intrinsics.checkNotNullParameter(tIntObjectHashMap, (String)"<set-?>");
            this.fromIdMap = tIntObjectHashMap;
        }

        public final int getId(@NotNull ResourceReference resourceReference) {
            Intrinsics.checkNotNullParameter((Object)resourceReference, (String)"resourceReference");
            TObjectIntHashMap<String> tObjectIntHashMap = this.toIdMap.get(resourceReference.getResourceType());
            return tObjectIntHashMap != null ? tObjectIntHashMap.get((Object)resourceReference.getName()) : 0;
        }

        @Nullable
        public final ResourceReference findById(int id2) {
            ResourceReference resourceReference;
            Pair pair = (Pair)this.fromIdMap.get(id2);
            if (pair != null) {
                Pair pair2 = pair;
                boolean bl = false;
                ResourceType type = (ResourceType)pair2.component1();
                String name = (String)pair2.component2();
                resourceReference = new ResourceReference(this.namespace, type, name);
            } else {
                resourceReference = null;
            }
            return resourceReference;
        }
    }
}

