/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.res;

import com.android.ide.common.rendering.api.ResourceNamespace;
import com.android.tools.idea.concurrency.AndroidIoManager;
import com.android.tools.idea.model.Namespacing;
import com.android.tools.idea.res.IdeResourcesUtil;
import com.android.tools.idea.res.ResourceFolderRegistry;
import com.android.tools.idea.res.ResourceFolderRepository;
import com.android.tools.idea.res.ResourceFolderRepositoryCachingData;
import com.android.tools.idea.res.ResourceFolderRepositoryFileCacheService;
import com.android.tools.idea.res.ResourceRepositoryManager;
import com.android.tools.idea.res.ResourceUpdateTracer;
import com.android.utils.TraceUtils;
import com.android.utils.concurrency.CacheUtils;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Sets;
import com.intellij.ProjectTopics;
import com.intellij.facet.ProjectFacetManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.DumbModeTask;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootEvent;
import com.intellij.openapi.roots.ModuleRootListener;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiTreeChangeListener;
import com.intellij.util.Consumer;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.Topic;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.facet.ResourceFolderManager;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u0000 &2\u00020\u0001:\u0002&'B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0014\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007H\u0002J \u0010\u0010\u001a\u00020\t2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\b2\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u001e\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\b2\u000e\u0010\u0019\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u001b0\u001aJ&\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\b2\u0016\u0010\u001c\u001a\u0012\u0012\u0006\u0012\u0004\u0018\u00010\t\u0012\u0006\u0012\u0004\u0018\u00010\b0\u001dJ\b\u0010\u001e\u001a\u00020\u0017H\u0016J\u0019\u0010\u001f\u001a\u00020\t2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\bH\u0086\u0002J!\u0010\u001f\u001a\u00020\t2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\b2\u0006\u0010\u0014\u001a\u00020\u0015H\u0087\u0002J\u0018\u0010 \u001a\u0004\u0018\u00010\t2\u0006\u0010\u0013\u001a\u00020\b2\u0006\u0010!\u001a\u00020\"J\b\u0010#\u001a\u00020\u0017H\u0002J\u001c\u0010#\u001a\u00020\u00172\u0012\u0010$\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007H\u0002J\u0006\u0010%\u001a\u00020\u0017Rb\u0010\u0005\u001aV\u0012$\u0012\"\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t \n*\u0010\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t\u0018\u00010\u00070\u0007 \n**\u0012$\u0012\"\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t \n*\u0010\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t\u0018\u00010\u00070\u0007\u0018\u00010\u00060\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006("}, d2={"Lcom/android/tools/idea/res/ResourceFolderRegistry;", "Lcom/intellij/openapi/Disposable;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "myCaches", "Lcom/google/common/collect/ImmutableList;", "Lcom/google/common/cache/Cache;", "Lcom/intellij/openapi/vfs/VirtualFile;", "Lcom/android/tools/idea/res/ResourceFolderRepository;", "kotlin.jvm.PlatformType", "myNamespacedCache", "myNonNamespacedCache", "getProject", "()Lcom/intellij/openapi/project/Project;", "buildCache", "createRepository", "facet", "Lorg/jetbrains/android/facet/AndroidFacet;", "dir", "namespace", "Lcom/android/ide/common/rendering/api/ResourceNamespace;", "dispatchToRepositories", "", "file", "invokeCallback", "Lcom/intellij/util/Consumer;", "Lcom/intellij/psi/PsiTreeChangeListener;", "handler", "Ljava/util/function/BiConsumer;", "dispose", "get", "getCached", "namespacing", "Lcom/android/tools/idea/model/Namespacing;", "removeStaleEntries", "cache", "reset", "Companion", "PopulateCachesTask", "intellij.android.core"})
public final class ResourceFolderRegistry
implements Disposable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final Cache<VirtualFile, ResourceFolderRepository> myNamespacedCache;
    @NotNull
    private final Cache<VirtualFile, ResourceFolderRepository> myNonNamespacedCache;
    private final ImmutableList<Cache<VirtualFile, ResourceFolderRepository>> myCaches;

    public ResourceFolderRegistry(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        this.myNamespacedCache = this.buildCache();
        this.myNonNamespacedCache = this.buildCache();
        this.myCaches = ImmutableList.of(this.myNamespacedCache, this.myNonNamespacedCache);
        MessageBusConnection messageBusConnection = this.project.getMessageBus().connect((Disposable)this);
        Topic topic = ProjectTopics.PROJECT_ROOTS;
        Intrinsics.checkNotNullExpressionValue((Object)topic, (String)"PROJECT_ROOTS");
        messageBusConnection.subscribe(topic, (Object)new ModuleRootListener(){

            public void rootsChanged(@NotNull ModuleRootEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                this.removeStaleEntries();
            }
        });
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @NotNull
    public final ResourceFolderRepository get(@NotNull AndroidFacet facet2, @NotNull VirtualFile dir) {
        Intrinsics.checkNotNullParameter((Object)facet2, (String)"facet");
        Intrinsics.checkNotNullParameter((Object)dir, (String)"dir");
        Object object = ReadAction.nonBlocking((Callable)new Callable(this, facet2, dir){
            final /* synthetic */ ResourceFolderRegistry this$0;
            final /* synthetic */ AndroidFacet $facet;
            final /* synthetic */ VirtualFile $dir;
            {
                this.this$0 = $receiver;
                this.$facet = $facet;
                this.$dir = $dir;
            }

            public final ResourceFolderRepository call() {
                ResourceNamespace resourceNamespace = ResourceRepositoryManager.getInstance(this.$facet).getNamespace();
                Intrinsics.checkNotNullExpressionValue((Object)resourceNamespace, (String)"getInstance(facet).namespace");
                return this.this$0.get(this.$facet, this.$dir, resourceNamespace);
            }
        }).executeSynchronously();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"operator fun get(facet: \u2026xecuteSynchronously()\n  }");
        return (ResourceFolderRepository)((Object)object);
    }

    @VisibleForTesting
    @NotNull
    public final ResourceFolderRepository get(@NotNull AndroidFacet facet2, @NotNull VirtualFile dir, @NotNull ResourceNamespace namespace) {
        Intrinsics.checkNotNullParameter((Object)facet2, (String)"facet");
        Intrinsics.checkNotNullParameter((Object)dir, (String)"dir");
        Intrinsics.checkNotNullParameter((Object)namespace, (String)"namespace");
        Cache<VirtualFile, ResourceFolderRepository> cache2 = namespace == ResourceNamespace.RES_AUTO ? this.myNonNamespacedCache : this.myNamespacedCache;
        ResourceFolderRepository repository2 = (ResourceFolderRepository)((Object)CacheUtils.getAndUnwrap(cache2, (Object)dir, (Function0)((Function0)new Function0<ResourceFolderRepository>(this, facet2, dir, namespace){
            final /* synthetic */ ResourceFolderRegistry this$0;
            final /* synthetic */ AndroidFacet $facet;
            final /* synthetic */ VirtualFile $dir;
            final /* synthetic */ ResourceNamespace $namespace;
            {
                this.this$0 = $receiver;
                this.$facet = $facet;
                this.$dir = $dir;
                this.$namespace = $namespace;
                super(0);
            }

            @NotNull
            public final ResourceFolderRepository invoke() {
                return ResourceFolderRegistry.access$createRepository(this.this$0, this.$facet, this.$dir, this.$namespace);
            }
        })));
        boolean bl = Intrinsics.areEqual((Object)repository2.getNamespace(), (Object)namespace);
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
        return repository2;
    }

    @Nullable
    public final ResourceFolderRepository getCached(@NotNull VirtualFile dir, @NotNull Namespacing namespacing) {
        Intrinsics.checkNotNullParameter((Object)dir, (String)"dir");
        Intrinsics.checkNotNullParameter((Object)((Object)namespacing), (String)"namespacing");
        Cache<VirtualFile, ResourceFolderRepository> cache2 = namespacing == Namespacing.REQUIRED ? this.myNamespacedCache : this.myNonNamespacedCache;
        return (ResourceFolderRepository)((Object)cache2.getIfPresent((Object)dir));
    }

    public final void reset() {
        ResourceUpdateTracer.logDirect(new Supplier(this){
            final /* synthetic */ ResourceFolderRegistry this$0;
            {
                this.this$0 = $receiver;
            }

            public final Object get() {
                return TraceUtils.getSimpleId((Object)this.this$0) + ".reset()";
            }
        });
        this.myNamespacedCache.invalidateAll();
        this.myNonNamespacedCache.invalidateAll();
    }

    private final void removeStaleEntries() {
        ResourceUpdateTracer.logDirect(new Supplier(this){
            final /* synthetic */ ResourceFolderRegistry this$0;
            {
                this.this$0 = $receiver;
            }

            public final Object get() {
                return TraceUtils.getSimpleId((Object)this.this$0) + ".removeStaleEntries()";
            }
        });
        this.removeStaleEntries(this.myNamespacedCache);
        this.removeStaleEntries(this.myNonNamespacedCache);
    }

    private final void removeStaleEntries(Cache<VirtualFile, ResourceFolderRepository> cache2) {
        ConcurrentMap cacheAsMap = cache2.asMap();
        if (cacheAsMap.isEmpty()) {
            ResourceUpdateTracer.logDirect(new Supplier(this){
                final /* synthetic */ ResourceFolderRegistry this$0;
                {
                    this.this$0 = $receiver;
                }

                public final Object get() {
                    return TraceUtils.getSimpleId((Object)this.this$0) + ".removeStaleEntries: cache is empty";
                }
            });
            return;
        }
        HashSet hashSet = Sets.newHashSetWithExpectedSize((int)cacheAsMap.size());
        Intrinsics.checkNotNullExpressionValue((Object)hashSet, (String)"newHashSetWithExpectedSize(cacheAsMap.size)");
        Set facets = hashSet;
        HashSet hashSet2 = Sets.newHashSetWithExpectedSize((int)cacheAsMap.size());
        Intrinsics.checkNotNullExpressionValue((Object)hashSet2, (String)"newHashSetWithExpectedSize(cacheAsMap.size)");
        Set newResourceFolders = hashSet2;
        for (ResourceFolderRepository repository2 : cacheAsMap.values()) {
            AndroidFacet facet2;
            Intrinsics.checkNotNullExpressionValue((Object)repository2.getFacet(), (String)"repository.facet");
            if (facet2.isDisposed() || !facets.add(facet2)) continue;
            ResourceFolderManager folderManager = ResourceFolderManager.Companion.getInstance(facet2);
            newResourceFolders.addAll((Collection)folderManager.getFolders());
            newResourceFolders.addAll((Collection)folderManager.getTestFolders());
        }
        ResourceUpdateTracer.logDirect(new Supplier(this, newResourceFolders){
            final /* synthetic */ ResourceFolderRegistry this$0;
            final /* synthetic */ Set<VirtualFile> $newResourceFolders;
            {
                this.this$0 = $receiver;
                this.$newResourceFolders = $newResourceFolders;
            }

            public final Object get() {
                return TraceUtils.getSimpleId((Object)this.this$0) + ".removeStaleEntries retained " + ResourceUpdateTracer.pathsForLogging((Collection<? extends VirtualFile>)this.$newResourceFolders, this.this$0.getProject());
            }
        });
        cacheAsMap.keySet().retainAll(newResourceFolders);
    }

    public void dispose() {
        this.reset();
    }

    public final void dispatchToRepositories(@NotNull VirtualFile file2, @NotNull BiConsumer<ResourceFolderRepository, VirtualFile> handler2) {
        VirtualFile dir;
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        Intrinsics.checkNotNullParameter(handler2, (String)"handler");
        ResourceUpdateTracer.log(new Supplier(file2){
            final /* synthetic */ VirtualFile $file;
            {
                this.$file = $file;
            }

            public final Object get() {
                return "ResourceFolderRegistry.dispatchToRepositories(" + ResourceUpdateTracer.pathForLogging(this.$file) + ", ...) VFS change";
            }
        });
        ApplicationManager.getApplication().assertWriteAccessAllowed();
        VirtualFile virtualFile = dir = file2.isDirectory() ? file2 : file2.getParent();
        while (dir != null) {
            for (Cache cache2 : this.myCaches) {
                ResourceFolderRepository repository2 = (ResourceFolderRepository)((Object)cache2.getIfPresent((Object)dir));
                if (repository2 == null) continue;
                handler2.accept(repository2, file2);
            }
            dir = dir.getParent();
        }
    }

    public final void dispatchToRepositories(@NotNull VirtualFile file2, @NotNull Consumer<PsiTreeChangeListener> invokeCallback) {
        VirtualFile dir;
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        Intrinsics.checkNotNullParameter(invokeCallback, (String)"invokeCallback");
        ResourceUpdateTracer.log(new Supplier(file2){
            final /* synthetic */ VirtualFile $file;
            {
                this.$file = $file;
            }

            public final Object get() {
                return "ResourceFolderRegistry.dispatchToRepositories(" + ResourceUpdateTracer.pathForLogging(this.$file) + ", ...) PSI change";
            }
        });
        ApplicationManager.getApplication().assertWriteAccessAllowed();
        VirtualFile virtualFile = dir = file2.isDirectory() ? file2 : file2.getParent();
        while (dir != null) {
            for (Cache cache2 : this.myCaches) {
                ResourceFolderRepository repository2 = (ResourceFolderRepository)((Object)cache2.getIfPresent((Object)dir));
                if (repository2 == null) continue;
                invokeCallback.consume((Object)repository2.getPsiListener());
            }
            dir = dir.getParent();
        }
    }

    private final Cache<VirtualFile, ResourceFolderRepository> buildCache() {
        Cache cache2 = CacheBuilder.newBuilder().build();
        Intrinsics.checkNotNullExpressionValue((Object)cache2, (String)"newBuilder().build()");
        return cache2;
    }

    private final ResourceFolderRepository createRepository(AndroidFacet facet2, VirtualFile dir, ResourceNamespace namespace) {
        Executor executor2 = ApplicationManager.getApplication().isUnitTestMode() ? (Executor)createRepository.executor.1.INSTANCE : (Executor)AndroidIoManager.Companion.getInstance().getBackgroundDiskIoExecutor();
        ResourceFolderRepositoryCachingData cachingData = ResourceFolderRepositoryFileCacheService.get().getCachingData(facet2.getModule().getProject(), dir, executor2);
        ResourceFolderRepository resourceFolderRepository = ResourceFolderRepository.create(facet2, dir, namespace, cachingData);
        Intrinsics.checkNotNullExpressionValue((Object)((Object)resourceFolderRepository), (String)"create(facet, dir, namespace, cachingData)");
        return resourceFolderRepository;
    }

    @JvmStatic
    @NotNull
    public static final ResourceFolderRegistry getInstance(@NotNull Project project) {
        return Companion.getInstance(project);
    }

    public static final /* synthetic */ ResourceFolderRepository access$createRepository(ResourceFolderRegistry $this, AndroidFacet facet2, VirtualFile dir, ResourceNamespace namespace) {
        return $this.createRepository(facet2, dir, namespace);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0007\u00a8\u0006\u0007"}, d2={"Lcom/android/tools/idea/res/ResourceFolderRegistry$Companion;", "", "()V", "getInstance", "Lcom/android/tools/idea/res/ResourceFolderRegistry;", "project", "Lcom/intellij/openapi/project/Project;", "intellij.android.core"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final ResourceFolderRegistry getInstance(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Object object = project.getService(ResourceFolderRegistry.class);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"project.getService(Resou\u2026lderRegistry::class.java)");
            return (ResourceFolderRegistry)object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0012\u0010\t\u001a\u0004\u0018\u00010\u00012\u0006\u0010\n\u001a\u00020\u0001H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/android/tools/idea/res/ResourceFolderRegistry$PopulateCachesTask;", "Lcom/intellij/openapi/project/DumbModeTask;", "myProject", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "performInDumbMode", "", "indicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "tryMergeWith", "taskFromQueue", "intellij.android.core"})
    public static final class PopulateCachesTask
    extends DumbModeTask {
        @NotNull
        private final Project myProject;

        public PopulateCachesTask(@NotNull Project myProject) {
            Intrinsics.checkNotNullParameter((Object)myProject, (String)"myProject");
            this.myProject = myProject;
        }

        @Nullable
        public DumbModeTask tryMergeWith(@NotNull DumbModeTask taskFromQueue) {
            Intrinsics.checkNotNullParameter((Object)taskFromQueue, (String)"taskFromQueue");
            return taskFromQueue instanceof PopulateCachesTask && Intrinsics.areEqual((Object)((PopulateCachesTask)taskFromQueue).myProject, (Object)this.myProject) ? (DumbModeTask)this : null;
        }

        public void performInDumbMode(@NotNull ProgressIndicator indicator) {
            boolean bl;
            Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
            List list2 = ProjectFacetManager.getInstance((Project)this.myProject).getFacets(AndroidFacet.ID);
            Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getInstance(myProject).getFacets(AndroidFacet.ID)");
            List facets = list2;
            if (facets.isEmpty()) {
                return;
            }
            indicator.setText("Indexing resources");
            indicator.setIndeterminate(false);
            Map<VirtualFile, AndroidFacet> resDirectories = IdeResourcesUtil.getResourceDirectoriesForFacets(facets);
            if (resDirectories.isEmpty()) {
                return;
            }
            try {
                ResourceFolderRepositoryFileCacheService.get().createDirForProject(this.myProject);
            }
            catch (IOException e) {
                return;
            }
            Application application = ApplicationManager.getApplication();
            boolean bl2 = bl = !application.isWriteAccessAllowed();
            if (_Assertions.ENABLED && !bl) {
                String string = "Assertion failed";
                throw new AssertionError((Object)string);
            }
            int numDone = 0;
            ExecutorService parallelExecutor = AndroidIoManager.Companion.getInstance().getBackgroundDiskIoExecutor();
            List repositoryJobs = new ArrayList();
            for (Map.Entry<VirtualFile, AndroidFacet> entry : resDirectories.entrySet()) {
                VirtualFile dir = entry.getKey();
                AndroidFacet facet2 = entry.getValue();
                ResourceFolderRegistry registry = Companion.getInstance(this.myProject);
                Future future2 = parallelExecutor.submit(new Callable(registry, facet2, dir){
                    final /* synthetic */ ResourceFolderRegistry $registry;
                    final /* synthetic */ AndroidFacet $facet;
                    final /* synthetic */ VirtualFile $dir;
                    {
                        this.$registry = $registry;
                        this.$facet = $facet;
                        this.$dir = $dir;
                    }

                    public final ResourceFolderRepository call() {
                        return this.$registry.get(this.$facet, this.$dir);
                    }
                });
                Intrinsics.checkNotNullExpressionValue(future2, (String)"dir, facet) in resDirect\u2026 { registry[facet, dir] }");
                repositoryJobs.add(future2);
            }
            for (Future job2 : repositoryJobs) {
                if (indicator.isCanceled()) break;
                indicator.setFraction((double)numDone / (double)resDirectories.size());
                try {
                    job2.get();
                }
                catch (ExecutionException dir) {
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
                ++numDone;
            }
        }
    }
}

