/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.res;

import com.android.ide.common.resources.ResourceRepository;
import com.android.resources.aar.AarResourceRepository;
import com.android.tools.idea.res.AndroidDependenciesCache;
import com.android.tools.idea.res.LocalResourceRepository;
import com.android.tools.idea.res.MultiResourceRepository;
import com.android.tools.idea.res.ResourceRepositoryManager;
import com.google.common.collect.ImmutableList;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.Disposer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.TestOnly;

final class ProjectResourceRepository
extends MultiResourceRepository {
    private final AndroidFacet myFacet;

    private ProjectResourceRepository(@NotNull AndroidFacet facet2, @NotNull List<LocalResourceRepository> localResources) {
        super(facet2.getModule().getName() + " with modules");
        this.myFacet = facet2;
        this.setChildren(localResources, (Collection<? extends AarResourceRepository>)ImmutableList.of(), (Collection<? extends ResourceRepository>)ImmutableList.of());
    }

    @NotNull
    public static ProjectResourceRepository create(@NotNull AndroidFacet facet2) {
        List<LocalResourceRepository> resources2 = ProjectResourceRepository.computeRepositories(facet2);
        return new ProjectResourceRepository(facet2, resources2);
    }

    @NotNull
    private static List<LocalResourceRepository> computeRepositories(@NotNull AndroidFacet facet2) {
        LocalResourceRepository main = ResourceRepositoryManager.getModuleResources(facet2);
        List<AndroidFacet> dependencies2 = AndroidDependenciesCache.getAndroidResourceDependencies(facet2.getModule());
        if (dependencies2.isEmpty()) {
            return Collections.singletonList(main);
        }
        ArrayList<LocalResourceRepository> resources2 = new ArrayList<LocalResourceRepository>(dependencies2.size() + 1);
        resources2.add(main);
        for (AndroidFacet dependency : dependencies2) {
            resources2.add(ResourceRepositoryManager.getModuleResources(dependency));
        }
        return resources2;
    }

    void updateRoots() {
        List<LocalResourceRepository> repositories = ProjectResourceRepository.computeRepositories(this.myFacet);
        this.invalidateResourceDirs();
        this.setChildren(repositories, (Collection<? extends AarResourceRepository>)ImmutableList.of(), (Collection<? extends ResourceRepository>)ImmutableList.of());
    }

    @TestOnly
    @NotNull
    static ProjectResourceRepository createForTest(@NotNull AndroidFacet facet2, @NotNull List<LocalResourceRepository> modules2) {
        ProjectResourceRepository repository2 = new ProjectResourceRepository(facet2, modules2);
        Disposer.register((Disposable)facet2, (Disposable)repository2);
        return repository2;
    }
}

