/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.res;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.PsiTreeChangeEvent;
import com.intellij.psi.PsiTreeChangeListener;
import org.jetbrains.annotations.NotNull;

class LoggingPsiTreeChangeListener
implements PsiTreeChangeListener {
    @NotNull
    private final PsiTreeChangeListener myWrappedListener;
    @NotNull
    private final Logger myLogger;

    LoggingPsiTreeChangeListener(@NotNull PsiTreeChangeListener wrappedListener, @NotNull Logger logger2) {
        this.myWrappedListener = wrappedListener;
        this.myLogger = logger2;
    }

    public void beforeChildAddition(@NotNull PsiTreeChangeEvent event) {
        this.logEvent(event);
        this.myWrappedListener.beforeChildAddition(event);
    }

    public void beforeChildRemoval(@NotNull PsiTreeChangeEvent event) {
        this.logEvent(event);
        this.myWrappedListener.beforeChildRemoval(event);
    }

    public void beforeChildReplacement(@NotNull PsiTreeChangeEvent event) {
        this.logEvent(event);
        this.myWrappedListener.beforeChildReplacement(event);
    }

    public void beforeChildMovement(@NotNull PsiTreeChangeEvent event) {
        this.logEvent(event);
        this.myWrappedListener.beforeChildMovement(event);
    }

    public void beforeChildrenChange(@NotNull PsiTreeChangeEvent event) {
        this.logEvent(event);
        this.myWrappedListener.beforeChildrenChange(event);
    }

    public void beforePropertyChange(@NotNull PsiTreeChangeEvent event) {
        this.logEvent(event);
        this.myWrappedListener.beforePropertyChange(event);
    }

    public void childAdded(@NotNull PsiTreeChangeEvent event) {
        this.logEvent(event);
        this.myWrappedListener.childAdded(event);
    }

    public void childRemoved(@NotNull PsiTreeChangeEvent event) {
        this.logEvent(event);
        this.myWrappedListener.childRemoved(event);
    }

    public void childReplaced(@NotNull PsiTreeChangeEvent event) {
        this.logEvent(event);
        this.myWrappedListener.childReplaced(event);
    }

    public void childrenChanged(@NotNull PsiTreeChangeEvent event) {
        this.logEvent(event);
        this.myWrappedListener.childrenChanged(event);
    }

    public void childMoved(@NotNull PsiTreeChangeEvent event) {
        this.logEvent(event);
        this.myWrappedListener.childMoved(event);
    }

    public void propertyChanged(@NotNull PsiTreeChangeEvent event) {
        this.logEvent(event);
        this.myWrappedListener.propertyChanged(event);
    }

    private void logEvent(@NotNull PsiTreeChangeEvent event) {
        this.myLogger.debug("Handling event ", new Object[]{event});
    }
}

