/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.res;

import com.android.annotations.concurrency.Slow;
import com.android.annotations.concurrency.UiThread;
import com.android.resources.ResourceFolderType;
import com.android.tools.idea.fileTypes.FontFileType;
import com.android.tools.idea.lang.rs.AndroidRenderscriptFileType;
import com.android.tools.idea.res.ResourceFolderRegistry;
import com.android.tools.idea.res.ResourceFolderRepository;
import com.android.tools.idea.res.ResourceNotificationManager;
import com.android.tools.idea.res.ResourceUpdateTracer;
import com.android.tools.idea.res.SampleDataListener;
import com.android.tools.idea.util.FileExtensions;
import com.intellij.AppTopics;
import com.intellij.ide.highlighter.JavaFileType;
import com.intellij.ide.highlighter.XmlFileType;
import com.intellij.lang.properties.PropertiesFileType;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileDocumentManagerListener;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.startup.StartupActivity;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.newvfs.BulkFileListener;
import com.intellij.openapi.vfs.newvfs.events.VFileCopyEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileCreateEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileDeleteEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileMoveEvent;
import com.intellij.openapi.vfs.newvfs.events.VFilePropertyChangeEvent;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiTreeChangeEvent;
import com.intellij.psi.PsiTreeChangeListener;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.ui.EditorNotifications;
import com.intellij.util.Consumer;
import com.intellij.util.messages.MessageBusConnection;
import java.util.List;
import org.intellij.images.fileTypes.ImageFileTypeManager;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.resourceManagers.ModuleResourceManagers;
import org.jetbrains.android.util.AndroidUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.KotlinFileType;
import org.jetbrains.plugins.gradle.config.GradleFileType;

public class AndroidFileChangeListener
implements Disposable {
    private ResourceFolderRegistry myRegistry;
    private Project myProject;
    private ResourceNotificationManager myResourceNotificationManager;
    private EditorNotifications myEditorNotifications;
    @Nullable
    private SampleDataListener mySampleDataListener;

    @NotNull
    public static AndroidFileChangeListener getInstance(@NotNull Project project) {
        return (AndroidFileChangeListener)project.getService(AndroidFileChangeListener.class);
    }

    private void onProjectOpened(@NotNull Project project) {
        this.myProject = project;
        this.myResourceNotificationManager = ResourceNotificationManager.getInstance(this.myProject);
        this.myRegistry = ResourceFolderRegistry.getInstance(this.myProject);
        this.myEditorNotifications = EditorNotifications.getInstance((Project)this.myProject);
        PsiManager.getInstance((Project)this.myProject).addPsiTreeChangeListener((PsiTreeChangeListener)new MyPsiListener(), (Disposable)this);
        EditorFactory.getInstance().getEventMulticaster().addDocumentListener((DocumentListener)new MyDocumentListener(this.myProject, this.myRegistry), (Disposable)this);
        MessageBusConnection connection2 = this.myProject.getMessageBus().connect((Disposable)this);
        connection2.subscribe(VirtualFileManager.VFS_CHANGES, (Object)new MyVfsListener(this.myRegistry));
        connection2.subscribe(AppTopics.FILE_DOCUMENT_SYNC, (Object)new MyFileDocumentManagerListener(this.myRegistry));
    }

    public void dispose() {
    }

    void setSampleDataListener(SampleDataListener sampleDataListener) {
        assert (this.mySampleDataListener == null) : "SampleDataListener already set!";
        this.mySampleDataListener = sampleDataListener;
    }

    static boolean isRelevantFileType(@NotNull FileType fileType) {
        if (fileType == JavaFileType.INSTANCE || fileType == KotlinFileType.INSTANCE) {
            return false;
        }
        if (fileType == XmlFileType.INSTANCE) {
            return true;
        }
        if (fileType.isBinary()) {
            return fileType == ImageFileTypeManager.getInstance().getImageFileType() || fileType == FontFileType.INSTANCE;
        }
        return false;
    }

    @Slow
    public static boolean isRelevantFile(@NotNull VirtualFile file2) {
        String parentName;
        String extension = file2.getExtension();
        if (StringUtil.isEmpty((String)extension)) {
            return false;
        }
        if ("java".equals(extension) || "kt".equals(extension)) {
            return false;
        }
        if ("xml".equals(extension)) {
            return true;
        }
        if ("AndroidManifest.xml".equals(file2.getName())) {
            return true;
        }
        if ("aidl".equals(extension)) {
            return true;
        }
        VirtualFile parent2 = file2.getParent();
        if (parent2 != null && (parentName = parent2.getName()).startsWith("raw")) {
            return true;
        }
        FileType fileType = file2.getFileType();
        return fileType.equals((Object)AndroidRenderscriptFileType.INSTANCE) || AndroidFileChangeListener.isRelevantFileType(fileType);
    }

    static boolean isRelevantFile(@NotNull PsiFile file2) {
        FileType fileType = file2.getFileType();
        if (fileType == JavaFileType.INSTANCE || fileType == KotlinFileType.INSTANCE) {
            return false;
        }
        if (AndroidFileChangeListener.isRelevantFileType(fileType)) {
            return true;
        }
        PsiDirectory parent2 = file2.getParent();
        if (parent2 == null) {
            return false;
        }
        String parentName = parent2.getName();
        return parentName.startsWith("raw");
    }

    public static boolean isGradleFile(@NotNull PsiFile psiFile) {
        if (GradleFileType.isGradleFile((PsiFile)psiFile)) {
            return true;
        }
        FileType fileType = psiFile.getFileType();
        if (fileType.getName().equals("Kotlin") && psiFile.getName().endsWith("gradle.kts")) {
            return true;
        }
        if (psiFile.getName().endsWith(".versions.toml")) {
            return true;
        }
        return fileType == PropertiesFileType.INSTANCE && ("gradle.properties".equals(psiFile.getName()) || "gradle-wrapper.properties".equals(psiFile.getName()));
    }

    private void dispatch(@Nullable VirtualFile file2, @NotNull Consumer<PsiTreeChangeListener> invokeCallback) {
        if (file2 != null) {
            this.myRegistry.dispatchToRepositories(file2, invokeCallback);
        }
        this.dispatchToResourceNotificationManager(invokeCallback);
    }

    private void dispatchToResourceNotificationManager(@NotNull Consumer<PsiTreeChangeListener> invokeCallback) {
        PsiTreeChangeListener resourceNotificationPsiListener = this.myResourceNotificationManager.getPsiListener();
        if (resourceNotificationPsiListener != null) {
            invokeCallback.consume((Object)resourceNotificationPsiListener);
        }
    }

    private class MyPsiListener
    implements PsiTreeChangeListener {
        private MyPsiListener() {
        }

        public void beforeChildAddition(@NotNull PsiTreeChangeEvent event) {
        }

        public void childAdded(@NotNull PsiTreeChangeEvent event) {
            PsiFile psiFile = event.getFile();
            if (psiFile == null) {
                PsiElement child = event.getChild();
                if (child instanceof PsiFile) {
                    VirtualFile file2 = ((PsiFile)child).getVirtualFile();
                    if (file2 != null) {
                        this.computeModulesToInvalidateAttributeDefinitions(file2);
                        if (AndroidFileChangeListener.isRelevantFile(file2)) {
                            this.dispatchChildAdded(event, file2);
                        }
                    }
                } else if (child instanceof PsiDirectory) {
                    PsiDirectory directory = (PsiDirectory)child;
                    this.dispatchChildAdded(event, directory.getVirtualFile());
                }
            } else if (AndroidFileChangeListener.isRelevantFile(psiFile)) {
                this.dispatchChildAdded(event, psiFile.getVirtualFile());
            } else if (AndroidFileChangeListener.isGradleFile(psiFile)) {
                this.notifyGradleEdit();
            }
            if (AndroidFileChangeListener.this.mySampleDataListener != null) {
                AndroidFileChangeListener.this.mySampleDataListener.childAdded(event);
            }
        }

        private void dispatchChildAdded(@NotNull PsiTreeChangeEvent event, @Nullable VirtualFile virtualFile) {
            AndroidFileChangeListener.this.dispatch(virtualFile, (Consumer<PsiTreeChangeListener>)((Consumer)listener2 -> listener2.childAdded(event)));
        }

        public void beforeChildRemoval(@NotNull PsiTreeChangeEvent event) {
        }

        public void childRemoved(@NotNull PsiTreeChangeEvent event) {
            PsiFile psiFile = event.getFile();
            if (psiFile != null && psiFile.getVirtualFile() != null) {
                this.computeModulesToInvalidateAttributeDefinitions(psiFile.getVirtualFile());
            }
            if (psiFile == null) {
                PsiDirectory directory;
                PsiElement child = event.getChild();
                if (child instanceof PsiFile) {
                    VirtualFile file2 = ((PsiFile)child).getVirtualFile();
                    if (file2 != null && AndroidFileChangeListener.isRelevantFile(file2)) {
                        this.dispatchChildRemoved(event, file2);
                    }
                } else if (child instanceof PsiDirectory && ResourceFolderType.getFolderType((String)(directory = (PsiDirectory)child).getName()) != null) {
                    VirtualFile file3 = directory.getVirtualFile();
                    this.dispatchChildRemoved(event, file3);
                }
            } else if (AndroidFileChangeListener.isRelevantFile(psiFile)) {
                VirtualFile file4 = psiFile.getVirtualFile();
                this.dispatchChildRemoved(event, file4);
            } else if (AndroidFileChangeListener.isGradleFile(psiFile)) {
                this.notifyGradleEdit();
            }
            if (AndroidFileChangeListener.this.mySampleDataListener != null) {
                AndroidFileChangeListener.this.mySampleDataListener.childRemoved(event);
            }
        }

        private void dispatchChildRemoved(@NotNull PsiTreeChangeEvent event, @Nullable VirtualFile virtualFile) {
            AndroidFileChangeListener.this.dispatch(virtualFile, (Consumer<PsiTreeChangeListener>)((Consumer)listener2 -> listener2.childRemoved(event)));
        }

        public void beforeChildReplacement(@NotNull PsiTreeChangeEvent event) {
        }

        public void childReplaced(@NotNull PsiTreeChangeEvent event) {
            PsiFile psiFile = event.getFile();
            if (psiFile != null) {
                VirtualFile file2 = psiFile.getVirtualFile();
                if (file2 != null) {
                    this.computeModulesToInvalidateAttributeDefinitions(file2);
                }
                if (AndroidFileChangeListener.isRelevantFile(psiFile)) {
                    this.dispatchChildReplaced(event, file2);
                } else if (AndroidFileChangeListener.isGradleFile(psiFile)) {
                    this.notifyGradleEdit();
                }
                if (AndroidFileChangeListener.this.mySampleDataListener != null) {
                    AndroidFileChangeListener.this.mySampleDataListener.childReplaced(event);
                }
            } else {
                PsiElement parent2 = event.getParent();
                if (parent2 instanceof PsiDirectory) {
                    PsiDirectory directory = (PsiDirectory)parent2;
                    this.dispatchChildReplaced(event, directory.getVirtualFile());
                }
            }
        }

        private void dispatchChildReplaced(@NotNull PsiTreeChangeEvent event, @Nullable VirtualFile virtualFile) {
            AndroidFileChangeListener.this.dispatch(virtualFile, (Consumer<PsiTreeChangeListener>)((Consumer)listener2 -> listener2.childReplaced(event)));
        }

        private void notifyGradleEdit() {
            AndroidFileChangeListener.this.myEditorNotifications.updateAllNotifications();
        }

        public void beforeChildrenChange(@NotNull PsiTreeChangeEvent event) {
            PsiFile psiFile = event.getFile();
            if (psiFile != null && AndroidFileChangeListener.isRelevantFile(psiFile)) {
                VirtualFile file2 = psiFile.getVirtualFile();
                this.dispatchBeforeChildrenChange(event, file2);
            }
        }

        private void dispatchBeforeChildrenChange(@NotNull PsiTreeChangeEvent event, @Nullable VirtualFile virtualFile) {
            AndroidFileChangeListener.this.dispatch(virtualFile, (Consumer<PsiTreeChangeListener>)((Consumer)listener2 -> listener2.beforeChildrenChange(event)));
        }

        public void childrenChanged(@NotNull PsiTreeChangeEvent event) {
            PsiFile psiFile = event.getFile();
            if (psiFile != null) {
                VirtualFile file2 = psiFile.getVirtualFile();
                if (file2 != null) {
                    this.computeModulesToInvalidateAttributeDefinitions(file2);
                }
                if (AndroidFileChangeListener.isRelevantFile(psiFile)) {
                    this.dispatchChildrenChanged(event, file2);
                }
                if (AndroidFileChangeListener.this.mySampleDataListener != null) {
                    AndroidFileChangeListener.this.mySampleDataListener.childrenChanged(event);
                }
            }
        }

        private void dispatchChildrenChanged(@NotNull PsiTreeChangeEvent event, @Nullable VirtualFile virtualFile) {
            AndroidFileChangeListener.this.dispatch(virtualFile, (Consumer<PsiTreeChangeListener>)((Consumer)listener2 -> listener2.childrenChanged(event)));
        }

        public void beforeChildMovement(@NotNull PsiTreeChangeEvent event) {
        }

        public void childMoved(@NotNull PsiTreeChangeEvent event) {
            PsiElement child = event.getChild();
            PsiFile psiFile = event.getFile();
            if (psiFile == null) {
                if (child instanceof PsiFile && AndroidFileChangeListener.isRelevantFile((PsiFile)child)) {
                    VirtualFile file2 = ((PsiFile)child).getVirtualFile();
                    if (file2 != null) {
                        this.dispatchChildMoved(event, file2);
                        return;
                    }
                    PsiElement oldParent = event.getOldParent();
                    if (oldParent instanceof PsiDirectory) {
                        PsiDirectory directory = (PsiDirectory)oldParent;
                        VirtualFile dir = directory.getVirtualFile();
                        this.dispatchChildMoved(event, dir);
                    }
                }
            } else {
                VirtualFile file3 = psiFile.getVirtualFile();
                if (file3 != null) {
                    this.computeModulesToInvalidateAttributeDefinitions(file3);
                    if (AndroidFileChangeListener.isRelevantFile(file3)) {
                        this.dispatchChildMoved(event, file3);
                    }
                    if (AndroidFileChangeListener.this.mySampleDataListener != null) {
                        AndroidFileChangeListener.this.mySampleDataListener.childMoved(event);
                    }
                }
            }
        }

        private void dispatchChildMoved(@NotNull PsiTreeChangeEvent event, @Nullable VirtualFile virtualFile) {
            PsiElement oldParent;
            AndroidFileChangeListener.this.dispatch(virtualFile, (Consumer<PsiTreeChangeListener>)((Consumer)listener2 -> listener2.childMoved(event)));
            if (event.getFile() == null && (oldParent = event.getOldParent()) instanceof PsiDirectory) {
                PsiDirectory sourceDir = (PsiDirectory)oldParent;
                AndroidFileChangeListener.this.dispatch(sourceDir.getVirtualFile(), (Consumer<PsiTreeChangeListener>)((Consumer)listener2 -> listener2.childMoved(event)));
            }
        }

        public void beforePropertyChange(@NotNull PsiTreeChangeEvent event) {
            PsiFile psiFile;
            PsiElement child;
            if ("fileName".equals(event.getPropertyName()) && (child = event.getChild()) instanceof PsiFile && AndroidFileChangeListener.isRelevantFile(psiFile = (PsiFile)child)) {
                VirtualFile file2 = psiFile.getVirtualFile();
                this.dispatchBeforePropertyChange(event, file2);
            }
        }

        private void dispatchBeforePropertyChange(@NotNull PsiTreeChangeEvent event, @Nullable VirtualFile virtualFile) {
            AndroidFileChangeListener.this.dispatch(virtualFile, (Consumer<PsiTreeChangeListener>)((Consumer)listener2 -> listener2.beforePropertyChange(event)));
        }

        public void propertyChanged(@NotNull PsiTreeChangeEvent event) {
            PsiFile psiFile;
            PsiElement child;
            if ("fileName".equals(event.getPropertyName()) && (child = event.getElement()) instanceof PsiFile && AndroidFileChangeListener.isRelevantFile(psiFile = (PsiFile)child)) {
                VirtualFile file2 = psiFile.getVirtualFile();
                this.dispatchPropertyChanged(event, file2);
            }
        }

        private void dispatchPropertyChanged(@NotNull PsiTreeChangeEvent event, @Nullable VirtualFile virtualFile) {
            AndroidFileChangeListener.this.dispatch(virtualFile, (Consumer<PsiTreeChangeListener>)((Consumer)listener2 -> listener2.propertyChanged(event)));
        }

        private void computeModulesToInvalidateAttributeDefinitions(@NotNull VirtualFile file2) {
            if (!AndroidFileChangeListener.isRelevantFile(file2)) {
                return;
            }
            AndroidFacet facet2 = AndroidFacet.getInstance((VirtualFile)file2, (Project)AndroidFileChangeListener.this.myProject);
            if (facet2 != null) {
                for (Module module2 : AndroidUtils.getSetWithBackwardDependencies(facet2.getModule())) {
                    AndroidFacet moduleFacet = AndroidFacet.getInstance((Module)module2);
                    if (moduleFacet == null) continue;
                    ModuleResourceManagers.getInstance(moduleFacet).getLocalResourceManager().invalidateAttributeDefinitions();
                }
            }
        }
    }

    static class MyDocumentListener
    implements DocumentListener {
        private final Project myProject;
        private final FileDocumentManager myFileDocumentManager;
        private final PsiDocumentManager myPsiDocumentManager;
        private final ResourceFolderRegistry myRegistry;

        private MyDocumentListener(@NotNull Project project, @NotNull ResourceFolderRegistry registry) {
            this.myProject = project;
            this.myPsiDocumentManager = PsiDocumentManager.getInstance((Project)project);
            this.myFileDocumentManager = FileDocumentManager.getInstance();
            this.myRegistry = registry;
        }

        public void documentChanged(@NotNull DocumentEvent event) {
            VirtualFile virtualFile;
            if (this.myProject.isDisposed()) {
                return;
            }
            Document document2 = event.getDocument();
            PsiFile psiFile = this.myPsiDocumentManager.getCachedPsiFile(document2);
            if (psiFile == null && (virtualFile = this.myFileDocumentManager.getFile(document2)) != null && !(virtualFile instanceof LightVirtualFile) && AndroidFileChangeListener.isRelevantFile(virtualFile)) {
                this.runInWriteAction(() -> this.myRegistry.dispatchToRepositories(virtualFile, ResourceFolderRepository::scheduleScan));
            }
        }

        private void runInWriteAction(@NotNull Runnable runnable2) {
            Application application = ApplicationManager.getApplication();
            if (application.isWriteAccessAllowed()) {
                runnable2.run();
            } else {
                application.invokeLater(() -> application.runWriteAction(runnable2));
            }
        }
    }

    static class MyFileDocumentManagerListener
    implements FileDocumentManagerListener {
        private final ResourceFolderRegistry myRegistry;

        private MyFileDocumentManagerListener(@NotNull ResourceFolderRegistry registry) {
            this.myRegistry = registry;
        }

        public void fileWithNoDocumentChanged(@NotNull VirtualFile file2) {
            this.myRegistry.dispatchToRepositories(file2, ResourceFolderRepository::scheduleScan);
        }
    }

    static class MyVfsListener
    implements BulkFileListener {
        private final ResourceFolderRegistry myRegistry;

        private MyVfsListener(@NotNull ResourceFolderRegistry registry) {
            this.myRegistry = registry;
        }

        @UiThread
        public void before(@NotNull @NotNull List<? extends @NotNull VFileEvent> events) {
            for (VFileEvent vFileEvent : events) {
                if (vFileEvent instanceof VFileMoveEvent) {
                    this.onFileOrDirectoryRemoved(((VFileMoveEvent)vFileEvent).getFile());
                    continue;
                }
                if (vFileEvent instanceof VFileDeleteEvent) {
                    this.onFileOrDirectoryRemoved(((VFileDeleteEvent)vFileEvent).getFile());
                    continue;
                }
                if (!(vFileEvent instanceof VFilePropertyChangeEvent) || !((VFilePropertyChangeEvent)vFileEvent).getPropertyName().equals("name")) continue;
                this.onFileOrDirectoryRemoved(((VFilePropertyChangeEvent)vFileEvent).getFile());
            }
        }

        public void after(@NotNull @NotNull List<? extends @NotNull VFileEvent> events) {
            for (VFileEvent vFileEvent : events) {
                VFilePropertyChangeEvent renameEvent;
                VirtualFile parentFile;
                if (vFileEvent instanceof VFileCreateEvent) {
                    VFileCreateEvent createEvent = (VFileCreateEvent)vFileEvent;
                    this.onFileOrDirectoryCreated(createEvent.getParent(), createEvent.getChildName());
                    continue;
                }
                if (vFileEvent instanceof VFileCopyEvent) {
                    VFileCopyEvent copyEvent = (VFileCopyEvent)vFileEvent;
                    this.onFileOrDirectoryCreated(copyEvent.getNewParent(), copyEvent.getNewChildName());
                    continue;
                }
                if (vFileEvent instanceof VFileMoveEvent) {
                    VFileMoveEvent moveEvent = (VFileMoveEvent)vFileEvent;
                    this.onFileOrDirectoryCreated(moveEvent.getNewParent(), moveEvent.getFile().getName());
                    continue;
                }
                if (!(vFileEvent instanceof VFilePropertyChangeEvent) || !((VFilePropertyChangeEvent)vFileEvent).getPropertyName().equals("name") || (parentFile = (renameEvent = (VFilePropertyChangeEvent)vFileEvent).getFile().getParent()) == null) continue;
                this.onFileOrDirectoryCreated(parentFile, (String)renameEvent.getNewValue());
            }
        }

        private void onFileOrDirectoryCreated(@Nullable VirtualFile parent2, @NotNull String childName) {
            VirtualFile resDir;
            ResourceUpdateTracer.log(() -> "AndroidFileChangeListener.MyVfsListener.onFileOrDirectoryCreated(" + this.pathForLogging(parent2, childName) + ")");
            if (parent2 == null || !parent2.exists()) {
                return;
            }
            VirtualFile created = parent2.findChild(childName);
            if (created == null) {
                return;
            }
            VirtualFile virtualFile = resDir = created.isDirectory() ? parent2 : parent2.getParent();
            if (resDir != null) {
                this.myRegistry.dispatchToRepositories(resDir, (repository2, dir) -> MyVfsListener.onFileOrDirectoryCreated(created, repository2));
            }
        }

        @NotNull
        private String pathForLogging(@Nullable VirtualFile parent2, @NotNull String childName) {
            if (parent2 == null) {
                return childName;
            }
            return ResourceUpdateTracer.pathForLogging(FileExtensions.toPathString(parent2).resolve(childName), this.myRegistry.getProject());
        }

        private static void onFileOrDirectoryCreated(@NotNull VirtualFile created, @Nullable ResourceFolderRepository repository2) {
            if (repository2 == null) {
                return;
            }
            ResourceUpdateTracer.log(() -> "AndroidFileChangeListener.MyVfsListener.onFileOrDirectoryCreated(" + created + ", " + repository2.getDisplayName() + ")");
            if (!created.isDirectory()) {
                repository2.onFileCreated(created);
            } else {
                for (VirtualFile child : created.getChildren()) {
                    if (child.isDirectory()) continue;
                    repository2.onFileCreated(child);
                }
            }
        }

        private void onFileOrDirectoryRemoved(@NotNull VirtualFile file2) {
            this.myRegistry.dispatchToRepositories(file2, ResourceFolderRepository::onFileOrDirectoryRemoved);
        }
    }

    public static class MyStartupActivity
    implements StartupActivity {
        public void runActivity(@NotNull Project project) {
            AndroidFileChangeListener listener2 = AndroidFileChangeListener.getInstance(project);
            listener2.onProjectOpened(project);
        }
    }
}

