/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.res;

import com.android.tools.idea.projectsystem.ProjectSystemUtil;
import com.android.tools.idea.res.AndroidProjectRootListener;
import com.intellij.ProjectTopics;
import com.intellij.facet.Facet;
import com.intellij.facet.FacetManager;
import com.intellij.facet.FacetManagerAdapter;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.ModuleListener;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.DependencyScope;
import com.intellij.openapi.roots.ModuleOrderEntry;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.messages.MessageBusConnection;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.facet.AndroidFacetConfiguration;
import org.jetbrains.annotations.NotNull;

public class AndroidDependenciesCache
implements Disposable {
    private static final Key<AndroidDependenciesCache> KEY = Key.create((String)AndroidDependenciesCache.class.getName());
    private final Module myModule;
    private final AtomicReference<List<WeakReference<AndroidFacet>>> myAllDependencies = new AtomicReference();
    private final AtomicReference<List<WeakReference<AndroidFacet>>> myAllLibraryDependencies = new AtomicReference();

    private AndroidDependenciesCache(@NotNull Module module2) {
        this.myModule = module2;
        AndroidProjectRootListener.ensureSubscribed(module2.getProject());
        MessageBusConnection busConnection = module2.getProject().getMessageBus().connect((Disposable)this);
        busConnection.subscribe(FacetManager.FACETS_TOPIC, (Object)new FacetManagerAdapter(){

            public void facetAdded(@NotNull Facet facet2) {
                AndroidDependenciesCache.this.dropCache();
            }

            public void facetRemoved(@NotNull Facet facet2) {
                AndroidDependenciesCache.this.dropCache();
            }

            public void facetConfigurationChanged(@NotNull Facet facet2) {
                AndroidDependenciesCache.this.dropCache();
            }
        });
        busConnection.subscribe(ProjectTopics.MODULES, (Object)new ModuleListener(){

            public void moduleAdded(@NotNull Project project, @NotNull Module module2) {
                AndroidDependenciesCache.this.dropCache();
            }

            public void moduleRemoved(@NotNull Project project, @NotNull Module module2) {
                AndroidDependenciesCache.this.dropCache();
            }
        });
    }

    public void dispose() {
    }

    public synchronized void dropCache() {
        this.myAllDependencies.set(null);
        this.myAllLibraryDependencies.set(null);
    }

    @NotNull
    public static synchronized AndroidDependenciesCache getInstance(@NotNull Module module2) {
        AndroidDependenciesCache cache2 = (AndroidDependenciesCache)module2.getUserData(KEY);
        if (cache2 == null) {
            cache2 = new AndroidDependenciesCache(module2);
            Disposer.register((Disposable)module2, (Disposable)cache2);
            module2.putUserData(KEY, (Object)cache2);
        }
        return cache2;
    }

    @NotNull
    public synchronized List<AndroidFacet> getAllAndroidDependencies(boolean androidLibrariesOnly) {
        return AndroidDependenciesCache.getAllAndroidDependencies(this.myModule, androidLibrariesOnly, this.getListRef(androidLibrariesOnly));
    }

    @NotNull
    public static List<AndroidFacet> getAllAndroidDependencies(@NotNull Module module2, boolean androidLibrariesOnly) {
        return AndroidDependenciesCache.getInstance(module2).getAllAndroidDependencies(androidLibrariesOnly);
    }

    public static List<AndroidFacet> getAndroidResourceDependencies(@NotNull Module module2) {
        return ProjectSystemUtil.getModuleSystem(module2).getResourceModuleDependencies().stream().map(AndroidFacet::getInstance).filter(Objects::nonNull).collect(Collectors.toList());
    }

    @NotNull
    private AtomicReference<List<WeakReference<AndroidFacet>>> getListRef(boolean androidLibrariesOnly) {
        return androidLibrariesOnly ? this.myAllLibraryDependencies : this.myAllDependencies;
    }

    @NotNull
    private static List<AndroidFacet> getAllAndroidDependencies(@NotNull Module module2, boolean androidLibrariesOnly, @NotNull AtomicReference<List<WeakReference<AndroidFacet>>> listRef) {
        if (module2.isDisposed()) {
            return Collections.emptyList();
        }
        List refs = listRef.get();
        if (refs == null) {
            ArrayList<AndroidFacet> facets = new ArrayList<AndroidFacet>();
            AndroidDependenciesCache.collectAllAndroidDependencies(module2, androidLibrariesOnly, facets, new HashSet<AndroidFacet>());
            refs = ContainerUtil.map((Collection)ContainerUtil.reverse(facets), facet2 -> new WeakReference<AndroidFacet>((AndroidFacet)facet2));
            listRef.set(refs);
        }
        return AndroidDependenciesCache.dereference(refs);
    }

    @NotNull
    private static List<AndroidFacet> dereference(@NotNull List<WeakReference<AndroidFacet>> refs) {
        return ContainerUtil.mapNotNull(refs, ref -> {
            AndroidFacet facet2 = (AndroidFacet)ref.get();
            if (facet2 == null) {
                AndroidDependenciesCache.logNullReference();
                return null;
            }
            if (facet2.isDisposed()) {
                AndroidDependenciesCache.logDisposedFacet();
                return null;
            }
            AndroidFacet facetFromModule = AndroidFacet.getInstance((Module)facet2.getModule());
            if (facetFromModule == null) {
                AndroidDependenciesCache.logNonAndroidModule();
                return null;
            }
            if (facetFromModule != facet2) {
                AndroidDependenciesCache.logObsoleteFacet();
                return null;
            }
            return facet2;
        });
    }

    private static void logObsoleteFacet() {
        Logger.getInstance(AndroidDependenciesCache.class).warn("obsolete facet");
    }

    private static void logNonAndroidModule() {
        Logger.getInstance(AndroidDependenciesCache.class).warn("non-Android module");
    }

    private static void logDisposedFacet() {
        Logger.getInstance(AndroidDependenciesCache.class).warn("disposed facet");
    }

    private static void logNullReference() {
        Logger.getInstance(AndroidDependenciesCache.class).warn("null in dereference");
    }

    private static void collectAllAndroidDependencies(@NotNull Module module2, boolean androidLibrariesOnly, @NotNull List<AndroidFacet> result2, @NotNull Set<AndroidFacet> visited) {
        AndroidFacet facet2 = AndroidFacet.getInstance((Module)module2);
        boolean isDynamicFeature = facet2 != null && ((AndroidFacetConfiguration)facet2.getConfiguration()).getProjectType() == 6;
        OrderEntry[] entries2 = ModuleRootManager.getInstance((Module)module2).getOrderEntries();
        int i = entries2.length;
        while (--i >= 0) {
            AndroidFacet depFacet;
            Module depModule;
            ModuleOrderEntry moduleOrderEntry;
            ProgressManager.checkCanceled();
            OrderEntry orderEntry = entries2[i];
            if (!(orderEntry instanceof ModuleOrderEntry) || (moduleOrderEntry = (ModuleOrderEntry)orderEntry).getScope() != DependencyScope.COMPILE || (depModule = moduleOrderEntry.getModule()) == null || (depFacet = AndroidFacet.getInstance((Module)depModule)) == null || androidLibrariesOnly && ((AndroidFacetConfiguration)depFacet.getConfiguration()).isAppProject() && !isDynamicFeature || !visited.add(depFacet)) continue;
            List<WeakReference<AndroidFacet>> cachedDepDeps = AndroidDependenciesCache.getInstance(depModule).getListRef(androidLibrariesOnly).get();
            if (cachedDepDeps != null) {
                List<AndroidFacet> depDeps = AndroidDependenciesCache.dereference(cachedDepDeps);
                for (AndroidFacet depDepFacet : depDeps) {
                    if (!visited.add(depDepFacet)) continue;
                    result2.add(depDepFacet);
                }
            } else {
                AndroidDependenciesCache.collectAllAndroidDependencies(depModule, androidLibrariesOnly, result2, visited);
            }
            result2.add(depFacet);
        }
    }
}

