/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.rendering.parsers;

import com.android.tools.idea.rendering.parsers.AaptAttrAttributeSnapshot;
import com.android.tools.idea.rendering.parsers.AttributeSnapshot;
import com.google.common.base.Charsets;
import com.google.common.collect.Lists;
import com.google.common.hash.HashFunction;
import com.google.common.hash.Hasher;
import com.google.common.hash.Hashing;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlTag;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TagSnapshot {
    @Nullable
    public final String namespace;
    @NotNull
    public final String tagName;
    @Nullable
    public final XmlTag tag;
    @Nullable
    public final String prefix;
    @Nullable
    private TagSnapshot myNext;
    @NotNull
    public List<TagSnapshot> children;
    @NotNull
    public List<AttributeSnapshot> attributes;
    @NotNull
    public Map<String, String> namespaceDeclarations;
    public boolean hasDeclaredAaptAttrs = false;

    private TagSnapshot(@Nullable XmlTag tag, @Nullable String tagName, @Nullable String prefix, @Nullable String namespace, @NotNull List<AttributeSnapshot> attributes, @NotNull List<TagSnapshot> children, boolean hasDeclaredAaptAttrs) {
        this.tagName = tagName != null ? tagName : "?";
        this.prefix = prefix == null || prefix.isEmpty() ? null : prefix;
        this.namespace = namespace;
        this.tag = tag;
        this.attributes = attributes;
        this.children = children;
        this.hasDeclaredAaptAttrs = hasDeclaredAaptAttrs;
        this.namespaceDeclarations = tag != null ? tag.getLocalNamespaceDeclarations() : Collections.emptyMap();
    }

    static TagSnapshot createSyntheticTag(@Nullable XmlTag tag, @Nullable String tagName, @Nullable String prefix, @Nullable String namespace, @NotNull List<AttributeSnapshot> attributes, @NotNull List<TagSnapshot> children, @Nullable Consumer<TagSnapshot> afterCreate) {
        TagSnapshot newSnapshot = new TagSnapshot(tag, tagName, prefix, namespace, attributes, children, false);
        if (afterCreate != null) {
            afterCreate.accept(newSnapshot);
        }
        return newSnapshot;
    }

    @Nullable
    private static String getTagNameForSnapshot(@NotNull XmlTag tag) {
        XmlAttribute useTagAttribute = tag.getAttribute("useTag", "http://schemas.android.com/tools");
        String tagName = useTagAttribute == null ? tag.getName() : useTagAttribute.getValue();
        return "androidx.compose.ui.platform.ComposeView".equals(tagName) ? "androidx.compose.ui.tooling.ComposeViewAdapter" : tagName;
    }

    @NotNull
    public static TagSnapshot createTagSnapshot(@NotNull XmlTag tag, @Nullable Consumer<TagSnapshot> afterCreate) {
        ArrayList children;
        List<AttributeSnapshot> attributes = AttributeSnapshot.createAttributesForTag(tag);
        XmlTag[] subTags = tag.getSubTags();
        boolean hasDeclaredAaptAttrs = false;
        if (subTags.length > 0) {
            TagSnapshot last = null;
            children = Lists.newArrayListWithCapacity((int)subTags.length);
            for (XmlTag subTag : subTags) {
                if ("http://schemas.android.com/aapt".equals(subTag.getNamespace())) {
                    AaptAttrAttributeSnapshot aaptAttribute;
                    if (!"attr".equals(subTag.getLocalName()) || subTag.getAttribute("name") == null || (aaptAttribute = AaptAttrAttributeSnapshot.createAttributeSnapshot(subTag)) == null) continue;
                    attributes.add(aaptAttribute);
                    hasDeclaredAaptAttrs = true;
                    continue;
                }
                TagSnapshot child = TagSnapshot.createTagSnapshot(subTag, afterCreate);
                hasDeclaredAaptAttrs |= child.hasDeclaredAaptAttrs;
                children.add(child);
                if (last != null) {
                    last.myNext = child;
                }
                last = child;
            }
        } else {
            children = Collections.emptyList();
        }
        TagSnapshot newSnapshot = new TagSnapshot(tag, TagSnapshot.getTagNameForSnapshot(tag), tag.getNamespacePrefix(), tag.getNamespace(), attributes, children, hasDeclaredAaptAttrs);
        if (afterCreate != null) {
            afterCreate.accept(newSnapshot);
        }
        return newSnapshot;
    }

    @NotNull
    public static TagSnapshot createTagSnapshotWithoutChildren(@NotNull XmlTag tag) {
        List<AttributeSnapshot> attributes = AttributeSnapshot.createAttributesForTag(tag);
        boolean hasDeclaredAaptAttrs = false;
        for (XmlTag subTag : tag.getSubTags()) {
            AaptAttrAttributeSnapshot aaptAttribute;
            if (!"http://schemas.android.com/aapt".equals(subTag.getNamespace()) || !"attr".equals(subTag.getLocalName()) || subTag.getAttribute("name") == null || (aaptAttribute = AaptAttrAttributeSnapshot.createAttributeSnapshot(subTag)) == null) continue;
            attributes.add(aaptAttribute);
            hasDeclaredAaptAttrs = true;
        }
        return new TagSnapshot(tag, TagSnapshot.getTagNameForSnapshot(tag), tag.getNamespacePrefix(), tag.getNamespace(), attributes, Collections.emptyList(), hasDeclaredAaptAttrs);
    }

    @Nullable
    public String getAttribute(@NotNull String name) {
        return this.getAttribute(name, null);
    }

    @Nullable
    public String getAttribute(@NotNull String name, @Nullable String namespace) {
        int n = this.attributes.size();
        for (int i = 0; i < n; ++i) {
            AttributeSnapshot attribute = this.attributes.get(i);
            if (!name.equals(attribute.name) || namespace != null && !namespace.equals(attribute.namespace)) continue;
            return attribute.value;
        }
        return null;
    }

    public void setAttribute(@NotNull String name, @Nullable String namespace, @Nullable String prefix, @Nullable String value2, boolean overrideIfExists) {
        int n = this.attributes.size();
        for (int i = 0; i < n; ++i) {
            AttributeSnapshot attribute = this.attributes.get(i);
            if (!name.equals(attribute.name) || namespace != null && !namespace.equals(attribute.namespace)) continue;
            if (overrideIfExists) {
                this.attributes.remove(i);
                break;
            }
            return;
        }
        if (value2 != null) {
            if (this.attributes.isEmpty()) {
                this.attributes = new ArrayList<AttributeSnapshot>();
            }
            this.attributes.add(new AttributeSnapshot(namespace, prefix, name, value2));
        }
    }

    public void setAttribute(@NotNull String name, @Nullable String namespace, @Nullable String prefix, @Nullable String value2) {
        this.setAttribute(name, namespace, prefix, value2, true);
    }

    @Nullable
    public TagSnapshot getNextSibling() {
        return this.myNext;
    }

    public String toString() {
        return "TagSnapshot{" + this.tagName + ", attributes=" + this.attributes + ", children=\n" + this.children + "\n}";
    }

    public long getSignature() {
        HashFunction hashFunction = Hashing.goodFastHash((int)64);
        Hasher hasher = hashFunction.newHasher();
        hasher.putString((CharSequence)this.tagName, Charsets.UTF_8);
        for (AttributeSnapshot attribute : this.attributes) {
            if (attribute.prefix != null) {
                hasher.putString((CharSequence)attribute.prefix, Charsets.UTF_8);
            }
            hasher.putString((CharSequence)attribute.name, Charsets.UTF_8);
            if (attribute.value == null) continue;
            hasher.putString((CharSequence)attribute.value, Charsets.UTF_8);
        }
        return hasher.hash().asLong();
    }
}

