/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.rendering.parsers;

import com.android.tools.idea.rendering.parsers.AttributeSnapshot;
import com.android.tools.idea.rendering.parsers.TagSnapshot;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.psi.xml.XmlTag;
import com.intellij.xml.util.XmlUtil;
import java.util.concurrent.atomic.AtomicLong;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class AaptAttrAttributeSnapshot
extends AttributeSnapshot {
    @VisibleForTesting
    static final AtomicLong ourUniqueId = new AtomicLong(0L);
    private final String myId;
    private final TagSnapshot myBundledTag;

    AaptAttrAttributeSnapshot(@Nullable String namespace, @Nullable String prefix, @NotNull String name, @NotNull String id2, @NotNull TagSnapshot bundledTag) {
        super(namespace, prefix, name, "@aapt:_aapt/aapt" + id2);
        this.myId = id2;
        this.myBundledTag = bundledTag;
    }

    @Nullable
    public static AaptAttrAttributeSnapshot createAttributeSnapshot(@NotNull XmlTag tag) {
        XmlTag parent2 = tag.getParentTag();
        String name = tag.getAttributeValue("name");
        if (parent2 == null || name == null) {
            return null;
        }
        XmlTag[] subTags = tag.getSubTags();
        if (subTags.length == 0) {
            return null;
        }
        XmlTag bundledTag = tag.getSubTags()[0];
        String prefix = XmlUtil.findPrefixByQualifiedName((String)name);
        return new AaptAttrAttributeSnapshot(tag.getNamespaceByPrefix(prefix), prefix, XmlUtil.findLocalNameByQualifiedName((String)name), Long.toString(ourUniqueId.getAndIncrement()), TagSnapshot.createTagSnapshot(bundledTag, null));
    }

    @NotNull
    public String getId() {
        return this.myId;
    }

    @NotNull
    public TagSnapshot getBundledTag() {
        return this.myBundledTag;
    }
}

