/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.rendering.multi;

import com.google.common.collect.Sets;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public enum RenderPreviewMode {
    DEFAULT,
    LOCALES,
    SCREENS,
    INCLUDES,
    VARIATIONS,
    RTL,
    CUSTOM,
    API_LEVELS,
    NONE;

    private static Collection<String> ourDeletedIds;
    private static RenderPreviewMode ourCurrent;

    @NotNull
    public static RenderPreviewMode getCurrent() {
        return ourCurrent;
    }

    public static void setCurrent(@NotNull RenderPreviewMode current) {
        if (ourCurrent != current) {
            ourCurrent = current;
            ourDeletedIds = null;
        }
    }

    public static boolean isDeletedId(@Nullable String id2) {
        return ourDeletedIds != null && id2 != null && ourDeletedIds.contains(id2);
    }

    public static void deleteId(@Nullable String id2) {
        if (id2 != null) {
            if (ourDeletedIds == null) {
                ourDeletedIds = Sets.newHashSet();
            }
            ourDeletedIds.add(id2);
        }
    }

    public boolean showsDeviceFrames() {
        return this == SCREENS;
    }

    static {
        ourCurrent = NONE;
    }
}

