/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.rendering.errors;

import com.android.tools.idea.rendering.HtmlLinkManager;
import com.android.tools.idea.rendering.RenderLogger;
import com.android.tools.idea.rendering.RenderProblem;
import com.android.tools.idea.rendering.errors.RenderErrorContributorUtilKt;
import com.android.tools.idea.rendering.errors.ui.RenderErrorModel;
import com.android.utils.HtmlBuilder;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.event.HyperlinkListener;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0003\n\u0002\b\u0006\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006H\u0002J\u0012\u0010\u0007\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006H\u0002J\u0012\u0010\b\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006H\u0002J\u0012\u0010\t\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006H\u0007J\u0012\u0010\n\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006H\u0002J\u0012\u0010\u000b\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006H\u0002J&\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0007\u00a8\u0006\u0015"}, d2={"Lcom/android/tools/idea/rendering/errors/ComposeRenderErrorContributor;", "", "()V", "isComposeNotFoundThrowable", "", "throwable", "", "isCompositionLocalStackTrace", "isFailToLoadPreviewParameterProvider", "isHandledByComposeContributor", "isPreviewParameterMismatchThrowable", "isViewModelStackTrace", "reportComposeErrors", "", "Lcom/android/tools/idea/rendering/errors/ui/RenderErrorModel$Issue;", "logger", "Lcom/android/tools/idea/rendering/RenderLogger;", "linkManager", "Lcom/android/tools/idea/rendering/HtmlLinkManager;", "linkHandler", "Ljavax/swing/event/HyperlinkListener;", "intellij.android.core"})
public final class ComposeRenderErrorContributor {
    @NotNull
    public static final ComposeRenderErrorContributor INSTANCE = new ComposeRenderErrorContributor();

    private ComposeRenderErrorContributor() {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isCompositionLocalStackTrace(Throwable throwable) {
        Throwable throwable2 = throwable;
        if (throwable2 == null) return false;
        Throwable throwable3 = throwable2;
        boolean bl = false;
        if (!(throwable3 instanceof IllegalStateException)) return false;
        StackTraceElement[] stackTraceElementArray = ((IllegalStateException)throwable3).getStackTrace();
        Intrinsics.checkNotNullExpressionValue((Object)stackTraceElementArray, (String)"throwable.stackTrace");
        Object[] $this$any$iv = stackTraceElementArray;
        boolean $i$f$any = false;
        int n = 0;
        int n2 = $this$any$iv.length;
        while (n < n2) {
            Object element$iv = $this$any$iv[n];
            StackTraceElement it = (StackTraceElement)element$iv;
            boolean bl2 = false;
            if (Intrinsics.areEqual((Object)it.getMethodName(), (Object)"resolveCompositionLocal") || Intrinsics.areEqual((Object)it.getMethodName(), (Object)"CompositionLocalProvider")) {
                String string = it.getClassName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"it.className");
                if (StringsKt.startsWith$default((String)string, (String)"androidx.compose.runtime", (boolean)false, (int)2, null)) {
                    return true;
                }
            }
            boolean bl3 = false;
            if (bl3) {
                return true;
            }
            ++n;
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isViewModelStackTrace(Throwable throwable) {
        Throwable throwable2 = throwable;
        if (throwable2 == null) return false;
        Throwable throwable3 = throwable2;
        boolean bl = false;
        StackTraceElement[] stackTraceElementArray = throwable3.getStackTrace();
        Intrinsics.checkNotNullExpressionValue((Object)stackTraceElementArray, (String)"throwable.stackTrace");
        Object[] $this$any$iv = stackTraceElementArray;
        boolean $i$f$any = false;
        int n = 0;
        int n2 = $this$any$iv.length;
        while (n < n2) {
            block7: {
                StackTraceElement it;
                block6: {
                    Object element$iv = $this$any$iv[n];
                    it = (StackTraceElement)element$iv;
                    boolean bl2 = false;
                    if (Intrinsics.areEqual((Object)it.getMethodName(), (Object)"viewModel")) break block6;
                    String string = it.getClassName();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"it.className");
                    if (StringsKt.endsWith$default((String)string, (String)"ViewModelProvider", (boolean)false, (int)2, null)) break block6;
                    String string2 = it.getClassName();
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"it.className");
                    if (!StringsKt.endsWith$default((String)string2, (String)"ViewModelKt", (boolean)false, (int)2, null)) break block7;
                }
                String string = it.getClassName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"it.className");
                if (StringsKt.startsWith$default((String)string, (String)"androidx.lifecycle", (boolean)false, (int)2, null)) {
                    return true;
                }
            }
            boolean bl3 = false;
            if (bl3) {
                return true;
            }
            ++n;
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isComposeNotFoundThrowable(Throwable throwable) {
        if (!(throwable instanceof NoSuchMethodException)) return false;
        String string = ((NoSuchMethodException)throwable).getStackTrace()[1].getMethodName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"throwable.getStackTrace()[1].methodName");
        if (!StringsKt.startsWith$default((String)string, (String)"invokeComposableViaReflection", (boolean)false, (int)2, null)) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isPreviewParameterMismatchThrowable(Throwable throwable) {
        if (!(throwable instanceof IllegalArgumentException)) return false;
        if (!Intrinsics.areEqual((Object)((IllegalArgumentException)throwable).getMessage(), (Object)"argument type mismatch")) return false;
        StackTraceElement[] stackTraceElementArray = ((IllegalArgumentException)throwable).getStackTrace();
        Intrinsics.checkNotNullExpressionValue((Object)stackTraceElementArray, (String)"throwable.stackTrace");
        StackTraceElement stackTraceElement = (StackTraceElement)CollectionsKt.firstOrNull((List)ArraysKt.drop((Object[])stackTraceElementArray, (int)5));
        Object object = stackTraceElement;
        if (stackTraceElement == null) return false;
        String string = ((StackTraceElement)object).getMethodName();
        object = string;
        if (string == null) return false;
        boolean bl = StringsKt.startsWith$default((String)object, (String)"invokeComposableViaReflection", (boolean)false, (int)2, null);
        if (!bl) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isFailToLoadPreviewParameterProvider(Throwable throwable) {
        if (!(throwable instanceof NoSuchMethodException)) return false;
        String string = ((NoSuchMethodException)throwable).getMessage();
        if (string == null) return false;
        if (!StringsKt.endsWith$default((String)string, (String)"$FailToLoadPreviewParameterProvider", (boolean)false, (int)2, null)) return false;
        return true;
    }

    @JvmStatic
    public static final boolean isHandledByComposeContributor(@Nullable Throwable throwable) {
        return INSTANCE.isComposeNotFoundThrowable(throwable) || INSTANCE.isCompositionLocalStackTrace(throwable) || INSTANCE.isPreviewParameterMismatchThrowable(throwable) || INSTANCE.isFailToLoadPreviewParameterProvider(throwable) || INSTANCE.isViewModelStackTrace(throwable);
    }

    /*
     * WARNING - void declaration
     */
    @JvmStatic
    @NotNull
    public static final List<RenderErrorModel.Issue> reportComposeErrors(@NotNull RenderLogger logger2, @NotNull HtmlLinkManager linkManager, @NotNull HyperlinkListener linkHandler) {
        void $this$mapTo$iv$iv;
        Iterable $this$mapNotNullTo$iv$iv;
        Object it;
        Iterable $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)logger2, (String)"logger");
        Intrinsics.checkNotNullParameter((Object)linkManager, (String)"linkManager");
        Intrinsics.checkNotNullParameter((Object)linkHandler, (String)"linkHandler");
        List<RenderProblem> list2 = logger2.getMessages();
        Intrinsics.checkNotNullExpressionValue(list2, (String)"logger.messages");
        Iterable $this$filter$iv = list2;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (RenderProblem)element$iv$iv;
            boolean bl = false;
            if (!Intrinsics.areEqual((Object)((RenderProblem)it).getTag(), (Object)"INFLATE")) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$mapNotNull$iv = (List)destination$iv$iv;
        boolean $i$f$mapNotNull = false;
        $this$filterTo$iv$iv = $this$mapNotNull$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        it = $this$forEach$iv$iv$iv.iterator();
        while (it.hasNext()) {
            RenderErrorModel.Issue.Builder builder2;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = it.next();
            boolean bl = false;
            RenderProblem it2 = (RenderProblem)element$iv$iv;
            boolean bl2 = false;
            if (INSTANCE.isViewModelStackTrace(it2.getThrowable())) {
                RenderErrorModel.Issue.Builder builder3 = RenderErrorModel.Issue.builder().setSeverity(HighlightSeverity.INFORMATION).setSummary("Failed to instantiate a ViewModel");
                HtmlBuilder htmlBuilder = new HtmlBuilder().addLink("This preview uses a ", "ViewModel", ". ", "https://developer.android.com/topic/libraries/architecture/viewmodel").add("ViewModels often trigger operations not supported by Compose Preview, such as database access, I/O operations, or network requests. ").addLink("You can ", "read more", " about preview limitations in our external documentation.", "https://developer.android.com/jetpack/compose/tooling");
                Intrinsics.checkNotNullExpressionValue((Object)htmlBuilder, (String)"HtmlBuilder()\n          \u2026jetpack/compose/tooling\")");
                Module module2 = logger2.getModule();
                builder2 = builder3.setHtmlContent(RenderErrorContributorUtilKt.addShowException(htmlBuilder, linkManager, (Project)(module2 != null ? module2.getProject() : null), it2.getThrowable()));
            } else if (INSTANCE.isCompositionLocalStackTrace(it2.getThrowable())) {
                RenderErrorModel.Issue.Builder builder4 = RenderErrorModel.Issue.builder().setSeverity(HighlightSeverity.INFORMATION).setSummary("Failed to instantiate Composition Local");
                HtmlBuilder htmlBuilder = new HtmlBuilder().addLink("This preview was unable to find a ", "CompositionLocal", ". ", "https://developer.android.com/jetpack/compose/compositionlocal").add("You might need to define it so it can render correctly.");
                Intrinsics.checkNotNullExpressionValue((Object)htmlBuilder, (String)"HtmlBuilder()\n          \u2026t can render correctly.\")");
                Module module3 = logger2.getModule();
                builder2 = builder4.setHtmlContent(RenderErrorContributorUtilKt.addShowException(htmlBuilder, linkManager, (Project)(module3 != null ? module3.getProject() : null), it2.getThrowable()));
            } else if (INSTANCE.isComposeNotFoundThrowable(it2.getThrowable())) {
                RenderErrorModel.Issue.Builder builder5 = RenderErrorModel.Issue.builder().setSeverity(HighlightSeverity.WARNING);
                Throwable throwable = it2.getThrowable();
                Intrinsics.checkNotNull((Object)throwable);
                RenderErrorModel.Issue.Builder builder6 = builder5.setSummary("Unable to find @Preview '" + throwable.getMessage() + "'");
                HtmlBuilder htmlBuilder = new HtmlBuilder().add("The preview will display after rebuilding the project.");
                Intrinsics.checkNotNullExpressionValue((Object)htmlBuilder, (String)"HtmlBuilder()\n          \u2026rebuilding the project.\")");
                builder2 = builder6.setHtmlContent(RenderErrorContributorUtilKt.addBuildAction(htmlBuilder, linkManager));
            } else if (INSTANCE.isPreviewParameterMismatchThrowable(it2.getThrowable())) {
                RenderErrorModel.Issue.Builder builder7 = RenderErrorModel.Issue.builder().setSeverity(HighlightSeverity.ERROR).setSummary("PreviewParameterProvider/@Preview type mismatch.");
                HtmlBuilder htmlBuilder = new HtmlBuilder().add("The type of the PreviewParameterProvider must match the @Preview input parameter type annotated with it.");
                Intrinsics.checkNotNullExpressionValue((Object)htmlBuilder, (String)"HtmlBuilder()\n          \u2026type annotated with it.\")");
                builder2 = builder7.setHtmlContent(RenderErrorContributorUtilKt.addBuildAction(htmlBuilder, linkManager));
            } else {
                builder2 = INSTANCE.isFailToLoadPreviewParameterProvider(it2.getThrowable()) ? RenderErrorModel.Issue.builder().setSeverity(HighlightSeverity.ERROR).setSummary("Fail to load PreviewParameterProvider").setHtmlContent(new HtmlBuilder().add("There was problem to load the PreviewParameterProvider defined. Please double-check its constructor and the values property implementation. The IDE logs should contain the full exception stack trace.")) : null;
            }
            if (builder2 == null) continue;
            RenderErrorModel.Issue.Builder it$iv$iv = builder2;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        Iterable $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$mapNotNullTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (RenderErrorModel.Issue.Builder)item$iv$iv;
            Collection collection2 = destination$iv$iv;
            boolean bl = false;
            collection2.add(((RenderErrorModel.Issue.Builder)it).setLinkHandler(linkHandler).build());
        }
        return (List)destination$iv$iv;
    }
}

