/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.rendering.classloading;

import com.android.tools.idea.editors.literals.LiteralUsageReference;
import com.android.tools.idea.rendering.classloading.ConstantRemapper;
import com.android.tools.idea.rendering.classloading.ProjectConstantRemapper;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.SimpleModificationTracker;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@Service
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010#\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010%\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0002\b\u0007\u0018\u0000 #2\u00020\u0001:\u0001#B\u0005\u00a2\u0006\u0002\u0010\u0002J*\u0010\u0012\u001a\u00020\u00062\b\u0010\u0013\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00112\u0006\u0010\u0017\u001a\u00020\u0011H\u0016J\b\u0010\u0018\u001a\u00020\u0005H\u0007J\u0012\u0010\u0019\u001a\u00020\u001a2\b\u0010\u0013\u001a\u0004\u0018\u00010\u000fH\u0016J\b\u0010\u001b\u001a\u00020\u001cH\u0016J\b\u0010\u001d\u001a\u00020\u0006H\u0016J.\u0010\u001e\u001a\u0004\u0018\u00010\u00112\b\u0010\u001f\u001a\u0004\u0018\u00010\u00112\u0006\u0010 \u001a\u00020\u00052\u0006\u0010!\u001a\u00020\"2\b\u0010\u0016\u001a\u0004\u0018\u00010\u0011H\u0016R\u001a\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00050\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\t\u001a\u00070\n\u00a2\u0006\u0002\b\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R&\u0010\u000e\u001a\u001a\u0012\u0004\u0012\u00020\u000f\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00110\u00100\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lcom/android/tools/idea/rendering/classloading/ProjectConstantRemapper;", "Lcom/android/tools/idea/rendering/classloading/ConstantRemapper;", "()V", "allKeys", "Ljava/util/WeakHashMap;", "", "", "initialValueCache", "", "log", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "modificationTracker", "Lcom/intellij/openapi/util/SimpleModificationTracker;", "perClassLoaderConstantMap", "Ljava/lang/ClassLoader;", "", "", "addConstant", "classLoader", "reference", "Lcom/android/tools/idea/editors/literals/LiteralUsageReference;", "initialValue", "newValue", "allKeysToText", "clearConstants", "", "getModificationCount", "", "hasConstants", "remapConstant", "source", "fileName", "offset", "", "Companion", "intellij.android.core"})
public final class ProjectConstantRemapper
implements ConstantRemapper {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Logger log;
    @NotNull
    private final WeakHashMap<ClassLoader, Map<String, Object>> perClassLoaderConstantMap;
    @NotNull
    private final WeakHashMap<String, Boolean> allKeys;
    @NotNull
    private final Set<String> initialValueCache;
    @NotNull
    private final SimpleModificationTracker modificationTracker;

    public ProjectConstantRemapper() {
        Logger logger2 = Logger.getInstance(ConstantRemapper.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"getInstance(ConstantRemapper::class.java)");
        this.log = logger2;
        this.perClassLoaderConstantMap = new WeakHashMap();
        this.allKeys = new WeakHashMap();
        this.initialValueCache = new LinkedHashSet();
        this.modificationTracker = new SimpleModificationTracker();
    }

    @Override
    public boolean addConstant(@Nullable ClassLoader classLoader, @NotNull LiteralUsageReference reference, @NotNull Object initialValue, @NotNull Object newValue) {
        Intrinsics.checkNotNullParameter((Object)reference, (String)"reference");
        Intrinsics.checkNotNullParameter((Object)initialValue, (String)"initialValue");
        Intrinsics.checkNotNullParameter((Object)newValue, (String)"newValue");
        Map<String, Object> classLoaderMap2 = this.perClassLoaderConstantMap.computeIfAbsent(classLoader, addConstant.classLoaderMap.1.INSTANCE);
        String serializedValue = initialValue.toString();
        this.initialValueCache.add(serializedValue);
        String lookupKey = reference.getFileName() + ":" + reference.getRange().getStartOffset() + ":" + serializedValue;
        if (this.allKeys.put(lookupKey, true) == null) {
            this.modificationTracker.incModificationCount();
        }
        return !Intrinsics.areEqual((Object)classLoaderMap2.put(lookupKey, newValue), (Object)newValue);
    }

    @Override
    public void clearConstants(@Nullable ClassLoader classLoader) {
        block1: {
            Map<String, Object> map2 = this.perClassLoaderConstantMap.get(classLoader);
            if (map2 == null) break block1;
            Map<String, Object> it = map2;
            boolean bl = false;
            if (!it.isEmpty()) {
                this.modificationTracker.incModificationCount();
                it.clear();
            }
        }
    }

    @TestOnly
    @NotNull
    public final String allKeysToText() {
        Set<String> set = this.allKeys.keySet();
        Intrinsics.checkNotNullExpressionValue(set, (String)"allKeys.keys");
        return CollectionsKt.joinToString$default((Iterable)set, (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null);
    }

    @Override
    @Nullable
    public Object remapConstant(@Nullable Object source, @NotNull String fileName, int offset, @Nullable Object initialValue) {
        ClassLoader classLoader;
        String serializedValue;
        Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
        Object object = initialValue;
        String string = serializedValue = object != null ? object.toString() : null;
        if (serializedValue == null || !this.initialValueCache.contains(serializedValue)) {
            return initialValue;
        }
        Class<?> clazz = source;
        ClassLoader classLoader2 = classLoader = clazz != null && (clazz = clazz.getClass()) != null ? clazz.getClassLoader() : null;
        Map<String, Object> map2 = this.perClassLoaderConstantMap.get(classLoader);
        if (map2 == null && (map2 = this.perClassLoaderConstantMap.get(null)) == null) {
            return initialValue;
        }
        Map<String, Object> classLoaderMap2 = map2;
        String lookupKey = fileName + ":" + offset + ":" + serializedValue;
        Logger $this$debug$iv = this.log;
        Exception e$iv = null;
        boolean $i$f$debug = false;
        if ($this$debug$iv.isDebugEnabled()) {
            Logger logger2 = $this$debug$iv;
            boolean bl = false;
            logger2.debug("Constant lookup " + lookupKey + " (present=" + classLoaderMap2.containsKey(lookupKey) + ")", (Throwable)e$iv);
        }
        return classLoaderMap2.getOrDefault(lookupKey, initialValue);
    }

    @Override
    public boolean hasConstants() {
        boolean bl;
        block3: {
            Collection<Map<String, Object>> collection2 = this.perClassLoaderConstantMap.values();
            Intrinsics.checkNotNullExpressionValue(collection2, (String)"perClassLoaderConstantMap.values");
            Iterable $this$any$iv = collection2;
            boolean $i$f$any = false;
            if (((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    Map it = (Map)element$iv;
                    boolean bl2 = false;
                    Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                    boolean bl3 = !it.isEmpty();
                    if (!bl3) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    public long getModificationCount() {
        return this.modificationTracker.getModificationCount();
    }

    @JvmStatic
    @NotNull
    public static final ConstantRemapper getInstance(@NotNull Project project) {
        return Companion.getInstance(project);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0007\u00a8\u0006\u0007"}, d2={"Lcom/android/tools/idea/rendering/classloading/ProjectConstantRemapper$Companion;", "", "()V", "getInstance", "Lcom/android/tools/idea/rendering/classloading/ConstantRemapper;", "project", "Lcom/intellij/openapi/project/Project;", "intellij.android.core"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final ConstantRemapper getInstance(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Object object = project.getService(ConstantRemapper.class);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"project.getService(ConstantRemapper::class.java)");
            return (ConstantRemapper)object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

