/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.rendering.classloading;

import com.android.tools.idea.rendering.classloading.ClassTransform;
import com.android.tools.idea.rendering.classloading.ClassWriterWithPseudoClassLocator;
import com.android.tools.idea.rendering.classloading.PseudoClassLocator;
import com.google.common.primitives.Ints;
import com.google.common.primitives.Shorts;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.util.lang.JavaVersion;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.org.objectweb.asm.ClassReader;
import org.jetbrains.org.objectweb.asm.ClassVisitor;

public class ClassConverter {
    private static final int ourCurrentJdkClassVersion = ClassConverter.jdkToClassVersion(SystemInfo.JAVA_VERSION);

    @NotNull
    public static byte[] rewriteClass(@NotNull byte[] classData, @NotNull ClassTransform transformations, int flags, @NotNull PseudoClassLocator classLocator) {
        ClassReader reader2 = new ClassReader(classData);
        ClassWriterWithPseudoClassLocator classWriter = new ClassWriterWithPseudoClassLocator(flags, classLocator);
        ClassVisitor classVisitor = transformations.invoke((ClassVisitor)classWriter);
        reader2.accept(classVisitor, 8);
        return classWriter.toByteArray();
    }

    @NotNull
    static byte[] rewriteClass(@NotNull byte[] classData, @NotNull ClassTransform transformations, @NotNull PseudoClassLocator classLocator) {
        return ClassConverter.rewriteClass(classData, transformations, 2, classLocator);
    }

    public static int jdkToClassVersion(@NotNull String version2) {
        JavaVersion javaVersion = JavaVersion.tryParse((String)version2);
        return javaVersion != null ? javaVersion.feature + 44 : -1;
    }

    public static String classVersionToJdk(int version2) {
        if (version2 >= 53) {
            return Integer.toString(version2 - 53 + 9);
        }
        return "1." + Integer.toString(version2 - 44);
    }

    public static int getCurrentClassVersion() {
        return ourCurrentJdkClassVersion;
    }

    public static boolean isValidClassFile(@NotNull byte[] classData) {
        return classData.length >= 7 && ClassConverter.getMagic(classData) == -889275714;
    }

    public static int getMagic(@NotNull byte[] classData) {
        return Ints.fromBytes((byte)classData[0], (byte)classData[1], (byte)classData[2], (byte)classData[3]);
    }

    public static short getMajorVersion(byte[] classData) {
        return Shorts.fromBytes((byte)classData[6], (byte)classData[7]);
    }

    public static short getMinorVersion(byte[] classData) {
        return Shorts.fromBytes((byte)classData[4], (byte)classData[5]);
    }
}

