/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.rendering.actions;

import com.android.tools.idea.rendering.RenderAsyncActionExecutor;
import com.android.tools.idea.rendering.RenderService;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.ui.DialogBuilder;
import com.intellij.openapi.ui.DialogPanel;
import com.intellij.ui.components.ComponentsKt;
import com.intellij.ui.layout.Cell;
import com.intellij.ui.layout.LCFlags;
import com.intellij.ui.layout.LayoutBuilder;
import com.intellij.ui.layout.LayoutImplKt;
import com.intellij.ui.layout.LayoutKt;
import com.intellij.ui.layout.Row;
import com.intellij.ui.layout.RowBuilder;
import com.intellij.util.concurrency.AppExecutorUtil;
import java.awt.Container;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.MutablePropertyReference0Impl;
import kotlin.random.Random;
import kotlin.ranges.RangesKt;
import kotlin.reflect.KMutableProperty0;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0018\u001a\u00020\u00072\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J\b\u0010\u001b\u001a\u00020\nH\u0002J\u0018\u0010\u001c\u001a\u00020\n2\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001d\u001a\u00020\u0007H\u0016R\u0013\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\r\u001a\u00020\f2\u0006\u0010\u000b\u001a\u00020\f@BX\u0082\u000e\u00a2\u0006\b\n\u0000\"\u0004\b\u000e\u0010\u000fR\u001e\u0010\u0010\u001a\u00020\f2\u0006\u0010\u000b\u001a\u00020\f@BX\u0082\u000e\u00a2\u0006\b\n\u0000\"\u0004\b\u0011\u0010\u000fR\u001e\u0010\u0012\u001a\u00020\f2\u0006\u0010\u000b\u001a\u00020\f@BX\u0082\u000e\u00a2\u0006\b\n\u0000\"\u0004\b\u0013\u0010\u000fR\u001e\u0010\u0014\u001a\u00020\f2\u0006\u0010\u000b\u001a\u00020\f@BX\u0082\u000e\u00a2\u0006\b\n\u0000\"\u0004\b\u0015\u0010\u000fR\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lcom/android/tools/idea/rendering/actions/RenderLaggingMode;", "Lcom/intellij/openapi/actionSystem/ToggleAction;", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "enabled", "", "lagger", "Lkotlin/Function0;", "", "value", "", "maxSpaceTimeMs", "setMaxSpaceTimeMs", "(I)V", "maxWaitTimeMs", "setMaxWaitTimeMs", "minSpaceTimeMs", "setMinSpaceTimeMs", "minWaitTimeMs", "setMinWaitTimeMs", "sleepLock", "Ljava/util/concurrent/locks/ReentrantReadWriteLock;", "isSelected", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "reschedule", "setSelected", "state", "intellij.android.core"})
public final class RenderLaggingMode
extends ToggleAction {
    @NotNull
    private final Logger LOG;
    private boolean enabled;
    private int minWaitTimeMs;
    private int maxWaitTimeMs;
    private int minSpaceTimeMs;
    private int maxSpaceTimeMs;
    @NotNull
    private final ReentrantReadWriteLock sleepLock;
    @NotNull
    private final Function0<Unit> lagger;

    public RenderLaggingMode() {
        super("Enable Layout Preview Lagging Mode");
        Logger logger2 = Logger.getInstance(RenderLaggingMode.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"getInstance(RenderLaggingMode::class.java)");
        this.LOG = logger2;
        this.minWaitTimeMs = (int)TimeUnit.SECONDS.toMillis(2L);
        this.maxWaitTimeMs = (int)TimeUnit.SECONDS.toMillis(4L);
        this.minSpaceTimeMs = 500;
        this.maxSpaceTimeMs = (int)TimeUnit.SECONDS.toMillis(5L);
        this.sleepLock = new ReentrantReadWriteLock();
        this.lagger = (Function0)new Function0<Unit>(this){
            final /* synthetic */ RenderLaggingMode this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final void invoke() {
                if (RenderLaggingMode.access$getEnabled$p(this.this$0)) {
                    RenderAsyncActionExecutor renderAsyncActionExecutor = RenderService.getRenderAsyncActionExecutor();
                    RenderLaggingMode renderLaggingMode = this.this$0;
                    RenderAsyncActionExecutor $this$invoke_u24lambda_u2d0 = renderAsyncActionExecutor;
                    boolean bl = false;
                    long waitTimeMs = Random.Default.nextLong((long)RenderLaggingMode.access$getMinWaitTimeMs$p(renderLaggingMode), (long)RenderLaggingMode.access$getMaxWaitTimeMs$p(renderLaggingMode));
                    RenderLaggingMode.access$getLOG$p(renderLaggingMode).info("Waiting " + waitTimeMs + "ms");
                    if (!RenderLaggingMode.access$getSleepLock$p(renderLaggingMode).readLock().tryLock(waitTimeMs, TimeUnit.MILLISECONDS)) {
                        RenderLaggingMode.access$getLOG$p(renderLaggingMode).info("Waited " + waitTimeMs + "ms");
                    }
                    RenderLaggingMode.access$reschedule(this.this$0);
                }
            }
        };
    }

    private final void setMinWaitTimeMs(int value2) {
        this.minWaitTimeMs = RangesKt.coerceAtMost((int)value2, (int)this.maxWaitTimeMs);
    }

    private final void setMaxWaitTimeMs(int value2) {
        this.maxWaitTimeMs = RangesKt.coerceAtLeast((int)value2, (int)this.minWaitTimeMs);
    }

    private final void setMinSpaceTimeMs(int value2) {
        this.minSpaceTimeMs = RangesKt.coerceAtMost((int)value2, (int)this.maxSpaceTimeMs);
    }

    private final void setMaxSpaceTimeMs(int value2) {
        this.maxSpaceTimeMs = RangesKt.coerceAtLeast((int)value2, (int)this.minSpaceTimeMs);
    }

    private final void reschedule() {
        if (this.enabled) {
            long spaceTimeMs = Random.Default.nextLong((long)this.minSpaceTimeMs, (long)this.maxSpaceTimeMs);
            this.LOG.info("Request scheduled in " + spaceTimeMs + "ms");
            Function0<Unit> function0 = this.lagger;
            AppExecutorUtil.getAppScheduledExecutorService().schedule(new Runnable(function0){
                private final /* synthetic */ Function0 function;
                {
                    this.function = function;
                }

                public final /* synthetic */ void run() {
                    this.function.invoke();
                }
            }, spaceTimeMs, TimeUnit.MILLISECONDS);
        }
    }

    public boolean isSelected(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        return this.enabled;
    }

    /*
     * WARNING - void declaration
     */
    public void setSelected(@NotNull AnActionEvent e, boolean state2) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        if (this.enabled) {
            this.enabled = false;
            this.sleepLock.writeLock().unlock();
        } else {
            void $this$setSelected_u24lambda_u2d0;
            LayoutBuilder builder$iv;
            DialogBuilder builder2 = new DialogBuilder();
            LCFlags[] constraints$iv = new LCFlags[]{};
            String title$iv = null;
            boolean $i$f$panel = false;
            LayoutBuilder layoutBuilder = builder$iv = LayoutImplKt.createLayoutBuilder();
            DialogBuilder dialogBuilder = builder2;
            boolean bl = false;
            RowBuilder.DefaultImpls.row$default((RowBuilder)((RowBuilder)$this$setSelected_u24lambda_u2d0), null, (boolean)false, (Function1)((Function1)new Function1<Row, Unit>(this){
                final /* synthetic */ RenderLaggingMode this$0;
                {
                    this.this$0 = $receiver;
                    super(1);
                }

                public final void invoke(@NotNull Row $this$row) {
                    Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
                    Cell.label$default((Cell)((Cell)$this$row), (String)"Min wait time", null, null, (boolean)false, (int)14, null);
                    Cell.spinner$default((Cell)((Cell)$this$row), (KMutableProperty0)((KMutableProperty0)new MutablePropertyReference0Impl((Object)((Object)this.this$0)){

                        @Nullable
                        public Object get() {
                            return RenderLaggingMode.access$getMinWaitTimeMs$p((RenderLaggingMode)((Object)this.receiver));
                        }

                        public void set(@Nullable Object value2) {
                            RenderLaggingMode.access$setMinWaitTimeMs((RenderLaggingMode)((Object)this.receiver), ((Number)value2).intValue());
                        }
                    }), (int)0, (int)90000, (int)0, (int)8, null);
                    Cell.label$default((Cell)((Cell)$this$row), (String)"ms", null, null, (boolean)false, (int)14, null);
                }
            }), (int)3, null);
            RowBuilder.DefaultImpls.row$default((RowBuilder)((RowBuilder)$this$setSelected_u24lambda_u2d0), null, (boolean)false, (Function1)((Function1)new Function1<Row, Unit>(this){
                final /* synthetic */ RenderLaggingMode this$0;
                {
                    this.this$0 = $receiver;
                    super(1);
                }

                public final void invoke(@NotNull Row $this$row) {
                    Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
                    Cell.label$default((Cell)((Cell)$this$row), (String)"Max wait time", null, null, (boolean)false, (int)14, null);
                    Cell.spinner$default((Cell)((Cell)$this$row), (KMutableProperty0)((KMutableProperty0)new MutablePropertyReference0Impl((Object)((Object)this.this$0)){

                        @Nullable
                        public Object get() {
                            return RenderLaggingMode.access$getMaxWaitTimeMs$p((RenderLaggingMode)((Object)this.receiver));
                        }

                        public void set(@Nullable Object value2) {
                            RenderLaggingMode.access$setMaxWaitTimeMs((RenderLaggingMode)((Object)this.receiver), ((Number)value2).intValue());
                        }
                    }), (int)0, (int)90000, (int)0, (int)8, null);
                    Cell.label$default((Cell)((Cell)$this$row), (String)"ms", null, null, (boolean)false, (int)14, null);
                }
            }), (int)3, null);
            RowBuilder.DefaultImpls.row$default((RowBuilder)((RowBuilder)$this$setSelected_u24lambda_u2d0), null, (boolean)false, (Function1)((Function1)new Function1<Row, Unit>(this){
                final /* synthetic */ RenderLaggingMode this$0;
                {
                    this.this$0 = $receiver;
                    super(1);
                }

                public final void invoke(@NotNull Row $this$row) {
                    Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
                    Cell.label$default((Cell)((Cell)$this$row), (String)"Min action space time", null, null, (boolean)false, (int)14, null);
                    Cell.spinner$default((Cell)((Cell)$this$row), (KMutableProperty0)((KMutableProperty0)new MutablePropertyReference0Impl((Object)((Object)this.this$0)){

                        @Nullable
                        public Object get() {
                            return RenderLaggingMode.access$getMinSpaceTimeMs$p((RenderLaggingMode)((Object)this.receiver));
                        }

                        public void set(@Nullable Object value2) {
                            RenderLaggingMode.access$setMinSpaceTimeMs((RenderLaggingMode)((Object)this.receiver), ((Number)value2).intValue());
                        }
                    }), (int)0, (int)90000, (int)0, (int)8, null);
                    Cell.label$default((Cell)((Cell)$this$row), (String)"ms", null, null, (boolean)false, (int)14, null);
                }
            }), (int)3, null);
            RowBuilder.DefaultImpls.row$default((RowBuilder)((RowBuilder)$this$setSelected_u24lambda_u2d0), null, (boolean)false, (Function1)((Function1)new Function1<Row, Unit>(this){
                final /* synthetic */ RenderLaggingMode this$0;
                {
                    this.this$0 = $receiver;
                    super(1);
                }

                public final void invoke(@NotNull Row $this$row) {
                    Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
                    Cell.label$default((Cell)((Cell)$this$row), (String)"Max action space time", null, null, (boolean)false, (int)14, null);
                    Cell.spinner$default((Cell)((Cell)$this$row), (KMutableProperty0)((KMutableProperty0)new MutablePropertyReference0Impl((Object)((Object)this.this$0)){

                        @Nullable
                        public Object get() {
                            return RenderLaggingMode.access$getMaxSpaceTimeMs$p((RenderLaggingMode)((Object)this.receiver));
                        }

                        public void set(@Nullable Object value2) {
                            RenderLaggingMode.access$setMaxSpaceTimeMs((RenderLaggingMode)((Object)this.receiver), ((Number)value2).intValue());
                        }
                    }), (int)0, (int)90000, (int)0, (int)8, null);
                    Cell.label$default((Cell)((Cell)$this$row), (String)"ms", null, null, (boolean)false, (int)14, null);
                }
            }), (int)3, null);
            DialogPanel panel$iv = ComponentsKt.DialogPanel((String)title$iv, null);
            builder$iv.getBuilder().build((Container)panel$iv, constraints$iv);
            LayoutKt.initPanel((LayoutBuilder)builder$iv, (DialogPanel)panel$iv);
            dialogBuilder.setCenterPanel((JComponent)panel$iv);
            builder2.setOkOperation(new Runnable(this, builder2){
                final /* synthetic */ RenderLaggingMode this$0;
                final /* synthetic */ DialogBuilder $builder;
                {
                    this.this$0 = $receiver;
                    this.$builder = $builder;
                }

                public final void run() {
                    RenderLaggingMode.access$setEnabled$p(this.this$0, true);
                    RenderLaggingMode.access$getSleepLock$p(this.this$0).writeLock().lock();
                    RenderLaggingMode.access$reschedule(this.this$0);
                    this.$builder.getDialogWrapper().close(0);
                }
            });
            builder2.show();
        }
    }

    public static final /* synthetic */ void access$setEnabled$p(RenderLaggingMode $this, boolean bl) {
        $this.enabled = bl;
    }

    public static final /* synthetic */ ReentrantReadWriteLock access$getSleepLock$p(RenderLaggingMode $this) {
        return $this.sleepLock;
    }

    public static final /* synthetic */ void access$reschedule(RenderLaggingMode $this) {
        $this.reschedule();
    }

    public static final /* synthetic */ int access$getMinWaitTimeMs$p(RenderLaggingMode $this) {
        return $this.minWaitTimeMs;
    }

    public static final /* synthetic */ void access$setMinWaitTimeMs(RenderLaggingMode $this, int value2) {
        $this.setMinWaitTimeMs(value2);
    }

    public static final /* synthetic */ int access$getMaxWaitTimeMs$p(RenderLaggingMode $this) {
        return $this.maxWaitTimeMs;
    }

    public static final /* synthetic */ void access$setMaxWaitTimeMs(RenderLaggingMode $this, int value2) {
        $this.setMaxWaitTimeMs(value2);
    }

    public static final /* synthetic */ int access$getMinSpaceTimeMs$p(RenderLaggingMode $this) {
        return $this.minSpaceTimeMs;
    }

    public static final /* synthetic */ void access$setMinSpaceTimeMs(RenderLaggingMode $this, int value2) {
        $this.setMinSpaceTimeMs(value2);
    }

    public static final /* synthetic */ int access$getMaxSpaceTimeMs$p(RenderLaggingMode $this) {
        return $this.maxSpaceTimeMs;
    }

    public static final /* synthetic */ void access$setMaxSpaceTimeMs(RenderLaggingMode $this, int value2) {
        $this.setMaxSpaceTimeMs(value2);
    }

    public static final /* synthetic */ boolean access$getEnabled$p(RenderLaggingMode $this) {
        return $this.enabled;
    }

    public static final /* synthetic */ Logger access$getLOG$p(RenderLaggingMode $this) {
        return $this.LOG;
    }
}

