/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.rendering;

import com.android.tools.idea.rendering.Gravity;
import com.android.tools.idea.res.IdeResourcesUtil;
import com.android.utils.CharSequences;
import com.android.utils.XmlUtils;
import com.google.common.collect.ImmutableSet;
import com.intellij.application.options.CodeStyle;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.LineSeparator;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.io.Reader;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.kxml2.io.KXmlParser;
import org.xmlpull.v1.XmlPullParserException;

public class VectorDrawableTransformer {
    private static final ImmutableSet<String> NAMES_OF_HANDLED_ATTRIBUTES = ImmutableSet.of((Object)"width", (Object)"height", (Object)"viewportWidth", (Object)"viewportHeight", (Object)"tint", (Object)"alpha", (Object[])new String[0]);
    private static final String INDENT = "  ";
    private static final String DOUBLE_INDENT = "    ";

    private VectorDrawableTransformer() {
    }

    @NotNull
    public static String transform(@NotNull String originalDrawable, @NotNull Dimension targetSize) {
        return VectorDrawableTransformer.transform(originalDrawable, targetSize, Gravity.CENTER, 1.0, null, null, null, 1.0, true);
    }

    @NotNull
    public static String transform(@NotNull String originalDrawable, @NotNull Dimension targetSize, @NotNull Gravity gravity, double scaleFactor, @Nullable Rectangle2D clipRectangle, @Nullable Point2D shift, @Nullable Color tint, double opacity, boolean addClipPath) {
        KXmlParser parser2 = new KXmlParser();
        try {
            int endColumnNumber;
            boolean adjustmentNeeded;
            String prefix;
            int i;
            String alphaValue;
            int token;
            parser2.setFeature("http://xmlpull.org/v1/doc/features.html#process-namespaces", true);
            parser2.setInput((Reader)CharSequences.getReader((CharSequence)originalDrawable, (boolean)true));
            int startLine = 1;
            int startColumn = 1;
            while ((token = parser2.nextToken()) != 1 && token != 2) {
                startLine = parser2.getLineNumber();
                startColumn = parser2.getColumnNumber();
            }
            if (parser2.getEventType() != 2 || !"vector".equals(parser2.getName()) || parser2.getPrefix() != null) {
                return originalDrawable;
            }
            String originalTintValue = parser2.getAttributeValue("http://schemas.android.com/apk/res/android", "tint");
            String tintValue = tint == null ? originalTintValue : IdeResourcesUtil.colorToString(tint);
            String originalAlphaValue = parser2.getAttributeValue("http://schemas.android.com/apk/res/android", "alpha");
            if (originalAlphaValue != null) {
                opacity *= VectorDrawableTransformer.parseDoubleValue(originalAlphaValue, "");
            }
            if ((alphaValue = XmlUtils.formatFloatValue((double)opacity)).equals("1")) {
                alphaValue = null;
            }
            double targetWidth = targetSize.getWidth();
            double targetHeight = targetSize.getHeight();
            double width = targetWidth;
            double height = targetHeight;
            double originalViewportWidth = VectorDrawableTransformer.getDoubleAttributeValue(parser2, "http://schemas.android.com/apk/res/android", "viewportWidth", "");
            double originalViewportHeight = VectorDrawableTransformer.getDoubleAttributeValue(parser2, "http://schemas.android.com/apk/res/android", "viewportHeight", "");
            String widthValue = parser2.getAttributeValue("http://schemas.android.com/apk/res/android", "width");
            if (widthValue != null) {
                String suffix = VectorDrawableTransformer.getSuffix(widthValue);
                width = VectorDrawableTransformer.getDoubleAttributeValue(parser2, "http://schemas.android.com/apk/res/android", "width", suffix);
                height = VectorDrawableTransformer.getDoubleAttributeValue(parser2, "http://schemas.android.com/apk/res/android", "height", suffix);
                if (suffix.equals("dp") && width == targetWidth && height == targetHeight && originalViewportWidth == targetWidth && originalViewportHeight == targetHeight && scaleFactor == 1.0 && clipRectangle == null && Objects.equals(tintValue, originalTintValue) && Objects.equals(alphaValue, originalAlphaValue)) {
                    return originalDrawable;
                }
                if (Double.isNaN(width) || width == 0.0 || Double.isNaN(height) || height == 0.0) {
                    width = targetWidth;
                    height = targetHeight;
                }
            }
            if (Double.isNaN(originalViewportWidth) || originalViewportWidth == 0.0 || Double.isNaN(originalViewportHeight) || originalViewportHeight == 0.0) {
                originalViewportWidth = width;
                originalViewportHeight = height;
            }
            double x = 0.0;
            double y = 0.0;
            if (clipRectangle != null) {
                x += (0.5 - clipRectangle.getCenterX()) * originalViewportWidth * (scaleFactor /= Math.max(clipRectangle.getWidth(), clipRectangle.getHeight()));
                y += (0.5 - clipRectangle.getCenterY()) * originalViewportHeight * scaleFactor;
            }
            double scaleFactorX = scaleFactor;
            double scaleFactorY = scaleFactor;
            double originalAspectRatio = width / height;
            double targetAspectRatio = targetWidth / targetHeight;
            double aspectFactor = originalAspectRatio / targetAspectRatio;
            if (aspectFactor < 1.0) {
                scaleFactorX *= aspectFactor;
            } else if (aspectFactor > 1.0) {
                scaleFactorY /= aspectFactor;
            }
            x += originalViewportWidth * ((1.0 - scaleFactorX) / 2.0);
            y += originalViewportHeight * ((1.0 - scaleFactorY) / 2.0);
            if (shift != null) {
                x += originalViewportWidth * shift.getX();
                y += originalViewportHeight * shift.getY();
            }
            StringBuilder result2 = new StringBuilder(originalDrawable.length() + originalDrawable.length() / 8);
            Indenter indenter = new Indenter(originalDrawable);
            indenter.copy(1, 1, startLine, startColumn, "", result2);
            String lineSeparator = VectorDrawableTransformer.detectLineSeparator(originalDrawable);
            result2.append(String.format("<vector %s:%s=\"%s\"", "xmlns", "android", "http://schemas.android.com/apk/res/android"));
            for (i = 0; i < parser2.getNamespaceCount(1); ++i) {
                prefix = parser2.getNamespacePrefix(i);
                String uri = parser2.getNamespaceUri(i);
                if ("android".equals(prefix) && "http://schemas.android.com/apk/res/android".equals(uri)) continue;
                result2.append(String.format("%s%s%s:%s=\"%s\"", lineSeparator, DOUBLE_INDENT, "xmlns", prefix, uri));
            }
            result2.append(String.format("%s%sandroid:width=\"%sdp\"", lineSeparator, DOUBLE_INDENT, XmlUtils.formatFloatValue((double)targetWidth)));
            result2.append(String.format("%s%sandroid:height=\"%sdp\"", lineSeparator, DOUBLE_INDENT, XmlUtils.formatFloatValue((double)targetHeight)));
            result2.append(String.format("%s%sandroid:viewportWidth=\"%s\"", lineSeparator, DOUBLE_INDENT, XmlUtils.formatFloatValue((double)originalViewportWidth)));
            result2.append(String.format("%s%sandroid:viewportHeight=\"%s\"", lineSeparator, DOUBLE_INDENT, XmlUtils.formatFloatValue((double)originalViewportHeight)));
            if (tintValue != null) {
                result2.append(String.format("%s%sandroid:tint=\"%s\"", lineSeparator, DOUBLE_INDENT, tintValue));
            }
            if (alphaValue != null) {
                result2.append(String.format("%s%sandroid:alpha=\"%s\"", lineSeparator, DOUBLE_INDENT, alphaValue));
            }
            for (i = 0; i < parser2.getAttributeCount(); ++i) {
                prefix = parser2.getAttributePrefix(i);
                Object name = parser2.getAttributeName(i);
                if ("android".equals(prefix) && NAMES_OF_HANDLED_ATTRIBUTES.contains(name)) continue;
                if (prefix != null) {
                    name = prefix + ":" + (String)name;
                }
                result2.append(String.format("%s%s%s=\"%s\"", lineSeparator, DOUBLE_INDENT, name, parser2.getAttributeValue(i)));
            }
            result2.append('>');
            String indent = "";
            int copyDepth = 2;
            startLine = parser2.getLineNumber();
            startColumn = parser2.getColumnNumber();
            String translateX = VectorDrawableTransformer.isSignificantlyDifferentFromZero(x / targetWidth) ? XmlUtils.formatFloatValue((double)x) : null;
            String translateY = VectorDrawableTransformer.isSignificantlyDifferentFromZero(y / targetHeight) ? XmlUtils.formatFloatValue((double)y) : null;
            String scaleX = XmlUtils.formatFloatValue((double)scaleFactorX);
            String scaleY = XmlUtils.formatFloatValue((double)scaleFactorY);
            String clipX = XmlUtils.formatFloatValue((double)originalViewportWidth);
            String clipY = XmlUtils.formatFloatValue((double)originalViewportHeight);
            boolean bl = adjustmentNeeded = !scaleX.equals("1") || !scaleY.equals("1") || translateX != null || translateY != null;
            if (adjustmentNeeded) {
                result2.append(lineSeparator).append(INDENT);
                result2.append("<group");
                Object delimiter = " ";
                if (!scaleX.equals("1")) {
                    result2.append(String.format("%sandroid:scaleX=\"%s\"", delimiter, scaleX));
                    delimiter = lineSeparator + "      ";
                }
                if (!scaleY.equals("1")) {
                    result2.append(String.format("%sandroid:scaleY=\"%s\"", delimiter, scaleY));
                    delimiter = lineSeparator + "      ";
                }
                if (translateX != null) {
                    result2.append(String.format("%sandroid:translateX=\"%s\"", delimiter, translateX));
                    delimiter = lineSeparator + "      ";
                }
                if (translateY != null) {
                    result2.append(String.format("%sandroid:translateY=\"%s\"", delimiter, translateY));
                }
                result2.append('>');
                if (addClipPath) {
                    result2.append(lineSeparator).append(DOUBLE_INDENT);
                    result2.append(String.format("<clip-path android:pathData=\"M0,0 L0,%s L%s,%s L%s,0 z\"/>", clipY, clipX, clipY, clipX));
                }
                indent = INDENT;
            }
            while ((token = parser2.nextToken()) != 1 && token != 3 || parser2.getDepth() >= copyDepth) {
                int endLineNumber = parser2.getLineNumber();
                endColumnNumber = parser2.getColumnNumber();
                indenter.copy(startLine, startColumn, endLineNumber, endColumnNumber, token == 5 ? "" : indent, result2);
                startLine = endLineNumber;
                startColumn = endColumnNumber;
            }
            if (startColumn > INDENT.length() + 1) {
                result2.append(lineSeparator);
                startColumn = 1;
            }
            if (adjustmentNeeded) {
                if (startColumn == 1) {
                    result2.append(INDENT);
                }
                result2.append(String.format("</group>%s", lineSeparator));
            }
            while (token != 1) {
                int endLineNumber = parser2.getLineNumber();
                endColumnNumber = parser2.getColumnNumber();
                indenter.copy(startLine, startColumn, endLineNumber, endColumnNumber, "", result2);
                startLine = endLineNumber;
                startColumn = endColumnNumber;
                token = parser2.nextToken();
            }
            return result2.toString();
        }
        catch (IOException | XmlPullParserException e) {
            return originalDrawable;
        }
    }

    public static String merge(@NotNull String drawable1, @NotNull String drawable2) {
        KXmlParser parser2 = new KXmlParser();
        try {
            int endColumnNumber;
            int endLineNumber;
            int token;
            parser2.setFeature("http://xmlpull.org/v1/doc/features.html#process-namespaces", true);
            parser2.setInput((Reader)CharSequences.getReader((CharSequence)drawable1, (boolean)true));
            while ((token = parser2.nextToken()) != 1 && token != 2) {
            }
            if (parser2.getEventType() != 2 || !"vector".equals(parser2.getName()) || parser2.getPrefix() != null) {
                return drawable1;
            }
            StringBuilder result2 = new StringBuilder(drawable1.length() + drawable2.length());
            Indenter indenter = new Indenter(drawable1);
            int startLine = 1;
            int startColumn = 1;
            while ((token = parser2.nextToken()) != 1 && token != 3 || parser2.getDepth() > 1) {
                endLineNumber = parser2.getLineNumber();
                endColumnNumber = parser2.getColumnNumber();
                indenter.copy(startLine, startColumn, endLineNumber, endColumnNumber, "", result2);
                startLine = endLineNumber;
                startColumn = endColumnNumber;
            }
            parser2.setInput((Reader)CharSequences.getReader((CharSequence)drawable2, (boolean)true));
            while ((token = parser2.nextToken()) != 1 && token != 2) {
            }
            if (parser2.getEventType() != 2 || !"vector".equals(parser2.getName()) || parser2.getPrefix() != null) {
                return drawable1;
            }
            startLine = parser2.getLineNumber();
            startColumn = parser2.getColumnNumber();
            indenter = new Indenter(drawable2);
            while (parser2.nextToken() != 1) {
                endLineNumber = parser2.getLineNumber();
                endColumnNumber = parser2.getColumnNumber();
                indenter.copy(startLine, startColumn, endLineNumber, endColumnNumber, "", result2);
                startLine = endLineNumber;
                startColumn = endColumnNumber;
            }
            return result2.toString();
        }
        catch (IOException | XmlPullParserException e) {
            return drawable1;
        }
    }

    @Nullable
    public static Point2D getViewportSize(@NotNull String drawable) {
        KXmlParser parser2 = new KXmlParser();
        try {
            int token;
            parser2.setFeature("http://xmlpull.org/v1/doc/features.html#process-namespaces", true);
            parser2.setInput((Reader)CharSequences.getReader((CharSequence)drawable, (boolean)true));
            while ((token = parser2.nextToken()) != 1 && token != 2) {
            }
            if (parser2.getEventType() != 2 || !"vector".equals(parser2.getName()) || parser2.getPrefix() != null) {
                return null;
            }
            double viewportWidth = VectorDrawableTransformer.getDoubleAttributeValue(parser2, "http://schemas.android.com/apk/res/android", "viewportWidth", "");
            double viewportHeight = VectorDrawableTransformer.getDoubleAttributeValue(parser2, "http://schemas.android.com/apk/res/android", "viewportHeight", "");
            return new Point2D.Double(viewportWidth, viewportHeight);
        }
        catch (IOException | XmlPullParserException e) {
            return null;
        }
    }

    @Nullable
    public static Dimension getSizeDp(@NotNull String drawable) {
        KXmlParser parser2 = new KXmlParser();
        try {
            String suffix;
            int token;
            parser2.setFeature("http://xmlpull.org/v1/doc/features.html#process-namespaces", true);
            parser2.setInput((Reader)CharSequences.getReader((CharSequence)drawable, (boolean)true));
            while ((token = parser2.nextToken()) != 1 && token != 2) {
            }
            if (parser2.getEventType() != 2 || !"vector".equals(parser2.getName()) || parser2.getPrefix() != null) {
                return null;
            }
            String widthValue = parser2.getAttributeValue("http://schemas.android.com/apk/res/android", "width");
            if (widthValue != null && (suffix = VectorDrawableTransformer.getSuffix(widthValue)).equals("dp")) {
                double width = VectorDrawableTransformer.getDoubleAttributeValue(parser2, "http://schemas.android.com/apk/res/android", "width", suffix);
                double height = VectorDrawableTransformer.getDoubleAttributeValue(parser2, "http://schemas.android.com/apk/res/android", "height", suffix);
                return new Dimension(Math.round((float)width), Math.round((float)height));
            }
            return null;
        }
        catch (IOException | XmlPullParserException e) {
            return null;
        }
    }

    private static String detectLineSeparator(@NotNull CharSequence str) {
        LineSeparator separator = StringUtil.detectSeparators((CharSequence)str);
        if (separator != null) {
            return separator.getSeparatorString();
        }
        return CodeStyle.getDefaultSettings().getLineSeparator();
    }

    private static double getDoubleAttributeValue(@NotNull KXmlParser parser2, @NotNull String namespaceUri, @NotNull String attributeName, @NotNull String expectedSuffix) {
        String value2 = parser2.getAttributeValue(namespaceUri, attributeName);
        return VectorDrawableTransformer.parseDoubleValue(value2, expectedSuffix);
    }

    private static double parseDoubleValue(String value2, @NotNull String expectedSuffix) {
        if (value2 == null || !value2.endsWith(expectedSuffix)) {
            return Double.NaN;
        }
        try {
            return Double.parseDouble(value2.substring(0, value2.length() - expectedSuffix.length()));
        }
        catch (NumberFormatException e) {
            return Double.NaN;
        }
    }

    @NotNull
    private static String getSuffix(@NotNull String value2) {
        int i = value2.length();
        while (--i >= 0 && !Character.isDigit(value2.charAt(i))) {
        }
        return value2.substring(++i);
    }

    private static boolean isSignificantlyDifferentFromZero(double value2) {
        return Math.abs(value2) >= 1.0E-6;
    }

    private static class Indenter {
        private int myLine;
        private int myColumn;
        private int myOffset;
        @NotNull
        private final CharSequence myText;

        Indenter(@NotNull CharSequence text2) {
            this.myText = text2;
            this.myLine = 1;
            this.myColumn = 1;
        }

        void copy(int fromLine, int fromColumn, int toLine, int toColumn, @NotNull String indent, @NotNull StringBuilder out) {
            char c;
            if (this.myLine != fromLine) {
                if (this.myLine > fromLine) {
                    this.myLine = 1;
                    this.myColumn = 1;
                    this.myOffset = 0;
                }
                while (this.myLine < fromLine) {
                    c = this.myText.charAt(this.myOffset);
                    if (c == '\n') {
                        ++this.myLine;
                        this.myColumn = 1;
                    } else if (this.myLine != 1 || this.myColumn != 1 || c != '\ufeff') {
                        ++this.myColumn;
                    }
                    ++this.myOffset;
                }
            }
            this.myOffset += fromColumn - this.myColumn;
            this.myColumn = fromColumn;
            while (this.myLine < toLine || this.myLine == toLine && this.myColumn < toColumn) {
                c = this.myText.charAt(this.myOffset);
                if (c == '\n') {
                    ++this.myLine;
                    this.myColumn = 1;
                } else if (this.myLine != 1 || this.myColumn != 1 || c != '\ufeff') {
                    if (this.myColumn == 1 && (c != '\r' || this.myOffset >= this.myText.length() || this.myText.charAt(this.myOffset + 1) != '\n')) {
                        out.append(indent);
                    }
                    ++this.myColumn;
                }
                ++this.myOffset;
                out.append(c);
            }
        }
    }
}

