/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.rendering;

import com.android.ide.common.rendering.api.MergeCookie;
import com.android.ide.common.rendering.api.SessionParams;
import com.android.ide.common.rendering.api.ViewInfo;
import com.android.sdklib.IAndroidTarget;
import com.android.sdklib.devices.Device;
import com.android.tools.analytics.crash.CrashReporter;
import com.android.tools.idea.configurations.Configuration;
import com.android.tools.idea.diagnostics.crash.StudioCrashReporter;
import com.android.tools.idea.layoutlib.LayoutLibrary;
import com.android.tools.idea.layoutlib.RenderingException;
import com.android.tools.idea.layoutlib.UnsupportedJavaRuntimeException;
import com.android.tools.idea.model.MergedManifestException;
import com.android.tools.idea.model.MergedManifestManager;
import com.android.tools.idea.model.MergedManifestSnapshot;
import com.android.tools.idea.projectsystem.AndroidProjectSettingsService;
import com.android.tools.idea.projectsystem.ProjectSystemUtil;
import com.android.tools.idea.rendering.RenderAsyncActionExecutor;
import com.android.tools.idea.rendering.RenderExecutor;
import com.android.tools.idea.rendering.RenderLogger;
import com.android.tools.idea.rendering.RenderProblem;
import com.android.tools.idea.rendering.RenderTask;
import com.android.tools.idea.rendering.RenderTaskAllocationTrackerKt;
import com.android.tools.idea.rendering.StackTraceCapture;
import com.android.tools.idea.rendering.classloading.ClassTransform;
import com.android.tools.idea.rendering.imagepool.ImagePool;
import com.android.tools.idea.rendering.imagepool.ImagePoolFactory;
import com.android.tools.idea.rendering.parsers.ILayoutPullParserFactory;
import com.android.tools.idea.rendering.parsers.LayoutPullParsers;
import com.android.tools.idea.rendering.parsers.TagSnapshot;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ui.configuration.ProjectSettingsService;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.ShutDownTracker;
import com.intellij.psi.PsiFile;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.concurrency.AppExecutorUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Function;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.sdk.AndroidPlatform;
import org.jetbrains.android.sdk.AndroidSdkUtils;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public class RenderService
implements Disposable {
    private static RenderExecutor ourExecutor;
    private static final Key<RenderService> KEY;
    private final Project myProject;
    private static final String JDK_INSTALL_URL = "https://developer.android.com/preview/setup-sdk.html#java8";
    private final Object myCredential = new Object();
    private final ImagePool myImagePool = ImagePoolFactory.createImagePool();
    private static final int MEASURE_SPEC_MODE_SHIFT = 30;
    private static final int MAX_MAGNITUDE = 0x2000000;
    private static final RenderAsyncActionExecutor.RenderingPriority DEFAULT_RENDERING_PRIORITY;

    @TestOnly
    public static void initializeRenderExecutor() {
        assert (ApplicationManager.getApplication().isUnitTestMode());
        ourExecutor = RenderExecutor.create();
    }

    private static void shutdownRenderExecutor() {
        ourExecutor.shutdown();
    }

    @TestOnly
    public static void shutdownRenderExecutor(long timeoutSeconds) {
        assert (ApplicationManager.getApplication().isUnitTestMode());
        ourExecutor.shutdown(timeoutSeconds);
    }

    @NotNull
    public static RenderAsyncActionExecutor getRenderAsyncActionExecutor() {
        return ourExecutor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static RenderService getInstance(@NotNull Project project) {
        Key<RenderService> key = KEY;
        synchronized (key) {
            RenderService renderService = (RenderService)project.getUserData(KEY);
            if (renderService == null) {
                renderService = new RenderService(project);
                project.putUserData(KEY, (Object)renderService);
            }
            return renderService;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TestOnly
    public static void setForTesting(@NotNull Project project, @Nullable RenderService renderService) {
        Key<RenderService> key = KEY;
        synchronized (key) {
            project.putUserData(KEY, (Object)renderService);
        }
    }

    public static boolean isCurrentThreadARenderThread() {
        return ourExecutor.isCurrentThreadARenderThread();
    }

    @VisibleForTesting
    protected RenderService(@NotNull Project project) {
        this.myProject = project;
        Disposer.register((Disposable)project, (Disposable)this);
    }

    @Nullable
    public static LayoutLibrary getLayoutLibrary(@Nullable Module module2, @Nullable IAndroidTarget target2) {
        if (module2 == null || target2 == null) {
            return null;
        }
        Project project = module2.getProject();
        AndroidPlatform platform = AndroidPlatform.getInstance(module2);
        if (platform != null) {
            try {
                return platform.getSdkData().getTargetData(target2).getLayoutLibrary(project);
            }
            catch (RenderingException renderingException) {
                // empty catch block
            }
        }
        return null;
    }

    public static boolean canRender(@Nullable PsiFile file2) {
        return file2 != null && LayoutPullParsers.isSupported(file2);
    }

    @NotNull
    public RenderLogger createLogger(@NotNull AndroidFacet facet2) {
        Module module2 = facet2.getModule();
        return new RenderLogger(module2.getName(), module2, this.myCredential);
    }

    @NotNull
    public RenderLogger getNopLogger() {
        return RenderLogger.NOP_RENDER_LOGGER;
    }

    @NotNull
    public RenderTaskBuilder taskBuilder(@NotNull AndroidFacet facet2, @NotNull Configuration configuration) {
        return new RenderTaskBuilder(this, facet2, configuration, this.myImagePool, this.myCredential);
    }

    public void dispose() {
        this.myProject.putUserData(KEY, null);
        this.myImagePool.dispose();
    }

    @Nullable
    public AndroidPlatform getPlatform(@NotNull AndroidFacet facet2) {
        return AndroidPlatform.getInstance(facet2.getModule());
    }

    @Nullable
    private static AndroidPlatform getPlatform(@NotNull AndroidFacet facet2, @Nullable RenderLogger logger2) {
        Module module2 = facet2.getModule();
        AndroidPlatform platform = AndroidPlatform.getInstance(module2);
        if (platform == null && logger2 != null) {
            RenderProblem.Html message2 = RenderProblem.create(HighlightSeverity.ERROR);
            logger2.addMessage(message2);
            message2.getHtmlBuilder().addLink("No Android SDK found. Please ", "configure", " an Android SDK.", logger2.getLinkManager().createRunnableLink(() -> {
                Project project = module2.getProject();
                ProjectSettingsService service = ProjectSettingsService.getInstance((Project)project);
                if (ProjectSystemUtil.requiresAndroidModel(project) && service instanceof AndroidProjectSettingsService) {
                    ((AndroidProjectSettingsService)service).openSdkSettings();
                    return;
                }
                AndroidSdkUtils.openModuleDependenciesConfigurable(module2);
            }));
        }
        return platform;
    }

    @Deprecated
    public static void runRenderAction(@NotNull Runnable runnable2) throws Exception {
        RenderService.runRenderAction(Executors.callable(runnable2));
    }

    @Deprecated
    public static <T> T runRenderAction(@NotNull Callable<T> callable) throws Exception {
        return ourExecutor.runAction(callable);
    }

    public static boolean isBusy() {
        return ourExecutor.isBusy();
    }

    @NotNull
    public static ViewInfo getSafeBounds(@NotNull ViewInfo view) {
        int left2 = Math.abs(view.getLeft());
        int right = Math.abs(view.getRight());
        int top = Math.abs(view.getTop());
        int bottom = Math.abs(view.getBottom());
        if (left2 < 0x2000000 && right < 0x2000000 && top < 0x2000000 && bottom < 0x2000000) {
            return view;
        }
        return new ViewInfo(null, null, 0, 0, 0, 0);
    }

    @Nullable
    public static XmlTag getXmlTag(@NotNull ViewInfo view) {
        Object cookie = view.getCookie();
        if (cookie != null) {
            if (cookie instanceof TagSnapshot) {
                TagSnapshot snapshot = (TagSnapshot)cookie;
                return snapshot.tag;
            }
            if (cookie instanceof MergeCookie && (cookie = ((MergeCookie)cookie).getCookie()) instanceof TagSnapshot) {
                TagSnapshot snapshot = (TagSnapshot)cookie;
                return snapshot.tag;
            }
            if (cookie instanceof XmlTag) {
                return (XmlTag)cookie;
            }
        }
        return null;
    }

    @NotNull
    public ImagePool getSharedImagePool() {
        return this.myImagePool;
    }

    private static Logger getLogger() {
        return Logger.getInstance(RenderService.class);
    }

    static {
        KEY = Key.create((String)RenderService.class.getName());
        ourExecutor = RenderExecutor.create();
        ShutDownTracker.getInstance().registerShutdownTask(RenderService::shutdownRenderExecutor);
        DEFAULT_RENDERING_PRIORITY = RenderAsyncActionExecutor.RenderingPriority.HIGH;
    }

    public static class RenderTaskBuilder {
        private final RenderService myService;
        private final AndroidFacet myFacet;
        private final Configuration myConfiguration;
        private final Object myCredential;
        @NotNull
        private ImagePool myImagePool;
        @Nullable
        private PsiFile myPsiFile;
        @Nullable
        private RenderLogger myLogger;
        @Nullable
        private ILayoutPullParserFactory myParserFactory;
        private boolean isSecurityManagerEnabled = true;
        private float myQuality = 1.0f;
        private boolean showDecorations = true;
        private boolean showWithToolsVisibilityAndPosition = true;
        private int myMaxRenderWidth = -1;
        private int myMaxRenderHeight = -1;
        private boolean enableLayoutScanner = false;
        private SessionParams.RenderingMode myRenderingMode = null;
        private boolean useTransparentBackground = false;
        @NotNull
        private Function<Module, MergedManifestSnapshot> myManifestProvider = module2 -> {
            try {
                return (MergedManifestSnapshot)MergedManifestManager.getMergedManifest(module2).get(1L, TimeUnit.SECONDS);
            }
            catch (InterruptedException e) {
                throw new ProcessCanceledException((Throwable)e);
            }
            catch (TimeoutException e) {
                RenderService.getLogger().warn((Throwable)e);
            }
            catch (ExecutionException e) {
                Throwable cause = e.getCause();
                if (cause instanceof ProcessCanceledException) {
                    throw (ProcessCanceledException)cause;
                }
                if (cause instanceof MergedManifestException) {
                    RenderService.getLogger().warn((Throwable)e);
                }
                RenderService.getLogger().error((Throwable)e);
            }
            return null;
        };
        private boolean privateClassLoader = false;
        private Collection<String> classesToPreload = Collections.emptyList();
        private ClassTransform myAdditionalProjectTransform = ClassTransform.getIdentity();
        private ClassTransform myAdditionalNonProjectTransform = ClassTransform.getIdentity();
        @NotNull
        private Runnable myOnNewModuleClassLoader = () -> {};
        private boolean reportOutOfDateUserClasses = true;
        @NotNull
        private RenderAsyncActionExecutor.RenderingPriority myPriority = DEFAULT_RENDERING_PRIORITY;
        private float myMinDownscalingFactor = 0.5f;

        private RenderTaskBuilder(@NotNull RenderService service, @NotNull AndroidFacet facet2, @NotNull Configuration configuration, @NotNull ImagePool defaultImagePool, @NotNull Object credential) {
            this.myService = service;
            this.myFacet = facet2;
            this.myConfiguration = configuration;
            this.myImagePool = defaultImagePool;
            this.myCredential = credential;
        }

        @NotNull
        public RenderTaskBuilder preloadClasses(Collection<String> classesToPreload) {
            this.classesToPreload = classesToPreload;
            return this;
        }

        @NotNull
        public RenderTaskBuilder usePrivateClassLoader() {
            this.privateClassLoader = true;
            return this;
        }

        @NotNull
        public RenderTaskBuilder withPsiFile(@NotNull PsiFile psiFile) {
            this.myPsiFile = psiFile;
            return this;
        }

        @NotNull
        public RenderTaskBuilder withLogger(@NotNull RenderLogger logger2) {
            this.myLogger = logger2;
            return this;
        }

        @NotNull
        public RenderTaskBuilder withParserFactory(@NotNull ILayoutPullParserFactory parserFactory) {
            this.myParserFactory = parserFactory;
            return this;
        }

        public RenderTaskBuilder withLayoutScanner(Boolean enableLayoutScanner) {
            this.enableLayoutScanner = enableLayoutScanner;
            return this;
        }

        @NotNull
        public RenderTaskBuilder disableImagePool() {
            this.myImagePool = ImagePoolFactory.getNonPooledPool();
            return this;
        }

        @NotNull
        public RenderTaskBuilder withQuality(float quality) {
            this.myQuality = quality;
            return this;
        }

        @NotNull
        public RenderTaskBuilder withMaxRenderSize(int maxRenderWidth, int maxRenderHeight) {
            this.myMaxRenderWidth = maxRenderWidth;
            this.myMaxRenderHeight = maxRenderHeight;
            return this;
        }

        @TestOnly
        @VisibleForTesting
        @NotNull
        public RenderTaskBuilder disableSecurityManager() {
            if (!ApplicationManager.getApplication().isUnitTestMode()) {
                throw new IllegalStateException("This method can only be called in unit test mode");
            }
            this.isSecurityManagerEnabled = false;
            return this;
        }

        @NotNull
        public RenderTaskBuilder disableDecorations() {
            this.showDecorations = false;
            return this;
        }

        @NotNull
        public RenderTaskBuilder disableToolsVisibilityAndPosition() {
            this.showWithToolsVisibilityAndPosition = false;
            return this;
        }

        @NotNull
        public RenderTaskBuilder withRenderingMode(@NotNull SessionParams.RenderingMode renderingMode) {
            this.myRenderingMode = renderingMode;
            return this;
        }

        @NotNull
        public RenderTaskBuilder useTransparentBackground() {
            this.useTransparentBackground = true;
            return this;
        }

        @NotNull
        public RenderTaskBuilder setMergedManifestProvider(@NotNull Function<Module, MergedManifestSnapshot> provider2) {
            this.myManifestProvider = provider2;
            return this;
        }

        @NotNull
        public RenderTaskBuilder setProjectClassesTransform(@NotNull ClassTransform transform2) {
            this.myAdditionalProjectTransform = transform2;
            return this;
        }

        @NotNull
        public RenderTaskBuilder setNonProjectClassesTransform(@NotNull ClassTransform transform2) {
            this.myAdditionalNonProjectTransform = transform2;
            return this;
        }

        @NotNull
        public RenderTaskBuilder setOnNewClassLoader(@NotNull Runnable runnable2) {
            this.myOnNewModuleClassLoader = runnable2;
            return this;
        }

        @NotNull
        public RenderTaskBuilder doNotReportOutOfDateUserClasses() {
            this.reportOutOfDateUserClasses = false;
            return this;
        }

        @NotNull
        public RenderTaskBuilder withPriority(@NotNull RenderAsyncActionExecutor.RenderingPriority priority) {
            this.myPriority = priority;
            return this;
        }

        @NotNull
        public RenderTaskBuilder withMinDownscalingFactor(float downscalingFactor) {
            this.myMinDownscalingFactor = downscalingFactor;
            return this;
        }

        @NotNull
        public CompletableFuture<RenderTask> build() {
            if (this.myLogger == null) {
                this.withLogger(this.myService.createLogger(this.myFacet));
            }
            StackTraceCapture stackTraceCaptureElement = RenderTaskAllocationTrackerKt.captureAllocationStackTrace();
            return CompletableFuture.supplyAsync(() -> {
                LayoutLibrary layoutLib;
                AndroidPlatform platform = RenderService.getPlatform(this.myFacet, this.myLogger);
                if (platform == null) {
                    return null;
                }
                IAndroidTarget target2 = this.myConfiguration.getTarget();
                if (target2 == null) {
                    this.myLogger.addMessage(RenderProblem.createPlain(HighlightSeverity.ERROR, "No render target was chosen"));
                    return null;
                }
                Module module2 = this.myFacet.getModule();
                if (module2.isDisposed()) {
                    RenderService.getLogger().warn("Module was already disposed");
                    return null;
                }
                try {
                    layoutLib = platform.getSdkData().getTargetData(target2).getLayoutLibrary(module2.getProject());
                }
                catch (UnsupportedJavaRuntimeException e) {
                    RenderProblem.Html javaVersionProblem = RenderProblem.create(HighlightSeverity.ERROR);
                    javaVersionProblem.getHtmlBuilder().add(e.getPresentableMessage()).newline().addLink("Install a supported JDK", RenderService.JDK_INSTALL_URL);
                    this.myLogger.addMessage(javaVersionProblem);
                    return null;
                }
                catch (RenderingException e) {
                    String message2 = e.getPresentableMessage();
                    message2 = message2 != null ? message2 : AndroidBundle.message("android.layout.preview.default.error.message", new Object[0]);
                    this.myLogger.addMessage(RenderProblem.createPlain(HighlightSeverity.ERROR, message2, module2.getProject(), this.myLogger.getLinkManager(), e));
                    return null;
                }
                Device device2 = this.myConfiguration.getDevice();
                if (device2 == null) {
                    this.myLogger.addMessage(RenderProblem.createPlain(HighlightSeverity.ERROR, "No device selected"));
                    return null;
                }
                try {
                    RenderTask task2 = new RenderTask(this.myFacet, this.myService, this.myConfiguration, this.myLogger, layoutLib, device2, this.myCredential, (CrashReporter)StudioCrashReporter.getInstance(), this.myImagePool, this.myParserFactory, this.isSecurityManagerEnabled, this.myQuality, stackTraceCaptureElement, this.myManifestProvider, this.privateClassLoader, this.myAdditionalProjectTransform, this.myAdditionalNonProjectTransform, this.myOnNewModuleClassLoader, this.classesToPreload, this.reportOutOfDateUserClasses, this.myPriority, this.myMinDownscalingFactor);
                    if (this.myPsiFile instanceof XmlFile) {
                        task2.setXmlFile((XmlFile)this.myPsiFile);
                    }
                    task2.setDecorations(this.showDecorations).setShowWithToolsVisibilityAndPosition(this.showWithToolsVisibilityAndPosition).setEnableLayoutScanner(this.enableLayoutScanner);
                    if (this.myMaxRenderWidth != -1 && this.myMaxRenderHeight != -1) {
                        task2.setMaxRenderSize(this.myMaxRenderWidth, this.myMaxRenderHeight);
                    }
                    if (this.useTransparentBackground) {
                        task2.setTransparentBackground();
                    }
                    if (this.myRenderingMode != null) {
                        task2.setRenderingMode(this.myRenderingMode);
                    }
                    return task2;
                }
                catch (IncorrectOperationException | AssertionError | IllegalStateException e) {
                    if (!module2.isDisposed()) {
                        throw e;
                    }
                    return null;
                }
            }, AppExecutorUtil.getAppExecutorService());
        }
    }
}

