/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.rendering;

import com.android.tools.idea.log.LogWrapper;
import com.android.tools.idea.rendering.RenderLogger;
import com.android.tools.idea.rendering.RenderSecurityManager;
import com.android.utils.ILogger;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.module.Module;
import org.jetbrains.android.sdk.AndroidPlatform;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RenderSecurityManagerFactory {
    @NotNull
    public static RenderSecurityManager create(@NotNull Module module2, @Nullable AndroidPlatform platform) {
        String projectPath = module2.getProject().getBasePath();
        String sdkPath = platform != null ? platform.getSdkData().getLocation().toString() : null;
        RenderSecurityManager securityManager = new RenderSecurityManager(sdkPath, projectPath, false);
        securityManager.setLogger((ILogger)new LogWrapper(RenderLogger.LOG).alwaysLogAsDebug(true).allowVerbose(false));
        securityManager.setAppTempDir(PathManager.getTempPath());
        return securityManager;
    }
}

