/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.rendering;

import com.android.tools.adtui.webp.WebpNativeLibHelper;
import com.android.tools.idea.rendering.RenderPropertiesAccessUtil;
import com.android.tools.idea.rendering.RenderSecurityException;
import com.android.utils.ILogger;
import com.intellij.openapi.application.PathManager;
import java.io.File;
import java.io.FileDescriptor;
import java.io.FilePermission;
import java.io.IOException;
import java.net.InetAddress;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.Permission;
import java.util.Arrays;
import java.util.PropertyPermission;
import java.util.concurrent.Callable;
import org.jetbrains.annotations.NotNull;

public class RenderSecurityManager
extends SecurityManager {
    public static final String ENABLED_PROPERTY = "android.render.sandbox";
    public static boolean sEnabled = !"false".equals(System.getProperty("android.render.sandbox"));
    private static ThreadLocal<Boolean> sIsRenderThread = new InheritableThreadLocal<Boolean>(){

        @Override
        protected synchronized Boolean initialValue() {
            return Boolean.FALSE;
        }

        @Override
        protected synchronized Boolean childValue(Boolean parentValue) {
            return parentValue;
        }
    };
    private static Object sCredential;
    private static String sLastFailedPath;
    private final String mIndexRootPath;
    private final String mCachePath;
    private final String mLogRootPath;
    private boolean mAllowSetSecurityManager;
    private boolean mDisabled;
    private final String mSdkPath;
    private final String mProjectPath;
    private final String mTempDir;
    private final String mNormalizedTempDir;
    private String mCanonicalTempDir;
    private String mAppTempDir;
    private SecurityManager myPreviousSecurityManager;
    private ILogger mLogger;
    private boolean isRestrictReads;

    @NotNull
    private static String normalizeDirectoryPath(@NotNull Path originalPath) {
        return originalPath.normalize() + originalPath.getFileSystem().getSeparator();
    }

    @NotNull
    private static String normalizeDirectoryPath(@NotNull String stringPath) {
        return RenderSecurityManager.normalizeDirectoryPath(Paths.get(stringPath, new String[0]));
    }

    public static RenderSecurityManager getCurrent() {
        SecurityManager securityManager;
        if (sIsRenderThread.get().booleanValue() && (securityManager = System.getSecurityManager()) instanceof RenderSecurityManager) {
            RenderSecurityManager manager = (RenderSecurityManager)securityManager;
            return manager.isRelevant() ? manager : null;
        }
        return null;
    }

    public RenderSecurityManager(String sdkPath, String projectPath, boolean restrictReads) {
        this.mSdkPath = sdkPath;
        this.mProjectPath = projectPath;
        this.mTempDir = System.getProperty("java.io.tmpdir");
        this.mNormalizedTempDir = new File(this.mTempDir).getPath();
        this.mIndexRootPath = RenderSecurityManager.normalizeDirectoryPath(PathManager.getIndexRoot());
        this.mLogRootPath = RenderSecurityManager.normalizeDirectoryPath(PathManager.getLogPath());
        this.mCachePath = RenderSecurityManager.normalizeDirectoryPath(Paths.get(PathManager.getSystemPath(), "caches"));
        sLastFailedPath = null;
        this.isRestrictReads = restrictReads;
    }

    public RenderSecurityManager setLogger(ILogger logger2) {
        this.mLogger = logger2;
        return this;
    }

    public RenderSecurityManager setAppTempDir(String appTempDir) {
        this.mAppTempDir = appTempDir;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setActive(boolean active, Object credential) {
        boolean isActive;
        SecurityManager current = System.getSecurityManager();
        boolean bl = isActive = current == this;
        if (active == isActive) {
            return;
        }
        if (active) {
            assert (!(current instanceof RenderSecurityManager));
            this.myPreviousSecurityManager = current;
            sIsRenderThread.set(true);
            this.mDisabled = false;
            System.setSecurityManager(this);
            sCredential = credential;
        } else {
            if (credential != sCredential) {
                throw RenderSecurityException.create("Invalid credential");
            }
            this.mAllowSetSecurityManager = true;
            try {
                if (current instanceof RenderSecurityManager) {
                    System.setSecurityManager(this.myPreviousSecurityManager);
                } else if (this.mLogger != null) {
                    sIsRenderThread.set(false);
                    this.mLogger.warning("Security manager was changed behind the scenes: ", new Object[]{current});
                }
            }
            finally {
                this.mDisabled = true;
                this.mAllowSetSecurityManager = false;
                sIsRenderThread.set(false);
            }
        }
    }

    private boolean isRelevant() {
        return sEnabled && !this.mDisabled && sIsRenderThread.get() != false;
    }

    public void dispose(Object credential) {
        this.setActive(false, credential);
    }

    public static boolean enterSafeRegion(Object credential) {
        boolean token = sEnabled;
        if (credential == sCredential) {
            sEnabled = false;
        }
        return token;
    }

    public static void exitSafeRegion(boolean token) {
        sEnabled = token;
    }

    public static void runInSafeRegion(Object credential, @NotNull Runnable runnable2) {
        boolean token = RenderSecurityManager.enterSafeRegion(credential);
        try {
            runnable2.run();
        }
        finally {
            RenderSecurityManager.exitSafeRegion(token);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T runInSafeRegion(Object credential, @NotNull Callable<T> callable) throws Exception {
        boolean token = RenderSecurityManager.enterSafeRegion(credential);
        try {
            T t = callable.call();
            return t;
        }
        finally {
            RenderSecurityManager.exitSafeRegion(token);
        }
    }

    public static String getLastFailedPath() {
        return sLastFailedPath;
    }

    @Override
    public void checkPackageAccess(String pkg) {
    }

    @Override
    public void checkPropertyAccess(String property2) {
    }

    @Override
    public void checkPropertiesAccess() {
        boolean isWithinLogger;
        if (this.isRelevant() && !RenderPropertiesAccessUtil.isPropertyAccessAllowed() && !(isWithinLogger = Arrays.stream(this.getClassContext()).anyMatch(clazz -> "Logger".equals(clazz.getSimpleName()) && "com.intellij.openapi.diagnostic.Logger".equals(clazz.getCanonicalName())))) {
            throw RenderSecurityException.create("Property", null);
        }
    }

    @Override
    public void checkLink(String lib) {
        if (this.isRelevant() && (lib.indexOf(47) != -1 || lib.indexOf(92) != -1)) {
            if (lib.startsWith(System.getProperty("java.home"))) {
                return;
            }
            if (lib.equals(new File(WebpNativeLibHelper.getLibLocation(), WebpNativeLibHelper.getLibName()).getAbsolutePath())) {
                return;
            }
            throw RenderSecurityException.create("Link", lib);
        }
    }

    @Override
    public void checkCreateClassLoader() {
    }

    @Override
    public void checkRead(String file2) {
        if (this.isRestrictReads && this.isRelevant() && !this.isReadingAllowed(file2)) {
            throw RenderSecurityException.create("Read", file2);
        }
    }

    @Override
    public void checkRead(String file2, Object context2) {
        if (this.isRestrictReads && this.isRelevant() && !this.isReadingAllowed(file2)) {
            throw RenderSecurityException.create("Read", file2);
        }
    }

    private boolean isReadingAllowed(String path2) {
        if (this.isRestrictReads) {
            try {
                path2 = RenderSecurityManager.canonicalize(path2);
            }
            catch (IOException e) {
                return false;
            }
            if (this.mSdkPath != null && path2.startsWith(this.mSdkPath)) {
                return true;
            }
            if (this.mProjectPath != null && path2.startsWith(this.mProjectPath)) {
                return true;
            }
            if (path2.startsWith("#") && path2.indexOf(File.separatorChar) == -1) {
                return true;
            }
            if (path2.endsWith(".class") || path2.endsWith(".jar")) {
                return true;
            }
            if (this.isTempDirPath(path2)) {
                return true;
            }
            String javaHome = System.getProperty("java.home");
            if (path2.startsWith(javaHome)) {
                return true;
            }
            return javaHome.endsWith("/Contents/Home") && path2.regionMatches(0, javaHome, 0, javaHome.length() - "Contents/Home".length());
        }
        return true;
    }

    private static String canonicalize(@NotNull String path2) throws IOException {
        return Paths.get(path2, new String[0]).normalize().toFile().getCanonicalPath();
    }

    private boolean isWritingAllowed(String path2) {
        try {
            path2 = RenderSecurityManager.canonicalize(path2);
            if (Files.isSymbolicLink(Paths.get(path2, new String[0]))) {
                return false;
            }
        }
        catch (IOException e) {
            return false;
        }
        return this.isTempDirPath(path2) || path2.startsWith(this.mIndexRootPath) || path2.startsWith(this.mLogRootPath) || path2.startsWith(this.mCachePath);
    }

    private boolean isTempDirPath(String path2) {
        if (path2.startsWith(this.mTempDir) || path2.startsWith(this.mNormalizedTempDir)) {
            return true;
        }
        if (this.mAppTempDir != null && path2.startsWith(this.mAppTempDir)) {
            return true;
        }
        try {
            if (this.mCanonicalTempDir == null) {
                this.mCanonicalTempDir = RenderSecurityManager.canonicalize(this.mNormalizedTempDir);
            }
            if (path2.startsWith(this.mCanonicalTempDir) || RenderSecurityManager.canonicalize(path2).startsWith(this.mCanonicalTempDir)) {
                return true;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        sLastFailedPath = path2;
        return false;
    }

    private static boolean isPropertyWriteAllowed(String name) {
        if (name.equals("sun.font.fontmanager")) {
            return true;
        }
        if (name.startsWith("sun.awt.") || name.startsWith("apple.awt.")) {
            return true;
        }
        return name.equals("user.timezone");
    }

    @Override
    public void checkExit(int status2) {
        if (this.isRelevant()) {
            throw RenderSecurityException.create("Exit", String.valueOf(status2));
        }
        super.checkExit(status2);
    }

    @Override
    public void checkPackageDefinition(String pkg) {
        if (this.isRelevant()) {
            throw RenderSecurityException.create("Package", pkg);
        }
    }

    @Override
    public void checkExec(String cmd) {
        if (this.isRelevant()) {
            throw RenderSecurityException.create("Exec", cmd);
        }
    }

    @Override
    public void checkConnect(String host, int port) {
        if (this.isRelevant()) {
            throw RenderSecurityException.create("Socket", host + ":" + port);
        }
    }

    @Override
    public void checkConnect(String host, int port, Object context2) {
        if (this.isRelevant()) {
            throw RenderSecurityException.create("Socket", host + ":" + port);
        }
    }

    @Override
    public void checkListen(int port) {
        if (this.isRelevant()) {
            throw RenderSecurityException.create("Socket", "port " + port);
        }
    }

    @Override
    public void checkAccept(String host, int port) {
        if (this.isRelevant()) {
            throw RenderSecurityException.create("Socket", host + ":" + port);
        }
    }

    @Override
    public void checkSetFactory() {
        if (this.isRelevant()) {
            throw RenderSecurityException.create("Socket", null);
        }
    }

    @Override
    public void checkMulticast(InetAddress inetAddress) {
        if (this.isRelevant()) {
            throw RenderSecurityException.create("Socket", inetAddress.getCanonicalHostName());
        }
    }

    @Override
    public void checkMulticast(InetAddress inetAddress, byte ttl) {
        if (this.isRelevant()) {
            throw RenderSecurityException.create("Socket", inetAddress.getCanonicalHostName());
        }
    }

    @Override
    public void checkDelete(String file2) {
        if (this.isRelevant()) {
            if (this.isWritingAllowed(file2)) {
                return;
            }
            throw RenderSecurityException.create("Delete", file2);
        }
    }

    @Override
    public void checkWrite(FileDescriptor fileDescriptor) {
        if (this.isRelevant()) {
            throw RenderSecurityException.create("Write", fileDescriptor.toString());
        }
    }

    @Override
    public void checkWrite(String file2) {
        if (this.isRelevant()) {
            if (this.isWritingAllowed(file2)) {
                return;
            }
            throw RenderSecurityException.create("Write", file2);
        }
    }

    @Override
    public void checkPrintJobAccess() {
        if (this.isRelevant()) {
            throw RenderSecurityException.create("Print", null);
        }
    }

    @Override
    public void checkAccess(Thread thread) {
    }

    @Override
    public void checkAccess(ThreadGroup threadGroup) {
    }

    @Override
    public void checkPermission(Permission permission) {
        String name = permission.getName();
        if ("setSecurityManager".equals(name)) {
            if (this.isRelevant()) {
                if (!this.mAllowSetSecurityManager) {
                    throw RenderSecurityException.create("Security", null);
                }
            } else if (this.mLogger != null) {
                this.mLogger.warning("RenderSecurityManager being replaced by another thread", new Object[0]);
            }
        } else if ("accessEventQueue".equals(name)) {
            if (this.isRelevant()) {
                throw RenderSecurityException.create("Event", null);
            }
        } else if ("accessClipboard".equals(name)) {
            if (this.isRelevant()) {
                throw RenderSecurityException.create("Clipboard", null);
            }
        } else if ("showWindowWithoutWarningBanner".equals(name)) {
            if (this.isRelevant()) {
                throw RenderSecurityException.create("Window", null);
            }
        } else if ("symbolic".equals(name)) {
            if (this.isRelevant()) {
                throw RenderSecurityException.create("SymbolicLinks", null);
            }
        } else if (this.isRelevant()) {
            String actions2 = permission.getActions();
            if (this.isRestrictReads && "read".equals(actions2)) {
                if (!this.isReadingAllowed(name)) {
                    throw RenderSecurityException.create("Read", name);
                }
            } else if (!(actions2.isEmpty() || actions2.equals("read") || permission instanceof FilePermission && this.isWritingAllowed(name))) {
                if (permission instanceof PropertyPermission && RenderSecurityManager.isPropertyWriteAllowed(name)) {
                    return;
                }
                throw RenderSecurityException.create("Write", name);
            }
        }
    }
}

