/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.rendering;

import com.android.ide.common.rendering.api.RenderSession;
import com.android.ide.common.rendering.api.ResourceReference;
import com.android.ide.common.rendering.api.ResourceValue;
import com.android.ide.common.rendering.api.Result;
import com.android.ide.common.rendering.api.ViewInfo;
import com.android.tools.idea.AndroidPsiUtils;
import com.android.tools.idea.rendering.RenderContext;
import com.android.tools.idea.rendering.RenderLogger;
import com.android.tools.idea.rendering.RenderResultStats;
import com.android.tools.idea.rendering.RenderTask;
import com.android.tools.idea.rendering.imagepool.ImagePool;
import com.android.tools.idea.rendering.imagepool.ImagePoolImageDisposer;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.intellij.notebook.editor.BackedVirtualFile;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RenderResult {
    private static Logger LOG = Logger.getInstance(RenderResult.class);
    @NotNull
    private final PsiFile myRenderedFile;
    @NotNull
    private final RenderLogger myLogger;
    @NotNull
    private final ImmutableList<ViewInfo> myRootViews;
    @NotNull
    private final ImmutableList<ViewInfo> mySystemRootViews;
    @NotNull
    private final ImagePool.Image myImage;
    @NotNull
    private final Result myRenderResult;
    @NotNull
    private final Map<Object, Map<ResourceReference, ResourceValue>> myDefaultProperties;
    @NotNull
    private final Map<Object, ResourceReference> myDefaultStyles;
    @NotNull
    private final Module myModule;
    private final ReadWriteLock myDisposeLock = new ReentrantReadWriteLock();
    @Nullable
    private final Object myValidatorResult;
    private final boolean myHasRequestedCustomViews;
    @Nullable
    private final RenderContext myRenderContext;
    private boolean isDisposed;
    private final RenderResultStats myStats;

    protected RenderResult(@NotNull PsiFile renderedFile, @NotNull Module module2, @NotNull RenderLogger logger2, @Nullable RenderContext renderContext, boolean hasRequestedCustomViews, @NotNull Result renderResult, @NotNull ImmutableList<ViewInfo> rootViews, @NotNull ImmutableList<ViewInfo> systemRootViews, @NotNull ImagePool.Image image, @NotNull Map<Object, Map<ResourceReference, ResourceValue>> defaultProperties, @NotNull Map<Object, ResourceReference> defaultStyles, @Nullable Object validatorResult, @NotNull RenderResultStats stats) {
        this.myModule = module2;
        this.myRenderContext = renderContext;
        this.myRenderedFile = renderedFile;
        this.myLogger = logger2;
        this.myRenderResult = renderResult;
        this.myRootViews = rootViews;
        this.mySystemRootViews = systemRootViews;
        this.myImage = image;
        this.myDefaultProperties = defaultProperties;
        this.myDefaultStyles = defaultStyles;
        this.myValidatorResult = validatorResult;
        this.myStats = stats;
        this.myHasRequestedCustomViews = hasRequestedCustomViews;
    }

    public boolean processImageIfNotDisposed(@NotNull Consumer<ImagePool.Image> processTask) {
        this.myDisposeLock.readLock().lock();
        try {
            if (this.isDisposed) {
                boolean bl = false;
                return bl;
            }
            processTask.accept(this.myImage);
            boolean bl = true;
            return bl;
        }
        finally {
            this.myDisposeLock.readLock().unlock();
        }
    }

    public void dispose() {
        this.myDisposeLock.writeLock().lock();
        try {
            this.isDisposed = true;
            ImagePoolImageDisposer.disposeImage(this.myImage);
        }
        finally {
            this.myDisposeLock.writeLock().unlock();
        }
    }

    @NotNull
    public static RenderResult create(@NotNull RenderTask renderTask, @NotNull RenderSession session, @NotNull PsiFile file2, @NotNull RenderLogger logger2, @NotNull ImagePool.Image image) {
        List rootViews = session.getRootViews();
        List systemRootViews = session.getSystemRootViews();
        Map defaultProperties = session.getDefaultNamespacedProperties();
        Map defaultStyles = session.getDefaultNamespacedStyles();
        RenderResult result2 = new RenderResult(file2, renderTask.getContext().getModule(), logger2, renderTask.getContext(), renderTask.getLayoutlibCallback().isUsed(), session.getResult(), (ImmutableList<ViewInfo>)(rootViews != null ? ImmutableList.copyOf((Collection)rootViews) : ImmutableList.of()), (ImmutableList<ViewInfo>)(systemRootViews != null ? ImmutableList.copyOf((Collection)systemRootViews) : ImmutableList.of()), image, (Map<Object, Map<ResourceReference, ResourceValue>>)(defaultProperties != null ? ImmutableMap.copyOf((Map)defaultProperties) : ImmutableMap.of()), (Map<Object, ResourceReference>)(defaultStyles != null ? ImmutableMap.copyOf((Map)defaultStyles) : ImmutableMap.of()), session.getValidationData(), RenderResultStats.getEMPTY());
        if (LOG.isDebugEnabled()) {
            LOG.debug(result2.toString());
        }
        return result2;
    }

    @NotNull
    RenderResult createWithStats(@NotNull RenderResultStats stats) {
        return new RenderResult(this.myRenderedFile, this.myModule, this.myLogger, this.myRenderContext, this.myHasRequestedCustomViews, this.myRenderResult, this.myRootViews, this.mySystemRootViews, this.myImage, this.myDefaultProperties, this.myDefaultStyles, this.myValidatorResult, this.myStats.combine(stats));
    }

    @NotNull
    public static RenderResult createBlank(@NotNull PsiFile file2) {
        return RenderResult.createErrorResult(file2, Result.Status.ERROR_UNKNOWN.createResult(""), null);
    }

    @NotNull
    public static RenderResult createRenderTaskErrorResult(@NotNull PsiFile file2, @NotNull RenderLogger logger2) {
        return RenderResult.createErrorResult(file2, Result.Status.ERROR_RENDER_TASK.createResult(), logger2);
    }

    @NotNull
    public static RenderResult createRenderTaskErrorResult(@NotNull PsiFile file2, @Nullable Throwable throwable) {
        return RenderResult.createErrorResult(file2, Result.Status.ERROR_RENDER_TASK.createResult("Render error", throwable), null);
    }

    @NotNull
    private static RenderResult createErrorResult(@NotNull PsiFile file2, @NotNull Result errorResult, @Nullable RenderLogger logger2) {
        Module module2 = ModuleUtilCore.findModuleForPsiElement((PsiElement)file2);
        assert (module2 != null);
        RenderResult result2 = new RenderResult(file2, module2, logger2 != null ? logger2 : new RenderLogger(null, module2), null, false, errorResult, (ImmutableList<ViewInfo>)ImmutableList.of(), (ImmutableList<ViewInfo>)ImmutableList.of(), ImagePool.NULL_POOLED_IMAGE, (Map<Object, Map<ResourceReference, ResourceValue>>)ImmutableMap.of(), (Map<Object, ResourceReference>)ImmutableMap.of(), null, RenderResultStats.getEMPTY());
        if (LOG.isDebugEnabled()) {
            LOG.debug(result2.toString());
        }
        return result2;
    }

    @NotNull
    public Result getRenderResult() {
        return this.myRenderResult;
    }

    @NotNull
    public RenderLogger getLogger() {
        return this.myLogger;
    }

    @NotNull
    public ImagePool.Image getRenderedImage() {
        this.myDisposeLock.readLock().lock();
        try {
            ImagePool.Image image = !this.isDisposed ? this.myImage : ImagePool.NULL_POOLED_IMAGE;
            return image;
        }
        finally {
            this.myDisposeLock.readLock().unlock();
        }
    }

    @NotNull
    public PsiFile getSourceFile() {
        VirtualFile renderedVirtualFile = this.myRenderedFile.getVirtualFile();
        if (!renderedVirtualFile.isInLocalFileSystem() && renderedVirtualFile instanceof BackedVirtualFile) {
            VirtualFile sourceVirtualFile = ((BackedVirtualFile)renderedVirtualFile).getOriginFile();
            PsiFile sourcePsiFile = AndroidPsiUtils.getPsiFileSafely((Project)this.myRenderedFile.getProject(), (VirtualFile)sourceVirtualFile);
            if (sourcePsiFile != null) {
                return sourcePsiFile;
            }
        }
        return this.myRenderedFile;
    }

    @NotNull
    public PsiFile getRenderedFile() {
        return this.myRenderedFile;
    }

    @Nullable
    public RenderContext getRenderContext() {
        return this.myRenderContext;
    }

    @NotNull
    public Module getModule() {
        return this.myModule;
    }

    @NotNull
    public ImmutableList<ViewInfo> getRootViews() {
        return this.myRootViews;
    }

    @NotNull
    public ImmutableList<ViewInfo> getSystemRootViews() {
        return this.mySystemRootViews;
    }

    @Nullable
    public Object getValidatorResult() {
        return this.myValidatorResult;
    }

    @NotNull
    public Map<Object, Map<ResourceReference, ResourceValue>> getDefaultProperties() {
        return this.myDefaultProperties;
    }

    @NotNull
    public Map<Object, ResourceReference> getDefaultStyles() {
        return this.myDefaultStyles;
    }

    public boolean hasRequestedCustomViews() {
        return this.myHasRequestedCustomViews;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("renderResult", (Object)this.myRenderResult).add("psiFile", (Object)this.myRenderedFile).add("rootViews", this.myRootViews).add("systemViews", this.mySystemRootViews).toString();
    }

    @NotNull
    public RenderResultStats getStats() {
        return this.myStats;
    }
}

