/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.rendering;

import com.android.AndroidXConstants;
import com.android.ide.common.fonts.FontFamily;
import com.android.ide.common.rendering.api.ActionBarCallback;
import com.android.ide.common.rendering.api.AdapterBinding;
import com.android.ide.common.rendering.api.DataBindingItem;
import com.android.ide.common.rendering.api.ILayoutLog;
import com.android.ide.common.rendering.api.ILayoutPullParser;
import com.android.ide.common.rendering.api.LayoutlibCallback;
import com.android.ide.common.rendering.api.ResourceNamespace;
import com.android.ide.common.rendering.api.ResourceReference;
import com.android.ide.common.rendering.api.ResourceValue;
import com.android.ide.common.rendering.api.Result;
import com.android.ide.common.resources.ProtoXmlPullParser;
import com.android.ide.common.resources.ResourceItem;
import com.android.ide.common.resources.ResourceResolver;
import com.android.ide.common.resources.ResourceVisitor;
import com.android.ide.common.resources.ResourcesUtil;
import com.android.ide.common.util.PathString;
import com.android.resources.ResourceType;
import com.android.support.AndroidxName;
import com.android.tools.idea.AndroidPsiUtils;
import com.android.tools.idea.fonts.DownloadableFontCacheService;
import com.android.tools.idea.fonts.ProjectFonts;
import com.android.tools.idea.layoutlib.LayoutLibrary;
import com.android.tools.idea.model.AndroidModuleInfo;
import com.android.tools.idea.model.Namespacing;
import com.android.tools.idea.projectsystem.GoogleMavenArtifactId;
import com.android.tools.idea.projectsystem.ProjectSystemUtil;
import com.android.tools.idea.rendering.ActionBarHandler;
import com.android.tools.idea.rendering.IRenderLogger;
import com.android.tools.idea.rendering.LayoutMetadata;
import com.android.tools.idea.rendering.RenderProblem;
import com.android.tools.idea.rendering.RenderSecurityManager;
import com.android.tools.idea.rendering.RenderTask;
import com.android.tools.idea.rendering.parsers.AaptAttrParser;
import com.android.tools.idea.rendering.parsers.ILayoutPullParserFactory;
import com.android.tools.idea.rendering.parsers.LayoutFilePullParser;
import com.android.tools.idea.rendering.parsers.LayoutPsiPullParser;
import com.android.tools.idea.rendering.parsers.TagSnapshot;
import com.android.tools.idea.res.FileResourceReader;
import com.android.tools.idea.res.LocalResourceRepository;
import com.android.tools.idea.res.ResourceIdManager;
import com.android.tools.idea.res.ResourceRepositoryManager;
import com.android.tools.idea.util.DependencyManagementUtil;
import com.android.tools.idea.util.FileExtensions;
import com.android.tools.lint.detector.api.Lint;
import com.android.utils.HtmlBuilder;
import com.android.utils.SdkUtils;
import com.android.utils.XmlUtils;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import com.google.common.io.Files;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.xml.XmlFile;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.net.MalformedURLException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.uipreview.ViewLoader;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.kxml2.io.KXmlParser;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public class LayoutlibCallbackImpl
extends LayoutlibCallback {
    private static final Logger LOG = Logger.getInstance((String)"#com.android.tools.idea.rendering.LayoutlibCallback");
    private static final int MAX_PARSER_INCLUDES = 50;
    private static final AndroidxName CLASS_WINDOR_DECOR_ACTION_BAR = new AndroidxName("android.support.v7.internal.app.WindowDecorActionBar", "androidx.appcompat.internal.app.WindowDecorActionBar");
    private static final Set<String> NOT_VIEW = ImmutableSet.of((Object)AndroidXConstants.CLASS_RECYCLER_VIEW_ADAPTER.oldName(), (Object)AndroidXConstants.CLASS_RECYCLER_VIEW_ADAPTER.newName(), (Object)AndroidXConstants.CLASS_RECYCLER_VIEW_LAYOUT_MANAGER.oldName(), (Object)AndroidXConstants.CLASS_RECYCLER_VIEW_LAYOUT_MANAGER.newName(), (Object)CLASS_WINDOR_DECOR_ACTION_BAR.oldName(), (Object)CLASS_WINDOR_DECOR_ACTION_BAR.newName(), (Object[])new String[0]);
    public static final String FD_LAYOUTLIB = "layoutlib";
    public static final String BUILD_CACHE = "build-cache";
    @NotNull
    private final AndroidFacet myFacet;
    @NotNull
    private final Module myModule;
    @NotNull
    private final ResourceIdManager myIdManager;
    @NotNull
    private final LayoutLibrary myLayoutLib;
    @Nullable
    private final Object myCredential;
    private final boolean myHasLegacyAppCompat;
    private final boolean myHasAndroidXAppCompat;
    private final Namespacing myNamespacing;
    @NotNull
    private IRenderLogger myLogger;
    @NotNull
    private final ViewLoader myClassLoader;
    @Nullable
    private String myLayoutName;
    @Nullable
    private ILayoutPullParser myLayoutEmbeddedParser;
    @Nullable
    private final ActionBarHandler myActionBarHandler;
    @NotNull
    private final RenderTask myRenderTask;
    @NotNull
    private final DownloadableFontCacheService myFontCacheService;
    private boolean myUsed;
    private Set<PathString> myParserFiles;
    private int myParserCount;
    @NotNull
    public ImmutableMap<String, TagSnapshot> myAaptDeclaredResources = ImmutableMap.of();
    private final Map<String, ResourceValue> myFontFamilies;
    private ProjectFonts myProjectFonts;
    private String myAdaptiveIconMaskPath;
    @Nullable
    private final ILayoutPullParserFactory myLayoutPullParserFactory;
    @NotNull
    private final ResourceNamespace.Resolver myImplicitNamespaces;
    private final Map<String, AtomicInteger> myLayoutCounterForSampleData = new HashMap<String, AtomicInteger>();

    public LayoutlibCallbackImpl(@NotNull RenderTask renderTask, @NotNull LayoutLibrary layoutLib, @NotNull LocalResourceRepository projectRes, @NotNull Module module2, @NotNull AndroidFacet facet2, @NotNull IRenderLogger logger2, @Nullable Object credential, @Nullable ActionBarHandler actionBarHandler, @Nullable ILayoutPullParserFactory parserFactory, @NotNull ClassLoader moduleClassLoader) {
        this.myRenderTask = renderTask;
        this.myLayoutLib = layoutLib;
        this.myIdManager = ResourceIdManager.get(module2);
        this.myFacet = facet2;
        this.myModule = module2;
        this.myLogger = logger2;
        this.myCredential = credential;
        this.myClassLoader = new ViewLoader(this.myLayoutLib, facet2, logger2, credential, moduleClassLoader);
        this.myActionBarHandler = actionBarHandler;
        this.myLayoutPullParserFactory = parserFactory;
        this.myHasLegacyAppCompat = DependencyManagementUtil.dependsOn(module2, GoogleMavenArtifactId.APP_COMPAT_V7);
        this.myHasAndroidXAppCompat = DependencyManagementUtil.dependsOn(module2, GoogleMavenArtifactId.ANDROIDX_APP_COMPAT_V7);
        this.myNamespacing = ResourceRepositoryManager.getInstance(facet2).getNamespacing();
        this.myImplicitNamespaces = this.myNamespacing == Namespacing.DISABLED ? ResourceNamespace.Resolver.TOOLS_ONLY : ResourceNamespace.Resolver.EMPTY_RESOLVER;
        this.myFontCacheService = DownloadableFontCacheService.getInstance();
        final ImmutableMap.Builder fontBuilder = ImmutableMap.builder();
        projectRes.accept(new ResourceVisitor(){

            @NotNull
            public ResourceVisitor.VisitResult visit(@NotNull ResourceItem resourceItem) {
                String rawXml;
                ResourceValue resourceValue = resourceItem.getResourceValue();
                if (resourceValue != null && (rawXml = resourceValue.getRawXmlValue()) != null && rawXml.endsWith(".xml")) {
                    fontBuilder.put((Object)rawXml, (Object)resourceValue);
                }
                return ResourceVisitor.VisitResult.CONTINUE;
            }

            public boolean shouldVisitResourceType(@NotNull ResourceType resourceType) {
                return resourceType == ResourceType.FONT;
            }
        });
        this.myFontFamilies = fontBuilder.build();
    }

    void reset() {
        this.myParserCount = 0;
        this.myParserFiles = null;
        this.myLayoutName = null;
        this.myLayoutEmbeddedParser = null;
        this.myAaptDeclaredResources = ImmutableMap.of();
    }

    public void setLogger(@NotNull IRenderLogger logger2) {
        this.myLogger = logger2;
        this.myClassLoader.setLogger(logger2);
    }

    @NotNull
    public ILayoutLog getLogger() {
        return this.myLogger;
    }

    @Nullable
    public Object loadView(@NotNull String className, @NotNull Class[] constructorSignature, @NotNull Object[] constructorParameters) throws ClassNotFoundException {
        this.myUsed = true;
        if (NOT_VIEW.contains(className)) {
            return this.myClassLoader.loadClass(className, constructorSignature, constructorParameters);
        }
        return this.myClassLoader.loadView(className, constructorSignature, constructorParameters);
    }

    public Object loadClass(@NotNull String name, @Nullable Class[] constructorSignature, @Nullable Object[] constructorArgs) throws ClassNotFoundException {
        this.myUsed = true;
        return this.myClassLoader.loadClass(name, constructorSignature, constructorArgs);
    }

    @Nullable
    public ResourceReference resolveResourceId(int id2) {
        return this.myIdManager.findById(id2);
    }

    public int getOrGenerateResourceId(@NotNull ResourceReference resource) {
        return this.myIdManager.getOrGenerateId(resource);
    }

    public boolean isUsed() {
        return this.myUsed;
    }

    @Nullable
    private static XmlPullParser getParserFromText(String fileName, @NotNull String text2) {
        try {
            NamedXmlParser parser2 = new NamedXmlParser(fileName);
            parser2.setInput(new StringReader(text2));
            return parser2;
        }
        catch (XmlPullParserException e) {
            LOG.warn("Could not create parser for " + fileName);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public XmlPullParser createXmlParserForPsiFile(@NotNull String fileName) {
        if (fileName.contains("exploded-aar") || fileName.contains(FD_LAYOUTLIB) || fileName.contains(BUILD_CACHE)) {
            return null;
        }
        boolean token = RenderSecurityManager.enterSafeRegion(this.myCredential);
        try {
            PsiFile psiFile;
            VirtualFile virtualFile = LocalFileSystem.getInstance().findFileByPath(fileName);
            if (virtualFile != null && (psiFile = AndroidPsiUtils.getPsiFileSafely((Project)this.myModule.getProject(), (VirtualFile)virtualFile)) != null) {
                ResourceValue resourceValue = this.myFontFamilies.get(fileName);
                if (resourceValue != null) {
                    FontFamily family;
                    String fontFamilyXml;
                    if (this.myProjectFonts == null) {
                        this.myProjectFonts = new ProjectFonts(this.myFacet);
                    }
                    if ((fontFamilyXml = this.myFontCacheService.toXml(family = this.myProjectFonts.getFont(resourceValue.getResourceUrl().toString()))) == null) {
                        XmlPullParser xmlPullParser = null;
                        return xmlPullParser;
                    }
                    XmlPullParser xmlPullParser = LayoutlibCallbackImpl.getParserFromText(fileName, fontFamilyXml);
                    return xmlPullParser;
                }
                String psiText = ApplicationManager.getApplication().isReadAccessAllowed() ? psiFile.getText() : (String)ApplicationManager.getApplication().runReadAction(() -> ((PsiFile)psiFile).getText());
                XmlPullParser xmlPullParser = LayoutlibCallbackImpl.getParserFromText(fileName, psiText);
                return xmlPullParser;
            }
            XmlPullParser xmlPullParser = null;
            return xmlPullParser;
        }
        finally {
            RenderSecurityManager.exitSafeRegion(token);
        }
    }

    @Nullable
    public XmlPullParser createXmlParserForFile(@NotNull String fileName) {
        try {
            ByteArrayInputStream stream = new ByteArrayInputStream(FileResourceReader.readBytes(fileName));
            Object parser2 = XmlUtils.isProtoXml((InputStream)stream) ? new NamedProtoXmlParser(fileName) : new NamedXmlParser(fileName);
            parser2.setInput(stream, null);
            return parser2;
        }
        catch (IOException | XmlPullParserException e) {
            return null;
        }
    }

    @NotNull
    public XmlPullParser createXmlParser() {
        return new NamedXmlParser(null);
    }

    public void setLayoutParser(@Nullable String layoutName, @Nullable ILayoutPullParser layoutParser) {
        this.myLayoutName = layoutName;
        this.myLayoutEmbeddedParser = layoutParser;
    }

    public void setAaptDeclaredResources(@NotNull Map<String, TagSnapshot> resources2) {
        this.myAaptDeclaredResources = ImmutableMap.copyOf(resources2);
    }

    @Nullable
    public ILayoutPullParser getLayoutEmbeddedParser() {
        return this.myLayoutEmbeddedParser;
    }

    @Nullable
    public ILayoutPullParser getParser(@NotNull ResourceValue layoutResource) {
        ImmutableMap<String, TagSnapshot> declared;
        ILayoutPullParser parser2;
        String value2 = layoutResource.getValue();
        if (value2 == null) {
            return null;
        }
        if (!this.myAaptDeclaredResources.isEmpty() && layoutResource.getResourceType() == ResourceType.AAPT) {
            TagSnapshot aaptResource = (TagSnapshot)this.myAaptDeclaredResources.get((Object)layoutResource.getValue());
            parser2 = LayoutPsiPullParser.create(aaptResource, ResourceNamespace.TODO(), (ILayoutLog)this.myLogger);
        } else {
            PathString pathString = ResourcesUtil.toFileResourcePathString((String)value2);
            if (pathString == null) {
                return null;
            }
            parser2 = this.getParser(layoutResource.getName(), layoutResource.getNamespace(), pathString);
        }
        if (parser2 instanceof AaptAttrParser && !(declared = ((AaptAttrParser)parser2).getAaptDeclaredAttrs()).isEmpty()) {
            this.myAaptDeclaredResources = ImmutableMap.builder().putAll(((AaptAttrParser)parser2).getAaptDeclaredAttrs()).putAll(this.myAaptDeclaredResources).build();
        }
        return parser2;
    }

    @Nullable
    private ILayoutPullParser getParser(@NotNull String layoutName, @NotNull ResourceNamespace namespace, @NotNull PathString xml) {
        ILayoutPullParser parser2;
        if (this.myParserFiles != null && this.myParserFiles.contains(xml)) {
            if (this.myParserCount > 50) {
                if (this.findCycles()) {
                    throw new RuntimeException(String.format("Cycle found (count=%3$d) evaluating '%1$s' with path '%2$s' (parserFiles=%4$s)", layoutName, xml.toDebugString(), this.myParserCount, StringUtil.join(this.myParserFiles, (String)", ")));
                }
                this.myParserCount = 0;
            }
        } else {
            if (this.myParserFiles == null) {
                this.myParserFiles = new HashSet<PathString>();
            }
            this.myParserFiles.add(xml);
        }
        ++this.myParserCount;
        if (this.myLayoutPullParserFactory != null && (parser2 = this.myLayoutPullParserFactory.create(xml, this)) != null) {
            return parser2;
        }
        if (layoutName.equals(this.myLayoutName) && namespace != ResourceNamespace.ANDROID) {
            parser2 = this.myLayoutEmbeddedParser;
            this.myLayoutEmbeddedParser = null;
            return parser2;
        }
        if (xml.getFilesystemUri().getScheme().equals("file")) {
            PsiFile psiFile;
            VirtualFile file2;
            AtomicInteger sampleDataCounter = this.myLayoutCounterForSampleData.get(layoutName);
            if (sampleDataCounter == null) {
                sampleDataCounter = new AtomicInteger(0);
                this.myLayoutCounterForSampleData.put(layoutName, sampleDataCounter);
            }
            String parentName = xml.getParentFileName();
            String path2 = xml.getRawPath();
            if (parentName != null && !path2.contains("exploded-aar") && !path2.contains(FD_LAYOUTLIB) && !path2.contains(BUILD_CACHE) && (parentName.startsWith("layout") || parentName.startsWith("drawable") || parentName.startsWith("menu")) && (file2 = FileExtensions.toVirtualFile(xml)) != null && (psiFile = AndroidPsiUtils.getPsiFileSafely((Project)this.myModule.getProject(), (VirtualFile)file2)) instanceof XmlFile) {
                ResourceResolver resourceResolver2 = this.myRenderTask.getContext().getConfiguration().getResourceResolver();
                LayoutPsiPullParser parser3 = LayoutPsiPullParser.create((XmlFile)psiFile, this.myLogger, false, resourceResolver2, sampleDataCounter.getAndIncrement());
                parser3.setUseSrcCompat(this.myHasLegacyAppCompat || this.myHasAndroidXAppCompat);
                if (parentName.startsWith("layout")) {
                    parser3.setProvideViewCookies(this.myRenderTask.getProvideCookiesForIncludedViews());
                }
                return parser3;
            }
        }
        return LayoutFilePullParser.create(xml, namespace);
    }

    private boolean findCycles() {
        if (this.myParserFiles.size() == 1) {
            return true;
        }
        HashMap<String, File> layoutToFile = new HashMap<String, File>();
        ArrayListMultimap includeMap = ArrayListMultimap.create();
        for (PathString path2 : this.myParserFiles) {
            File file2 = path2.toFile();
            if (file2 == null || !file2.exists()) continue;
            String layoutName = Lint.getLayoutName((File)file2);
            layoutToFile.put(layoutName, file2);
            try {
                String xml = Files.toString((File)file2, (Charset)StandardCharsets.UTF_8);
                Document document2 = XmlUtils.parseDocumentSilently((String)xml, (boolean)true);
                if (document2 == null) continue;
                NodeList includeNodeList = document2.getElementsByTagName("include");
                int n = includeNodeList.getLength();
                for (int i = 0; i < n; ++i) {
                    Element include2 = (Element)includeNodeList.item(i);
                    String included = include2.getAttribute("layout");
                    if (!included.startsWith("@layout/")) continue;
                    String resource = included.substring("@layout/".length());
                    includeMap.put((Object)layoutName, (Object)resource);
                }
                NodeList fragmentNodeList = document2.getElementsByTagName("androidx.fragment.app.FragmentContainerView");
                if (fragmentNodeList.getLength() == 0) {
                    fragmentNodeList = document2.getElementsByTagName("fragment");
                }
                int n2 = fragmentNodeList.getLength();
                for (int i = 0; i < n2; ++i) {
                    Element fragment = (Element)fragmentNodeList.item(i);
                    String included = fragment.getAttributeNS("http://schemas.android.com/tools", "layout");
                    if (!included.startsWith("@layout/")) continue;
                    String resource = included.substring("@layout/".length());
                    includeMap.put((Object)layoutName, (Object)resource);
                }
            }
            catch (IOException e) {
                LOG.warn("Could not check file " + file2 + " for cyclic dependencies", (Throwable)e);
            }
        }
        if (!includeMap.isEmpty()) {
            for (String from : includeMap.keySet()) {
                HashSet visiting;
                List<String> chain = LayoutlibCallbackImpl.dfs(from, visiting = Sets.newHashSetWithExpectedSize((int)includeMap.size()), (Multimap<String, String>)includeMap);
                if (chain == null) continue;
                RenderProblem.Html problem = RenderProblem.create(HighlightSeverity.WARNING);
                HtmlBuilder builder2 = problem.getHtmlBuilder();
                builder2.add("Found cyclical <include> chain: ");
                boolean first = true;
                Collections.reverse(chain);
                for (String layout : chain) {
                    if (first) {
                        first = false;
                    } else {
                        builder2.add(" includes ");
                    }
                    File file3 = (File)layoutToFile.get(layout);
                    if (file3 != null) {
                        try {
                            String url = SdkUtils.fileToUrlString((File)file3);
                            builder2.addLink(layout, url);
                        }
                        catch (MalformedURLException e) {
                            builder2.add(layout);
                        }
                        continue;
                    }
                    builder2.add(layout);
                }
                this.myLogger.addMessage(problem);
                return true;
            }
        }
        return false;
    }

    @Nullable
    private static List<String> dfs(String from, Set<String> visiting, Multimap<String, String> includeMap) {
        visiting.add(from);
        Collection includes = includeMap.get((Object)from);
        if (includes != null && !includes.isEmpty()) {
            for (String include2 : includes) {
                if (visiting.contains(include2)) {
                    LinkedList list2 = Lists.newLinkedList();
                    list2.add(include2);
                    list2.add(from);
                    return list2;
                }
                List<String> chain = LayoutlibCallbackImpl.dfs(include2, visiting, includeMap);
                if (chain == null) continue;
                chain.add(from);
                return chain;
            }
        }
        visiting.remove(from);
        return null;
    }

    @Nullable
    public Object getAdapterItemValue(ResourceReference adapterView, Object adapterCookie, ResourceReference itemRef, int fullPosition, int typePosition, int fullChildPosition, int typeChildPosition, ResourceReference viewRef, LayoutlibCallback.ViewAttribute viewAttribute, Object defaultValue) {
        if (viewAttribute == LayoutlibCallback.ViewAttribute.TEXT && adapterView.getName().startsWith("android_widget_")) {
            String name = adapterView.getName();
            if (viewRef.getName().equals("text2")) {
                return "Sub Item";
            }
            if (fullPosition == 0) {
                String viewName = name.substring("android_widget_".length());
                if (viewName.equals("ExpandableListView")) {
                    return "ExpandableList";
                }
                return viewName;
            }
            return "Next Item";
        }
        if (itemRef.getNamespace() == ResourceNamespace.ANDROID && viewRef.getName().equals("text2")) {
            return "Sub Item " + (fullPosition + 1);
        }
        if (viewAttribute == LayoutlibCallback.ViewAttribute.TEXT && ((String)defaultValue).isEmpty()) {
            return "Item " + (fullPosition + 1);
        }
        return null;
    }

    @Nullable
    public static String getListAdapterViewFqcn(@NotNull Class<?> clz) {
        String fqcn = clz.getName();
        if (fqcn.endsWith("ListView") || fqcn.equals("android.widget.GridView") || fqcn.equals("android.widget.Spinner")) {
            return fqcn;
        }
        if (fqcn.startsWith("android.")) {
            return null;
        }
        Class<?> superClass = clz.getSuperclass();
        if (superClass != null) {
            return LayoutlibCallbackImpl.getListAdapterViewFqcn(superClass);
        }
        return null;
    }

    private boolean isWithinIllegalParent(@NotNull Object viewObject, int depth) {
        Object parent2;
        Result result2;
        String fqcn = viewObject.getClass().getName();
        if (fqcn.endsWith("CalendarView") || !fqcn.startsWith("android.") && !fqcn.startsWith("androidx.") && !fqcn.startsWith("com.android.internal.widget.")) {
            return true;
        }
        if (depth > 0 && (result2 = this.myLayoutLib.getViewParent(viewObject)).isSuccess() && (parent2 = result2.getData()) != null) {
            return this.isWithinIllegalParent(parent2, depth - 1);
        }
        return false;
    }

    @Nullable
    public AdapterBinding getAdapterBinding(Object viewObject, Map<String, String> attributes) {
        AdapterBinding binding = LayoutMetadata.getNodeBinding(viewObject, attributes);
        if (binding != null) {
            return binding;
        }
        if (viewObject == null) {
            return null;
        }
        String listFqcn = LayoutlibCallbackImpl.getListAdapterViewFqcn(viewObject.getClass());
        if (listFqcn == null) {
            return null;
        }
        if (this.isWithinIllegalParent(viewObject, 2)) {
            return null;
        }
        int count2 = listFqcn.endsWith("GridView") ? 24 : 12;
        binding = new AdapterBinding(count2);
        if (listFqcn.endsWith("ExpandableListView")) {
            binding.addItem(new DataBindingItem("simple_expandable_list_item_2", true, 1));
        } else if (listFqcn.equals("android.widget.Spinner")) {
            binding.addItem(new DataBindingItem("simple_spinner_item", true, 1));
        } else {
            binding.addItem(new DataBindingItem("simple_list_item_2", true, 1));
        }
        return binding;
    }

    public void loadAndParseRClass() {
        this.myClassLoader.loadAndParseRClassSilently();
    }

    public ActionBarCallback getActionBarCallback() {
        return this.myActionBarHandler;
    }

    @Nullable
    public ActionBarHandler getActionBarHandler() {
        return this.myActionBarHandler;
    }

    @Nullable
    public String getResourcePackage() {
        return ProjectSystemUtil.getModuleSystem(this.myModule).getPackageName();
    }

    @Nullable
    public String getApplicationId() {
        try {
            return RenderSecurityManager.runInSafeRegion(this.myCredential, () -> {
                AndroidModuleInfo info2 = AndroidModuleInfo.getInstance(this.myModule);
                return info2 == null ? null : info2.getPackage();
            });
        }
        catch (Exception e) {
            LOG.warn((Throwable)e);
            return null;
        }
    }

    @NotNull
    public Class<?> findClass(@NotNull String name) throws ClassNotFoundException {
        Class<?> aClass = this.myClassLoader.loadClass(name, false);
        if (aClass != null) {
            return aClass;
        }
        throw new ClassNotFoundException(name + " not found.");
    }

    public boolean isClassLoaded(String name) {
        return this.myClassLoader.isClassLoaded(name);
    }

    @NotNull
    public ResourceNamespace.Resolver getImplicitNamespaces() {
        return this.myImplicitNamespaces;
    }

    public void setAdaptiveIconMaskPath(@NotNull String adaptiveIconMaskPath) {
        this.myAdaptiveIconMaskPath = adaptiveIconMaskPath;
    }

    public boolean hasLegacyAppCompat() {
        return this.myHasLegacyAppCompat;
    }

    public boolean hasAndroidXAppCompat() {
        return this.myHasAndroidXAppCompat;
    }

    public boolean isResourceNamespacingRequired() {
        return this.myNamespacing == Namespacing.REQUIRED;
    }

    public void error(@NotNull String message2, String ... details) {
        LOG.error(message2, details);
    }

    public void error(@NotNull String message2, @Nullable Throwable t) {
        LOG.error(message2, t);
    }

    public void error(@NotNull Throwable t) {
        LOG.error(t);
    }

    boolean hasLoadedClass(@NotNull String classFqn) {
        return this.myClassLoader.hasLoadedClass(classFqn);
    }

    private static class NamedProtoXmlParser
    extends ProtoXmlPullParser {
        @Nullable
        private final String myName;
        private boolean hasToolsNamespace;

        NamedProtoXmlParser(@Nullable String name) {
            this.myName = name;
            try {
                this.setFeature("http://xmlpull.org/v1/doc/features.html#process-namespaces", true);
            }
            catch (XmlPullParserException e) {
                throw new Error(e);
            }
        }

        public int next() throws XmlPullParserException, IOException {
            int tagType = super.next();
            if (!this.hasToolsNamespace && tagType == 2 || this.hasToolsNamespace && tagType == 3) {
                this.hasToolsNamespace = this.getNamespace("tools") != null;
            }
            return tagType;
        }

        public String getAttributeValue(@Nullable String namespace, @NotNull String name) {
            String toolsValue;
            if (this.hasToolsNamespace && "http://schemas.android.com/apk/res/android".equals(namespace) && (toolsValue = super.getAttributeValue("http://schemas.android.com/tools", name)) != null) {
                return toolsValue;
            }
            return super.getAttributeValue(namespace, name);
        }

        public String toString() {
            return this.myName != null ? this.myName : super.toString();
        }
    }

    private static class NamedXmlParser
    extends KXmlParser {
        @Nullable
        private final String myName;
        private boolean hasToolsNamespace;

        NamedXmlParser(@Nullable String name) {
            this.myName = name;
            try {
                this.setFeature("http://xmlpull.org/v1/doc/features.html#process-namespaces", true);
            }
            catch (XmlPullParserException e) {
                throw new Error("Internal error", e);
            }
        }

        public int next() throws XmlPullParserException, IOException {
            int tagType = super.next();
            if (!this.hasToolsNamespace && tagType == 2 || this.hasToolsNamespace && tagType == 3) {
                this.hasToolsNamespace = this.getNamespace("tools") != null;
            }
            return tagType;
        }

        public String getAttributeValue(@Nullable String namespace, @NotNull String name) {
            String toolsValue;
            if (this.hasToolsNamespace && "http://schemas.android.com/apk/res/android".equals(namespace) && (toolsValue = super.getAttributeValue("http://schemas.android.com/tools", name)) != null) {
                return toolsValue;
            }
            return super.getAttributeValue(namespace, name);
        }

        public String toString() {
            return this.myName != null ? this.myName : super.toString();
        }
    }
}

