/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.rendering;

import com.android.ide.common.rendering.api.AdapterBinding;
import com.android.ide.common.rendering.api.DataBindingItem;
import com.android.ide.common.rendering.api.ResourceNamespace;
import com.android.ide.common.rendering.api.ResourceReference;
import com.android.resources.ResourceType;
import com.android.tools.idea.rendering.LayoutlibCallbackImpl;
import com.android.tools.idea.rendering.parsers.TagSnapshot;
import com.android.tools.idea.res.IdeResourcesUtil;
import com.android.tools.lint.detector.api.Lint;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xmlpull.v1.XmlPullParser;

public class LayoutMetadata {
    public static final String DEFAULT_EXPANDABLE_LIST_ITEM = "simple_expandable_list_item_2";
    public static final String DEFAULT_LIST_ITEM = "simple_list_item_2";
    public static final String DEFAULT_SPINNER_ITEM = "simple_spinner_item";
    public static final String KEY_LV_ITEM = "listitem";
    public static final String KEY_LV_HEADER = "listheader";
    public static final String KEY_LV_FOOTER = "listfooter";
    public static final String KEY_LV_COLUMN = "numColumns";
    public static final String KEY_FRAGMENT_LAYOUT = "layout";

    private LayoutMetadata() {
    }

    public static String getProperty(@NotNull XmlPullParser parser2, @NotNull String name) {
        String value2 = parser2.getAttributeValue("http://schemas.android.com/tools", name);
        if (value2 != null && value2.isEmpty()) {
            value2 = null;
        }
        return value2;
    }

    public static String getProperty(@NotNull Node node, @NotNull String name) {
        if (node.getNodeType() == 1) {
            Element element2 = (Element)node;
            String value2 = element2.getAttributeNS("http://schemas.android.com/tools", name);
            if (value2 != null && value2.isEmpty()) {
                value2 = null;
            }
            return value2;
        }
        return null;
    }

    public static String getProperty(@NotNull TagSnapshot node, @NotNull String name) {
        String value2 = node.getAttribute(name, "http://schemas.android.com/tools");
        if (value2 != null && value2.isEmpty()) {
            value2 = null;
        }
        return value2;
    }

    private static String stripLayoutPrefix(String layout) {
        if (layout.startsWith("@android:layout/")) {
            layout = layout.substring("@android:layout/".length());
        } else if (layout.startsWith("@layout/")) {
            layout = layout.substring("@layout/".length());
        }
        return layout;
    }

    public static AdapterBinding getNodeBinding(Object viewObject, Map<String, String> attributes) {
        String listFqcn;
        if (attributes == null) {
            return null;
        }
        String header = attributes.get(KEY_LV_HEADER);
        String footer = attributes.get(KEY_LV_FOOTER);
        String layout = attributes.get(KEY_LV_ITEM);
        int count2 = 12;
        if (viewObject != null && (listFqcn = LayoutlibCallbackImpl.getListAdapterViewFqcn(viewObject.getClass())) != null && listFqcn.endsWith("GridView")) {
            int multiplier = 2;
            String columns2 = attributes.get(KEY_LV_COLUMN);
            if (columns2 != null && !columns2.isEmpty() && !columns2.equals("auto_fit")) {
                try {
                    int c = Integer.parseInt(columns2);
                    if (c >= 1 && c <= 10) {
                        multiplier = c;
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            count2 *= multiplier;
        }
        return LayoutMetadata.getNodeBinding(viewObject, header, footer, layout, count2);
    }

    private static AdapterBinding getNodeBinding(Object viewObject, String header, String footer, String layout, int count2) {
        if (layout != null || header != null || footer != null) {
            boolean isFramework;
            AdapterBinding binding = new AdapterBinding(count2);
            if (header != null) {
                isFramework = header.startsWith("@android:layout/");
                binding.addHeader(new ResourceReference(ResourceNamespace.fromBoolean((boolean)isFramework), ResourceType.LAYOUT, LayoutMetadata.stripLayoutPrefix(header)));
            }
            if (footer != null) {
                isFramework = footer.startsWith("@android:layout/");
                binding.addFooter(new ResourceReference(ResourceNamespace.fromBoolean((boolean)isFramework), ResourceType.LAYOUT, LayoutMetadata.stripLayoutPrefix(footer)));
            }
            if (layout != null) {
                isFramework = layout.startsWith("@android:layout/");
                if (isFramework) {
                    layout = layout.substring("@android:layout/".length());
                } else if (layout.startsWith("@layout/")) {
                    layout = layout.substring("@layout/".length());
                }
                binding.addItem(new DataBindingItem(layout, isFramework, 1));
            } else if (viewObject != null) {
                String listFqcn = LayoutlibCallbackImpl.getListAdapterViewFqcn(viewObject.getClass());
                if (listFqcn != null) {
                    if (listFqcn.endsWith("ExpandableListView")) {
                        binding.addItem(new DataBindingItem(DEFAULT_EXPANDABLE_LIST_ITEM, true, 1));
                    } else {
                        binding.addItem(new DataBindingItem(DEFAULT_LIST_ITEM, true, 1));
                    }
                }
            } else {
                binding.addItem(new DataBindingItem(DEFAULT_LIST_ITEM, true, 1));
            }
            return binding;
        }
        return null;
    }

    public static void setProperty(final @NotNull Project project, String title, final @NotNull XmlFile file2, final @NotNull XmlTag element2, @NotNull String name, String namespace, String value2) {
        String capitalizedName = StringUtil.capitalize((String)name);
        if (title == null) {
            title = String.format(value2 != null ? "Set %1$s" : "Clear %1$s", capitalizedName);
        }
        WriteCommandAction.writeCommandAction((Project)project, (PsiFile[])new PsiFile[]{file2}).withName(title).run(() -> {
            if (value2 == null) {
                XmlAttribute attribute = namespace != null ? element2.getAttribute(name, namespace) : element2.getAttribute(name);
                if (attribute != null) {
                    attribute.delete();
                }
            } else if (namespace != null) {
                IdeResourcesUtil.ensureNamespaceImported(file2, namespace, null);
                element2.setAttribute(name, namespace, value2);
            } else {
                element2.setAttribute(name, value2);
            }
        });
        List list2 = (List)ApplicationManager.getApplication().runReadAction((Computable)new Computable<List<XmlTag>>(){

            public List<XmlTag> compute() {
                String id2 = Lint.stripIdPrefix((String)element2.getAttributeValue("id", "http://schemas.android.com/apk/res/android"));
                if (id2.isEmpty()) {
                    return null;
                }
                VirtualFile layoutFile = file2.getVirtualFile();
                if (layoutFile != null) {
                    List<VirtualFile> variations = IdeResourcesUtil.getResourceVariations(layoutFile, false);
                    if (variations.isEmpty()) {
                        return null;
                    }
                    PsiManager manager = PsiManager.getInstance((Project)project);
                    ArrayList<XmlTag> list2 = new ArrayList<XmlTag>();
                    block0: for (VirtualFile file22 : variations) {
                        PsiFile psiFile = manager.findFile(file22);
                        if (psiFile == null) continue;
                        for (XmlTag tag : PsiTreeUtil.findChildrenOfType((PsiElement)psiFile, XmlTag.class)) {
                            XmlAttribute attribute = tag.getAttribute("id", "http://schemas.android.com/apk/res/android");
                            if (attribute == null || attribute.getValue() == null || !attribute.getValue().endsWith(id2) || !id2.equals(Lint.stripIdPrefix((String)attribute.getValue()))) continue;
                            list2.add(tag);
                            continue block0;
                        }
                    }
                    return list2;
                }
                return null;
            }
        });
        if (list2 != null && !list2.isEmpty()) {
            ArrayList<PsiFile> affectedFiles = new ArrayList<PsiFile>();
            for (XmlTag tag : list2) {
                PsiFile psiFile = tag.getContainingFile();
                if (psiFile == null) continue;
                affectedFiles.add(psiFile);
            }
            WriteCommandAction.writeCommandAction((Project)project, (PsiFile[])affectedFiles.toArray(PsiFile.EMPTY_ARRAY)).withName(title).run(() -> {
                for (XmlTag tag : list2) {
                    if (value2 == null) {
                        XmlAttribute attribute = namespace != null ? tag.getAttribute(name, namespace) : tag.getAttribute(name);
                        if (attribute == null) continue;
                        attribute.delete();
                        continue;
                    }
                    if (namespace != null) {
                        IdeResourcesUtil.ensureNamespaceImported(file2, namespace, null);
                        tag.setAttribute(name, namespace, value2);
                        continue;
                    }
                    tag.setAttribute(name, value2);
                }
            });
        }
    }
}

