/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.rendering;

import com.android.ide.common.rendering.api.RenderResources;
import com.android.ide.common.rendering.api.ResourceValue;
import com.android.resources.ResourceUrl;
import com.android.tools.idea.rendering.SetAttributeFix;
import com.android.tools.idea.res.IdeResourcesUtil;
import com.android.utils.SdkUtils;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import java.io.File;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class IncludeReference {
    public static final IncludeReference NONE = new IncludeReference(null, null, null);
    @NotNull
    private final VirtualFile myFromFile;
    @Nullable
    private final VirtualFile myToFile;
    @NotNull
    private final Module myModule;

    private IncludeReference(Module module2, VirtualFile fromFile, @Nullable VirtualFile toFile) {
        this.myModule = module2;
        this.myFromFile = fromFile;
        this.myToFile = toFile;
    }

    public static IncludeReference create(Module module2, VirtualFile fromFile, @Nullable VirtualFile toFile) {
        return new IncludeReference(module2, fromFile, toFile);
    }

    @NotNull
    public Module getModule() {
        return this.myModule;
    }

    @NotNull
    public VirtualFile getFromFile() {
        return this.myFromFile;
    }

    @NotNull
    public File getFromPath() {
        return VfsUtilCore.virtualToIoFile((VirtualFile)this.myFromFile);
    }

    @Nullable
    public VirtualFile getToFile() {
        return this.myToFile;
    }

    @Nullable
    public File getToPath() {
        return this.myToFile != null ? VfsUtilCore.virtualToIoFile((VirtualFile)this.myToFile) : null;
    }

    @NotNull
    public String getFromDisplayName() {
        if (this.myToFile != null && this.myToFile.getParent() != null && this.myToFile.getParent().equals(this.myFromFile.getParent())) {
            return this.myFromFile.getName();
        }
        return this.myFromFile.getParent().getName() + "/" + this.myFromFile.getName();
    }

    @NotNull
    public String getFromResourceName() {
        return SdkUtils.fileNameToResourceName((String)this.myFromFile.getName());
    }

    @NotNull
    public String getFromResourceUrl() {
        return "@layout/" + this.getFromResourceName();
    }

    @Nullable
    public static String getIncludingLayout(@NotNull XmlFile file2) {
        if (!ApplicationManager.getApplication().isReadAccessAllowed()) {
            return (String)ApplicationManager.getApplication().runReadAction(() -> IncludeReference.getIncludingLayout(file2));
        }
        XmlTag rootTag = file2.getRootTag();
        if (rootTag != null && rootTag.isValid()) {
            return rootTag.getAttributeValue("showIn", "http://schemas.android.com/tools");
        }
        return null;
    }

    public static void setIncludingLayout(@NotNull Project project, @NotNull XmlFile xmlFile, @Nullable String layout) {
        XmlTag tag = xmlFile.getRootTag();
        if (tag != null) {
            SetAttributeFix fix = new SetAttributeFix(tag, "showIn", "http://schemas.android.com/tools", layout);
            fix.executeCommand();
        }
    }

    @NotNull
    public static IncludeReference get(@NotNull Module module2, @NotNull XmlFile file2, @NotNull RenderResources resolver) {
        VirtualFile source;
        ResourceValue resValue;
        ResourceUrl layoutUrl;
        String layoutRef;
        if (!ApplicationManager.getApplication().isReadAccessAllowed()) {
            return (IncludeReference)ApplicationManager.getApplication().runReadAction(() -> IncludeReference.get(module2, file2, resolver));
        }
        ApplicationManager.getApplication().assertReadAccessAllowed();
        XmlTag rootTag = file2.getRootTag();
        if (rootTag != null && (layoutRef = rootTag.getAttributeValue("showIn", "http://schemas.android.com/tools")) != null && (layoutUrl = ResourceUrl.parse((String)layoutRef)) != null && (resValue = IdeResourcesUtil.resolve(resolver, layoutUrl, (XmlElement)rootTag)) != null && (source = IdeResourcesUtil.resolveLayout(resolver, resValue)) != null) {
            VirtualFile target2 = file2.getVirtualFile();
            return IncludeReference.create(module2, source, target2);
        }
        return NONE;
    }
}

