/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.rendering;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ui.UIUtil;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import org.jetbrains.annotations.Nullable;

public class HtmlBuilderHelper {
    @Nullable
    private static String getIconPath(String relative) {
        URL resource = AllIcons.class.getClassLoader().getResource(StringUtil.trimStart((String)relative, (String)"/"));
        try {
            return resource != null ? resource.toURI().toURL().toExternalForm() : null;
        }
        catch (MalformedURLException e) {
            return null;
        }
        catch (URISyntaxException e) {
            return null;
        }
    }

    @Nullable
    public static String getTipIconPath() {
        return HtmlBuilderHelper.getIconPath("general/informationDialog.png");
    }

    @Nullable
    public static String getErrorIconPath() {
        return HtmlBuilderHelper.getIconPath("general/error.png");
    }

    @Nullable
    public static String getRefreshIconPath() {
        return HtmlBuilderHelper.getIconPath("actions/refresh.png");
    }

    public static String getHeaderFontColor() {
        return UIUtil.isUnderDarcula() ? "#A5C25C" : "#005555";
    }
}

